/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render;

import com.infinityraider.infinitylib.config.ModConfiguration;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import com.infinityraider.infinitylib.render.tessellation.TessellatorVertexBuffer;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class RenderUtilBase {
    protected RenderUtilBase() {
    }

    public static void drawBlockModel(ITessellator tessellator, IBlockState state) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        for (EnumFacing facing : EnumFacing.values()) {
            RenderUtilBase.drawQuads(TessellatorVertexBuffer.getInstance(), model.func_188616_a(state, facing, 0L));
        }
        RenderUtilBase.drawQuads(TessellatorVertexBuffer.getInstance(), model.func_188616_a(state, null, 0L));
    }

    public static void drawQuads(ITessellator tessellator, List<BakedQuad> quads) {
        if (quads.size() > 0) {
            tessellator.startDrawingQuads(quads.get(0).getFormat());
            tessellator.addQuads(quads);
            tessellator.draw();
        }
    }

    public static int getMixedBrightness(World world, BlockPos pos, Block block) {
        return RenderUtilBase.getMixedBrightness(world, pos, world.func_180495_p(pos), block);
    }

    public static int getMixedBrightness(World world, BlockPos pos, IBlockState state) {
        return RenderUtilBase.getMixedBrightness(world, pos, state, state.func_177230_c());
    }

    public static int getMixedBrightness(World world, BlockPos pos, IBlockState state, Block block) {
        return world.func_175626_b(pos, world.func_175642_b(EnumSkyBlock.BLOCK, pos));
    }

    public static void rotateBlock(ITessellator tess, EnumFacing dir) {
        switch (dir) {
            case WEST: {
                tess.translate(0.5f, 0.0f, 0.5f);
                tess.rotate(270.0f, 0.0f, 1.0f, 0.0f);
                tess.translate(-0.5f, 0.0f, -0.5f);
                break;
            }
            case NORTH: {
                tess.translate(0.5f, 0.0f, 0.5f);
                tess.rotate(180.0f, 0.0f, 1.0f, 0.0f);
                tess.translate(-0.5f, 0.0f, -0.5f);
                break;
            }
            case EAST: {
                tess.translate(0.5f, 0.0f, 0.5f);
                tess.rotate(90.0f, 0.0f, 1.0f, 0.0f);
                tess.translate(-0.5f, 0.0f, -0.5f);
                break;
            }
            case DOWN: {
                tess.translate(0.0f, 0.5f, 0.5f);
                tess.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                tess.translate(0.0f, -0.5f, -0.5f);
                break;
            }
            case UP: {
                tess.translate(0.0f, 0.5f, 0.5f);
                tess.rotate(270.0f, 1.0f, 0.0f, 0.0f);
                tess.translate(0.0f, -0.5f, -0.5f);
            }
        }
    }

    public static void renderItemStack(ItemStack stack, double x, double y, double z, double scale, boolean rotate) {
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        RenderHelper.func_74519_b();
        GlStateManager.func_179145_e();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        if (rotate) {
            double angle = 720.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0;
            GlStateManager.func_179114_b((float)((float)angle), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.GROUND);
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }

    public static final void correctViewBobbing(EntityPlayer player, float partialTicks, boolean inverse) {
        if (!Minecraft.func_71410_x().field_71474_y.field_74336_f) {
            return;
        }
        float f = player.field_70140_Q - player.field_70141_P;
        float f1 = -(player.field_70140_Q + f * partialTicks);
        float f2 = player.field_71107_bF + (player.field_71109_bG - player.field_71107_bF) * partialTicks;
        float f3 = player.field_70727_aS + (player.field_70726_aT - player.field_70727_aS) * partialTicks;
        if (inverse) {
            GlStateManager.func_179109_b((float)(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 0.5f), (float)(-Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI)) * f2)), (float)0.0f);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)f3, (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            GlStateManager.func_179114_b((float)(-f3), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)(-MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 0.5f), (float)Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI)) * f2), (float)0.0f);
        }
    }

    public static final void renderCoordinateSystemDebug() {
        if (ModConfiguration.getInstance().debug()) {
            int i;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            for (i = 0; i <= 16; ++i) {
                buffer.func_181662_b((double)((float)i / 16.0f), 0.0, 0.0).func_181669_b(255, 0, 0, 255).func_181675_d();
            }
            tessellator.func_78381_a();
            buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            for (i = 0; i <= 16; ++i) {
                buffer.func_181662_b(0.0, (double)((float)i / 16.0f), 0.0).func_181669_b(0, 255, 0, 255).func_181675_d();
            }
            tessellator.func_78381_a();
            buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            for (i = 0; i <= 16; ++i) {
                buffer.func_181662_b(0.0, 0.0, (double)((float)i / 16.0f)).func_181669_b(0, 0, 255, 255).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
        }
    }

    public static final TextureAtlasSprite getIcon(ResourceLocation loc) {
        if (loc == null) {
            return Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        return (TextureAtlasSprite)ModelLoader.defaultTextureGetter().apply(loc);
    }
}

