/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render;

import com.google.common.collect.ImmutableMap;
import java.util.function.Function;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraftforge.common.model.TRSRTransformation;

public class DefaultTransforms {
    private static final TRSRTransformation flipX = new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);
    public static final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> BLOCK = DefaultTransforms.generateBlockTransform();
    public static final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> ITEM = DefaultTransforms.generateItemTransform();

    private static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> generateBlockTransform() {
        TRSRTransformation thirdperson = DefaultTransforms.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        ImmutableMap.Builder transform = new ImmutableMap.Builder();
        transform.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)DefaultTransforms.get(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f));
        transform.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)DefaultTransforms.get(0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f));
        transform.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)DefaultTransforms.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        transform.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdperson);
        transform.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)DefaultTransforms.leftify(thirdperson));
        transform.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)DefaultTransforms.get(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f));
        transform.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)DefaultTransforms.get(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f));
        return transform.build();
    }

    private static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> generateItemTransform() {
        TRSRTransformation thirdperson = DefaultTransforms.get(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
        TRSRTransformation firstperson = DefaultTransforms.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
        ImmutableMap.Builder transform = new ImmutableMap.Builder();
        transform.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)DefaultTransforms.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        transform.put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)DefaultTransforms.get(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        transform.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdperson);
        transform.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)DefaultTransforms.leftify(thirdperson));
        transform.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)firstperson);
        transform.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)DefaultTransforms.leftify(firstperson));
        return transform.build();
    }

    private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null);
    }

    private static TRSRTransformation leftify(TRSRTransformation transform) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)flipX.compose(TRSRTransformation.blockCornerToCenter((TRSRTransformation)transform)).compose(flipX));
    }

    public static final Matrix4f getBlockMatrix(ItemCameraTransforms.TransformType type) {
        if (BLOCK.containsKey((Object)type)) {
            return ((TRSRTransformation)BLOCK.get((Object)type)).getMatrix();
        }
        return TRSRTransformation.identity().getMatrix();
    }

    public static final Matrix4f getItemMatrix(ItemCameraTransforms.TransformType type) {
        if (ITEM.containsKey((Object)type)) {
            return ((TRSRTransformation)ITEM.get((Object)type)).getMatrix();
        }
        return TRSRTransformation.identity().getMatrix();
    }

    public static interface Transformer
    extends Function<ItemCameraTransforms.TransformType, Matrix4f> {
    }
}

