/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.network;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.network.INetworkWrapper;
import com.infinityraider.infinitylib.network.NetworkWrapperDummy;
import com.infinityraider.infinitylib.network.serialization.IMessageSerializer;
import com.infinityraider.infinitylib.network.serialization.MessageElement;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public abstract class MessageBase<REPLY extends IMessage>
implements IMessage {
    private static final Map<Class<? extends MessageBase>, List<MessageElement>> ELEMENT_MAP = Maps.newIdentityHashMap();
    private static final Map<Class<? extends MessageBase>, INetworkWrapper> WRAPPER_MAP = Maps.newIdentityHashMap();
    private INetworkWrapper wrapper;

    public final INetworkWrapper getNetworkWrapper() {
        if (this.wrapper == null) {
            this.wrapper = WRAPPER_MAP.containsKey(this.getClass()) ? WRAPPER_MAP.get(this.getClass()) : NetworkWrapperDummy.getInstance();
        }
        return this.wrapper;
    }

    public abstract Side getMessageHandlerSide();

    protected abstract void processMessage(MessageContext var1);

    protected abstract REPLY getReply(MessageContext var1);

    protected List<IMessageSerializer> getNecessarySerializers() {
        return Collections.emptyList();
    }

    public final void fromBytes(ByteBuf buf) {
        Map<Class<? extends MessageBase>, List<MessageElement>> map = ELEMENT_MAP;
        if (ELEMENT_MAP.containsKey(this.getClass())) {
            for (MessageElement element : ELEMENT_MAP.get(this.getClass())) {
                element.readFromByteBuf(buf, this);
            }
        }
    }

    public final void toBytes(ByteBuf buf) {
        Map<Class<? extends MessageBase>, List<MessageElement>> map = ELEMENT_MAP;
        if (ELEMENT_MAP.containsKey(this.getClass())) {
            for (MessageElement element : ELEMENT_MAP.get(this.getClass())) {
                element.writeToByteBuf(buf, this);
            }
        }
    }

    public final MessageBase<REPLY> sendToAll() {
        this.getNetworkWrapper().sendToAll(this);
        return this;
    }

    public final MessageBase<REPLY> sendTo(EntityPlayerMP player) {
        this.getNetworkWrapper().sendTo(this, player);
        return this;
    }

    public final MessageBase<REPLY> sendToAllAround(World world, double x, double y, double z, double range) {
        this.getNetworkWrapper().sendToAllAround(this, world.field_73011_w.getDimension(), x, y, z, range);
        return this;
    }

    public final MessageBase<REPLY> sendToAllAround(int dimension, double x, double y, double z, double range) {
        this.getNetworkWrapper().sendToAllAround(this, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
        return this;
    }

    public final MessageBase<REPLY> sendToAllAround(NetworkRegistry.TargetPoint point) {
        this.getNetworkWrapper().sendToAllAround(this, point);
        return this;
    }

    public final MessageBase<REPLY> sendToDimension(World world) {
        this.getNetworkWrapper().sendToDimension(this, world.field_73011_w.getDimension());
        return this;
    }

    public final MessageBase<REPLY> sendToDimension(int dimensionId) {
        this.getNetworkWrapper().sendToDimension(this, dimensionId);
        return this;
    }

    public final MessageBase<REPLY> sendToServer() {
        this.getNetworkWrapper().sendToServer(this);
        return this;
    }

    static void onMessageRegistered(Class<? extends MessageBase> clazz, INetworkWrapper wrapper) {
        WRAPPER_MAP.put(clazz, wrapper);
        MessageBase.compileFieldsList(clazz);
    }

    private static void compileFieldsList(Class<? extends MessageBase> clazz) {
        if (!ELEMENT_MAP.containsKey(clazz)) {
            Field[] fields = clazz.getDeclaredFields();
            ArrayList elements = Lists.newArrayList();
            ArrayList skippedFields = Lists.newArrayList();
            for (Field field : fields) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                Optional<MessageElement> element = MessageElement.createNewElement(field);
                if (element.isPresent()) {
                    elements.add(element.get());
                    continue;
                }
                skippedFields.add(field);
            }
            ELEMENT_MAP.put(clazz, (List<MessageElement>)ImmutableList.copyOf((Collection)elements));
            if (skippedFields.size() > 0) {
                InfinityLib.instance.getLogger().error("SKIPPED FIELDS FOR MESSAGE CLASS: " + clazz.getName(), new Object[0]);
                InfinityLib.instance.getLogger().error("Report this to the mod author, skipped fields are:", new Object[0]);
                for (Field field : skippedFields) {
                    InfinityLib.instance.getLogger().error(" - " + field.getName(), new Object[0]);
                }
                InfinityLib.instance.getLogger().error("serializers have to be registered for these field types,", new Object[0]);
                InfinityLib.instance.getLogger().error("this is done via INetworkWrapper.registerDataSerializer", new Object[0]);
            }
        }
    }
}

