/*
 * Decompiled with CFR 0.152.
 */
package com.laikaiwanowa.millenaireextended.common.deployer;

import com.laikaiwanowa.millenaireextended.MillenaireExtended;
import com.laikaiwanowa.millenaireextended.common.utilities.MillCommonUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;

public class ContentDeployer {
    private static final String DEV_VERSION_NUMBER = "1.0.0";

    private static void copyFolder(String modJarPath, String deployLocation, String folder, File destDir) throws URISyntaxException, IOException {
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        JarFile file = new JarFile(modJarPath);
        Enumeration<JarEntry> e = file.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String jarEntryName = entry.getName();
            if (!jarEntryName.startsWith(deployLocation + folder)) continue;
            File destination = new File(destDir, jarEntryName.substring(deployLocation.length(), jarEntryName.length()));
            if (entry.isDirectory()) {
                destination.mkdirs();
                continue;
            }
            InputStream stream = file.getInputStream(entry);
            FileOutputStream out = new FileOutputStream(destination);
            IOUtils.copy((InputStream)stream, (OutputStream)out);
            stream.close();
            ((OutputStream)out).close();
        }
        file.close();
    }

    public static void deployContent(File ourJar) {
        if (!ContentDeployer.class.getResource("ContentDeployer.class").toString().startsWith("jar")) {
            MillenaireExtended.LOGGER.warn("No need to redeploy Mill\u00e9naire as we are in a dev environement.");
            return;
        }
        File modsDir = MillCommonUtilities.getModsDir();
        try {
            boolean redeployMillenaire = false;
            File millenaireCustomDir = new File(modsDir, "millenaire-custom");
            if (DEV_VERSION_NUMBER.equals(DEV_VERSION_NUMBER)) {
                redeployMillenaire = true;
                MillenaireExtended.LOGGER.warn("Deploying millenaire extended normans/ as we are using a dev version and can't test whether it has changed.");
            } else if (!millenaireCustomDir.exists()) {
                redeployMillenaire = true;
                MillenaireExtended.LOGGER.warn("Deploying millenaire extended normans/ to version 1.2.0 as it can't be found.");
            } else {
                File versionFile = new File(millenaireCustomDir, "version.txt");
                if (!versionFile.exists()) {
                    redeployMillenaire = true;
                    MillCommonUtilities.deleteDir(millenaireCustomDir);
                    MillenaireExtended.LOGGER.warn("Redeploying millenaire extended normans/ to version 1.2.0 as it has no version file.");
                } else {
                    BufferedReader reader = MillCommonUtilities.getReader(versionFile);
                    String versionString = reader.readLine();
                    if (!versionString.equals(DEV_VERSION_NUMBER)) {
                        redeployMillenaire = true;
                        MillCommonUtilities.deleteDir(millenaireCustomDir);
                        MillenaireExtended.LOGGER.warn("Redeploying millenaire extended normans/ to version 1.2.0 as it has version " + versionString + ".");
                    } else {
                        MillenaireExtended.LOGGER.warn("No need to redeploy millenaire extended normans as the millenaire extended normans folder is already at version " + versionString + ".");
                    }
                }
            }
            if (redeployMillenaire) {
                try {
                    long startTime = System.currentTimeMillis();
                    ContentDeployer.copyFolder(ourJar.getAbsolutePath(), "todeploy/", "millenaire-custom/", modsDir);
                    Files.write(Paths.get(modsDir.getAbsolutePath() + "/millenaire-custom/mods/me_normans/version.txt", new String[0]), "1.2.0".getBytes(), new OpenOption[0]);
                    MillenaireExtended.LOGGER.warn("Deployed millenaire-custom normans folder in " + (System.currentTimeMillis() - startTime) + " ms.");
                }
                catch (IOException e) {
                    MillenaireExtended.LOGGER.error("Error when checking existing millenaire-custom dir: ", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            MillenaireExtended.LOGGER.error("Error when unzipping millenaire: ", (Throwable)e);
        }
    }
}

