/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.asm;

import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.WeightedBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.BlockRenderLayer;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import team.chisel.ctm.CTM;
import team.chisel.ctm.api.event.TextureCollectedEvent;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;
import team.chisel.ctm.client.util.ProfileUtil;

public class CTMCoreMethods {
    public static ThreadLocal<Boolean> renderingDamageModel = ThreadLocal.withInitial(() -> false);

    public static Boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        ProfileUtil.start("ctm_render_in_layer");
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        if (model instanceof WeightedBakedModel) {
            model = ((WeightedBakedModel)model).field_177566_c;
        }
        Boolean ret = model instanceof AbstractCTMBakedModel ? Boolean.valueOf(((AbstractCTMBakedModel)model).getModel().canRenderInLayer(state, layer)) : null;
        ProfileUtil.end();
        return ret;
    }

    public static void preDamageModel() {
        renderingDamageModel.set(true);
    }

    public static void postDamageModel() {
        renderingDamageModel.set(false);
    }

    public static void onSpriteRegister(TextureMap map, TextureAtlasSprite sprite) {
        MinecraftForge.EVENT_BUS.post((Event)new TextureCollectedEvent(map, sprite));
    }

    public static IModel transformParent(IModel model) {
        if (model instanceof IModelCTM) {
            try {
                return ((IModelCTM)model).getVanillaParent();
            }
            catch (Throwable t) {
                CTM.logger.error("Please update Chisel!");
            }
        }
        return model;
    }
}

