/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.itemfilters.api;

import com.latmod.mods.itemfilters.api.IItemFilter;
import com.latmod.mods.itemfilters.api.IRegisteredItemFilter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class ItemFiltersAPI {
    @CapabilityInject(value=IItemFilter.class)
    public static Capability<IItemFilter> CAPABILITY;
    private static final Map<String, Supplier<IRegisteredItemFilter>> REGISTRY0;
    public static final Map<String, Supplier<IRegisteredItemFilter>> REGISTRY;
    public static final Item NULL_ITEM;

    @Nullable
    public static IItemFilter getFilter(ItemStack stack) {
        return (IItemFilter)stack.getCapability(CAPABILITY, null);
    }

    public static boolean isFilter(ItemStack stack) {
        return stack.hasCapability(CAPABILITY, null);
    }

    public static boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB) {
        if (stackA == stackB) {
            return true;
        }
        if (stackA.func_77973_b() != stackB.func_77973_b()) {
            return false;
        }
        if (stackA.func_77981_g() ? stackA.func_77960_j() != stackB.func_77960_j() : stackA.func_77952_i() != stackB.func_77952_i()) {
            return false;
        }
        return ItemStack.areItemStackShareTagsEqual((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean filter(ItemStack filter, ItemStack stack) {
        if (filter == stack || filter.func_190926_b()) {
            return true;
        }
        IItemFilter f = ItemFiltersAPI.getFilter(filter);
        return f == null ? ItemFiltersAPI.areItemStacksEqual(filter, stack) : f.filter(stack);
    }

    public static void getValidItems(ItemStack filter, List<ItemStack> list) {
        if (filter.func_190926_b()) {
            return;
        }
        IItemFilter f = ItemFiltersAPI.getFilter(filter);
        if (f == null) {
            list.add(filter);
        } else {
            f.getValidItems(list);
        }
    }

    public static void register(String id, Supplier<IRegisteredItemFilter> supplier) {
        REGISTRY0.put(id, supplier);
    }

    @Nullable
    public static IRegisteredItemFilter createFromID(String id) {
        Supplier<IRegisteredItemFilter> supplier = REGISTRY0.get(id);
        return supplier == null ? null : supplier.get();
    }

    static {
        REGISTRY0 = new LinkedHashMap<String, Supplier<IRegisteredItemFilter>>();
        REGISTRY = Collections.unmodifiableMap(REGISTRY0);
        NULL_ITEM = Item.func_150898_a((Block)Blocks.field_180401_cv);
    }
}

