/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.chameleon.render;

import com.jaquadro.minecraft.chameleon.render.ChamRender;
import com.jaquadro.minecraft.chameleon.render.ChamRenderAO;
import com.jaquadro.minecraft.chameleon.render.ChamRenderState;
import java.lang.reflect.Array;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

public class ChamRenderLL {
    private static final int TL = 0;
    private static final int BL = 1;
    private static final int BR = 2;
    private static final int TR = 3;
    private static final int MINX = 0;
    private static final int MAXX = 1;
    private static final int MINY = 2;
    private static final int MAXY = 3;
    private static final int MINZ = 4;
    private static final int MAXZ = 5;
    private static final int[][][] xyzuvMap = new int[][][]{new int[][]{{0, 2, 5, 0, 2}, {0, 2, 4, 0, 3}, {1, 2, 4, 1, 3}, {1, 2, 5, 1, 2}}, new int[][]{{1, 3, 5, 0, 2}, {1, 3, 4, 0, 3}, {0, 3, 4, 1, 3}, {0, 3, 5, 1, 2}}, new int[][]{{0, 3, 4, 0, 2}, {1, 3, 4, 1, 2}, {1, 2, 4, 1, 3}, {0, 2, 4, 0, 3}}, new int[][]{{0, 3, 5, 0, 2}, {0, 2, 5, 0, 3}, {1, 2, 5, 1, 3}, {1, 3, 5, 1, 2}}, new int[][]{{0, 3, 5, 0, 2}, {0, 3, 4, 1, 2}, {0, 2, 4, 1, 3}, {0, 2, 5, 0, 3}}, new int[][]{{1, 2, 5, 0, 2}, {1, 2, 4, 1, 2}, {1, 3, 4, 1, 3}, {1, 3, 5, 0, 3}}};
    private ChamRenderState state;
    private BufferBuilder tessellator;
    private double[] minUDiv = new double[24];
    private double[] maxUDiv = new double[24];
    private double[] minVDiv = new double[24];
    private double[] maxVDiv = new double[24];
    private int[][] brightnessLerp = new int[10][10];
    private double[] uv = new double[4];
    private double[] xyz = new double[6];
    private boolean isBaking;
    private boolean faceGroup;
    private VertexFormat bakedFormat;
    private int bakedTintIndex = -1;
    private boolean diffuseLight = false;
    private List<BakedQuad>[] quadBuffer;

    public ChamRenderLL(ChamRenderState state) {
        this.state = state;
    }

    public void startBaking(VertexFormat format) {
        this.startBaking(format, -1, false);
    }

    public void startBaking(VertexFormat format, int tintIndex) {
        this.startBaking(format, tintIndex, false);
    }

    public void startBaking(VertexFormat format, int tintIndex, boolean applyDiffuseLight) {
        this.isBaking = true;
        this.bakedFormat = format;
        this.bakedTintIndex = tintIndex;
        this.diffuseLight = applyDiffuseLight;
        if (this.quadBuffer == null) {
            List[] newBuffer = (List[])Array.newInstance(ArrayList.class, 7);
            this.quadBuffer = newBuffer;
            for (int i = 0; i < this.quadBuffer.length; ++i) {
                this.quadBuffer[i] = new ArrayList<BakedQuad>();
            }
        }
        for (List<BakedQuad> buffer : this.quadBuffer) {
            buffer.clear();
        }
    }

    public void stopBaking() {
        this.isBaking = false;
    }

    public List<BakedQuad> takeBakedQuads(EnumFacing dir) {
        int index = dir == null ? 6 : dir.func_176745_a();
        List<BakedQuad> result = this.quadBuffer[index];
        this.quadBuffer[index] = new ArrayList<BakedQuad>();
        return result;
    }

    public boolean isBaking() {
        return this.isBaking;
    }

    public VertexFormat getVertexFormat() {
        return this.bakedFormat;
    }

    public void setTessellator(BufferBuilder tessellator) {
        this.tessellator = tessellator;
    }

    public void drawFace(EnumFacing face, double x, double y, double z, TextureAtlasSprite icon, boolean isFaceGroup) {
        this.faceGroup = isFaceGroup;
        this.drawFace(face, x, y, z, icon);
        this.faceGroup = false;
    }

    public void drawFace(EnumFacing face, double x, double y, double z, TextureAtlasSprite icon) {
        boolean flip = this.state.flipTexture;
        switch (face.func_176745_a()) {
            case 0: 
            case 1: {
                this.drawFaceY(face, x, y, z, icon);
                break;
            }
            case 2: 
            case 3: {
                if (this.state.autoFlipTexture && (this.state.rotateTransform == 2 || this.state.rotateTransform == 1)) {
                    this.state.flipTexture = !this.state.flipTexture;
                }
                this.drawFaceZ(face, x, y, z, icon);
                break;
            }
            case 4: 
            case 5: {
                if (this.state.autoFlipTexture && (this.state.rotateTransform == 2 || this.state.rotateTransform == 3)) {
                    this.state.flipTexture = !this.state.flipTexture;
                }
                this.drawFaceX(face, x, y, z, icon);
            }
        }
        this.state.flipTexture = flip;
    }

    private void drawFaceY(EnumFacing face, double x, double y, double z, TextureAtlasSprite icon) {
        int rotate;
        if (icon == null) {
            return;
        }
        int rangeX = (int)(Math.ceil(this.state.renderMaxX + (double)this.state.shiftU) - Math.floor(this.state.renderMinX + (double)this.state.shiftU));
        int rangeZ = (int)(Math.ceil(this.state.renderMaxZ + (double)this.state.shiftV) - Math.floor(this.state.renderMinZ + (double)this.state.shiftV));
        this.setXYZ(x, y, z);
        if (this.state.renderFromInside) {
            this.xyz[0] = z + this.state.renderMaxX;
            this.xyz[1] = z + this.state.renderMinX;
        }
        int n = rotate = face == ChamRender.FACE_YNEG ? this.state.uvRotate[0] : this.state.uvRotate[1];
        if (rangeX <= 1 && rangeZ <= 1) {
            if (face == ChamRender.FACE_YNEG) {
                this.setFaceYNegUV(icon, this.state.renderMinX, this.state.renderMinZ, this.state.renderMaxX, this.state.renderMaxZ);
            } else {
                this.setFaceYPosUV(icon, this.state.renderMinX, this.state.renderMinZ, this.state.renderMaxX, this.state.renderMaxZ);
            }
            if (this.state.enableAO) {
                this.renderXYZUVAO(face, icon);
            } else {
                this.renderXYZUV(face, icon);
            }
            return;
        }
        double uStart = (this.state.renderMinX + (double)this.state.shiftU + (double)rangeX) % 1.0;
        double uStop = (this.state.renderMaxX + (double)this.state.shiftU + (double)rangeX) % 1.0;
        double vStart = (this.state.renderMinZ + (double)this.state.shiftV + (double)rangeZ) % 1.0;
        double vStop = (this.state.renderMaxZ + (double)this.state.shiftV + (double)rangeZ) % 1.0;
        this.setupUVPoints(uStart, vStart, uStop, vStop, rangeX, rangeZ);
        this.setupAOBrightnessLerp(this.state.renderMinX, this.state.renderMaxX, this.state.renderMinZ, this.state.renderMaxZ, rangeX, rangeZ);
        for (int ix = 0; ix < rangeX; ++ix) {
            this.xyz[1] = this.xyz[0] + this.maxUDiv[ix] - this.minUDiv[ix];
            this.xyz[4] = z + this.state.renderMinZ;
            for (int iz = 0; iz < rangeZ; ++iz) {
                this.xyz[5] = this.xyz[4] + this.maxVDiv[iz] - this.minVDiv[iz];
                this.state.brightnessTopLeft = this.brightnessLerp[ix][iz];
                this.state.brightnessTopRight = this.brightnessLerp[ix + 1][iz];
                this.state.brightnessBottomLeft = this.brightnessLerp[ix][iz + 1];
                this.state.brightnessBottomRight = this.brightnessLerp[ix + 1][iz + 1];
                switch (rotate) {
                    case 1: {
                        this.setUV(icon, this.maxVDiv[ix], this.minVDiv[ix], this.minUDiv[iz], this.maxUDiv[iz]);
                        break;
                    }
                    case 2: {
                        this.setUV(icon, this.maxUDiv[ix], this.minUDiv[ix], this.maxVDiv[iz], this.minVDiv[iz]);
                        break;
                    }
                    case 3: {
                        this.setUV(icon, this.minVDiv[ix], this.maxVDiv[ix], this.maxUDiv[iz], this.minUDiv[iz]);
                        break;
                    }
                    default: {
                        this.setUV(icon, this.minUDiv[ix], this.maxUDiv[ix], this.minVDiv[iz], this.maxVDiv[iz]);
                    }
                }
                this.renderXYZUVAO(face, icon);
                this.xyz[4] = this.xyz[5];
            }
            this.xyz[0] = this.xyz[1];
        }
    }

    private void setFaceYNegUV(TextureAtlasSprite icon, double minX, double minZ, double maxX, double maxZ) {
        int rotate = this.state.uvRotate[0];
        if (rotate == 0) {
            this.setUV(icon, minX + (double)this.state.shiftU, maxX + (double)this.state.shiftU, maxZ + (double)this.state.shiftV, minZ + (double)this.state.shiftV);
        }
        if (rotate == 1) {
            this.setUV(icon, 1.0 - maxZ + (double)this.state.shiftU, 1.0 - minZ + (double)this.state.shiftU, minX + (double)this.state.shiftV, maxX + (double)this.state.shiftV);
        }
        if (rotate == 2) {
            this.setUV(icon, 1.0 - minX + (double)this.state.shiftU, 1.0 - maxX + (double)this.state.shiftU, 1.0 - maxZ + (double)this.state.shiftV, 1.0 - minZ + (double)this.state.shiftV);
        }
        if (rotate == 3) {
            this.setUV(icon, maxZ + (double)this.state.shiftU, minZ + (double)this.state.shiftU, 1.0 - minX + (double)this.state.shiftV, 1.0 - maxX + (double)this.state.shiftV);
        }
    }

    private void setFaceYPosUV(TextureAtlasSprite icon, double minX, double minZ, double maxX, double maxZ) {
        int rotate = this.state.uvRotate[1];
        if (rotate == 0) {
            this.setUV(icon, maxX + (double)this.state.shiftU, minX + (double)this.state.shiftU, maxZ + (double)this.state.shiftV, minZ + (double)this.state.shiftV);
        }
        if (rotate == 1) {
            this.setUV(icon, maxZ + (double)this.state.shiftU, minZ + (double)this.state.shiftU, 1.0 - maxX + (double)this.state.shiftV, 1.0 - minX + (double)this.state.shiftV);
        }
        if (rotate == 2) {
            this.setUV(icon, 1.0 - maxX + (double)this.state.shiftU, 1.0 - minX + (double)this.state.shiftU, 1.0 - maxZ + (double)this.state.shiftV, 1.0 - minZ + (double)this.state.shiftV);
        }
        if (rotate == 3) {
            this.setUV(icon, 1.0 - maxZ + (double)this.state.shiftU, 1.0 - minZ + (double)this.state.shiftU, maxX + (double)this.state.shiftV, minX + (double)this.state.shiftV);
        }
    }

    private void drawFaceZ(EnumFacing face, double x, double y, double z, TextureAtlasSprite icon) {
        if (icon == null) {
            return;
        }
        int rangeX = (int)(Math.ceil(this.state.renderMaxX + (double)this.state.shiftU) - Math.floor(this.state.renderMinX + (double)this.state.shiftU));
        int rangeY = (int)(Math.ceil(this.state.renderMaxY + (double)this.state.shiftV) - Math.floor(this.state.renderMinY + (double)this.state.shiftV));
        this.setXYZ(x, y, z);
        if (this.state.renderFromInside) {
            this.xyz[0] = z + this.state.renderMaxX;
            this.xyz[1] = z + this.state.renderMinX;
        }
        if (rangeX <= 1 && rangeY <= 1) {
            double minX = this.state.renderMinX;
            double maxX = this.state.renderMaxX;
            if (this.state.flipTexture) {
                minX = this.state.renderMaxX;
                maxX = this.state.renderMinX;
            }
            if (face == ChamRender.FACE_ZNEG) {
                this.setFaceZNegUV(icon, minX, this.state.renderMinY, maxX, this.state.renderMaxY);
            } else {
                this.setFaceZPosUV(icon, minX, this.state.renderMinY, maxX, this.state.renderMaxY);
            }
            if (this.state.enableAO) {
                this.renderXYZUVAO(face, icon);
            } else {
                this.renderXYZUV(face, icon);
            }
            return;
        }
        double uStart = (this.state.renderMinX + (double)this.state.shiftU + (double)rangeX) % 1.0;
        double uStop = (this.state.renderMaxX + (double)this.state.shiftU + (double)rangeX) % 1.0;
        double vStart = (this.state.renderMinY + (double)this.state.shiftV + (double)rangeY) % 1.0;
        double vStop = (this.state.renderMaxY + (double)this.state.shiftV + (double)rangeY) % 1.0;
        this.setupUVPoints(uStart, vStart, uStop, vStop, rangeX, rangeY);
        this.setupAOBrightnessLerp(this.state.renderMinX, this.state.renderMaxX, this.state.renderMinY, this.state.renderMaxY, rangeX, rangeY);
        for (int ix = 0; ix < rangeX; ++ix) {
            this.xyz[1] = this.xyz[0] + this.maxUDiv[ix] - this.minUDiv[ix];
            this.xyz[2] = y + this.state.renderMinY;
            for (int iy = 0; iy < rangeY; ++iy) {
                this.xyz[3] = this.xyz[2] + this.maxVDiv[iy] - this.minVDiv[iy];
                this.state.brightnessTopLeft = this.brightnessLerp[ix][iy];
                this.state.brightnessTopRight = this.brightnessLerp[ix + 1][iy];
                this.state.brightnessBottomLeft = this.brightnessLerp[ix][iy + 1];
                this.state.brightnessBottomRight = this.brightnessLerp[ix + 1][iy + 1];
                if (this.state.flipTexture) {
                    this.setUV(icon, 1.0 - this.minUDiv[ix], 1.0 - this.maxUDiv[ix], 1.0 - this.maxVDiv[iy], 1.0 - this.minVDiv[iy]);
                } else {
                    this.setUV(icon, this.minUDiv[ix], this.maxUDiv[ix], 1.0 - this.maxVDiv[iy], 1.0 - this.minVDiv[iy]);
                }
                this.renderXYZUVAO(face, icon);
                this.xyz[2] = this.xyz[3];
            }
            this.xyz[0] = this.xyz[1];
        }
    }

    private void setFaceZNegUV(TextureAtlasSprite icon, double minX, double minY, double maxX, double maxY) {
        int rotate = this.state.uvRotate[2];
        if (rotate == 0) {
            this.setUV(icon, maxX + (double)this.state.shiftU, minX + (double)this.state.shiftU, 1.0 - maxY + (double)this.state.shiftV, 1.0 - minY + (double)this.state.shiftV);
        }
        if (rotate == 1) {
            this.setUV(icon, 1.0 - minY + (double)this.state.shiftU, 1.0 - maxY + (double)this.state.shiftU, minX + (double)this.state.shiftV, maxX + (double)this.state.shiftV);
        }
        if (rotate == 2) {
            this.setUV(icon, 1.0 - maxX + (double)this.state.shiftU, 1.0 - minX + (double)this.state.shiftU, maxY + (double)this.state.shiftV, minY + (double)this.state.shiftV);
        }
        if (rotate == 3) {
            this.setUV(icon, minY + (double)this.state.shiftU, maxY + (double)this.state.shiftU, 1.0 - minX + (double)this.state.shiftV, 1.0 - maxX + (double)this.state.shiftV);
        }
    }

    private void setFaceZPosUV(TextureAtlasSprite icon, double minX, double minY, double maxX, double maxY) {
        int rotate = this.state.uvRotate[3];
        if (rotate == 0) {
            this.setUV(icon, minX + (double)this.state.shiftU, maxX + (double)this.state.shiftU, 1.0 - maxY + (double)this.state.shiftV, 1.0 - minY + (double)this.state.shiftV);
        }
        if (rotate == 1) {
            this.setUV(icon, minY + (double)this.state.shiftU, maxY + (double)this.state.shiftU, 1.0 - minX + (double)this.state.shiftV, 1.0 - maxX + (double)this.state.shiftV);
        }
        if (rotate == 2) {
            this.setUV(icon, 1.0 - minX + (double)this.state.shiftU, 1.0 - maxX + (double)this.state.shiftU, maxY + (double)this.state.shiftV, minY + (double)this.state.shiftV);
        }
        if (rotate == 3) {
            this.setUV(icon, 1.0 - minY + (double)this.state.shiftU, 1.0 - maxY + (double)this.state.shiftU, minX + (double)this.state.shiftV, maxX + (double)this.state.shiftV);
        }
    }

    private void drawFaceX(EnumFacing face, double x, double y, double z, TextureAtlasSprite icon) {
        if (icon == null) {
            return;
        }
        int rangeZ = (int)(Math.ceil(this.state.renderMaxZ + (double)this.state.shiftU) - Math.floor(this.state.renderMinZ + (double)this.state.shiftU));
        int rangeY = (int)(Math.ceil(this.state.renderMaxY + (double)this.state.shiftV) - Math.floor(this.state.renderMinY + (double)this.state.shiftV));
        this.setXYZ(x, y, z);
        if (this.state.renderFromInside) {
            this.xyz[4] = z + this.state.renderMaxZ;
            this.xyz[5] = z + this.state.renderMinZ;
        }
        if (rangeZ <= 1 && rangeY <= 1) {
            double minZ = this.state.renderMinZ;
            double maxZ = this.state.renderMaxZ;
            if (this.state.flipTexture) {
                minZ = this.state.renderMaxZ;
                maxZ = this.state.renderMinZ;
            }
            if (face == ChamRender.FACE_XNEG) {
                this.setFaceXNegUV(icon, minZ, this.state.renderMinY, maxZ, this.state.renderMaxY);
            } else {
                this.setFaceXPosUV(icon, minZ, this.state.renderMinY, maxZ, this.state.renderMaxY);
            }
            if (this.state.enableAO) {
                this.renderXYZUVAO(face, icon);
            } else {
                this.renderXYZUV(face, icon);
            }
            return;
        }
        double uStart = (this.state.renderMinZ + (double)this.state.shiftU + (double)rangeZ) % 1.0;
        double uStop = (this.state.renderMaxZ + (double)this.state.shiftU + (double)rangeZ) % 1.0;
        double vStart = (this.state.renderMinY + (double)this.state.shiftV + (double)rangeY) % 1.0;
        double vStop = (this.state.renderMaxY + (double)this.state.shiftV + (double)rangeY) % 1.0;
        this.setupUVPoints(uStart, vStart, uStop, vStop, rangeZ, rangeY);
        this.setupAOBrightnessLerp(this.state.renderMinZ, this.state.renderMaxZ, this.state.renderMinY, this.state.renderMaxY, rangeZ, rangeY);
        for (int iz = 0; iz < rangeZ; ++iz) {
            this.xyz[5] = this.xyz[4] + this.maxUDiv[iz] - this.minUDiv[iz];
            this.xyz[2] = y + this.state.renderMinY;
            for (int iy = 0; iy < rangeY; ++iy) {
                this.xyz[3] = this.xyz[2] + this.maxVDiv[iy] - this.minVDiv[iy];
                this.state.brightnessTopLeft = this.brightnessLerp[iz][iy];
                this.state.brightnessTopRight = this.brightnessLerp[iz + 1][iy];
                this.state.brightnessBottomLeft = this.brightnessLerp[iz][iy + 1];
                this.state.brightnessBottomRight = this.brightnessLerp[iz + 1][iy + 1];
                if (this.state.flipTexture) {
                    this.setUV(icon, 1.0 - this.minUDiv[iz], 1.0 - this.maxUDiv[iz], 1.0 - this.maxVDiv[iy], 1.0 - this.minVDiv[iy]);
                } else {
                    this.setUV(icon, this.minUDiv[iz], this.maxUDiv[iz], 1.0 - this.maxVDiv[iy], 1.0 - this.minVDiv[iy]);
                }
                this.renderXYZUVAO(face, icon);
                this.xyz[2] = this.xyz[3];
            }
            this.xyz[4] = this.xyz[5];
        }
    }

    private void setFaceXNegUV(TextureAtlasSprite icon, double minZ, double minY, double maxZ, double maxY) {
        int rotate = this.state.uvRotate[4];
        if (rotate == 0) {
            this.setUV(icon, maxZ + (double)this.state.shiftU, minZ + (double)this.state.shiftU, 1.0 - maxY + (double)this.state.shiftV, 1.0 - minY + (double)this.state.shiftV);
        }
        if (rotate == 1) {
            this.setUV(icon, minY + (double)this.state.shiftU, maxY + (double)this.state.shiftU, 1.0 - maxZ + (double)this.state.shiftV, 1.0 - minZ + (double)this.state.shiftV);
        }
        if (rotate == 2) {
            this.setUV(icon, 1.0 - maxZ + (double)this.state.shiftU, 1.0 - minZ + (double)this.state.shiftU, maxY + (double)this.state.shiftV, minY + (double)this.state.shiftV);
        }
        if (rotate == 3) {
            this.setUV(icon, 1.0 - minY + (double)this.state.shiftU, 1.0 - maxY + (double)this.state.shiftU, maxZ + (double)this.state.shiftV, minZ + (double)this.state.shiftV);
        }
    }

    private void setFaceXPosUV(TextureAtlasSprite icon, double minZ, double minY, double maxZ, double maxY) {
        int rotate = this.state.uvRotate[5];
        if (rotate == 0) {
            this.setUV(icon, minZ + (double)this.state.shiftU, maxZ + (double)this.state.shiftU, 1.0 - minY + (double)this.state.shiftV, 1.0 - maxY + (double)this.state.shiftV);
        }
        if (rotate == 1) {
            this.setUV(icon, 1.0 - maxY + (double)this.state.shiftU, 1.0 - minY + (double)this.state.shiftU, maxZ + (double)this.state.shiftV, minZ + (double)this.state.shiftV);
        }
        if (rotate == 2) {
            this.setUV(icon, 1.0 - minZ + (double)this.state.shiftU, 1.0 - maxZ + (double)this.state.shiftU, minY + (double)this.state.shiftV, maxY + (double)this.state.shiftV);
        }
        if (rotate == 3) {
            this.setUV(icon, maxY + (double)this.state.shiftU, minY + (double)this.state.shiftU, 1.0 - maxZ + (double)this.state.shiftV, 1.0 - minZ + (double)this.state.shiftV);
        }
    }

    public void drawPartialFace(EnumFacing face, double x, double y, double z, TextureAtlasSprite icon, double uMin, double vMin, double uMax, double vMax, boolean isFaceGroup) {
        this.faceGroup = isFaceGroup;
        this.drawPartialFace(face, x, y, z, icon, uMin, vMin, uMax, vMax);
        this.faceGroup = false;
    }

    public void drawPartialFace(EnumFacing face, double x, double y, double z, TextureAtlasSprite icon, double uMin, double vMin, double uMax, double vMax) {
        this.setXYZ(x, y, z);
        this.setUV(icon, uMin, uMax, vMin, vMax);
        if (this.state.enableAO) {
            this.renderXYZUVAO(face, icon);
        } else {
            this.renderXYZUV(face, icon);
        }
    }

    private void setupUVPoints(double uStart, double vStart, double uStop, double vStop, int rangeU, int rangeV) {
        int i;
        if (rangeU <= 1) {
            this.minUDiv[0] = uStart;
            this.maxUDiv[0] = uStop;
        } else {
            this.minUDiv[0] = uStart;
            this.maxUDiv[0] = 1.0;
            for (i = 1; i < rangeU - 1; ++i) {
                this.minUDiv[i] = 0.0;
                this.maxUDiv[i] = 1.0;
            }
            this.minUDiv[rangeU - 1] = 0.0;
            this.maxUDiv[rangeU - 1] = uStop;
        }
        if (rangeV <= 1) {
            this.minVDiv[0] = vStart;
            this.maxVDiv[0] = vStop;
        } else {
            this.minVDiv[0] = vStart;
            this.maxVDiv[0] = 1.0;
            for (i = 1; i < rangeV - 1; ++i) {
                this.minVDiv[i] = 0.0;
                this.maxVDiv[i] = 1.0;
            }
            this.minVDiv[rangeV - 1] = 0.0;
            this.maxVDiv[rangeV - 1] = vStop;
        }
    }

    private void setupAOBrightnessLerp(double left, double right, double top, double bottom, int rangeLR, int rangeTB) {
        double diffLR = right - left;
        double diffTB = bottom - top;
        double posLR = 0.0;
        for (int lr = 0; lr <= rangeLR; ++lr) {
            float lerpLR = (float)(posLR / diffLR);
            int brightTop = ChamRenderAO.mixAOBrightness(this.state.brightnessTopLeft, this.state.brightnessTopRight, 1.0f - lerpLR, lerpLR);
            int brightBottom = ChamRenderAO.mixAOBrightness(this.state.brightnessBottomLeft, this.state.brightnessBottomRight, 1.0f - lerpLR, lerpLR);
            double posTB = 0.0;
            for (int tb = 0; tb <= rangeTB; ++tb) {
                float lerpTB = (float)(posTB / diffTB);
                this.brightnessLerp[lr][tb] = ChamRenderAO.mixAOBrightness(brightTop, brightBottom, 1.0f - lerpTB, lerpTB);
                if (tb >= rangeTB) continue;
                posTB += this.maxVDiv[tb] - this.minVDiv[tb];
            }
            if (lr >= rangeLR) continue;
            posLR += this.maxUDiv[lr] - this.minUDiv[lr];
        }
    }

    private void setUV(TextureAtlasSprite icon, double uMin, double uMax, double vMin, double vMax) {
        this.uv[0] = icon.func_94214_a(uMin * 16.0);
        this.uv[1] = icon.func_94214_a(uMax * 16.0);
        this.uv[2] = icon.func_94207_b(vMin * 16.0);
        this.uv[3] = icon.func_94207_b(vMax * 16.0);
    }

    private void setUV(double uMin, double uMax, double vMin, double vMax) {
        this.uv[0] = uMin;
        this.uv[1] = uMax;
        this.uv[2] = vMin;
        this.uv[3] = vMax;
    }

    private void setXYZ(double x, double y, double z) {
        this.xyz[0] = x + this.state.renderOffsetX + this.state.renderMinX;
        this.xyz[1] = x + this.state.renderOffsetX + this.state.renderMaxX;
        this.xyz[2] = y + this.state.renderOffsetY + this.state.renderMinY;
        this.xyz[3] = y + this.state.renderOffsetY + this.state.renderMaxY;
        this.xyz[4] = z + this.state.renderOffsetZ + this.state.renderMinZ;
        this.xyz[5] = z + this.state.renderOffsetZ + this.state.renderMaxZ;
    }

    private int getFacingIndex(EnumFacing dir) {
        return dir == null || !this.faceGroup ? 6 : dir.func_176745_a();
    }

    private void renderXYZUV(EnumFacing facing, TextureAtlasSprite icon) {
        if (this.isBaking) {
            int index = this.getFacingIndex(facing);
            if (this.bakedFormat == DefaultVertexFormats.field_176600_a) {
                this.quadBuffer[index].add(this.bakeXYZUVBlock(facing, icon, this.state.color, this.state.color, this.state.color, this.state.color));
            } else if (this.bakedFormat == DefaultVertexFormats.field_176599_b) {
                this.quadBuffer[index].add(this.bakeXYZUVItem(facing, icon, this.state.color, this.state.color, this.state.color, this.state.color));
            }
            return;
        }
        int[][] index = xyzuvMap[facing.func_176745_a()];
        int uvRotate = this.state.uvRotate[facing.func_176745_a()];
        int[] mapTL = index[0];
        int[] mapBL = index[1];
        int[] mapBR = index[2];
        int[] mapTR = index[3];
        double ubl = this.uv[mapBL[3]];
        double vbl = this.uv[mapBL[4]];
        double utr = this.uv[mapTR[3]];
        double vtr = this.uv[mapTR[4]];
        if (uvRotate == 1 || uvRotate == 3) {
            ubl = this.uv[mapTR[3]];
            vbl = this.uv[mapTR[4]];
            utr = this.uv[mapBL[3]];
            vtr = this.uv[mapBL[4]];
        }
        this.setBlockVertex(index[0], this.uv[mapTL[3]], this.uv[mapTL[4]], this.state.color, this.state.brightness);
        this.setBlockVertex(index[1], ubl, vbl, this.state.color, this.state.brightness);
        this.setBlockVertex(index[2], this.uv[mapBR[3]], this.uv[mapBR[4]], this.state.color, this.state.brightness);
        this.setBlockVertex(index[3], utr, vtr, this.state.color, this.state.brightness);
    }

    private void renderXYZUVAO(EnumFacing facing, TextureAtlasSprite icon) {
        if (this.isBaking) {
            int index = this.getFacingIndex(facing);
            if (this.bakedFormat == DefaultVertexFormats.field_176600_a) {
                this.quadBuffer[index].add(this.bakeXYZUVBlock(facing, icon, this.state.color, this.state.color, this.state.color, this.state.color));
            } else if (this.bakedFormat == DefaultVertexFormats.field_176599_b) {
                this.quadBuffer[index].add(this.bakeXYZUVItem(facing, icon, this.state.color, this.state.color, this.state.color, this.state.color));
            }
            return;
        }
        int[][] index = xyzuvMap[facing.func_176745_a()];
        int uvRotate = this.state.uvRotate[facing.func_176745_a()];
        int[] mapTL = index[0];
        int[] mapBL = index[1];
        int[] mapBR = index[2];
        int[] mapTR = index[3];
        double ubl = this.uv[mapBL[3]];
        double vbl = this.uv[mapBL[4]];
        double utr = this.uv[mapTR[3]];
        double vtr = this.uv[mapTR[4]];
        if (uvRotate == 1 || uvRotate == 3) {
            ubl = this.uv[mapTR[3]];
            vbl = this.uv[mapTR[4]];
            utr = this.uv[mapBL[3]];
            vtr = this.uv[mapBL[4]];
        }
        this.setBlockVertex(index[0], this.uv[mapTL[3]], this.uv[mapTL[4]], this.state.colorTopLeft, this.state.brightnessTopLeft);
        this.setBlockVertex(index[1], ubl, vbl, this.state.colorBottomLeft, this.state.brightnessBottomLeft);
        this.setBlockVertex(index[2], this.uv[mapBR[3]], this.uv[mapBR[4]], this.state.colorBottomRight, this.state.brightnessBottomRight);
        this.setBlockVertex(index[3], utr, vtr, this.state.colorTopRight, this.state.brightnessTopRight);
    }

    private void setBlockVertex(int[] xumap, double u, double v, float[] color, int brightness) {
        if (this.tessellator == null) {
            return;
        }
        if (this.tessellator.func_178973_g().func_177350_b()) {
            this.tessellator.func_181662_b(this.xyz[xumap[0]], this.xyz[xumap[1]], this.xyz[xumap[2]]).func_181666_a(color[0], color[1], color[2], 1.0f).func_187315_a(u, v).func_181663_c(this.state.normal[0], this.state.normal[1], this.state.normal[2]).func_181675_d();
        } else {
            int lsky = brightness >> 16 & 0xFF;
            int lblk = brightness & 0xFF;
            this.tessellator.func_181662_b(this.xyz[xumap[0]], this.xyz[xumap[1]], this.xyz[xumap[2]]).func_187315_a(u, v).func_187314_a(lsky, lblk).func_181666_a(color[0], color[1], color[2], 1.0f).func_181675_d();
        }
    }

    private BakedQuad bakeXYZUVBlock(EnumFacing facing, TextureAtlasSprite icon, float[] colorTL, float[] colorBL, float[] colorBR, float[] colorTR) {
        int[][] index = xyzuvMap[facing.func_176745_a()];
        int uvRotate = this.state.uvRotate[facing.func_176745_a()];
        int[] mapTL = index[0];
        int[] mapBL = index[1];
        int[] mapBR = index[2];
        int[] mapTR = index[3];
        double ubl = this.uv[mapBL[3]];
        double vbl = this.uv[mapBL[4]];
        double utr = this.uv[mapTR[3]];
        double vtr = this.uv[mapTR[4]];
        if (uvRotate == 1 || uvRotate == 3) {
            ubl = this.uv[mapTR[3]];
            vbl = this.uv[mapTR[4]];
            utr = this.uv[mapBL[3]];
            vtr = this.uv[mapBL[4]];
        }
        int light = -1;
        return new BakedQuad(new int[]{Float.floatToRawIntBits((float)this.xyz[mapTL[0]]), Float.floatToRawIntBits((float)this.xyz[mapTL[1]]), Float.floatToRawIntBits((float)this.xyz[mapTL[2]]), this.packColor(colorTL), Float.floatToRawIntBits((float)this.uv[mapTL[3]]), Float.floatToRawIntBits((float)this.uv[mapTL[4]]), light, Float.floatToRawIntBits((float)this.xyz[mapBL[0]]), Float.floatToRawIntBits((float)this.xyz[mapBL[1]]), Float.floatToRawIntBits((float)this.xyz[mapBL[2]]), this.packColor(colorBL), Float.floatToRawIntBits((float)ubl), Float.floatToRawIntBits((float)vbl), light, Float.floatToRawIntBits((float)this.xyz[mapBR[0]]), Float.floatToRawIntBits((float)this.xyz[mapBR[1]]), Float.floatToRawIntBits((float)this.xyz[mapBR[2]]), this.packColor(colorBR), Float.floatToRawIntBits((float)this.uv[mapBR[3]]), Float.floatToRawIntBits((float)this.uv[mapBR[4]]), light, Float.floatToRawIntBits((float)this.xyz[mapTR[0]]), Float.floatToRawIntBits((float)this.xyz[mapTR[1]]), Float.floatToRawIntBits((float)this.xyz[mapTR[2]]), this.packColor(colorTR), Float.floatToRawIntBits((float)utr), Float.floatToRawIntBits((float)vtr), light}, this.bakedTintIndex, facing, icon, this.diffuseLight, this.getVertexFormat());
    }

    private BakedQuad bakeXYZUVItem(EnumFacing facing, TextureAtlasSprite icon, float[] colorTL, float[] colorBL, float[] colorBR, float[] colorTR) {
        int[][] index = xyzuvMap[facing.func_176745_a()];
        int uvRotate = this.state.uvRotate[facing.func_176745_a()];
        int[] mapTL = index[0];
        int[] mapBL = index[1];
        int[] mapBR = index[2];
        int[] mapTR = index[3];
        double ubl = this.uv[mapBL[3]];
        double vbl = this.uv[mapBL[4]];
        double utr = this.uv[mapTR[3]];
        double vtr = this.uv[mapTR[4]];
        if (uvRotate == 1 || uvRotate == 3) {
            ubl = this.uv[mapTR[3]];
            vbl = this.uv[mapTR[4]];
            utr = this.uv[mapBL[3]];
            vtr = this.uv[mapBL[4]];
        }
        return new BakedQuad(new int[]{Float.floatToRawIntBits((float)this.xyz[mapTL[0]]), Float.floatToRawIntBits((float)this.xyz[mapTL[1]]), Float.floatToRawIntBits((float)this.xyz[mapTL[2]]), this.packColor(colorTL), Float.floatToRawIntBits((float)this.uv[mapTL[3]]), Float.floatToRawIntBits((float)this.uv[mapTL[4]]), this.packNormal(this.state.normal), Float.floatToRawIntBits((float)this.xyz[mapBL[0]]), Float.floatToRawIntBits((float)this.xyz[mapBL[1]]), Float.floatToRawIntBits((float)this.xyz[mapBL[2]]), this.packColor(colorBL), Float.floatToRawIntBits((float)ubl), Float.floatToRawIntBits((float)vbl), this.packNormal(this.state.normal), Float.floatToRawIntBits((float)this.xyz[mapBR[0]]), Float.floatToRawIntBits((float)this.xyz[mapBR[1]]), Float.floatToRawIntBits((float)this.xyz[mapBR[2]]), this.packColor(colorBR), Float.floatToRawIntBits((float)this.uv[mapBR[3]]), Float.floatToRawIntBits((float)this.uv[mapBR[4]]), this.packNormal(this.state.normal), Float.floatToRawIntBits((float)this.xyz[mapTR[0]]), Float.floatToRawIntBits((float)this.xyz[mapTR[1]]), Float.floatToRawIntBits((float)this.xyz[mapTR[2]]), this.packColor(colorTR), Float.floatToRawIntBits((float)utr), Float.floatToRawIntBits((float)vtr), this.packNormal(this.state.normal)}, this.bakedTintIndex, facing, icon, this.diffuseLight, this.getVertexFormat());
    }

    private int packColor(float[] color) {
        int r = MathHelper.func_76125_a((int)((int)(color[0] * 255.0f)), (int)0, (int)255);
        int g = MathHelper.func_76125_a((int)((int)(color[1] * 255.0f)), (int)0, (int)255);
        int b = MathHelper.func_76125_a((int)((int)(color[2] * 255.0f)), (int)0, (int)255);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private int packNormal(float[] normal) {
        int nx = (int)(normal[0] * 127.0f) & 0xFF;
        int ny = (int)(normal[1] * 127.0f) & 0xFF;
        int nz = (int)(normal[2] * 127.0f) & 0xFF;
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            return nx | ny << 8 | nz << 16;
        }
        return nx << 24 | ny << 16 | nz << 8;
    }
}

