/*
 * Decompiled with CFR 0.152.
 */
package api.player.render;

import api.player.render.IRenderPlayer;
import api.player.render.RenderPlayerAPI;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.ResourceLocation;

public abstract class RenderPlayerBase {
    protected final RenderPlayer renderPlayer;
    protected final IRenderPlayer renderPlayerAPI;
    private final RenderPlayerAPI internalRenderPlayerAPI;

    public RenderPlayerBase(RenderPlayerAPI renderPlayerAPI) {
        this.internalRenderPlayerAPI = renderPlayerAPI;
        this.renderPlayerAPI = renderPlayerAPI.renderPlayer;
        this.renderPlayer = renderPlayerAPI.renderPlayer.getRenderPlayer();
    }

    public void beforeBaseAttach(boolean onTheFly) {
    }

    public void afterBaseAttach(boolean onTheFly) {
    }

    public void beforeLocalConstructing(RenderManager paramRenderManager, boolean paramBoolean) {
    }

    public void afterLocalConstructing(RenderManager paramRenderManager, boolean paramBoolean) {
    }

    public void beforeBaseDetach(boolean onTheFly) {
    }

    public void afterBaseDetach(boolean onTheFly) {
    }

    public Object dynamic(String key, Object[] parameters) {
        return this.internalRenderPlayerAPI.dynamicOverwritten(key, parameters, this);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public void beforeAddLayer(LayerRenderer paramLayerRenderer) {
    }

    public boolean addLayer(LayerRenderer paramLayerRenderer) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenAddLayer(this);
        boolean _result = overwritten == null ? this.renderPlayerAPI.localAddLayer(paramLayerRenderer) : (overwritten != this ? overwritten.addLayer(paramLayerRenderer) : false);
        return _result;
    }

    public void afterAddLayer(LayerRenderer paramLayerRenderer) {
    }

    public void beforeBindEntityTexture(AbstractClientPlayer paramAbstractClientPlayer) {
    }

    public boolean bindEntityTexture(AbstractClientPlayer paramAbstractClientPlayer) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenBindEntityTexture(this);
        boolean _result = overwritten == null ? this.renderPlayerAPI.localBindEntityTexture(paramAbstractClientPlayer) : (overwritten != this ? overwritten.bindEntityTexture(paramAbstractClientPlayer) : false);
        return _result;
    }

    public void afterBindEntityTexture(AbstractClientPlayer paramAbstractClientPlayer) {
    }

    public void beforeBindTexture(ResourceLocation paramResourceLocation) {
    }

    public void bindTexture(ResourceLocation paramResourceLocation) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenBindTexture(this);
        if (overwritten == null) {
            this.renderPlayerAPI.localBindTexture(paramResourceLocation);
        } else if (overwritten != this) {
            overwritten.bindTexture(paramResourceLocation);
        }
    }

    public void afterBindTexture(ResourceLocation paramResourceLocation) {
    }

    public void beforeCanRenderName(AbstractClientPlayer paramAbstractClientPlayer) {
    }

    public boolean canRenderName(AbstractClientPlayer paramAbstractClientPlayer) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenCanRenderName(this);
        boolean _result = overwritten == null ? this.renderPlayerAPI.localCanRenderName(paramAbstractClientPlayer) : (overwritten != this ? overwritten.canRenderName(paramAbstractClientPlayer) : false);
        return _result;
    }

    public void afterCanRenderName(AbstractClientPlayer paramAbstractClientPlayer) {
    }

    public void beforeDoRender(AbstractClientPlayer paramAbstractClientPlayer, double paramDouble1, double paramDouble2, double paramDouble3, float paramFloat1, float paramFloat2) {
    }

    public void doRender(AbstractClientPlayer paramAbstractClientPlayer, double paramDouble1, double paramDouble2, double paramDouble3, float paramFloat1, float paramFloat2) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenDoRender(this);
        if (overwritten == null) {
            this.renderPlayerAPI.localDoRender(paramAbstractClientPlayer, paramDouble1, paramDouble2, paramDouble3, paramFloat1, paramFloat2);
        } else if (overwritten != this) {
            overwritten.doRender(paramAbstractClientPlayer, paramDouble1, paramDouble2, paramDouble3, paramFloat1, paramFloat2);
        }
    }

    public void afterDoRender(AbstractClientPlayer paramAbstractClientPlayer, double paramDouble1, double paramDouble2, double paramDouble3, float paramFloat1, float paramFloat2) {
    }

    public void beforeDoRenderShadowAndFire(AbstractClientPlayer paramAbstractClientPlayer, double paramDouble1, double paramDouble2, double paramDouble3, float paramFloat1, float paramFloat2) {
    }

    public void doRenderShadowAndFire(AbstractClientPlayer paramAbstractClientPlayer, double paramDouble1, double paramDouble2, double paramDouble3, float paramFloat1, float paramFloat2) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenDoRenderShadowAndFire(this);
        if (overwritten == null) {
            this.renderPlayerAPI.localDoRenderShadowAndFire(paramAbstractClientPlayer, paramDouble1, paramDouble2, paramDouble3, paramFloat1, paramFloat2);
        } else if (overwritten != this) {
            overwritten.doRenderShadowAndFire(paramAbstractClientPlayer, paramDouble1, paramDouble2, paramDouble3, paramFloat1, paramFloat2);
        }
    }

    public void afterDoRenderShadowAndFire(AbstractClientPlayer paramAbstractClientPlayer, double paramDouble1, double paramDouble2, double paramDouble3, float paramFloat1, float paramFloat2) {
    }

    public void beforeGetColorMultiplier(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat1, float paramFloat2) {
    }

    public int getColorMultiplier(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat1, float paramFloat2) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenGetColorMultiplier(this);
        int _result = overwritten == null ? this.renderPlayerAPI.localGetColorMultiplier(paramAbstractClientPlayer, paramFloat1, paramFloat2) : (overwritten != this ? overwritten.getColorMultiplier(paramAbstractClientPlayer, paramFloat1, paramFloat2) : 0);
        return _result;
    }

    public void afterGetColorMultiplier(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat1, float paramFloat2) {
    }

    public void beforeGetDeathMaxRotation(AbstractClientPlayer paramAbstractClientPlayer) {
    }

    public float getDeathMaxRotation(AbstractClientPlayer paramAbstractClientPlayer) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenGetDeathMaxRotation(this);
        float _result = overwritten == null ? this.renderPlayerAPI.localGetDeathMaxRotation(paramAbstractClientPlayer) : (overwritten != this ? overwritten.getDeathMaxRotation(paramAbstractClientPlayer) : 0.0f);
        return _result;
    }

    public void afterGetDeathMaxRotation(AbstractClientPlayer paramAbstractClientPlayer) {
    }

    public void beforeGetEntityTexture(AbstractClientPlayer paramAbstractClientPlayer) {
    }

    public ResourceLocation getEntityTexture(AbstractClientPlayer paramAbstractClientPlayer) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenGetEntityTexture(this);
        Object _result = overwritten == null ? this.renderPlayerAPI.localGetEntityTexture(paramAbstractClientPlayer) : (overwritten != this ? overwritten.getEntityTexture(paramAbstractClientPlayer) : null);
        return _result;
    }

    public void afterGetEntityTexture(AbstractClientPlayer paramAbstractClientPlayer) {
    }

    public void beforeGetFontRendererFromRenderManager() {
    }

    public FontRenderer getFontRendererFromRenderManager() {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenGetFontRendererFromRenderManager(this);
        Object _result = overwritten == null ? this.renderPlayerAPI.localGetFontRendererFromRenderManager() : (overwritten != this ? overwritten.getFontRendererFromRenderManager() : null);
        return _result;
    }

    public void afterGetFontRendererFromRenderManager() {
    }

    public void beforeGetMainModel() {
    }

    public ModelPlayer getMainModel() {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenGetMainModel(this);
        Object _result = overwritten == null ? this.renderPlayerAPI.localGetMainModel() : (overwritten != this ? overwritten.getMainModel() : null);
        return _result;
    }

    public void afterGetMainModel() {
    }

    public void beforeGetRenderManager() {
    }

    public RenderManager getRenderManager() {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenGetRenderManager(this);
        Object _result = overwritten == null ? this.renderPlayerAPI.localGetRenderManager() : (overwritten != this ? overwritten.getRenderManager() : null);
        return _result;
    }

    public void afterGetRenderManager() {
    }

    public void beforeGetSwingProgress(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat) {
    }

    public float getSwingProgress(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenGetSwingProgress(this);
        float _result = overwritten == null ? this.renderPlayerAPI.localGetSwingProgress(paramAbstractClientPlayer, paramFloat) : (overwritten != this ? overwritten.getSwingProgress(paramAbstractClientPlayer, paramFloat) : 0.0f);
        return _result;
    }

    public void afterGetSwingProgress(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat) {
    }

    public void beforeGetTeamColor(AbstractClientPlayer paramAbstractClientPlayer) {
    }

    public int getTeamColor(AbstractClientPlayer paramAbstractClientPlayer) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenGetTeamColor(this);
        int _result = overwritten == null ? this.renderPlayerAPI.localGetTeamColor(paramAbstractClientPlayer) : (overwritten != this ? overwritten.getTeamColor(paramAbstractClientPlayer) : 0);
        return _result;
    }

    public void afterGetTeamColor(AbstractClientPlayer paramAbstractClientPlayer) {
    }

    public void beforeHandleRotationFloat(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat) {
    }

    public float handleRotationFloat(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenHandleRotationFloat(this);
        float _result = overwritten == null ? this.renderPlayerAPI.localHandleRotationFloat(paramAbstractClientPlayer, paramFloat) : (overwritten != this ? overwritten.handleRotationFloat(paramAbstractClientPlayer, paramFloat) : 0.0f);
        return _result;
    }

    public void afterHandleRotationFloat(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat) {
    }

    public void beforeInterpolateRotation(float paramFloat1, float paramFloat2, float paramFloat3) {
    }

    public float interpolateRotation(float paramFloat1, float paramFloat2, float paramFloat3) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenInterpolateRotation(this);
        float _result = overwritten == null ? this.renderPlayerAPI.localInterpolateRotation(paramFloat1, paramFloat2, paramFloat3) : (overwritten != this ? overwritten.interpolateRotation(paramFloat1, paramFloat2, paramFloat3) : 0.0f);
        return _result;
    }

    public void afterInterpolateRotation(float paramFloat1, float paramFloat2, float paramFloat3) {
    }

    public void beforeIsMultipass() {
    }

    public boolean isMultipass() {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenIsMultipass(this);
        boolean _result = overwritten == null ? this.renderPlayerAPI.localIsMultipass() : (overwritten != this ? overwritten.isMultipass() : false);
        return _result;
    }

    public void afterIsMultipass() {
    }

    public void beforeIsVisible(AbstractClientPlayer paramAbstractClientPlayer) {
    }

    public boolean isVisible(AbstractClientPlayer paramAbstractClientPlayer) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenIsVisible(this);
        boolean _result = overwritten == null ? this.renderPlayerAPI.localIsVisible(paramAbstractClientPlayer) : (overwritten != this ? overwritten.isVisible(paramAbstractClientPlayer) : false);
        return _result;
    }

    public void afterIsVisible(AbstractClientPlayer paramAbstractClientPlayer) {
    }

    public void beforePreRenderCallback(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat) {
    }

    public void preRenderCallback(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenPreRenderCallback(this);
        if (overwritten == null) {
            this.renderPlayerAPI.localPreRenderCallback(paramAbstractClientPlayer, paramFloat);
        } else if (overwritten != this) {
            overwritten.preRenderCallback(paramAbstractClientPlayer, paramFloat);
        }
    }

    public void afterPreRenderCallback(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat) {
    }

    public void beforePrepareScale(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat) {
    }

    public float prepareScale(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenPrepareScale(this);
        float _result = overwritten == null ? this.renderPlayerAPI.localPrepareScale(paramAbstractClientPlayer, paramFloat) : (overwritten != this ? overwritten.prepareScale(paramAbstractClientPlayer, paramFloat) : 0.0f);
        return _result;
    }

    public void afterPrepareScale(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat) {
    }

    public void beforeRenderEntityName(AbstractClientPlayer paramAbstractClientPlayer, double paramDouble1, double paramDouble2, double paramDouble3, String paramString, double paramDouble4) {
    }

    public void renderEntityName(AbstractClientPlayer paramAbstractClientPlayer, double paramDouble1, double paramDouble2, double paramDouble3, String paramString, double paramDouble4) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenRenderEntityName(this);
        if (overwritten == null) {
            this.renderPlayerAPI.localRenderEntityName(paramAbstractClientPlayer, paramDouble1, paramDouble2, paramDouble3, paramString, paramDouble4);
        } else if (overwritten != this) {
            overwritten.renderEntityName(paramAbstractClientPlayer, paramDouble1, paramDouble2, paramDouble3, paramString, paramDouble4);
        }
    }

    public void afterRenderEntityName(AbstractClientPlayer paramAbstractClientPlayer, double paramDouble1, double paramDouble2, double paramDouble3, String paramString, double paramDouble4) {
    }

    public void beforeRenderLayers(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat1, float paramFloat2, float paramFloat3, float paramFloat4, float paramFloat5, float paramFloat6, float paramFloat7) {
    }

    public void renderLayers(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat1, float paramFloat2, float paramFloat3, float paramFloat4, float paramFloat5, float paramFloat6, float paramFloat7) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenRenderLayers(this);
        if (overwritten == null) {
            this.renderPlayerAPI.localRenderLayers(paramAbstractClientPlayer, paramFloat1, paramFloat2, paramFloat3, paramFloat4, paramFloat5, paramFloat6, paramFloat7);
        } else if (overwritten != this) {
            overwritten.renderLayers(paramAbstractClientPlayer, paramFloat1, paramFloat2, paramFloat3, paramFloat4, paramFloat5, paramFloat6, paramFloat7);
        }
    }

    public void afterRenderLayers(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat1, float paramFloat2, float paramFloat3, float paramFloat4, float paramFloat5, float paramFloat6, float paramFloat7) {
    }

    public void beforeRenderLeftArm(AbstractClientPlayer paramAbstractClientPlayer) {
    }

    public void renderLeftArm(AbstractClientPlayer paramAbstractClientPlayer) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenRenderLeftArm(this);
        if (overwritten == null) {
            this.renderPlayerAPI.localRenderLeftArm(paramAbstractClientPlayer);
        } else if (overwritten != this) {
            overwritten.renderLeftArm(paramAbstractClientPlayer);
        }
    }

    public void afterRenderLeftArm(AbstractClientPlayer paramAbstractClientPlayer) {
    }

    public void beforeRenderLivingAt(AbstractClientPlayer paramAbstractClientPlayer, double paramDouble1, double paramDouble2, double paramDouble3) {
    }

    public void renderLivingAt(AbstractClientPlayer paramAbstractClientPlayer, double paramDouble1, double paramDouble2, double paramDouble3) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenRenderLivingAt(this);
        if (overwritten == null) {
            this.renderPlayerAPI.localRenderLivingAt(paramAbstractClientPlayer, paramDouble1, paramDouble2, paramDouble3);
        } else if (overwritten != this) {
            overwritten.renderLivingAt(paramAbstractClientPlayer, paramDouble1, paramDouble2, paramDouble3);
        }
    }

    public void afterRenderLivingAt(AbstractClientPlayer paramAbstractClientPlayer, double paramDouble1, double paramDouble2, double paramDouble3) {
    }

    public void beforeRenderLivingLabel(AbstractClientPlayer paramAbstractClientPlayer, String paramString, double paramDouble1, double paramDouble2, double paramDouble3, int paramInt) {
    }

    public void renderLivingLabel(AbstractClientPlayer paramAbstractClientPlayer, String paramString, double paramDouble1, double paramDouble2, double paramDouble3, int paramInt) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenRenderLivingLabel(this);
        if (overwritten == null) {
            this.renderPlayerAPI.localRenderLivingLabel(paramAbstractClientPlayer, paramString, paramDouble1, paramDouble2, paramDouble3, paramInt);
        } else if (overwritten != this) {
            overwritten.renderLivingLabel(paramAbstractClientPlayer, paramString, paramDouble1, paramDouble2, paramDouble3, paramInt);
        }
    }

    public void afterRenderLivingLabel(AbstractClientPlayer paramAbstractClientPlayer, String paramString, double paramDouble1, double paramDouble2, double paramDouble3, int paramInt) {
    }

    public void beforeRenderModel(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat1, float paramFloat2, float paramFloat3, float paramFloat4, float paramFloat5, float paramFloat6) {
    }

    public void renderModel(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat1, float paramFloat2, float paramFloat3, float paramFloat4, float paramFloat5, float paramFloat6) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenRenderModel(this);
        if (overwritten == null) {
            this.renderPlayerAPI.localRenderModel(paramAbstractClientPlayer, paramFloat1, paramFloat2, paramFloat3, paramFloat4, paramFloat5, paramFloat6);
        } else if (overwritten != this) {
            overwritten.renderModel(paramAbstractClientPlayer, paramFloat1, paramFloat2, paramFloat3, paramFloat4, paramFloat5, paramFloat6);
        }
    }

    public void afterRenderModel(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat1, float paramFloat2, float paramFloat3, float paramFloat4, float paramFloat5, float paramFloat6) {
    }

    public void beforeRenderMultipass(AbstractClientPlayer paramAbstractClientPlayer, double paramDouble1, double paramDouble2, double paramDouble3, float paramFloat1, float paramFloat2) {
    }

    public void renderMultipass(AbstractClientPlayer paramAbstractClientPlayer, double paramDouble1, double paramDouble2, double paramDouble3, float paramFloat1, float paramFloat2) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenRenderMultipass(this);
        if (overwritten == null) {
            this.renderPlayerAPI.localRenderMultipass(paramAbstractClientPlayer, paramDouble1, paramDouble2, paramDouble3, paramFloat1, paramFloat2);
        } else if (overwritten != this) {
            overwritten.renderMultipass(paramAbstractClientPlayer, paramDouble1, paramDouble2, paramDouble3, paramFloat1, paramFloat2);
        }
    }

    public void afterRenderMultipass(AbstractClientPlayer paramAbstractClientPlayer, double paramDouble1, double paramDouble2, double paramDouble3, float paramFloat1, float paramFloat2) {
    }

    public void beforeRenderName(AbstractClientPlayer paramAbstractClientPlayer, double paramDouble1, double paramDouble2, double paramDouble3) {
    }

    public void renderName(AbstractClientPlayer paramAbstractClientPlayer, double paramDouble1, double paramDouble2, double paramDouble3) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenRenderName(this);
        if (overwritten == null) {
            this.renderPlayerAPI.localRenderName(paramAbstractClientPlayer, paramDouble1, paramDouble2, paramDouble3);
        } else if (overwritten != this) {
            overwritten.renderName(paramAbstractClientPlayer, paramDouble1, paramDouble2, paramDouble3);
        }
    }

    public void afterRenderName(AbstractClientPlayer paramAbstractClientPlayer, double paramDouble1, double paramDouble2, double paramDouble3) {
    }

    public void beforeRenderRightArm(AbstractClientPlayer paramAbstractClientPlayer) {
    }

    public void renderRightArm(AbstractClientPlayer paramAbstractClientPlayer) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenRenderRightArm(this);
        if (overwritten == null) {
            this.renderPlayerAPI.localRenderRightArm(paramAbstractClientPlayer);
        } else if (overwritten != this) {
            overwritten.renderRightArm(paramAbstractClientPlayer);
        }
    }

    public void afterRenderRightArm(AbstractClientPlayer paramAbstractClientPlayer) {
    }

    public void beforeRotateCorpse(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat1, float paramFloat2, float paramFloat3) {
    }

    public void rotateCorpse(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat1, float paramFloat2, float paramFloat3) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenRotateCorpse(this);
        if (overwritten == null) {
            this.renderPlayerAPI.localRotateCorpse(paramAbstractClientPlayer, paramFloat1, paramFloat2, paramFloat3);
        } else if (overwritten != this) {
            overwritten.rotateCorpse(paramAbstractClientPlayer, paramFloat1, paramFloat2, paramFloat3);
        }
    }

    public void afterRotateCorpse(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat1, float paramFloat2, float paramFloat3) {
    }

    public void beforeSetBrightness(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat, boolean paramBoolean) {
    }

    public boolean setBrightness(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat, boolean paramBoolean) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenSetBrightness(this);
        boolean _result = overwritten == null ? this.renderPlayerAPI.localSetBrightness(paramAbstractClientPlayer, paramFloat, paramBoolean) : (overwritten != this ? overwritten.setBrightness(paramAbstractClientPlayer, paramFloat, paramBoolean) : false);
        return _result;
    }

    public void afterSetBrightness(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat, boolean paramBoolean) {
    }

    public void beforeSetDoRenderBrightness(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat) {
    }

    public boolean setDoRenderBrightness(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenSetDoRenderBrightness(this);
        boolean _result = overwritten == null ? this.renderPlayerAPI.localSetDoRenderBrightness(paramAbstractClientPlayer, paramFloat) : (overwritten != this ? overwritten.setDoRenderBrightness(paramAbstractClientPlayer, paramFloat) : false);
        return _result;
    }

    public void afterSetDoRenderBrightness(AbstractClientPlayer paramAbstractClientPlayer, float paramFloat) {
    }

    public void beforeSetModelVisibilities(AbstractClientPlayer paramAbstractClientPlayer) {
    }

    public void setModelVisibilities(AbstractClientPlayer paramAbstractClientPlayer) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenSetModelVisibilities(this);
        if (overwritten == null) {
            this.renderPlayerAPI.localSetModelVisibilities(paramAbstractClientPlayer);
        } else if (overwritten != this) {
            overwritten.setModelVisibilities(paramAbstractClientPlayer);
        }
    }

    public void afterSetModelVisibilities(AbstractClientPlayer paramAbstractClientPlayer) {
    }

    public void beforeSetRenderOutlines(boolean paramBoolean) {
    }

    public void setRenderOutlines(boolean paramBoolean) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenSetRenderOutlines(this);
        if (overwritten == null) {
            this.renderPlayerAPI.localSetRenderOutlines(paramBoolean);
        } else if (overwritten != this) {
            overwritten.setRenderOutlines(paramBoolean);
        }
    }

    public void afterSetRenderOutlines(boolean paramBoolean) {
    }

    public void beforeSetScoreTeamColor(AbstractClientPlayer paramAbstractClientPlayer) {
    }

    public boolean setScoreTeamColor(AbstractClientPlayer paramAbstractClientPlayer) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenSetScoreTeamColor(this);
        boolean _result = overwritten == null ? this.renderPlayerAPI.localSetScoreTeamColor(paramAbstractClientPlayer) : (overwritten != this ? overwritten.setScoreTeamColor(paramAbstractClientPlayer) : false);
        return _result;
    }

    public void afterSetScoreTeamColor(AbstractClientPlayer paramAbstractClientPlayer) {
    }

    public void beforeShouldRender(AbstractClientPlayer paramAbstractClientPlayer, ICamera paramICamera, double paramDouble1, double paramDouble2, double paramDouble3) {
    }

    public boolean shouldRender(AbstractClientPlayer paramAbstractClientPlayer, ICamera paramICamera, double paramDouble1, double paramDouble2, double paramDouble3) {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenShouldRender(this);
        boolean _result = overwritten == null ? this.renderPlayerAPI.localShouldRender(paramAbstractClientPlayer, paramICamera, paramDouble1, paramDouble2, paramDouble3) : (overwritten != this ? overwritten.shouldRender(paramAbstractClientPlayer, paramICamera, paramDouble1, paramDouble2, paramDouble3) : false);
        return _result;
    }

    public void afterShouldRender(AbstractClientPlayer paramAbstractClientPlayer, ICamera paramICamera, double paramDouble1, double paramDouble2, double paramDouble3) {
    }

    public void beforeTransformHeldFull3DItemLayer() {
    }

    public void transformHeldFull3DItemLayer() {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenTransformHeldFull3DItemLayer(this);
        if (overwritten == null) {
            this.renderPlayerAPI.localTransformHeldFull3DItemLayer();
        } else if (overwritten != this) {
            overwritten.transformHeldFull3DItemLayer();
        }
    }

    public void afterTransformHeldFull3DItemLayer() {
    }

    public void beforeUnsetBrightness() {
    }

    public void unsetBrightness() {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenUnsetBrightness(this);
        if (overwritten == null) {
            this.renderPlayerAPI.localUnsetBrightness();
        } else if (overwritten != this) {
            overwritten.unsetBrightness();
        }
    }

    public void afterUnsetBrightness() {
    }

    public void beforeUnsetScoreTeamColor() {
    }

    public void unsetScoreTeamColor() {
        RenderPlayerBase overwritten = this.internalRenderPlayerAPI.GetOverwrittenUnsetScoreTeamColor(this);
        if (overwritten == null) {
            this.renderPlayerAPI.localUnsetScoreTeamColor();
        } else if (overwritten != this) {
            overwritten.unsetScoreTeamColor();
        }
    }

    public void afterUnsetScoreTeamColor() {
    }
}

