/*
 * Decompiled with CFR 0.152.
 */
package api.player.model;

import api.player.model.IModelPlayerAPI;
import api.player.model.ModelPlayerBase;
import api.player.model.ModelPlayerBaseSorter;
import api.player.model.ModelPlayerBaseSorting;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.TextureOffset;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumHandSide;

public final class ModelPlayerAPI {
    private static final Class<?>[] Class = new Class[]{ModelPlayerAPI.class};
    private static final Class<?>[] Classes = new Class[]{ModelPlayerAPI.class, String.class};
    private static boolean isCreated;
    private static final Logger logger;
    private static List<WeakReference<IModelPlayerAPI>> allInstances;
    private static final Map<String, String[]> EmptySortMap;
    private static final List<String> beforeGetArmForSideHookTypes;
    private static final List<String> overrideGetArmForSideHookTypes;
    private static final List<String> afterGetArmForSideHookTypes;
    private ModelPlayerBase[] beforeGetArmForSideHooks;
    private ModelPlayerBase[] overrideGetArmForSideHooks;
    private ModelPlayerBase[] afterGetArmForSideHooks;
    public boolean isGetArmForSideModded;
    private static final Map<String, String[]> allBaseBeforeGetArmForSideSuperiors;
    private static final Map<String, String[]> allBaseBeforeGetArmForSideInferiors;
    private static final Map<String, String[]> allBaseOverrideGetArmForSideSuperiors;
    private static final Map<String, String[]> allBaseOverrideGetArmForSideInferiors;
    private static final Map<String, String[]> allBaseAfterGetArmForSideSuperiors;
    private static final Map<String, String[]> allBaseAfterGetArmForSideInferiors;
    private static final List<String> beforeGetMainHandHookTypes;
    private static final List<String> overrideGetMainHandHookTypes;
    private static final List<String> afterGetMainHandHookTypes;
    private ModelPlayerBase[] beforeGetMainHandHooks;
    private ModelPlayerBase[] overrideGetMainHandHooks;
    private ModelPlayerBase[] afterGetMainHandHooks;
    public boolean isGetMainHandModded;
    private static final Map<String, String[]> allBaseBeforeGetMainHandSuperiors;
    private static final Map<String, String[]> allBaseBeforeGetMainHandInferiors;
    private static final Map<String, String[]> allBaseOverrideGetMainHandSuperiors;
    private static final Map<String, String[]> allBaseOverrideGetMainHandInferiors;
    private static final Map<String, String[]> allBaseAfterGetMainHandSuperiors;
    private static final Map<String, String[]> allBaseAfterGetMainHandInferiors;
    private static final List<String> beforeGetRandomModelBoxHookTypes;
    private static final List<String> overrideGetRandomModelBoxHookTypes;
    private static final List<String> afterGetRandomModelBoxHookTypes;
    private ModelPlayerBase[] beforeGetRandomModelBoxHooks;
    private ModelPlayerBase[] overrideGetRandomModelBoxHooks;
    private ModelPlayerBase[] afterGetRandomModelBoxHooks;
    public boolean isGetRandomModelBoxModded;
    private static final Map<String, String[]> allBaseBeforeGetRandomModelBoxSuperiors;
    private static final Map<String, String[]> allBaseBeforeGetRandomModelBoxInferiors;
    private static final Map<String, String[]> allBaseOverrideGetRandomModelBoxSuperiors;
    private static final Map<String, String[]> allBaseOverrideGetRandomModelBoxInferiors;
    private static final Map<String, String[]> allBaseAfterGetRandomModelBoxSuperiors;
    private static final Map<String, String[]> allBaseAfterGetRandomModelBoxInferiors;
    private static final List<String> beforeGetTextureOffsetHookTypes;
    private static final List<String> overrideGetTextureOffsetHookTypes;
    private static final List<String> afterGetTextureOffsetHookTypes;
    private ModelPlayerBase[] beforeGetTextureOffsetHooks;
    private ModelPlayerBase[] overrideGetTextureOffsetHooks;
    private ModelPlayerBase[] afterGetTextureOffsetHooks;
    public boolean isGetTextureOffsetModded;
    private static final Map<String, String[]> allBaseBeforeGetTextureOffsetSuperiors;
    private static final Map<String, String[]> allBaseBeforeGetTextureOffsetInferiors;
    private static final Map<String, String[]> allBaseOverrideGetTextureOffsetSuperiors;
    private static final Map<String, String[]> allBaseOverrideGetTextureOffsetInferiors;
    private static final Map<String, String[]> allBaseAfterGetTextureOffsetSuperiors;
    private static final Map<String, String[]> allBaseAfterGetTextureOffsetInferiors;
    private static final List<String> beforePostRenderArmHookTypes;
    private static final List<String> overridePostRenderArmHookTypes;
    private static final List<String> afterPostRenderArmHookTypes;
    private ModelPlayerBase[] beforePostRenderArmHooks;
    private ModelPlayerBase[] overridePostRenderArmHooks;
    private ModelPlayerBase[] afterPostRenderArmHooks;
    public boolean isPostRenderArmModded;
    private static final Map<String, String[]> allBaseBeforePostRenderArmSuperiors;
    private static final Map<String, String[]> allBaseBeforePostRenderArmInferiors;
    private static final Map<String, String[]> allBaseOverridePostRenderArmSuperiors;
    private static final Map<String, String[]> allBaseOverridePostRenderArmInferiors;
    private static final Map<String, String[]> allBaseAfterPostRenderArmSuperiors;
    private static final Map<String, String[]> allBaseAfterPostRenderArmInferiors;
    private static final List<String> beforeRenderHookTypes;
    private static final List<String> overrideRenderHookTypes;
    private static final List<String> afterRenderHookTypes;
    private ModelPlayerBase[] beforeRenderHooks;
    private ModelPlayerBase[] overrideRenderHooks;
    private ModelPlayerBase[] afterRenderHooks;
    public boolean isRenderModded;
    private static final Map<String, String[]> allBaseBeforeRenderSuperiors;
    private static final Map<String, String[]> allBaseBeforeRenderInferiors;
    private static final Map<String, String[]> allBaseOverrideRenderSuperiors;
    private static final Map<String, String[]> allBaseOverrideRenderInferiors;
    private static final Map<String, String[]> allBaseAfterRenderSuperiors;
    private static final Map<String, String[]> allBaseAfterRenderInferiors;
    private static final List<String> beforeRenderCapeHookTypes;
    private static final List<String> overrideRenderCapeHookTypes;
    private static final List<String> afterRenderCapeHookTypes;
    private ModelPlayerBase[] beforeRenderCapeHooks;
    private ModelPlayerBase[] overrideRenderCapeHooks;
    private ModelPlayerBase[] afterRenderCapeHooks;
    public boolean isRenderCapeModded;
    private static final Map<String, String[]> allBaseBeforeRenderCapeSuperiors;
    private static final Map<String, String[]> allBaseBeforeRenderCapeInferiors;
    private static final Map<String, String[]> allBaseOverrideRenderCapeSuperiors;
    private static final Map<String, String[]> allBaseOverrideRenderCapeInferiors;
    private static final Map<String, String[]> allBaseAfterRenderCapeSuperiors;
    private static final Map<String, String[]> allBaseAfterRenderCapeInferiors;
    private static final List<String> beforeRenderDeadmau5HeadHookTypes;
    private static final List<String> overrideRenderDeadmau5HeadHookTypes;
    private static final List<String> afterRenderDeadmau5HeadHookTypes;
    private ModelPlayerBase[] beforeRenderDeadmau5HeadHooks;
    private ModelPlayerBase[] overrideRenderDeadmau5HeadHooks;
    private ModelPlayerBase[] afterRenderDeadmau5HeadHooks;
    public boolean isRenderDeadmau5HeadModded;
    private static final Map<String, String[]> allBaseBeforeRenderDeadmau5HeadSuperiors;
    private static final Map<String, String[]> allBaseBeforeRenderDeadmau5HeadInferiors;
    private static final Map<String, String[]> allBaseOverrideRenderDeadmau5HeadSuperiors;
    private static final Map<String, String[]> allBaseOverrideRenderDeadmau5HeadInferiors;
    private static final Map<String, String[]> allBaseAfterRenderDeadmau5HeadSuperiors;
    private static final Map<String, String[]> allBaseAfterRenderDeadmau5HeadInferiors;
    private static final List<String> beforeSetLivingAnimationsHookTypes;
    private static final List<String> overrideSetLivingAnimationsHookTypes;
    private static final List<String> afterSetLivingAnimationsHookTypes;
    private ModelPlayerBase[] beforeSetLivingAnimationsHooks;
    private ModelPlayerBase[] overrideSetLivingAnimationsHooks;
    private ModelPlayerBase[] afterSetLivingAnimationsHooks;
    public boolean isSetLivingAnimationsModded;
    private static final Map<String, String[]> allBaseBeforeSetLivingAnimationsSuperiors;
    private static final Map<String, String[]> allBaseBeforeSetLivingAnimationsInferiors;
    private static final Map<String, String[]> allBaseOverrideSetLivingAnimationsSuperiors;
    private static final Map<String, String[]> allBaseOverrideSetLivingAnimationsInferiors;
    private static final Map<String, String[]> allBaseAfterSetLivingAnimationsSuperiors;
    private static final Map<String, String[]> allBaseAfterSetLivingAnimationsInferiors;
    private static final List<String> beforeSetModelAttributesHookTypes;
    private static final List<String> overrideSetModelAttributesHookTypes;
    private static final List<String> afterSetModelAttributesHookTypes;
    private ModelPlayerBase[] beforeSetModelAttributesHooks;
    private ModelPlayerBase[] overrideSetModelAttributesHooks;
    private ModelPlayerBase[] afterSetModelAttributesHooks;
    public boolean isSetModelAttributesModded;
    private static final Map<String, String[]> allBaseBeforeSetModelAttributesSuperiors;
    private static final Map<String, String[]> allBaseBeforeSetModelAttributesInferiors;
    private static final Map<String, String[]> allBaseOverrideSetModelAttributesSuperiors;
    private static final Map<String, String[]> allBaseOverrideSetModelAttributesInferiors;
    private static final Map<String, String[]> allBaseAfterSetModelAttributesSuperiors;
    private static final Map<String, String[]> allBaseAfterSetModelAttributesInferiors;
    private static final List<String> beforeSetRotationAnglesHookTypes;
    private static final List<String> overrideSetRotationAnglesHookTypes;
    private static final List<String> afterSetRotationAnglesHookTypes;
    private ModelPlayerBase[] beforeSetRotationAnglesHooks;
    private ModelPlayerBase[] overrideSetRotationAnglesHooks;
    private ModelPlayerBase[] afterSetRotationAnglesHooks;
    public boolean isSetRotationAnglesModded;
    private static final Map<String, String[]> allBaseBeforeSetRotationAnglesSuperiors;
    private static final Map<String, String[]> allBaseBeforeSetRotationAnglesInferiors;
    private static final Map<String, String[]> allBaseOverrideSetRotationAnglesSuperiors;
    private static final Map<String, String[]> allBaseOverrideSetRotationAnglesInferiors;
    private static final Map<String, String[]> allBaseAfterSetRotationAnglesSuperiors;
    private static final Map<String, String[]> allBaseAfterSetRotationAnglesInferiors;
    private static final List<String> beforeSetTextureOffsetHookTypes;
    private static final List<String> overrideSetTextureOffsetHookTypes;
    private static final List<String> afterSetTextureOffsetHookTypes;
    private ModelPlayerBase[] beforeSetTextureOffsetHooks;
    private ModelPlayerBase[] overrideSetTextureOffsetHooks;
    private ModelPlayerBase[] afterSetTextureOffsetHooks;
    public boolean isSetTextureOffsetModded;
    private static final Map<String, String[]> allBaseBeforeSetTextureOffsetSuperiors;
    private static final Map<String, String[]> allBaseBeforeSetTextureOffsetInferiors;
    private static final Map<String, String[]> allBaseOverrideSetTextureOffsetSuperiors;
    private static final Map<String, String[]> allBaseOverrideSetTextureOffsetInferiors;
    private static final Map<String, String[]> allBaseAfterSetTextureOffsetSuperiors;
    private static final Map<String, String[]> allBaseAfterSetTextureOffsetInferiors;
    private static final List<String> beforeSetVisibleHookTypes;
    private static final List<String> overrideSetVisibleHookTypes;
    private static final List<String> afterSetVisibleHookTypes;
    private ModelPlayerBase[] beforeSetVisibleHooks;
    private ModelPlayerBase[] overrideSetVisibleHooks;
    private ModelPlayerBase[] afterSetVisibleHooks;
    public boolean isSetVisibleModded;
    private static final Map<String, String[]> allBaseBeforeSetVisibleSuperiors;
    private static final Map<String, String[]> allBaseBeforeSetVisibleInferiors;
    private static final Map<String, String[]> allBaseOverrideSetVisibleSuperiors;
    private static final Map<String, String[]> allBaseOverrideSetVisibleInferiors;
    private static final Map<String, String[]> allBaseAfterSetVisibleSuperiors;
    private static final Map<String, String[]> allBaseAfterSetVisibleInferiors;
    protected final IModelPlayerAPI modelPlayer;
    private final float paramFloat1;
    private final float paramFloat2;
    private final int paramInt1;
    private final int paramInt2;
    private final boolean paramBoolean;
    private final String type;
    private static final Set<String> keys;
    private static final Map<String, String> keysToVirtualIds;
    private static final Set<Class<?>> dynamicTypes;
    private static final Map<Class<?>, Map<String, Method>> virtualDynamicHookMethods;
    private static final Map<Class<?>, Map<String, Method>> beforeDynamicHookMethods;
    private static final Map<Class<?>, Map<String, Method>> overrideDynamicHookMethods;
    private static final Map<Class<?>, Map<String, Method>> afterDynamicHookMethods;
    private static final List<String> beforeLocalConstructingHookTypes;
    private static final List<String> afterLocalConstructingHookTypes;
    private static final Map<String, List<String>> beforeDynamicHookTypes;
    private static final Map<String, List<String>> overrideDynamicHookTypes;
    private static final Map<String, List<String>> afterDynamicHookTypes;
    private ModelPlayerBase[] beforeLocalConstructingHooks;
    private ModelPlayerBase[] afterLocalConstructingHooks;
    private final Map<ModelPlayerBase, String> baseObjectsToId = new Hashtable<ModelPlayerBase, String>();
    private final Map<String, ModelPlayerBase> allBaseObjects = new Hashtable<String, ModelPlayerBase>();
    private final Set<String> unmodifiableAllBaseIds = Collections.unmodifiableSet(this.allBaseObjects.keySet());
    private static final Map<String, Constructor<?>> allBaseConstructors;
    private static final Set<String> unmodifiableAllIds;
    private static final Map<String, String[]> allBaseBeforeLocalConstructingSuperiors;
    private static final Map<String, String[]> allBaseBeforeLocalConstructingInferiors;
    private static final Map<String, String[]> allBaseAfterLocalConstructingSuperiors;
    private static final Map<String, String[]> allBaseAfterLocalConstructingInferiors;
    private static final Map<String, Map<String, String[]>> allBaseBeforeDynamicSuperiors;
    private static final Map<String, Map<String, String[]>> allBaseBeforeDynamicInferiors;
    private static final Map<String, Map<String, String[]>> allBaseOverrideDynamicSuperiors;
    private static final Map<String, Map<String, String[]>> allBaseOverrideDynamicInferiors;
    private static final Map<String, Map<String, String[]>> allBaseAfterDynamicSuperiors;
    private static final Map<String, Map<String, String[]>> allBaseAfterDynamicInferiors;
    private static boolean initialized;

    private static void log(String text) {
        System.out.println(text);
        logger.fine(text);
    }

    public static void register(String id, Class<?> baseClass) {
        ModelPlayerAPI.register(id, baseClass, null);
    }

    public static void register(String id, Class<?> baseClass, ModelPlayerBaseSorting baseSorting) {
        try {
            ModelPlayerAPI.register(baseClass, id, baseSorting);
        }
        catch (RuntimeException exception) {
            if (id != null) {
                ModelPlayerAPI.log("Model Player: failed to register id '" + id + "'");
            } else {
                ModelPlayerAPI.log("Model Player: failed to register ModelPlayerBase");
            }
            throw exception;
        }
    }

    private static void register(Class<?> baseClass, String id, ModelPlayerBaseSorting baseSorting) {
        Constructor<?> baseConstructor;
        if (!isCreated) {
            try {
                Method mandatory = ModelPlayer.class.getMethod("getModelPlayerBase", String.class);
                if (mandatory.getReturnType() != ModelPlayerBase.class) {
                    throw new NoSuchMethodException(ModelPlayerBase.class.getName() + " " + ModelPlayer.class.getName() + ".getModelPlayerBase(" + String.class.getName() + ")");
                }
            }
            catch (NoSuchMethodException exception) {
                String[] errorMessageParts = new String[]{"========================================", "The API \"Model Player\" version 1.0 of the mod \"Render Player API Core 1.0\" can not be created!", "----------------------------------------", "Mandatory member method \"{0} getModelPlayerBase({3})\" not found in class \"{1}\".", "There are three scenarios this can happen:", "* Minecraft Forge is missing a Render Player API Core which Minecraft version matches its own.", "  Download and install the latest Render Player API Core for the Minecraft version you were trying to run.", "* The code of the class \"{2}\" of Render Player API Core has been modified beyond recognition by another Minecraft Forge coremod.", "  Try temporary deinstallation of other core mods to find the culprit and deinstall it permanently to fix this specific problem.", "* Render Player API Core has not been installed correctly.", "  Deinstall Render Player API Core and install it again following the installation instructions in the readme file.", "========================================"};
                String baseModelPlayerClassName = ModelPlayerBase.class.getName();
                String targetClassName = ModelPlayer.class.getName();
                String targetClassFileName = targetClassName.replace(".", File.separator);
                String stringClassName = String.class.getName();
                for (int i = 0; i < errorMessageParts.length; ++i) {
                    errorMessageParts[i] = MessageFormat.format(errorMessageParts[i], baseModelPlayerClassName, targetClassName, targetClassFileName, stringClassName);
                }
                for (String errorMessagePart : errorMessageParts) {
                    logger.severe(errorMessagePart);
                }
                for (String errorMessagePart : errorMessageParts) {
                    System.err.println(errorMessagePart);
                }
                String errorMessage = "\n\n";
                for (String errorMessagePart : errorMessageParts) {
                    errorMessage = errorMessage + "\t" + errorMessagePart + "\n";
                }
                throw new RuntimeException(errorMessage, exception);
            }
            ModelPlayerAPI.log("Model Player 1.0 Created");
            isCreated = true;
        }
        if (id == null) {
            throw new NullPointerException("Argument 'id' can not be null");
        }
        if (baseClass == null) {
            throw new NullPointerException("Argument 'baseClass' can not be null");
        }
        Constructor<?> allreadyRegistered = allBaseConstructors.get(id);
        if (allreadyRegistered != null) {
            throw new IllegalArgumentException("The class '" + baseClass.getName() + "' can not be registered with the id '" + id + "' because the class '" + allreadyRegistered.getDeclaringClass().getName() + "' has allready been registered with the same id");
        }
        try {
            baseConstructor = baseClass.getDeclaredConstructor(Classes);
        }
        catch (Throwable t) {
            try {
                baseConstructor = baseClass.getDeclaredConstructor(Class);
            }
            catch (Throwable s) {
                throw new IllegalArgumentException("Can not find necessary constructor with one argument of type '" + ModelPlayerAPI.class.getName() + "' and eventually a second argument of type 'String' in the class '" + baseClass.getName() + "'", t);
            }
        }
        allBaseConstructors.put(id, baseConstructor);
        if (baseSorting != null) {
            ModelPlayerAPI.addSorting(id, allBaseBeforeLocalConstructingSuperiors, baseSorting.getBeforeLocalConstructingSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeLocalConstructingInferiors, baseSorting.getBeforeLocalConstructingInferiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterLocalConstructingSuperiors, baseSorting.getAfterLocalConstructingSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterLocalConstructingInferiors, baseSorting.getAfterLocalConstructingInferiors());
            ModelPlayerAPI.addDynamicSorting(id, allBaseBeforeDynamicSuperiors, baseSorting.getDynamicBeforeSuperiors());
            ModelPlayerAPI.addDynamicSorting(id, allBaseBeforeDynamicInferiors, baseSorting.getDynamicBeforeInferiors());
            ModelPlayerAPI.addDynamicSorting(id, allBaseOverrideDynamicSuperiors, baseSorting.getDynamicOverrideSuperiors());
            ModelPlayerAPI.addDynamicSorting(id, allBaseOverrideDynamicInferiors, baseSorting.getDynamicOverrideInferiors());
            ModelPlayerAPI.addDynamicSorting(id, allBaseAfterDynamicSuperiors, baseSorting.getDynamicAfterSuperiors());
            ModelPlayerAPI.addDynamicSorting(id, allBaseAfterDynamicInferiors, baseSorting.getDynamicAfterInferiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeGetArmForSideSuperiors, baseSorting.getBeforeGetArmForSideSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeGetArmForSideInferiors, baseSorting.getBeforeGetArmForSideInferiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideGetArmForSideSuperiors, baseSorting.getOverrideGetArmForSideSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideGetArmForSideInferiors, baseSorting.getOverrideGetArmForSideInferiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterGetArmForSideSuperiors, baseSorting.getAfterGetArmForSideSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterGetArmForSideInferiors, baseSorting.getAfterGetArmForSideInferiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeGetMainHandSuperiors, baseSorting.getBeforeGetMainHandSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeGetMainHandInferiors, baseSorting.getBeforeGetMainHandInferiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideGetMainHandSuperiors, baseSorting.getOverrideGetMainHandSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideGetMainHandInferiors, baseSorting.getOverrideGetMainHandInferiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterGetMainHandSuperiors, baseSorting.getAfterGetMainHandSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterGetMainHandInferiors, baseSorting.getAfterGetMainHandInferiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeGetRandomModelBoxSuperiors, baseSorting.getBeforeGetRandomModelBoxSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeGetRandomModelBoxInferiors, baseSorting.getBeforeGetRandomModelBoxInferiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideGetRandomModelBoxSuperiors, baseSorting.getOverrideGetRandomModelBoxSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideGetRandomModelBoxInferiors, baseSorting.getOverrideGetRandomModelBoxInferiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterGetRandomModelBoxSuperiors, baseSorting.getAfterGetRandomModelBoxSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterGetRandomModelBoxInferiors, baseSorting.getAfterGetRandomModelBoxInferiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeGetTextureOffsetSuperiors, baseSorting.getBeforeGetTextureOffsetSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeGetTextureOffsetInferiors, baseSorting.getBeforeGetTextureOffsetInferiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideGetTextureOffsetSuperiors, baseSorting.getOverrideGetTextureOffsetSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideGetTextureOffsetInferiors, baseSorting.getOverrideGetTextureOffsetInferiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterGetTextureOffsetSuperiors, baseSorting.getAfterGetTextureOffsetSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterGetTextureOffsetInferiors, baseSorting.getAfterGetTextureOffsetInferiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforePostRenderArmSuperiors, baseSorting.getBeforePostRenderArmSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforePostRenderArmInferiors, baseSorting.getBeforePostRenderArmInferiors());
            ModelPlayerAPI.addSorting(id, allBaseOverridePostRenderArmSuperiors, baseSorting.getOverridePostRenderArmSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseOverridePostRenderArmInferiors, baseSorting.getOverridePostRenderArmInferiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterPostRenderArmSuperiors, baseSorting.getAfterPostRenderArmSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterPostRenderArmInferiors, baseSorting.getAfterPostRenderArmInferiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeRenderSuperiors, baseSorting.getBeforeRenderSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeRenderInferiors, baseSorting.getBeforeRenderInferiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideRenderSuperiors, baseSorting.getOverrideRenderSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideRenderInferiors, baseSorting.getOverrideRenderInferiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterRenderSuperiors, baseSorting.getAfterRenderSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterRenderInferiors, baseSorting.getAfterRenderInferiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeRenderCapeSuperiors, baseSorting.getBeforeRenderCapeSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeRenderCapeInferiors, baseSorting.getBeforeRenderCapeInferiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideRenderCapeSuperiors, baseSorting.getOverrideRenderCapeSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideRenderCapeInferiors, baseSorting.getOverrideRenderCapeInferiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterRenderCapeSuperiors, baseSorting.getAfterRenderCapeSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterRenderCapeInferiors, baseSorting.getAfterRenderCapeInferiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeRenderDeadmau5HeadSuperiors, baseSorting.getBeforeRenderDeadmau5HeadSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeRenderDeadmau5HeadInferiors, baseSorting.getBeforeRenderDeadmau5HeadInferiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideRenderDeadmau5HeadSuperiors, baseSorting.getOverrideRenderDeadmau5HeadSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideRenderDeadmau5HeadInferiors, baseSorting.getOverrideRenderDeadmau5HeadInferiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterRenderDeadmau5HeadSuperiors, baseSorting.getAfterRenderDeadmau5HeadSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterRenderDeadmau5HeadInferiors, baseSorting.getAfterRenderDeadmau5HeadInferiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeSetLivingAnimationsSuperiors, baseSorting.getBeforeSetLivingAnimationsSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeSetLivingAnimationsInferiors, baseSorting.getBeforeSetLivingAnimationsInferiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideSetLivingAnimationsSuperiors, baseSorting.getOverrideSetLivingAnimationsSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideSetLivingAnimationsInferiors, baseSorting.getOverrideSetLivingAnimationsInferiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterSetLivingAnimationsSuperiors, baseSorting.getAfterSetLivingAnimationsSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterSetLivingAnimationsInferiors, baseSorting.getAfterSetLivingAnimationsInferiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeSetModelAttributesSuperiors, baseSorting.getBeforeSetModelAttributesSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeSetModelAttributesInferiors, baseSorting.getBeforeSetModelAttributesInferiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideSetModelAttributesSuperiors, baseSorting.getOverrideSetModelAttributesSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideSetModelAttributesInferiors, baseSorting.getOverrideSetModelAttributesInferiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterSetModelAttributesSuperiors, baseSorting.getAfterSetModelAttributesSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterSetModelAttributesInferiors, baseSorting.getAfterSetModelAttributesInferiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeSetRotationAnglesSuperiors, baseSorting.getBeforeSetRotationAnglesSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeSetRotationAnglesInferiors, baseSorting.getBeforeSetRotationAnglesInferiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideSetRotationAnglesSuperiors, baseSorting.getOverrideSetRotationAnglesSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideSetRotationAnglesInferiors, baseSorting.getOverrideSetRotationAnglesInferiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterSetRotationAnglesSuperiors, baseSorting.getAfterSetRotationAnglesSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterSetRotationAnglesInferiors, baseSorting.getAfterSetRotationAnglesInferiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeSetTextureOffsetSuperiors, baseSorting.getBeforeSetTextureOffsetSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeSetTextureOffsetInferiors, baseSorting.getBeforeSetTextureOffsetInferiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideSetTextureOffsetSuperiors, baseSorting.getOverrideSetTextureOffsetSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideSetTextureOffsetInferiors, baseSorting.getOverrideSetTextureOffsetInferiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterSetTextureOffsetSuperiors, baseSorting.getAfterSetTextureOffsetSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterSetTextureOffsetInferiors, baseSorting.getAfterSetTextureOffsetInferiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeSetVisibleSuperiors, baseSorting.getBeforeSetVisibleSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseBeforeSetVisibleInferiors, baseSorting.getBeforeSetVisibleInferiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideSetVisibleSuperiors, baseSorting.getOverrideSetVisibleSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseOverrideSetVisibleInferiors, baseSorting.getOverrideSetVisibleInferiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterSetVisibleSuperiors, baseSorting.getAfterSetVisibleSuperiors());
            ModelPlayerAPI.addSorting(id, allBaseAfterSetVisibleInferiors, baseSorting.getAfterSetVisibleInferiors());
        }
        ModelPlayerAPI.addMethod(id, baseClass, beforeLocalConstructingHookTypes, "beforeLocalConstructing", Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        ModelPlayerAPI.addMethod(id, baseClass, afterLocalConstructingHookTypes, "afterLocalConstructing", Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        ModelPlayerAPI.addMethod(id, baseClass, beforeGetArmForSideHookTypes, "beforeGetArmForSide", EnumHandSide.class);
        ModelPlayerAPI.addMethod(id, baseClass, overrideGetArmForSideHookTypes, "getArmForSide", EnumHandSide.class);
        ModelPlayerAPI.addMethod(id, baseClass, afterGetArmForSideHookTypes, "afterGetArmForSide", EnumHandSide.class);
        ModelPlayerAPI.addMethod(id, baseClass, beforeGetMainHandHookTypes, "beforeGetMainHand", Entity.class);
        ModelPlayerAPI.addMethod(id, baseClass, overrideGetMainHandHookTypes, "getMainHand", Entity.class);
        ModelPlayerAPI.addMethod(id, baseClass, afterGetMainHandHookTypes, "afterGetMainHand", Entity.class);
        ModelPlayerAPI.addMethod(id, baseClass, beforeGetRandomModelBoxHookTypes, "beforeGetRandomModelBox", Random.class);
        ModelPlayerAPI.addMethod(id, baseClass, overrideGetRandomModelBoxHookTypes, "getRandomModelBox", Random.class);
        ModelPlayerAPI.addMethod(id, baseClass, afterGetRandomModelBoxHookTypes, "afterGetRandomModelBox", Random.class);
        ModelPlayerAPI.addMethod(id, baseClass, beforeGetTextureOffsetHookTypes, "beforeGetTextureOffset", String.class);
        ModelPlayerAPI.addMethod(id, baseClass, overrideGetTextureOffsetHookTypes, "getTextureOffset", String.class);
        ModelPlayerAPI.addMethod(id, baseClass, afterGetTextureOffsetHookTypes, "afterGetTextureOffset", String.class);
        ModelPlayerAPI.addMethod(id, baseClass, beforePostRenderArmHookTypes, "beforePostRenderArm", Float.TYPE, EnumHandSide.class);
        ModelPlayerAPI.addMethod(id, baseClass, overridePostRenderArmHookTypes, "postRenderArm", Float.TYPE, EnumHandSide.class);
        ModelPlayerAPI.addMethod(id, baseClass, afterPostRenderArmHookTypes, "afterPostRenderArm", Float.TYPE, EnumHandSide.class);
        ModelPlayerAPI.addMethod(id, baseClass, beforeRenderHookTypes, "beforeRender", Entity.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
        ModelPlayerAPI.addMethod(id, baseClass, overrideRenderHookTypes, "render", Entity.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
        ModelPlayerAPI.addMethod(id, baseClass, afterRenderHookTypes, "afterRender", Entity.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
        ModelPlayerAPI.addMethod(id, baseClass, beforeRenderCapeHookTypes, "beforeRenderCape", Float.TYPE);
        ModelPlayerAPI.addMethod(id, baseClass, overrideRenderCapeHookTypes, "renderCape", Float.TYPE);
        ModelPlayerAPI.addMethod(id, baseClass, afterRenderCapeHookTypes, "afterRenderCape", Float.TYPE);
        ModelPlayerAPI.addMethod(id, baseClass, beforeRenderDeadmau5HeadHookTypes, "beforeRenderDeadmau5Head", Float.TYPE);
        ModelPlayerAPI.addMethod(id, baseClass, overrideRenderDeadmau5HeadHookTypes, "renderDeadmau5Head", Float.TYPE);
        ModelPlayerAPI.addMethod(id, baseClass, afterRenderDeadmau5HeadHookTypes, "afterRenderDeadmau5Head", Float.TYPE);
        ModelPlayerAPI.addMethod(id, baseClass, beforeSetLivingAnimationsHookTypes, "beforeSetLivingAnimations", EntityLivingBase.class, Float.TYPE, Float.TYPE, Float.TYPE);
        ModelPlayerAPI.addMethod(id, baseClass, overrideSetLivingAnimationsHookTypes, "setLivingAnimations", EntityLivingBase.class, Float.TYPE, Float.TYPE, Float.TYPE);
        ModelPlayerAPI.addMethod(id, baseClass, afterSetLivingAnimationsHookTypes, "afterSetLivingAnimations", EntityLivingBase.class, Float.TYPE, Float.TYPE, Float.TYPE);
        ModelPlayerAPI.addMethod(id, baseClass, beforeSetModelAttributesHookTypes, "beforeSetModelAttributes", ModelBase.class);
        ModelPlayerAPI.addMethod(id, baseClass, overrideSetModelAttributesHookTypes, "setModelAttributes", ModelBase.class);
        ModelPlayerAPI.addMethod(id, baseClass, afterSetModelAttributesHookTypes, "afterSetModelAttributes", ModelBase.class);
        ModelPlayerAPI.addMethod(id, baseClass, beforeSetRotationAnglesHookTypes, "beforeSetRotationAngles", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Entity.class);
        ModelPlayerAPI.addMethod(id, baseClass, overrideSetRotationAnglesHookTypes, "setRotationAngles", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Entity.class);
        ModelPlayerAPI.addMethod(id, baseClass, afterSetRotationAnglesHookTypes, "afterSetRotationAngles", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Entity.class);
        ModelPlayerAPI.addMethod(id, baseClass, beforeSetTextureOffsetHookTypes, "beforeSetTextureOffset", String.class, Integer.TYPE, Integer.TYPE);
        ModelPlayerAPI.addMethod(id, baseClass, overrideSetTextureOffsetHookTypes, "setTextureOffset", String.class, Integer.TYPE, Integer.TYPE);
        ModelPlayerAPI.addMethod(id, baseClass, afterSetTextureOffsetHookTypes, "afterSetTextureOffset", String.class, Integer.TYPE, Integer.TYPE);
        ModelPlayerAPI.addMethod(id, baseClass, beforeSetVisibleHookTypes, "beforeSetVisible", Boolean.TYPE);
        ModelPlayerAPI.addMethod(id, baseClass, overrideSetVisibleHookTypes, "setVisible", Boolean.TYPE);
        ModelPlayerAPI.addMethod(id, baseClass, afterSetVisibleHookTypes, "afterSetVisible", Boolean.TYPE);
        ModelPlayerAPI.addDynamicMethods(id, baseClass);
        ModelPlayerAPI.addDynamicKeys(id, baseClass, beforeDynamicHookMethods, beforeDynamicHookTypes);
        ModelPlayerAPI.addDynamicKeys(id, baseClass, overrideDynamicHookMethods, overrideDynamicHookTypes);
        ModelPlayerAPI.addDynamicKeys(id, baseClass, afterDynamicHookMethods, afterDynamicHookTypes);
        ModelPlayerAPI.initialize();
        for (IModelPlayerAPI instance : ModelPlayerAPI.getAllInstancesList()) {
            instance.getModelPlayerAPI().attachModelPlayerBase(id);
        }
        System.out.println("Model Player: registered " + id);
        logger.fine("Model Player: registered class '" + baseClass.getName() + "' with id '" + id + "'");
        initialized = false;
    }

    public static boolean unregister(String id) {
        if (id == null) {
            return false;
        }
        Constructor<?> constructor = allBaseConstructors.remove(id);
        if (constructor == null) {
            return false;
        }
        for (IModelPlayerAPI instance : ModelPlayerAPI.getAllInstancesList()) {
            instance.getModelPlayerAPI().detachModelPlayerBase(id);
        }
        beforeLocalConstructingHookTypes.remove(id);
        afterLocalConstructingHookTypes.remove(id);
        allBaseBeforeGetArmForSideSuperiors.remove(id);
        allBaseBeforeGetArmForSideInferiors.remove(id);
        allBaseOverrideGetArmForSideSuperiors.remove(id);
        allBaseOverrideGetArmForSideInferiors.remove(id);
        allBaseAfterGetArmForSideSuperiors.remove(id);
        allBaseAfterGetArmForSideInferiors.remove(id);
        beforeGetArmForSideHookTypes.remove(id);
        overrideGetArmForSideHookTypes.remove(id);
        afterGetArmForSideHookTypes.remove(id);
        allBaseBeforeGetMainHandSuperiors.remove(id);
        allBaseBeforeGetMainHandInferiors.remove(id);
        allBaseOverrideGetMainHandSuperiors.remove(id);
        allBaseOverrideGetMainHandInferiors.remove(id);
        allBaseAfterGetMainHandSuperiors.remove(id);
        allBaseAfterGetMainHandInferiors.remove(id);
        beforeGetMainHandHookTypes.remove(id);
        overrideGetMainHandHookTypes.remove(id);
        afterGetMainHandHookTypes.remove(id);
        allBaseBeforeGetRandomModelBoxSuperiors.remove(id);
        allBaseBeforeGetRandomModelBoxInferiors.remove(id);
        allBaseOverrideGetRandomModelBoxSuperiors.remove(id);
        allBaseOverrideGetRandomModelBoxInferiors.remove(id);
        allBaseAfterGetRandomModelBoxSuperiors.remove(id);
        allBaseAfterGetRandomModelBoxInferiors.remove(id);
        beforeGetRandomModelBoxHookTypes.remove(id);
        overrideGetRandomModelBoxHookTypes.remove(id);
        afterGetRandomModelBoxHookTypes.remove(id);
        allBaseBeforeGetTextureOffsetSuperiors.remove(id);
        allBaseBeforeGetTextureOffsetInferiors.remove(id);
        allBaseOverrideGetTextureOffsetSuperiors.remove(id);
        allBaseOverrideGetTextureOffsetInferiors.remove(id);
        allBaseAfterGetTextureOffsetSuperiors.remove(id);
        allBaseAfterGetTextureOffsetInferiors.remove(id);
        beforeGetTextureOffsetHookTypes.remove(id);
        overrideGetTextureOffsetHookTypes.remove(id);
        afterGetTextureOffsetHookTypes.remove(id);
        allBaseBeforePostRenderArmSuperiors.remove(id);
        allBaseBeforePostRenderArmInferiors.remove(id);
        allBaseOverridePostRenderArmSuperiors.remove(id);
        allBaseOverridePostRenderArmInferiors.remove(id);
        allBaseAfterPostRenderArmSuperiors.remove(id);
        allBaseAfterPostRenderArmInferiors.remove(id);
        beforePostRenderArmHookTypes.remove(id);
        overridePostRenderArmHookTypes.remove(id);
        afterPostRenderArmHookTypes.remove(id);
        allBaseBeforeRenderSuperiors.remove(id);
        allBaseBeforeRenderInferiors.remove(id);
        allBaseOverrideRenderSuperiors.remove(id);
        allBaseOverrideRenderInferiors.remove(id);
        allBaseAfterRenderSuperiors.remove(id);
        allBaseAfterRenderInferiors.remove(id);
        beforeRenderHookTypes.remove(id);
        overrideRenderHookTypes.remove(id);
        afterRenderHookTypes.remove(id);
        allBaseBeforeRenderCapeSuperiors.remove(id);
        allBaseBeforeRenderCapeInferiors.remove(id);
        allBaseOverrideRenderCapeSuperiors.remove(id);
        allBaseOverrideRenderCapeInferiors.remove(id);
        allBaseAfterRenderCapeSuperiors.remove(id);
        allBaseAfterRenderCapeInferiors.remove(id);
        beforeRenderCapeHookTypes.remove(id);
        overrideRenderCapeHookTypes.remove(id);
        afterRenderCapeHookTypes.remove(id);
        allBaseBeforeRenderDeadmau5HeadSuperiors.remove(id);
        allBaseBeforeRenderDeadmau5HeadInferiors.remove(id);
        allBaseOverrideRenderDeadmau5HeadSuperiors.remove(id);
        allBaseOverrideRenderDeadmau5HeadInferiors.remove(id);
        allBaseAfterRenderDeadmau5HeadSuperiors.remove(id);
        allBaseAfterRenderDeadmau5HeadInferiors.remove(id);
        beforeRenderDeadmau5HeadHookTypes.remove(id);
        overrideRenderDeadmau5HeadHookTypes.remove(id);
        afterRenderDeadmau5HeadHookTypes.remove(id);
        allBaseBeforeSetLivingAnimationsSuperiors.remove(id);
        allBaseBeforeSetLivingAnimationsInferiors.remove(id);
        allBaseOverrideSetLivingAnimationsSuperiors.remove(id);
        allBaseOverrideSetLivingAnimationsInferiors.remove(id);
        allBaseAfterSetLivingAnimationsSuperiors.remove(id);
        allBaseAfterSetLivingAnimationsInferiors.remove(id);
        beforeSetLivingAnimationsHookTypes.remove(id);
        overrideSetLivingAnimationsHookTypes.remove(id);
        afterSetLivingAnimationsHookTypes.remove(id);
        allBaseBeforeSetModelAttributesSuperiors.remove(id);
        allBaseBeforeSetModelAttributesInferiors.remove(id);
        allBaseOverrideSetModelAttributesSuperiors.remove(id);
        allBaseOverrideSetModelAttributesInferiors.remove(id);
        allBaseAfterSetModelAttributesSuperiors.remove(id);
        allBaseAfterSetModelAttributesInferiors.remove(id);
        beforeSetModelAttributesHookTypes.remove(id);
        overrideSetModelAttributesHookTypes.remove(id);
        afterSetModelAttributesHookTypes.remove(id);
        allBaseBeforeSetRotationAnglesSuperiors.remove(id);
        allBaseBeforeSetRotationAnglesInferiors.remove(id);
        allBaseOverrideSetRotationAnglesSuperiors.remove(id);
        allBaseOverrideSetRotationAnglesInferiors.remove(id);
        allBaseAfterSetRotationAnglesSuperiors.remove(id);
        allBaseAfterSetRotationAnglesInferiors.remove(id);
        beforeSetRotationAnglesHookTypes.remove(id);
        overrideSetRotationAnglesHookTypes.remove(id);
        afterSetRotationAnglesHookTypes.remove(id);
        allBaseBeforeSetTextureOffsetSuperiors.remove(id);
        allBaseBeforeSetTextureOffsetInferiors.remove(id);
        allBaseOverrideSetTextureOffsetSuperiors.remove(id);
        allBaseOverrideSetTextureOffsetInferiors.remove(id);
        allBaseAfterSetTextureOffsetSuperiors.remove(id);
        allBaseAfterSetTextureOffsetInferiors.remove(id);
        beforeSetTextureOffsetHookTypes.remove(id);
        overrideSetTextureOffsetHookTypes.remove(id);
        afterSetTextureOffsetHookTypes.remove(id);
        allBaseBeforeSetVisibleSuperiors.remove(id);
        allBaseBeforeSetVisibleInferiors.remove(id);
        allBaseOverrideSetVisibleSuperiors.remove(id);
        allBaseOverrideSetVisibleInferiors.remove(id);
        allBaseAfterSetVisibleSuperiors.remove(id);
        allBaseAfterSetVisibleInferiors.remove(id);
        beforeSetVisibleHookTypes.remove(id);
        overrideSetVisibleHookTypes.remove(id);
        afterSetVisibleHookTypes.remove(id);
        for (IModelPlayerAPI instance : ModelPlayerAPI.getAllInstancesList()) {
            instance.getModelPlayerAPI().updateModelPlayerBases();
        }
        for (String key : keysToVirtualIds.keySet()) {
            if (!keysToVirtualIds.get(key).equals(id)) continue;
            keysToVirtualIds.remove(key);
        }
        boolean otherFound = false;
        Class<?> type = constructor.getDeclaringClass();
        for (String otherId : allBaseConstructors.keySet()) {
            Class<?> otherType = allBaseConstructors.get(otherId).getDeclaringClass();
            if (otherId.equals(id) || !otherType.equals(type)) continue;
            otherFound = true;
            break;
        }
        if (!otherFound) {
            dynamicTypes.remove(type);
            virtualDynamicHookMethods.remove(type);
            beforeDynamicHookMethods.remove(type);
            overrideDynamicHookMethods.remove(type);
            afterDynamicHookMethods.remove(type);
        }
        ModelPlayerAPI.removeDynamicHookTypes(id, beforeDynamicHookTypes);
        ModelPlayerAPI.removeDynamicHookTypes(id, overrideDynamicHookTypes);
        ModelPlayerAPI.removeDynamicHookTypes(id, afterDynamicHookTypes);
        allBaseBeforeDynamicSuperiors.remove(id);
        allBaseBeforeDynamicInferiors.remove(id);
        allBaseOverrideDynamicSuperiors.remove(id);
        allBaseOverrideDynamicInferiors.remove(id);
        allBaseAfterDynamicSuperiors.remove(id);
        allBaseAfterDynamicInferiors.remove(id);
        ModelPlayerAPI.log("ModelPlayerAPI: unregistered id '" + id + "'");
        return true;
    }

    public static void removeDynamicHookTypes(String id, Map<String, List<String>> map) {
        Iterator<String> keys = map.keySet().iterator();
        while (keys.hasNext()) {
            map.get(keys.next()).remove(id);
        }
    }

    public static Set<String> getRegisteredIds() {
        return unmodifiableAllIds;
    }

    private static void addSorting(String id, Map<String, String[]> map, String[] values) {
        if (values != null && values.length > 0) {
            map.put(id, values);
        }
    }

    private static void addDynamicSorting(String id, Map<String, Map<String, String[]>> map, Map<String, String[]> values) {
        if (values != null && values.size() > 0) {
            map.put(id, values);
        }
    }

    private static boolean addMethod(String id, Class<?> baseClass, List<String> list, String methodName, Class<?> ... _parameterTypes) {
        try {
            boolean isOverridden;
            Method method = baseClass.getMethod(methodName, _parameterTypes);
            boolean bl = isOverridden = method.getDeclaringClass() != ModelPlayerBase.class;
            if (isOverridden) {
                list.add(id);
            }
            return isOverridden;
        }
        catch (Exception e) {
            throw new RuntimeException("Can not reflect method '" + methodName + "' of class '" + baseClass.getName() + "'", e);
        }
    }

    private static void addDynamicMethods(String id, Class<?> baseClass) {
        if (!dynamicTypes.add(baseClass)) {
            return;
        }
        Map<String, Method> virtuals = null;
        Map<String, Method> befores = null;
        Map<String, Method> overrides = null;
        Map<String, Method> afters = null;
        Method[] methods = baseClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String name;
            int modifiers;
            Method method = methods[i];
            if (method.getDeclaringClass() != baseClass || Modifier.isAbstract(modifiers = method.getModifiers()) || Modifier.isStatic(modifiers) || (name = method.getName()).length() < 7 || !name.substring(0, 7).equalsIgnoreCase("dynamic")) continue;
            name = name.substring(7);
            while (name.charAt(0) == '_') {
                name = name.substring(1);
            }
            boolean before = false;
            boolean virtual = false;
            boolean override = false;
            boolean after = false;
            if (name.substring(0, 7).equalsIgnoreCase("virtual")) {
                virtual = true;
                name = name.substring(7);
            } else if (name.length() >= 8 && name.substring(0, 8).equalsIgnoreCase("override")) {
                name = name.substring(8);
                override = true;
            } else if (name.length() >= 6 && name.substring(0, 6).equalsIgnoreCase("before")) {
                before = true;
                name = name.substring(6);
            } else if (name.length() >= 5 && name.substring(0, 5).equalsIgnoreCase("after")) {
                after = true;
                name = name.substring(5);
            }
            if (name.length() >= 1 && (before || virtual || override || after)) {
                name = name.substring(0, 1).toLowerCase() + name.substring(1);
            }
            while (name.charAt(0) == '_') {
                name = name.substring(1);
            }
            if (name.length() == 0) {
                throw new RuntimeException("Can not process dynamic hook method with no key");
            }
            keys.add(name);
            if (virtual) {
                if (keysToVirtualIds.containsKey(name)) {
                    throw new RuntimeException("Can not process more than one dynamic virtual method");
                }
                keysToVirtualIds.put(name, id);
                virtuals = ModelPlayerAPI.addDynamicMethod(name, method, virtuals);
                continue;
            }
            if (before) {
                befores = ModelPlayerAPI.addDynamicMethod(name, method, befores);
                continue;
            }
            if (after) {
                afters = ModelPlayerAPI.addDynamicMethod(name, method, afters);
                continue;
            }
            overrides = ModelPlayerAPI.addDynamicMethod(name, method, overrides);
        }
        if (virtuals != null) {
            virtualDynamicHookMethods.put(baseClass, virtuals);
        }
        if (befores != null) {
            beforeDynamicHookMethods.put(baseClass, befores);
        }
        if (overrides != null) {
            overrideDynamicHookMethods.put(baseClass, overrides);
        }
        if (afters != null) {
            afterDynamicHookMethods.put(baseClass, afters);
        }
    }

    private static void addDynamicKeys(String id, Class<?> baseClass, Map<Class<?>, Map<String, Method>> dynamicHookMethods, Map<String, List<String>> dynamicHookTypes) {
        Map<String, Method> methods = dynamicHookMethods.get(baseClass);
        if (methods == null || methods.size() == 0) {
            return;
        }
        for (String key : methods.keySet()) {
            if (!dynamicHookTypes.containsKey(key)) {
                dynamicHookTypes.put(key, new ArrayList(1));
            }
            dynamicHookTypes.get(key).add(id);
        }
    }

    private static Map<String, Method> addDynamicMethod(String key, Method method, Map<String, Method> methods) {
        if (methods == null) {
            methods = new HashMap<String, Method>();
        }
        if (methods.containsKey(key)) {
            throw new RuntimeException("method with key '" + key + "' allready exists");
        }
        methods.put(key, method);
        return methods;
    }

    public static ModelPlayerAPI create(IModelPlayerAPI modelPlayer, float paramFloat1, float paramFloat2, int paramInt1, int paramInt2, boolean paramBoolean, String type) {
        if (allBaseConstructors.size() > 0 && !initialized) {
            ModelPlayerAPI.initialize();
        }
        return new ModelPlayerAPI(modelPlayer, paramFloat1, paramFloat2, paramInt1, paramInt2, paramBoolean, type);
    }

    private static void initialize() {
        ModelPlayerAPI.sortBases(beforeLocalConstructingHookTypes, allBaseBeforeLocalConstructingSuperiors, allBaseBeforeLocalConstructingInferiors, "beforeLocalConstructing");
        ModelPlayerAPI.sortBases(afterLocalConstructingHookTypes, allBaseAfterLocalConstructingSuperiors, allBaseAfterLocalConstructingInferiors, "afterLocalConstructing");
        for (String key : keys) {
            ModelPlayerAPI.sortDynamicBases(beforeDynamicHookTypes, allBaseBeforeDynamicSuperiors, allBaseBeforeDynamicInferiors, key);
            ModelPlayerAPI.sortDynamicBases(overrideDynamicHookTypes, allBaseOverrideDynamicSuperiors, allBaseOverrideDynamicInferiors, key);
            ModelPlayerAPI.sortDynamicBases(afterDynamicHookTypes, allBaseAfterDynamicSuperiors, allBaseAfterDynamicInferiors, key);
        }
        ModelPlayerAPI.sortBases(beforeGetArmForSideHookTypes, allBaseBeforeGetArmForSideSuperiors, allBaseBeforeGetArmForSideInferiors, "beforeGetArmForSide");
        ModelPlayerAPI.sortBases(overrideGetArmForSideHookTypes, allBaseOverrideGetArmForSideSuperiors, allBaseOverrideGetArmForSideInferiors, "overrideGetArmForSide");
        ModelPlayerAPI.sortBases(afterGetArmForSideHookTypes, allBaseAfterGetArmForSideSuperiors, allBaseAfterGetArmForSideInferiors, "afterGetArmForSide");
        ModelPlayerAPI.sortBases(beforeGetMainHandHookTypes, allBaseBeforeGetMainHandSuperiors, allBaseBeforeGetMainHandInferiors, "beforeGetMainHand");
        ModelPlayerAPI.sortBases(overrideGetMainHandHookTypes, allBaseOverrideGetMainHandSuperiors, allBaseOverrideGetMainHandInferiors, "overrideGetMainHand");
        ModelPlayerAPI.sortBases(afterGetMainHandHookTypes, allBaseAfterGetMainHandSuperiors, allBaseAfterGetMainHandInferiors, "afterGetMainHand");
        ModelPlayerAPI.sortBases(beforeGetRandomModelBoxHookTypes, allBaseBeforeGetRandomModelBoxSuperiors, allBaseBeforeGetRandomModelBoxInferiors, "beforeGetRandomModelBox");
        ModelPlayerAPI.sortBases(overrideGetRandomModelBoxHookTypes, allBaseOverrideGetRandomModelBoxSuperiors, allBaseOverrideGetRandomModelBoxInferiors, "overrideGetRandomModelBox");
        ModelPlayerAPI.sortBases(afterGetRandomModelBoxHookTypes, allBaseAfterGetRandomModelBoxSuperiors, allBaseAfterGetRandomModelBoxInferiors, "afterGetRandomModelBox");
        ModelPlayerAPI.sortBases(beforeGetTextureOffsetHookTypes, allBaseBeforeGetTextureOffsetSuperiors, allBaseBeforeGetTextureOffsetInferiors, "beforeGetTextureOffset");
        ModelPlayerAPI.sortBases(overrideGetTextureOffsetHookTypes, allBaseOverrideGetTextureOffsetSuperiors, allBaseOverrideGetTextureOffsetInferiors, "overrideGetTextureOffset");
        ModelPlayerAPI.sortBases(afterGetTextureOffsetHookTypes, allBaseAfterGetTextureOffsetSuperiors, allBaseAfterGetTextureOffsetInferiors, "afterGetTextureOffset");
        ModelPlayerAPI.sortBases(beforePostRenderArmHookTypes, allBaseBeforePostRenderArmSuperiors, allBaseBeforePostRenderArmInferiors, "beforePostRenderArm");
        ModelPlayerAPI.sortBases(overridePostRenderArmHookTypes, allBaseOverridePostRenderArmSuperiors, allBaseOverridePostRenderArmInferiors, "overridePostRenderArm");
        ModelPlayerAPI.sortBases(afterPostRenderArmHookTypes, allBaseAfterPostRenderArmSuperiors, allBaseAfterPostRenderArmInferiors, "afterPostRenderArm");
        ModelPlayerAPI.sortBases(beforeRenderHookTypes, allBaseBeforeRenderSuperiors, allBaseBeforeRenderInferiors, "beforeRender");
        ModelPlayerAPI.sortBases(overrideRenderHookTypes, allBaseOverrideRenderSuperiors, allBaseOverrideRenderInferiors, "overrideRender");
        ModelPlayerAPI.sortBases(afterRenderHookTypes, allBaseAfterRenderSuperiors, allBaseAfterRenderInferiors, "afterRender");
        ModelPlayerAPI.sortBases(beforeRenderCapeHookTypes, allBaseBeforeRenderCapeSuperiors, allBaseBeforeRenderCapeInferiors, "beforeRenderCape");
        ModelPlayerAPI.sortBases(overrideRenderCapeHookTypes, allBaseOverrideRenderCapeSuperiors, allBaseOverrideRenderCapeInferiors, "overrideRenderCape");
        ModelPlayerAPI.sortBases(afterRenderCapeHookTypes, allBaseAfterRenderCapeSuperiors, allBaseAfterRenderCapeInferiors, "afterRenderCape");
        ModelPlayerAPI.sortBases(beforeRenderDeadmau5HeadHookTypes, allBaseBeforeRenderDeadmau5HeadSuperiors, allBaseBeforeRenderDeadmau5HeadInferiors, "beforeRenderDeadmau5Head");
        ModelPlayerAPI.sortBases(overrideRenderDeadmau5HeadHookTypes, allBaseOverrideRenderDeadmau5HeadSuperiors, allBaseOverrideRenderDeadmau5HeadInferiors, "overrideRenderDeadmau5Head");
        ModelPlayerAPI.sortBases(afterRenderDeadmau5HeadHookTypes, allBaseAfterRenderDeadmau5HeadSuperiors, allBaseAfterRenderDeadmau5HeadInferiors, "afterRenderDeadmau5Head");
        ModelPlayerAPI.sortBases(beforeSetLivingAnimationsHookTypes, allBaseBeforeSetLivingAnimationsSuperiors, allBaseBeforeSetLivingAnimationsInferiors, "beforeSetLivingAnimations");
        ModelPlayerAPI.sortBases(overrideSetLivingAnimationsHookTypes, allBaseOverrideSetLivingAnimationsSuperiors, allBaseOverrideSetLivingAnimationsInferiors, "overrideSetLivingAnimations");
        ModelPlayerAPI.sortBases(afterSetLivingAnimationsHookTypes, allBaseAfterSetLivingAnimationsSuperiors, allBaseAfterSetLivingAnimationsInferiors, "afterSetLivingAnimations");
        ModelPlayerAPI.sortBases(beforeSetModelAttributesHookTypes, allBaseBeforeSetModelAttributesSuperiors, allBaseBeforeSetModelAttributesInferiors, "beforeSetModelAttributes");
        ModelPlayerAPI.sortBases(overrideSetModelAttributesHookTypes, allBaseOverrideSetModelAttributesSuperiors, allBaseOverrideSetModelAttributesInferiors, "overrideSetModelAttributes");
        ModelPlayerAPI.sortBases(afterSetModelAttributesHookTypes, allBaseAfterSetModelAttributesSuperiors, allBaseAfterSetModelAttributesInferiors, "afterSetModelAttributes");
        ModelPlayerAPI.sortBases(beforeSetRotationAnglesHookTypes, allBaseBeforeSetRotationAnglesSuperiors, allBaseBeforeSetRotationAnglesInferiors, "beforeSetRotationAngles");
        ModelPlayerAPI.sortBases(overrideSetRotationAnglesHookTypes, allBaseOverrideSetRotationAnglesSuperiors, allBaseOverrideSetRotationAnglesInferiors, "overrideSetRotationAngles");
        ModelPlayerAPI.sortBases(afterSetRotationAnglesHookTypes, allBaseAfterSetRotationAnglesSuperiors, allBaseAfterSetRotationAnglesInferiors, "afterSetRotationAngles");
        ModelPlayerAPI.sortBases(beforeSetTextureOffsetHookTypes, allBaseBeforeSetTextureOffsetSuperiors, allBaseBeforeSetTextureOffsetInferiors, "beforeSetTextureOffset");
        ModelPlayerAPI.sortBases(overrideSetTextureOffsetHookTypes, allBaseOverrideSetTextureOffsetSuperiors, allBaseOverrideSetTextureOffsetInferiors, "overrideSetTextureOffset");
        ModelPlayerAPI.sortBases(afterSetTextureOffsetHookTypes, allBaseAfterSetTextureOffsetSuperiors, allBaseAfterSetTextureOffsetInferiors, "afterSetTextureOffset");
        ModelPlayerAPI.sortBases(beforeSetVisibleHookTypes, allBaseBeforeSetVisibleSuperiors, allBaseBeforeSetVisibleInferiors, "beforeSetVisible");
        ModelPlayerAPI.sortBases(overrideSetVisibleHookTypes, allBaseOverrideSetVisibleSuperiors, allBaseOverrideSetVisibleInferiors, "overrideSetVisible");
        ModelPlayerAPI.sortBases(afterSetVisibleHookTypes, allBaseAfterSetVisibleSuperiors, allBaseAfterSetVisibleInferiors, "afterSetVisible");
        initialized = true;
    }

    private static List<IModelPlayerAPI> getAllInstancesList() {
        ArrayList<IModelPlayerAPI> result = new ArrayList<IModelPlayerAPI>();
        Iterator<WeakReference<IModelPlayerAPI>> iterator = allInstances.iterator();
        while (iterator.hasNext()) {
            IModelPlayerAPI instance = (IModelPlayerAPI)iterator.next().get();
            if (instance != null) {
                result.add(instance);
                continue;
            }
            iterator.remove();
        }
        return result;
    }

    public static ModelBiped[] getAllInstances() {
        List<IModelPlayerAPI> allInstances = ModelPlayerAPI.getAllInstancesList();
        return allInstances.toArray(new ModelBiped[allInstances.size()]);
    }

    public static void beforeLocalConstructing(IModelPlayerAPI modelPlayer) {
        ModelPlayerAPI modelPlayerAPI = modelPlayer.getModelPlayerAPI();
        if (modelPlayerAPI != null) {
            modelPlayerAPI.load();
        }
        allInstances.add(new WeakReference<IModelPlayerAPI>(modelPlayer));
        if (modelPlayerAPI != null) {
            modelPlayerAPI.beforeLocalConstructing();
        }
    }

    public static void afterLocalConstructing(IModelPlayerAPI modelPlayer) {
        ModelPlayerAPI modelPlayerAPI = modelPlayer.getModelPlayerAPI();
        if (modelPlayerAPI != null) {
            modelPlayerAPI.afterLocalConstructing();
        }
    }

    public static ModelPlayerBase getModelPlayerBase(IModelPlayerAPI modelPlayer, String baseId) {
        ModelPlayerAPI modelPlayerAPI = modelPlayer.getModelPlayerAPI();
        if (modelPlayerAPI != null) {
            return modelPlayerAPI.getModelPlayerBase(baseId);
        }
        return null;
    }

    public static Set<String> getModelPlayerBaseIds(IModelPlayerAPI modelPlayer) {
        ModelPlayerAPI modelPlayerAPI = modelPlayer.getModelPlayerAPI();
        Set<String> result = null;
        result = modelPlayerAPI != null ? modelPlayerAPI.getModelPlayerBaseIds() : Collections.emptySet();
        return result;
    }

    public static float getExpandParameter(IModelPlayerAPI modelPlayer) {
        ModelPlayerAPI modelPlayerAPI = modelPlayer.getModelPlayerAPI();
        if (modelPlayerAPI != null) {
            return modelPlayerAPI.paramFloat1;
        }
        return 0.0f;
    }

    public static float getYOffsetParameter(IModelPlayerAPI modelPlayer) {
        ModelPlayerAPI modelPlayerAPI = modelPlayer.getModelPlayerAPI();
        if (modelPlayerAPI != null) {
            return modelPlayerAPI.paramFloat2;
        }
        return 0.0f;
    }

    public static int getTextureWidthParameter(IModelPlayerAPI modelPlayer) {
        ModelPlayerAPI modelPlayerAPI = modelPlayer.getModelPlayerAPI();
        if (modelPlayerAPI != null) {
            return modelPlayerAPI.paramInt1;
        }
        return 0;
    }

    public static int getTextureHeightParameter(IModelPlayerAPI modelPlayer) {
        ModelPlayerAPI modelPlayerAPI = modelPlayer.getModelPlayerAPI();
        if (modelPlayerAPI != null) {
            return modelPlayerAPI.paramInt2;
        }
        return 0;
    }

    public static boolean getSmallArmsParameter(IModelPlayerAPI modelPlayer) {
        ModelPlayerAPI modelPlayerAPI = modelPlayer.getModelPlayerAPI();
        if (modelPlayerAPI != null) {
            return modelPlayerAPI.paramBoolean;
        }
        return false;
    }

    public static String getModelPlayerType(IModelPlayerAPI modelPlayer) {
        ModelPlayerAPI modelPlayerAPI = modelPlayer.getModelPlayerAPI();
        if (modelPlayerAPI != null && modelPlayerAPI.type != null) {
            return modelPlayerAPI.type;
        }
        return "other";
    }

    public static Object dynamic(IModelPlayerAPI modelPlayer, String key, Object[] parameters) {
        ModelPlayerAPI modelPlayerAPI = modelPlayer.getModelPlayerAPI();
        if (modelPlayerAPI != null) {
            return modelPlayerAPI.dynamic(key, parameters);
        }
        return null;
    }

    private static void sortBases(List<String> list, Map<String, String[]> allBaseSuperiors, Map<String, String[]> allBaseInferiors, String methodName) {
        new ModelPlayerBaseSorter(list, allBaseSuperiors, allBaseInferiors, methodName).Sort();
    }

    private static void sortDynamicBases(Map<String, List<String>> lists, Map<String, Map<String, String[]>> allBaseSuperiors, Map<String, Map<String, String[]>> allBaseInferiors, String key) {
        List<String> types = lists.get(key);
        if (types != null && types.size() > 1) {
            ModelPlayerAPI.sortBases(types, ModelPlayerAPI.getDynamicSorters(key, types, allBaseSuperiors), ModelPlayerAPI.getDynamicSorters(key, types, allBaseInferiors), key);
        }
    }

    private static Map<String, String[]> getDynamicSorters(String key, List<String> toSort, Map<String, Map<String, String[]>> allBaseValues) {
        Map<String, String[]> superiors = null;
        for (String id : toSort) {
            String[] keySuperiorIds;
            Map<String, String[]> idSuperiors = allBaseValues.get(id);
            if (idSuperiors == null || (keySuperiorIds = idSuperiors.get(key)) == null || keySuperiorIds.length <= 0) continue;
            if (superiors == null) {
                superiors = new HashMap<String, String[]>(1);
            }
            superiors.put(id, keySuperiorIds);
        }
        return superiors != null ? superiors : EmptySortMap;
    }

    private ModelPlayerAPI(IModelPlayerAPI modelPlayer, float paramFloat1, float paramFloat2, int paramInt1, int paramInt2, boolean paramBoolean, String type) {
        this.modelPlayer = modelPlayer;
        this.paramFloat1 = paramFloat1;
        this.paramFloat2 = paramFloat2;
        this.paramInt1 = paramInt1;
        this.paramInt2 = paramInt2;
        this.paramBoolean = paramBoolean;
        this.type = type;
    }

    private void load() {
        for (String id : allBaseConstructors.keySet()) {
            ModelPlayerBase toAttach = this.createModelPlayerBase(id);
            toAttach.beforeBaseAttach(false);
            this.allBaseObjects.put(id, toAttach);
            this.baseObjectsToId.put(toAttach, id);
        }
        this.beforeLocalConstructingHooks = this.create(beforeLocalConstructingHookTypes);
        this.afterLocalConstructingHooks = this.create(afterLocalConstructingHookTypes);
        this.updateModelPlayerBases();
        Iterator<String> iterator = this.allBaseObjects.keySet().iterator();
        while (iterator.hasNext()) {
            this.allBaseObjects.get(iterator.next()).afterBaseAttach(false);
        }
    }

    private ModelPlayerBase createModelPlayerBase(String id) {
        ModelPlayerBase base;
        Constructor<?> contructor = allBaseConstructors.get(id);
        try {
            base = contructor.getParameterTypes().length == 1 ? (ModelPlayerBase)contructor.newInstance(this) : (ModelPlayerBase)contructor.newInstance(this, id);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while creating a ModelPlayerBase of type '" + contructor.getDeclaringClass() + "'", e);
        }
        return base;
    }

    private void updateModelPlayerBases() {
        this.beforeGetArmForSideHooks = this.create(beforeGetArmForSideHookTypes);
        this.overrideGetArmForSideHooks = this.create(overrideGetArmForSideHookTypes);
        this.afterGetArmForSideHooks = this.create(afterGetArmForSideHookTypes);
        this.isGetArmForSideModded = this.beforeGetArmForSideHooks != null || this.overrideGetArmForSideHooks != null || this.afterGetArmForSideHooks != null;
        this.beforeGetMainHandHooks = this.create(beforeGetMainHandHookTypes);
        this.overrideGetMainHandHooks = this.create(overrideGetMainHandHookTypes);
        this.afterGetMainHandHooks = this.create(afterGetMainHandHookTypes);
        this.isGetMainHandModded = this.beforeGetMainHandHooks != null || this.overrideGetMainHandHooks != null || this.afterGetMainHandHooks != null;
        this.beforeGetRandomModelBoxHooks = this.create(beforeGetRandomModelBoxHookTypes);
        this.overrideGetRandomModelBoxHooks = this.create(overrideGetRandomModelBoxHookTypes);
        this.afterGetRandomModelBoxHooks = this.create(afterGetRandomModelBoxHookTypes);
        this.isGetRandomModelBoxModded = this.beforeGetRandomModelBoxHooks != null || this.overrideGetRandomModelBoxHooks != null || this.afterGetRandomModelBoxHooks != null;
        this.beforeGetTextureOffsetHooks = this.create(beforeGetTextureOffsetHookTypes);
        this.overrideGetTextureOffsetHooks = this.create(overrideGetTextureOffsetHookTypes);
        this.afterGetTextureOffsetHooks = this.create(afterGetTextureOffsetHookTypes);
        this.isGetTextureOffsetModded = this.beforeGetTextureOffsetHooks != null || this.overrideGetTextureOffsetHooks != null || this.afterGetTextureOffsetHooks != null;
        this.beforePostRenderArmHooks = this.create(beforePostRenderArmHookTypes);
        this.overridePostRenderArmHooks = this.create(overridePostRenderArmHookTypes);
        this.afterPostRenderArmHooks = this.create(afterPostRenderArmHookTypes);
        this.isPostRenderArmModded = this.beforePostRenderArmHooks != null || this.overridePostRenderArmHooks != null || this.afterPostRenderArmHooks != null;
        this.beforeRenderHooks = this.create(beforeRenderHookTypes);
        this.overrideRenderHooks = this.create(overrideRenderHookTypes);
        this.afterRenderHooks = this.create(afterRenderHookTypes);
        this.isRenderModded = this.beforeRenderHooks != null || this.overrideRenderHooks != null || this.afterRenderHooks != null;
        this.beforeRenderCapeHooks = this.create(beforeRenderCapeHookTypes);
        this.overrideRenderCapeHooks = this.create(overrideRenderCapeHookTypes);
        this.afterRenderCapeHooks = this.create(afterRenderCapeHookTypes);
        this.isRenderCapeModded = this.beforeRenderCapeHooks != null || this.overrideRenderCapeHooks != null || this.afterRenderCapeHooks != null;
        this.beforeRenderDeadmau5HeadHooks = this.create(beforeRenderDeadmau5HeadHookTypes);
        this.overrideRenderDeadmau5HeadHooks = this.create(overrideRenderDeadmau5HeadHookTypes);
        this.afterRenderDeadmau5HeadHooks = this.create(afterRenderDeadmau5HeadHookTypes);
        this.isRenderDeadmau5HeadModded = this.beforeRenderDeadmau5HeadHooks != null || this.overrideRenderDeadmau5HeadHooks != null || this.afterRenderDeadmau5HeadHooks != null;
        this.beforeSetLivingAnimationsHooks = this.create(beforeSetLivingAnimationsHookTypes);
        this.overrideSetLivingAnimationsHooks = this.create(overrideSetLivingAnimationsHookTypes);
        this.afterSetLivingAnimationsHooks = this.create(afterSetLivingAnimationsHookTypes);
        this.isSetLivingAnimationsModded = this.beforeSetLivingAnimationsHooks != null || this.overrideSetLivingAnimationsHooks != null || this.afterSetLivingAnimationsHooks != null;
        this.beforeSetModelAttributesHooks = this.create(beforeSetModelAttributesHookTypes);
        this.overrideSetModelAttributesHooks = this.create(overrideSetModelAttributesHookTypes);
        this.afterSetModelAttributesHooks = this.create(afterSetModelAttributesHookTypes);
        this.isSetModelAttributesModded = this.beforeSetModelAttributesHooks != null || this.overrideSetModelAttributesHooks != null || this.afterSetModelAttributesHooks != null;
        this.beforeSetRotationAnglesHooks = this.create(beforeSetRotationAnglesHookTypes);
        this.overrideSetRotationAnglesHooks = this.create(overrideSetRotationAnglesHookTypes);
        this.afterSetRotationAnglesHooks = this.create(afterSetRotationAnglesHookTypes);
        this.isSetRotationAnglesModded = this.beforeSetRotationAnglesHooks != null || this.overrideSetRotationAnglesHooks != null || this.afterSetRotationAnglesHooks != null;
        this.beforeSetTextureOffsetHooks = this.create(beforeSetTextureOffsetHookTypes);
        this.overrideSetTextureOffsetHooks = this.create(overrideSetTextureOffsetHookTypes);
        this.afterSetTextureOffsetHooks = this.create(afterSetTextureOffsetHookTypes);
        this.isSetTextureOffsetModded = this.beforeSetTextureOffsetHooks != null || this.overrideSetTextureOffsetHooks != null || this.afterSetTextureOffsetHooks != null;
        this.beforeSetVisibleHooks = this.create(beforeSetVisibleHookTypes);
        this.overrideSetVisibleHooks = this.create(overrideSetVisibleHookTypes);
        this.afterSetVisibleHooks = this.create(afterSetVisibleHookTypes);
        this.isSetVisibleModded = this.beforeSetVisibleHooks != null || this.overrideSetVisibleHooks != null || this.afterSetVisibleHooks != null;
    }

    private void attachModelPlayerBase(String id) {
        ModelPlayerBase toAttach = this.createModelPlayerBase(id);
        toAttach.beforeBaseAttach(true);
        this.allBaseObjects.put(id, toAttach);
        this.updateModelPlayerBases();
        toAttach.afterBaseAttach(true);
    }

    private void detachModelPlayerBase(String id) {
        ModelPlayerBase toDetach = this.allBaseObjects.get(id);
        toDetach.beforeBaseDetach(true);
        this.allBaseObjects.remove(id);
        toDetach.afterBaseDetach(true);
    }

    private ModelPlayerBase[] create(List<String> types) {
        if (types.isEmpty()) {
            return null;
        }
        ModelPlayerBase[] result = new ModelPlayerBase[types.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getModelPlayerBase(types.get(i));
        }
        return result;
    }

    private void beforeLocalConstructing() {
        if (this.beforeLocalConstructingHooks != null) {
            for (int i = this.beforeLocalConstructingHooks.length - 1; i >= 0; --i) {
                this.beforeLocalConstructingHooks[i].beforeLocalConstructing(this.paramFloat1, this.paramFloat2, this.paramInt1, this.paramInt2, this.paramBoolean);
            }
        }
        this.beforeLocalConstructingHooks = null;
    }

    private void afterLocalConstructing() {
        if (this.afterLocalConstructingHooks != null) {
            for (int i = 0; i < this.afterLocalConstructingHooks.length; ++i) {
                this.afterLocalConstructingHooks[i].afterLocalConstructing(this.paramFloat1, this.paramFloat2, this.paramInt1, this.paramInt2, this.paramBoolean);
            }
        }
        this.afterLocalConstructingHooks = null;
    }

    public ModelPlayerBase getModelPlayerBase(String id) {
        return this.allBaseObjects.get(id);
    }

    public Set<String> getModelPlayerBaseIds() {
        return this.unmodifiableAllBaseIds;
    }

    public Object dynamic(String key, Object[] parameters) {
        key = key.replace('.', '_').replace(' ', '_');
        this.executeAll(key, parameters, beforeDynamicHookTypes, beforeDynamicHookMethods, true);
        Object result = this.dynamicOverwritten(key, parameters, null);
        this.executeAll(key, parameters, afterDynamicHookTypes, afterDynamicHookMethods, false);
        return result;
    }

    public Object dynamicOverwritten(String key, Object[] parameters, ModelPlayerBase overwriter) {
        Map<Class<?>, Map<String, Method>> methodMap;
        List<String> overrideIds = overrideDynamicHookTypes.get(key);
        String id = null;
        if (overrideIds != null) {
            if (overwriter != null) {
                id = this.baseObjectsToId.get(overwriter);
                int index = overrideIds.indexOf(id);
                id = index > 0 ? overrideIds.get(index - 1) : null;
            } else if (overrideIds.size() > 0) {
                id = overrideIds.get(overrideIds.size() - 1);
            }
        }
        if (id == null) {
            id = keysToVirtualIds.get(key);
            if (id == null) {
                return null;
            }
            methodMap = virtualDynamicHookMethods;
        } else {
            methodMap = overrideDynamicHookMethods;
        }
        Map<String, Method> methods = methodMap.get(allBaseConstructors.get(id).getDeclaringClass());
        if (methods == null) {
            return null;
        }
        Method method = methods.get(key);
        if (method == null) {
            return null;
        }
        return this.execute(this.getModelPlayerBase(id), method, parameters);
    }

    private void executeAll(String key, Object[] parameters, Map<String, List<String>> dynamicHookTypes, Map<Class<?>, Map<String, Method>> dynamicHookMethods, boolean reverse) {
        int i;
        List<String> beforeIds = dynamicHookTypes.get(key);
        if (beforeIds == null) {
            return;
        }
        int n = i = reverse ? beforeIds.size() - 1 : 0;
        while (reverse ? i >= 0 : i < beforeIds.size()) {
            Method method;
            String id = beforeIds.get(i);
            ModelPlayerBase base = this.getModelPlayerBase(id);
            Class<?> type = base.getClass();
            Map<String, Method> methods = dynamicHookMethods.get(type);
            if (methods != null && (method = methods.get(key)) != null) {
                this.execute(base, method, parameters);
            }
            i += reverse ? -1 : 1;
        }
    }

    private Object execute(ModelPlayerBase base, Method method, Object[] parameters) {
        try {
            return method.invoke((Object)base, parameters);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while invoking dynamic method", e);
        }
    }

    public static ModelRenderer getArmForSide(IModelPlayerAPI target, EnumHandSide paramEnumHandSide) {
        ModelPlayerAPI modelPlayerAPI = target.getModelPlayerAPI();
        ModelRenderer _result = modelPlayerAPI != null && modelPlayerAPI.isGetArmForSideModded ? modelPlayerAPI.getArmForSide(paramEnumHandSide) : target.localGetArmForSide(paramEnumHandSide);
        return _result;
    }

    private ModelRenderer getArmForSide(EnumHandSide paramEnumHandSide) {
        if (this.beforeGetArmForSideHooks != null) {
            for (int i = this.beforeGetArmForSideHooks.length - 1; i >= 0; --i) {
                this.beforeGetArmForSideHooks[i].beforeGetArmForSide(paramEnumHandSide);
            }
        }
        ModelRenderer _result = this.overrideGetArmForSideHooks != null ? this.overrideGetArmForSideHooks[this.overrideGetArmForSideHooks.length - 1].getArmForSide(paramEnumHandSide) : this.modelPlayer.localGetArmForSide(paramEnumHandSide);
        if (this.afterGetArmForSideHooks != null) {
            for (int i = 0; i < this.afterGetArmForSideHooks.length; ++i) {
                this.afterGetArmForSideHooks[i].afterGetArmForSide(paramEnumHandSide);
            }
        }
        return _result;
    }

    protected ModelPlayerBase GetOverwrittenGetArmForSide(ModelPlayerBase overWriter) {
        if (this.overrideGetArmForSideHooks == null) {
            return overWriter;
        }
        for (int i = 0; i < this.overrideGetArmForSideHooks.length; ++i) {
            if (this.overrideGetArmForSideHooks[i] != overWriter) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideGetArmForSideHooks[i - 1];
        }
        return overWriter;
    }

    public static EnumHandSide getMainHand(IModelPlayerAPI target, Entity paramEntity) {
        ModelPlayerAPI modelPlayerAPI = target.getModelPlayerAPI();
        EnumHandSide _result = modelPlayerAPI != null && modelPlayerAPI.isGetMainHandModded ? modelPlayerAPI.getMainHand(paramEntity) : target.localGetMainHand(paramEntity);
        return _result;
    }

    private EnumHandSide getMainHand(Entity paramEntity) {
        if (this.beforeGetMainHandHooks != null) {
            for (int i = this.beforeGetMainHandHooks.length - 1; i >= 0; --i) {
                this.beforeGetMainHandHooks[i].beforeGetMainHand(paramEntity);
            }
        }
        EnumHandSide _result = this.overrideGetMainHandHooks != null ? this.overrideGetMainHandHooks[this.overrideGetMainHandHooks.length - 1].getMainHand(paramEntity) : this.modelPlayer.localGetMainHand(paramEntity);
        if (this.afterGetMainHandHooks != null) {
            for (int i = 0; i < this.afterGetMainHandHooks.length; ++i) {
                this.afterGetMainHandHooks[i].afterGetMainHand(paramEntity);
            }
        }
        return _result;
    }

    protected ModelPlayerBase GetOverwrittenGetMainHand(ModelPlayerBase overWriter) {
        if (this.overrideGetMainHandHooks == null) {
            return overWriter;
        }
        for (int i = 0; i < this.overrideGetMainHandHooks.length; ++i) {
            if (this.overrideGetMainHandHooks[i] != overWriter) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideGetMainHandHooks[i - 1];
        }
        return overWriter;
    }

    public static ModelRenderer getRandomModelBox(IModelPlayerAPI target, Random paramRandom) {
        ModelPlayerAPI modelPlayerAPI = target.getModelPlayerAPI();
        ModelRenderer _result = modelPlayerAPI != null && modelPlayerAPI.isGetRandomModelBoxModded ? modelPlayerAPI.getRandomModelBox(paramRandom) : target.localGetRandomModelBox(paramRandom);
        return _result;
    }

    private ModelRenderer getRandomModelBox(Random paramRandom) {
        if (this.beforeGetRandomModelBoxHooks != null) {
            for (int i = this.beforeGetRandomModelBoxHooks.length - 1; i >= 0; --i) {
                this.beforeGetRandomModelBoxHooks[i].beforeGetRandomModelBox(paramRandom);
            }
        }
        ModelRenderer _result = this.overrideGetRandomModelBoxHooks != null ? this.overrideGetRandomModelBoxHooks[this.overrideGetRandomModelBoxHooks.length - 1].getRandomModelBox(paramRandom) : this.modelPlayer.localGetRandomModelBox(paramRandom);
        if (this.afterGetRandomModelBoxHooks != null) {
            for (int i = 0; i < this.afterGetRandomModelBoxHooks.length; ++i) {
                this.afterGetRandomModelBoxHooks[i].afterGetRandomModelBox(paramRandom);
            }
        }
        return _result;
    }

    protected ModelPlayerBase GetOverwrittenGetRandomModelBox(ModelPlayerBase overWriter) {
        if (this.overrideGetRandomModelBoxHooks == null) {
            return overWriter;
        }
        for (int i = 0; i < this.overrideGetRandomModelBoxHooks.length; ++i) {
            if (this.overrideGetRandomModelBoxHooks[i] != overWriter) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideGetRandomModelBoxHooks[i - 1];
        }
        return overWriter;
    }

    public static TextureOffset getTextureOffset(IModelPlayerAPI target, String paramString) {
        ModelPlayerAPI modelPlayerAPI = target.getModelPlayerAPI();
        TextureOffset _result = modelPlayerAPI != null && modelPlayerAPI.isGetTextureOffsetModded ? modelPlayerAPI.getTextureOffset(paramString) : target.localGetTextureOffset(paramString);
        return _result;
    }

    private TextureOffset getTextureOffset(String paramString) {
        if (this.beforeGetTextureOffsetHooks != null) {
            for (int i = this.beforeGetTextureOffsetHooks.length - 1; i >= 0; --i) {
                this.beforeGetTextureOffsetHooks[i].beforeGetTextureOffset(paramString);
            }
        }
        TextureOffset _result = this.overrideGetTextureOffsetHooks != null ? this.overrideGetTextureOffsetHooks[this.overrideGetTextureOffsetHooks.length - 1].getTextureOffset(paramString) : this.modelPlayer.localGetTextureOffset(paramString);
        if (this.afterGetTextureOffsetHooks != null) {
            for (int i = 0; i < this.afterGetTextureOffsetHooks.length; ++i) {
                this.afterGetTextureOffsetHooks[i].afterGetTextureOffset(paramString);
            }
        }
        return _result;
    }

    protected ModelPlayerBase GetOverwrittenGetTextureOffset(ModelPlayerBase overWriter) {
        if (this.overrideGetTextureOffsetHooks == null) {
            return overWriter;
        }
        for (int i = 0; i < this.overrideGetTextureOffsetHooks.length; ++i) {
            if (this.overrideGetTextureOffsetHooks[i] != overWriter) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideGetTextureOffsetHooks[i - 1];
        }
        return overWriter;
    }

    public static void postRenderArm(IModelPlayerAPI target, float paramFloat, EnumHandSide paramEnumHandSide) {
        ModelPlayerAPI modelPlayerAPI = target.getModelPlayerAPI();
        if (modelPlayerAPI != null && modelPlayerAPI.isPostRenderArmModded) {
            modelPlayerAPI.postRenderArm(paramFloat, paramEnumHandSide);
        } else {
            target.localPostRenderArm(paramFloat, paramEnumHandSide);
        }
    }

    private void postRenderArm(float paramFloat, EnumHandSide paramEnumHandSide) {
        int i;
        if (this.beforePostRenderArmHooks != null) {
            for (i = this.beforePostRenderArmHooks.length - 1; i >= 0; --i) {
                this.beforePostRenderArmHooks[i].beforePostRenderArm(paramFloat, paramEnumHandSide);
            }
        }
        if (this.overridePostRenderArmHooks != null) {
            this.overridePostRenderArmHooks[this.overridePostRenderArmHooks.length - 1].postRenderArm(paramFloat, paramEnumHandSide);
        } else {
            this.modelPlayer.localPostRenderArm(paramFloat, paramEnumHandSide);
        }
        if (this.afterPostRenderArmHooks != null) {
            for (i = 0; i < this.afterPostRenderArmHooks.length; ++i) {
                this.afterPostRenderArmHooks[i].afterPostRenderArm(paramFloat, paramEnumHandSide);
            }
        }
    }

    protected ModelPlayerBase GetOverwrittenPostRenderArm(ModelPlayerBase overWriter) {
        if (this.overridePostRenderArmHooks == null) {
            return overWriter;
        }
        for (int i = 0; i < this.overridePostRenderArmHooks.length; ++i) {
            if (this.overridePostRenderArmHooks[i] != overWriter) continue;
            if (i == 0) {
                return null;
            }
            return this.overridePostRenderArmHooks[i - 1];
        }
        return overWriter;
    }

    public static void render(IModelPlayerAPI target, Entity paramEntity, float paramFloat1, float paramFloat2, float paramFloat3, float paramFloat4, float paramFloat5, float paramFloat6) {
        ModelPlayerAPI modelPlayerAPI = target.getModelPlayerAPI();
        if (modelPlayerAPI != null && modelPlayerAPI.isRenderModded) {
            modelPlayerAPI.render(paramEntity, paramFloat1, paramFloat2, paramFloat3, paramFloat4, paramFloat5, paramFloat6);
        } else {
            target.localRender(paramEntity, paramFloat1, paramFloat2, paramFloat3, paramFloat4, paramFloat5, paramFloat6);
        }
    }

    private void render(Entity paramEntity, float paramFloat1, float paramFloat2, float paramFloat3, float paramFloat4, float paramFloat5, float paramFloat6) {
        int i;
        if (this.beforeRenderHooks != null) {
            for (i = this.beforeRenderHooks.length - 1; i >= 0; --i) {
                this.beforeRenderHooks[i].beforeRender(paramEntity, paramFloat1, paramFloat2, paramFloat3, paramFloat4, paramFloat5, paramFloat6);
            }
        }
        if (this.overrideRenderHooks != null) {
            this.overrideRenderHooks[this.overrideRenderHooks.length - 1].render(paramEntity, paramFloat1, paramFloat2, paramFloat3, paramFloat4, paramFloat5, paramFloat6);
        } else {
            this.modelPlayer.localRender(paramEntity, paramFloat1, paramFloat2, paramFloat3, paramFloat4, paramFloat5, paramFloat6);
        }
        if (this.afterRenderHooks != null) {
            for (i = 0; i < this.afterRenderHooks.length; ++i) {
                this.afterRenderHooks[i].afterRender(paramEntity, paramFloat1, paramFloat2, paramFloat3, paramFloat4, paramFloat5, paramFloat6);
            }
        }
    }

    protected ModelPlayerBase GetOverwrittenRender(ModelPlayerBase overWriter) {
        if (this.overrideRenderHooks == null) {
            return overWriter;
        }
        for (int i = 0; i < this.overrideRenderHooks.length; ++i) {
            if (this.overrideRenderHooks[i] != overWriter) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideRenderHooks[i - 1];
        }
        return overWriter;
    }

    public static void renderCape(IModelPlayerAPI target, float paramFloat) {
        ModelPlayerAPI modelPlayerAPI = target.getModelPlayerAPI();
        if (modelPlayerAPI != null && modelPlayerAPI.isRenderCapeModded) {
            modelPlayerAPI.renderCape(paramFloat);
        } else {
            target.localRenderCape(paramFloat);
        }
    }

    private void renderCape(float paramFloat) {
        int i;
        if (this.beforeRenderCapeHooks != null) {
            for (i = this.beforeRenderCapeHooks.length - 1; i >= 0; --i) {
                this.beforeRenderCapeHooks[i].beforeRenderCape(paramFloat);
            }
        }
        if (this.overrideRenderCapeHooks != null) {
            this.overrideRenderCapeHooks[this.overrideRenderCapeHooks.length - 1].renderCape(paramFloat);
        } else {
            this.modelPlayer.localRenderCape(paramFloat);
        }
        if (this.afterRenderCapeHooks != null) {
            for (i = 0; i < this.afterRenderCapeHooks.length; ++i) {
                this.afterRenderCapeHooks[i].afterRenderCape(paramFloat);
            }
        }
    }

    protected ModelPlayerBase GetOverwrittenRenderCape(ModelPlayerBase overWriter) {
        if (this.overrideRenderCapeHooks == null) {
            return overWriter;
        }
        for (int i = 0; i < this.overrideRenderCapeHooks.length; ++i) {
            if (this.overrideRenderCapeHooks[i] != overWriter) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideRenderCapeHooks[i - 1];
        }
        return overWriter;
    }

    public static void renderDeadmau5Head(IModelPlayerAPI target, float paramFloat) {
        ModelPlayerAPI modelPlayerAPI = target.getModelPlayerAPI();
        if (modelPlayerAPI != null && modelPlayerAPI.isRenderDeadmau5HeadModded) {
            modelPlayerAPI.renderDeadmau5Head(paramFloat);
        } else {
            target.localRenderDeadmau5Head(paramFloat);
        }
    }

    private void renderDeadmau5Head(float paramFloat) {
        int i;
        if (this.beforeRenderDeadmau5HeadHooks != null) {
            for (i = this.beforeRenderDeadmau5HeadHooks.length - 1; i >= 0; --i) {
                this.beforeRenderDeadmau5HeadHooks[i].beforeRenderDeadmau5Head(paramFloat);
            }
        }
        if (this.overrideRenderDeadmau5HeadHooks != null) {
            this.overrideRenderDeadmau5HeadHooks[this.overrideRenderDeadmau5HeadHooks.length - 1].renderDeadmau5Head(paramFloat);
        } else {
            this.modelPlayer.localRenderDeadmau5Head(paramFloat);
        }
        if (this.afterRenderDeadmau5HeadHooks != null) {
            for (i = 0; i < this.afterRenderDeadmau5HeadHooks.length; ++i) {
                this.afterRenderDeadmau5HeadHooks[i].afterRenderDeadmau5Head(paramFloat);
            }
        }
    }

    protected ModelPlayerBase GetOverwrittenRenderDeadmau5Head(ModelPlayerBase overWriter) {
        if (this.overrideRenderDeadmau5HeadHooks == null) {
            return overWriter;
        }
        for (int i = 0; i < this.overrideRenderDeadmau5HeadHooks.length; ++i) {
            if (this.overrideRenderDeadmau5HeadHooks[i] != overWriter) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideRenderDeadmau5HeadHooks[i - 1];
        }
        return overWriter;
    }

    public static void setLivingAnimations(IModelPlayerAPI target, EntityLivingBase paramEntityLivingBase, float paramFloat1, float paramFloat2, float paramFloat3) {
        ModelPlayerAPI modelPlayerAPI = target.getModelPlayerAPI();
        if (modelPlayerAPI != null && modelPlayerAPI.isSetLivingAnimationsModded) {
            modelPlayerAPI.setLivingAnimations(paramEntityLivingBase, paramFloat1, paramFloat2, paramFloat3);
        } else {
            target.localSetLivingAnimations(paramEntityLivingBase, paramFloat1, paramFloat2, paramFloat3);
        }
    }

    private void setLivingAnimations(EntityLivingBase paramEntityLivingBase, float paramFloat1, float paramFloat2, float paramFloat3) {
        int i;
        if (this.beforeSetLivingAnimationsHooks != null) {
            for (i = this.beforeSetLivingAnimationsHooks.length - 1; i >= 0; --i) {
                this.beforeSetLivingAnimationsHooks[i].beforeSetLivingAnimations(paramEntityLivingBase, paramFloat1, paramFloat2, paramFloat3);
            }
        }
        if (this.overrideSetLivingAnimationsHooks != null) {
            this.overrideSetLivingAnimationsHooks[this.overrideSetLivingAnimationsHooks.length - 1].setLivingAnimations(paramEntityLivingBase, paramFloat1, paramFloat2, paramFloat3);
        } else {
            this.modelPlayer.localSetLivingAnimations(paramEntityLivingBase, paramFloat1, paramFloat2, paramFloat3);
        }
        if (this.afterSetLivingAnimationsHooks != null) {
            for (i = 0; i < this.afterSetLivingAnimationsHooks.length; ++i) {
                this.afterSetLivingAnimationsHooks[i].afterSetLivingAnimations(paramEntityLivingBase, paramFloat1, paramFloat2, paramFloat3);
            }
        }
    }

    protected ModelPlayerBase GetOverwrittenSetLivingAnimations(ModelPlayerBase overWriter) {
        if (this.overrideSetLivingAnimationsHooks == null) {
            return overWriter;
        }
        for (int i = 0; i < this.overrideSetLivingAnimationsHooks.length; ++i) {
            if (this.overrideSetLivingAnimationsHooks[i] != overWriter) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideSetLivingAnimationsHooks[i - 1];
        }
        return overWriter;
    }

    public static void setModelAttributes(IModelPlayerAPI target, ModelBase paramModelBase) {
        ModelPlayerAPI modelPlayerAPI = target.getModelPlayerAPI();
        if (modelPlayerAPI != null && modelPlayerAPI.isSetModelAttributesModded) {
            modelPlayerAPI.setModelAttributes(paramModelBase);
        } else {
            target.localSetModelAttributes(paramModelBase);
        }
    }

    private void setModelAttributes(ModelBase paramModelBase) {
        int i;
        if (this.beforeSetModelAttributesHooks != null) {
            for (i = this.beforeSetModelAttributesHooks.length - 1; i >= 0; --i) {
                this.beforeSetModelAttributesHooks[i].beforeSetModelAttributes(paramModelBase);
            }
        }
        if (this.overrideSetModelAttributesHooks != null) {
            this.overrideSetModelAttributesHooks[this.overrideSetModelAttributesHooks.length - 1].setModelAttributes(paramModelBase);
        } else {
            this.modelPlayer.localSetModelAttributes(paramModelBase);
        }
        if (this.afterSetModelAttributesHooks != null) {
            for (i = 0; i < this.afterSetModelAttributesHooks.length; ++i) {
                this.afterSetModelAttributesHooks[i].afterSetModelAttributes(paramModelBase);
            }
        }
    }

    protected ModelPlayerBase GetOverwrittenSetModelAttributes(ModelPlayerBase overWriter) {
        if (this.overrideSetModelAttributesHooks == null) {
            return overWriter;
        }
        for (int i = 0; i < this.overrideSetModelAttributesHooks.length; ++i) {
            if (this.overrideSetModelAttributesHooks[i] != overWriter) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideSetModelAttributesHooks[i - 1];
        }
        return overWriter;
    }

    public static void setRotationAngles(IModelPlayerAPI target, float paramFloat1, float paramFloat2, float paramFloat3, float paramFloat4, float paramFloat5, float paramFloat6, Entity paramEntity) {
        ModelPlayerAPI modelPlayerAPI = target.getModelPlayerAPI();
        if (modelPlayerAPI != null && modelPlayerAPI.isSetRotationAnglesModded) {
            modelPlayerAPI.setRotationAngles(paramFloat1, paramFloat2, paramFloat3, paramFloat4, paramFloat5, paramFloat6, paramEntity);
        } else {
            target.localSetRotationAngles(paramFloat1, paramFloat2, paramFloat3, paramFloat4, paramFloat5, paramFloat6, paramEntity);
        }
    }

    private void setRotationAngles(float paramFloat1, float paramFloat2, float paramFloat3, float paramFloat4, float paramFloat5, float paramFloat6, Entity paramEntity) {
        int i;
        if (this.beforeSetRotationAnglesHooks != null) {
            for (i = this.beforeSetRotationAnglesHooks.length - 1; i >= 0; --i) {
                this.beforeSetRotationAnglesHooks[i].beforeSetRotationAngles(paramFloat1, paramFloat2, paramFloat3, paramFloat4, paramFloat5, paramFloat6, paramEntity);
            }
        }
        if (this.overrideSetRotationAnglesHooks != null) {
            this.overrideSetRotationAnglesHooks[this.overrideSetRotationAnglesHooks.length - 1].setRotationAngles(paramFloat1, paramFloat2, paramFloat3, paramFloat4, paramFloat5, paramFloat6, paramEntity);
        } else {
            this.modelPlayer.localSetRotationAngles(paramFloat1, paramFloat2, paramFloat3, paramFloat4, paramFloat5, paramFloat6, paramEntity);
        }
        if (this.afterSetRotationAnglesHooks != null) {
            for (i = 0; i < this.afterSetRotationAnglesHooks.length; ++i) {
                this.afterSetRotationAnglesHooks[i].afterSetRotationAngles(paramFloat1, paramFloat2, paramFloat3, paramFloat4, paramFloat5, paramFloat6, paramEntity);
            }
        }
    }

    protected ModelPlayerBase GetOverwrittenSetRotationAngles(ModelPlayerBase overWriter) {
        if (this.overrideSetRotationAnglesHooks == null) {
            return overWriter;
        }
        for (int i = 0; i < this.overrideSetRotationAnglesHooks.length; ++i) {
            if (this.overrideSetRotationAnglesHooks[i] != overWriter) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideSetRotationAnglesHooks[i - 1];
        }
        return overWriter;
    }

    public static void setTextureOffset(IModelPlayerAPI target, String paramString, int paramInt1, int paramInt2) {
        ModelPlayerAPI modelPlayerAPI = target.getModelPlayerAPI();
        if (modelPlayerAPI != null && modelPlayerAPI.isSetTextureOffsetModded) {
            modelPlayerAPI.setTextureOffset(paramString, paramInt1, paramInt2);
        } else {
            target.localSetTextureOffset(paramString, paramInt1, paramInt2);
        }
    }

    private void setTextureOffset(String paramString, int paramInt1, int paramInt2) {
        int i;
        if (this.beforeSetTextureOffsetHooks != null) {
            for (i = this.beforeSetTextureOffsetHooks.length - 1; i >= 0; --i) {
                this.beforeSetTextureOffsetHooks[i].beforeSetTextureOffset(paramString, paramInt1, paramInt2);
            }
        }
        if (this.overrideSetTextureOffsetHooks != null) {
            this.overrideSetTextureOffsetHooks[this.overrideSetTextureOffsetHooks.length - 1].setTextureOffset(paramString, paramInt1, paramInt2);
        } else {
            this.modelPlayer.localSetTextureOffset(paramString, paramInt1, paramInt2);
        }
        if (this.afterSetTextureOffsetHooks != null) {
            for (i = 0; i < this.afterSetTextureOffsetHooks.length; ++i) {
                this.afterSetTextureOffsetHooks[i].afterSetTextureOffset(paramString, paramInt1, paramInt2);
            }
        }
    }

    protected ModelPlayerBase GetOverwrittenSetTextureOffset(ModelPlayerBase overWriter) {
        if (this.overrideSetTextureOffsetHooks == null) {
            return overWriter;
        }
        for (int i = 0; i < this.overrideSetTextureOffsetHooks.length; ++i) {
            if (this.overrideSetTextureOffsetHooks[i] != overWriter) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideSetTextureOffsetHooks[i - 1];
        }
        return overWriter;
    }

    public static void setVisible(IModelPlayerAPI target, boolean paramBoolean) {
        ModelPlayerAPI modelPlayerAPI = target.getModelPlayerAPI();
        if (modelPlayerAPI != null && modelPlayerAPI.isSetVisibleModded) {
            modelPlayerAPI.setVisible(paramBoolean);
        } else {
            target.localSetVisible(paramBoolean);
        }
    }

    private void setVisible(boolean paramBoolean) {
        int i;
        if (this.beforeSetVisibleHooks != null) {
            for (i = this.beforeSetVisibleHooks.length - 1; i >= 0; --i) {
                this.beforeSetVisibleHooks[i].beforeSetVisible(paramBoolean);
            }
        }
        if (this.overrideSetVisibleHooks != null) {
            this.overrideSetVisibleHooks[this.overrideSetVisibleHooks.length - 1].setVisible(paramBoolean);
        } else {
            this.modelPlayer.localSetVisible(paramBoolean);
        }
        if (this.afterSetVisibleHooks != null) {
            for (i = 0; i < this.afterSetVisibleHooks.length; ++i) {
                this.afterSetVisibleHooks[i].afterSetVisible(paramBoolean);
            }
        }
    }

    protected ModelPlayerBase GetOverwrittenSetVisible(ModelPlayerBase overWriter) {
        if (this.overrideSetVisibleHooks == null) {
            return overWriter;
        }
        for (int i = 0; i < this.overrideSetVisibleHooks.length; ++i) {
            if (this.overrideSetVisibleHooks[i] != overWriter) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideSetVisibleHooks[i - 1];
        }
        return overWriter;
    }

    static {
        logger = Logger.getLogger("ModelPlayerAPI");
        allInstances = new ArrayList<WeakReference<IModelPlayerAPI>>();
        EmptySortMap = Collections.unmodifiableMap(new HashMap());
        beforeGetArmForSideHookTypes = new LinkedList<String>();
        overrideGetArmForSideHookTypes = new LinkedList<String>();
        afterGetArmForSideHookTypes = new LinkedList<String>();
        allBaseBeforeGetArmForSideSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeGetArmForSideInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideGetArmForSideSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideGetArmForSideInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterGetArmForSideSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterGetArmForSideInferiors = new Hashtable<String, String[]>(0);
        beforeGetMainHandHookTypes = new LinkedList<String>();
        overrideGetMainHandHookTypes = new LinkedList<String>();
        afterGetMainHandHookTypes = new LinkedList<String>();
        allBaseBeforeGetMainHandSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeGetMainHandInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideGetMainHandSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideGetMainHandInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterGetMainHandSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterGetMainHandInferiors = new Hashtable<String, String[]>(0);
        beforeGetRandomModelBoxHookTypes = new LinkedList<String>();
        overrideGetRandomModelBoxHookTypes = new LinkedList<String>();
        afterGetRandomModelBoxHookTypes = new LinkedList<String>();
        allBaseBeforeGetRandomModelBoxSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeGetRandomModelBoxInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideGetRandomModelBoxSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideGetRandomModelBoxInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterGetRandomModelBoxSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterGetRandomModelBoxInferiors = new Hashtable<String, String[]>(0);
        beforeGetTextureOffsetHookTypes = new LinkedList<String>();
        overrideGetTextureOffsetHookTypes = new LinkedList<String>();
        afterGetTextureOffsetHookTypes = new LinkedList<String>();
        allBaseBeforeGetTextureOffsetSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeGetTextureOffsetInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideGetTextureOffsetSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideGetTextureOffsetInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterGetTextureOffsetSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterGetTextureOffsetInferiors = new Hashtable<String, String[]>(0);
        beforePostRenderArmHookTypes = new LinkedList<String>();
        overridePostRenderArmHookTypes = new LinkedList<String>();
        afterPostRenderArmHookTypes = new LinkedList<String>();
        allBaseBeforePostRenderArmSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforePostRenderArmInferiors = new Hashtable<String, String[]>(0);
        allBaseOverridePostRenderArmSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverridePostRenderArmInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterPostRenderArmSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterPostRenderArmInferiors = new Hashtable<String, String[]>(0);
        beforeRenderHookTypes = new LinkedList<String>();
        overrideRenderHookTypes = new LinkedList<String>();
        afterRenderHookTypes = new LinkedList<String>();
        allBaseBeforeRenderSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeRenderInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideRenderSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideRenderInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterRenderSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterRenderInferiors = new Hashtable<String, String[]>(0);
        beforeRenderCapeHookTypes = new LinkedList<String>();
        overrideRenderCapeHookTypes = new LinkedList<String>();
        afterRenderCapeHookTypes = new LinkedList<String>();
        allBaseBeforeRenderCapeSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeRenderCapeInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideRenderCapeSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideRenderCapeInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterRenderCapeSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterRenderCapeInferiors = new Hashtable<String, String[]>(0);
        beforeRenderDeadmau5HeadHookTypes = new LinkedList<String>();
        overrideRenderDeadmau5HeadHookTypes = new LinkedList<String>();
        afterRenderDeadmau5HeadHookTypes = new LinkedList<String>();
        allBaseBeforeRenderDeadmau5HeadSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeRenderDeadmau5HeadInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideRenderDeadmau5HeadSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideRenderDeadmau5HeadInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterRenderDeadmau5HeadSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterRenderDeadmau5HeadInferiors = new Hashtable<String, String[]>(0);
        beforeSetLivingAnimationsHookTypes = new LinkedList<String>();
        overrideSetLivingAnimationsHookTypes = new LinkedList<String>();
        afterSetLivingAnimationsHookTypes = new LinkedList<String>();
        allBaseBeforeSetLivingAnimationsSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeSetLivingAnimationsInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideSetLivingAnimationsSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideSetLivingAnimationsInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterSetLivingAnimationsSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterSetLivingAnimationsInferiors = new Hashtable<String, String[]>(0);
        beforeSetModelAttributesHookTypes = new LinkedList<String>();
        overrideSetModelAttributesHookTypes = new LinkedList<String>();
        afterSetModelAttributesHookTypes = new LinkedList<String>();
        allBaseBeforeSetModelAttributesSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeSetModelAttributesInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideSetModelAttributesSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideSetModelAttributesInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterSetModelAttributesSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterSetModelAttributesInferiors = new Hashtable<String, String[]>(0);
        beforeSetRotationAnglesHookTypes = new LinkedList<String>();
        overrideSetRotationAnglesHookTypes = new LinkedList<String>();
        afterSetRotationAnglesHookTypes = new LinkedList<String>();
        allBaseBeforeSetRotationAnglesSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeSetRotationAnglesInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideSetRotationAnglesSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideSetRotationAnglesInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterSetRotationAnglesSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterSetRotationAnglesInferiors = new Hashtable<String, String[]>(0);
        beforeSetTextureOffsetHookTypes = new LinkedList<String>();
        overrideSetTextureOffsetHookTypes = new LinkedList<String>();
        afterSetTextureOffsetHookTypes = new LinkedList<String>();
        allBaseBeforeSetTextureOffsetSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeSetTextureOffsetInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideSetTextureOffsetSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideSetTextureOffsetInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterSetTextureOffsetSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterSetTextureOffsetInferiors = new Hashtable<String, String[]>(0);
        beforeSetVisibleHookTypes = new LinkedList<String>();
        overrideSetVisibleHookTypes = new LinkedList<String>();
        afterSetVisibleHookTypes = new LinkedList<String>();
        allBaseBeforeSetVisibleSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeSetVisibleInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideSetVisibleSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideSetVisibleInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterSetVisibleSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterSetVisibleInferiors = new Hashtable<String, String[]>(0);
        keys = new HashSet<String>();
        keysToVirtualIds = new HashMap<String, String>();
        dynamicTypes = new HashSet();
        virtualDynamicHookMethods = new HashMap();
        beforeDynamicHookMethods = new HashMap();
        overrideDynamicHookMethods = new HashMap();
        afterDynamicHookMethods = new HashMap();
        beforeLocalConstructingHookTypes = new LinkedList<String>();
        afterLocalConstructingHookTypes = new LinkedList<String>();
        beforeDynamicHookTypes = new Hashtable<String, List<String>>(0);
        overrideDynamicHookTypes = new Hashtable<String, List<String>>(0);
        afterDynamicHookTypes = new Hashtable<String, List<String>>(0);
        allBaseConstructors = new Hashtable();
        unmodifiableAllIds = Collections.unmodifiableSet(allBaseConstructors.keySet());
        allBaseBeforeLocalConstructingSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeLocalConstructingInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterLocalConstructingSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterLocalConstructingInferiors = new Hashtable<String, String[]>(0);
        allBaseBeforeDynamicSuperiors = new Hashtable<String, Map<String, String[]>>(0);
        allBaseBeforeDynamicInferiors = new Hashtable<String, Map<String, String[]>>(0);
        allBaseOverrideDynamicSuperiors = new Hashtable<String, Map<String, String[]>>(0);
        allBaseOverrideDynamicInferiors = new Hashtable<String, Map<String, String[]>>(0);
        allBaseAfterDynamicSuperiors = new Hashtable<String, Map<String, String[]>>(0);
        allBaseAfterDynamicInferiors = new Hashtable<String, Map<String, String[]>>(0);
        initialized = false;
    }
}

