/*
 * Decompiled with CFR 0.152.
 */
package cavern.world.mirage;

import cavern.api.entity.ICavenicMob;
import cavern.client.CaveMusics;
import cavern.config.CaveniaConfig;
import cavern.entity.CaveEntityRegistry;
import cavern.world.CaveBiomeProvider;
import cavern.world.CaveDimensions;
import cavern.world.WorldProviderCavern;
import cavern.world.mirage.ChunkGeneratorCavenia;
import java.util.Random;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderCavenia
extends WorldProviderCavern {
    @Override
    protected BiomeProvider createBiomeProvider() {
        return new CaveBiomeProvider(this.field_76579_a, CaveniaConfig.BIOMES);
    }

    @Override
    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorCavenia(this.field_76579_a);
    }

    @Override
    public DimensionType func_186058_p() {
        return CaveDimensions.CAVENIA;
    }

    @Override
    public int getWorldHeight() {
        return CaveniaConfig.worldHeight;
    }

    @Override
    public int getMonsterSpawn() {
        return CaveniaConfig.monsterSpawn;
    }

    @Override
    public double getBrightness() {
        return CaveniaConfig.caveBrightness;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public MusicTicker.MusicType getMusicType() {
        return CaveMusics.CAVENIA;
    }

    @Override
    public EntityLiving createSpawnCreature(WorldServer world, EnumCreatureType type, BlockPos pos, Biome.SpawnListEntry entry) {
        if (type != EnumCreatureType.MONSTER) {
            return null;
        }
        NonNullList<Biome.SpawnListEntry> list = CaveEntityRegistry.SPAWNS;
        double chance = CaveniaConfig.crazySpawnChance;
        if (chance > 0.0 && world.field_73012_v.nextDouble() <= chance) {
            int rangeY;
            int range = 0;
            if (chance <= 0.1) {
                range = 50;
            } else if (chance <= 0.2) {
                range = 32;
            } else if (chance <= 0.4) {
                range = 16;
            } else if (chance <= 0.6) {
                range = 8;
            } else if (chance <= 0.8) {
                range = 4;
            }
            int n = rangeY = range > 1 ? range / 2 : range;
            if (range <= 0 || world.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(pos.func_177982_a(-range, -rangeY, -range), pos.func_177982_a(range, rangeY, range)), entity -> entity instanceof ICavenicMob && !entity.func_184222_aU()).isEmpty()) {
                list = CaveEntityRegistry.CRAZY_SPAWNS;
            }
        }
        Biome.SpawnListEntry spawnEntry = (Biome.SpawnListEntry)WeightedRandom.func_76271_a((Random)world.field_73012_v, list);
        try {
            return spawnEntry.newInstance((World)world);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

