/*
 * Decompiled with CFR 0.152.
 */
package cavern.world.mirage;

import cavern.world.gen.MapGenSkyCaves;
import cavern.world.gen.MapGenSkyWatchTower;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class ChunkGeneratorSkyland
implements IChunkGenerator {
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState STONE = Blocks.field_150348_b.func_176223_P();
    protected static final IBlockState SANDSTONE = Blocks.field_150322_A.func_176223_P();
    private final World world;
    private final Random rand;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorOctaves noiseGen4;
    private NoiseGeneratorOctaves noiseGen5;
    private Biome[] biomesForGeneration;
    private double[] buffer;
    private double[] noise1;
    private double[] noise2;
    private double[] noise3;
    private double[] noise4;
    private double[] noise5;
    private final MapGenSkyWatchTower skyWatchTowerGenerator = new MapGenSkyWatchTower(this);
    private final MapGenBase caveGenerator = new MapGenSkyCaves();
    private final WorldGenerator lakeWaterGen = new WorldGenLakes((Block)Blocks.field_150355_j);
    private final WorldGenerator lakeLavaGen = new WorldGenLakes((Block)Blocks.field_150353_l);
    private final WorldGenerator worldGenIron = new WorldGenMinable(Blocks.field_150366_p.func_176223_P(), 7);
    private final WorldGenerator worldGenEmerald = new WorldGenMinable(Blocks.field_150412_bA.func_176223_P(), 4);
    private final WorldGenerator worldGenDiamond = new WorldGenMinable(Blocks.field_150482_ag.func_176223_P(), 3);

    public ChunkGeneratorSkyland(World world) {
        this.world = world;
        this.rand = new Random(world.func_72905_C());
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 16);
    }

    public void setBlocksInChunk(int chunkX, int chunkZ, ChunkPrimer primer) {
        int density = 20;
        if (Math.abs(chunkX) >= density) {
            int rx = Math.abs(chunkX) % density - density / 2;
            int n = chunkX = chunkX < 0 ? -rx : rx;
        }
        if (Math.abs(chunkZ) >= density) {
            int rz = Math.abs(chunkZ) % density - density / 2;
            chunkZ = chunkZ < 0 ? -rz : rz;
        }
        int b0 = 2;
        int b1 = 1;
        int sizeX = b0 + b1;
        int sizeY = 35;
        int sizeZ = b0 + b1;
        this.buffer = this.getHeights(this.buffer, chunkX * b0, 0, chunkZ * b0, sizeX, sizeY, sizeZ);
        for (int i = 0; i < b0; ++i) {
            for (int j = 0; j < b0; ++j) {
                for (int k = 0; k < 32; ++k) {
                    double d0 = 0.25;
                    double d1 = this.buffer[((i + 0) * sizeZ + j + 0) * sizeY + k + 0];
                    double d2 = this.buffer[((i + 0) * sizeZ + j + 1) * sizeY + k + 0];
                    double d3 = this.buffer[((i + 1) * sizeZ + j + 0) * sizeY + k + 0];
                    double d4 = this.buffer[((i + 1) * sizeZ + j + 1) * sizeY + k + 0];
                    double d5 = (this.buffer[((i + 0) * sizeZ + j + 0) * sizeY + k + 1] - d1) * d0;
                    double d6 = (this.buffer[((i + 0) * sizeZ + j + 1) * sizeY + k + 1] - d2) * d0;
                    double d7 = (this.buffer[((i + 1) * sizeZ + j + 0) * sizeY + k + 1] - d3) * d0;
                    double d8 = (this.buffer[((i + 1) * sizeZ + j + 1) * sizeY + k + 1] - d4) * d0;
                    for (int l = 0; l < 4; ++l) {
                        double d9 = 0.15;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int m = 0; m < 8; ++m) {
                            double d14 = 0.125;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int n = 0; n < 8; ++n) {
                                IBlockState state = AIR;
                                if (d15 > 0.0) {
                                    state = STONE;
                                }
                                int x = m + i * 8;
                                int y = l + k * 4;
                                int z = n + j * 8;
                                primer.func_177855_a(x, y, z, state);
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private double[] getHeights(double[] buffer, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ) {
        if (buffer == null) {
            buffer = new double[sizeX * sizeY * sizeZ];
        }
        double d0 = 684.412;
        double d1 = 684.412;
        this.noise4 = this.noiseGen4.func_76305_a(this.noise4, posX, posZ, sizeX, sizeZ, 1.121, 1.121, 0.5);
        this.noise5 = this.noiseGen5.func_76305_a(this.noise5, posX, posZ, sizeX, sizeZ, 200.0, 200.0, 0.5);
        this.noise1 = this.noiseGen3.func_76304_a(this.noise1, posX, posY, posZ, sizeX, sizeY, sizeZ, (d0 *= 5.0) / 80.0, (d1 *= 2.0) / 160.0, d0 / 80.0);
        this.noise2 = this.noiseGen1.func_76304_a(this.noise2, posX, posY, posZ, sizeX, sizeY, sizeZ, d0, d1, d0);
        this.noise3 = this.noiseGen2.func_76304_a(this.noise3, posX, posY, posZ, sizeX, sizeY, sizeZ, d0, d1, d0);
        int i = 0;
        int j = 0;
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                double d3;
                double d2 = (this.noise4[j] + 256.0) / 512.0;
                if (d2 > 1.0) {
                    d2 = 1.0;
                }
                if ((d3 = this.noise5[j] / 8000.0) < 0.0) {
                    d3 = -d3 * 0.3;
                }
                d3 = d3 * 3.0 - 2.0;
                float f = (float)(x + posX - 0) / 1.0f;
                float f1 = (float)(z + posZ - 0) / 1.0f;
                float f2 = 100.0f - MathHelper.func_76129_c((float)(f * f + f1 * f1)) * 8.0f;
                if (f2 > 80.0f) {
                    f2 = 80.0f;
                }
                if (f2 < -100.0f) {
                    f2 = -100.0f;
                }
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d3 /= 8.0;
                d3 = 0.0;
                if (d2 < 0.0) {
                    d2 = 0.0;
                }
                d2 += 0.5;
                d3 = d3 * (double)sizeY / 16.0;
                ++j;
                double d4 = (double)sizeY / 2.0;
                for (int y = 0; y < sizeY; ++y) {
                    double d10;
                    double d5 = 0.0;
                    double d6 = ((double)y - d4) * 8.0 / d2;
                    if (d6 < 0.0) {
                        d6 *= -1.0;
                    }
                    double d7 = this.noise2[i] / 512.0;
                    double d8 = this.noise3[i] / 512.0;
                    double d9 = (this.noise1[i] / 10.0 + 1.0) / 2.0;
                    d5 = d9 < 0.0 ? d7 : (d9 > 1.0 ? d8 : d7 + (d8 - d7) * d9);
                    d5 -= 8.0;
                    d5 += (double)f2;
                    int b0 = 2;
                    if (y > sizeY / 2 - b0) {
                        d10 = (float)(y - (sizeY / 2 - b0)) / 64.0f;
                        if (d10 < 0.0) {
                            d10 = 0.0;
                        }
                        if (d10 > 1.0) {
                            d10 = 1.0;
                        }
                        d5 = d5 * (1.0 - d10) + -3000.0 * d10;
                    }
                    if (y < (b0 = 8)) {
                        d10 = (float)(b0 - y) / ((float)b0 - 1.0f);
                        d5 = d5 * (1.0 - d10) + -30.0 * d10;
                    }
                    buffer[i] = d5;
                    ++i;
                }
            }
        }
        return buffer;
    }

    public void buildSurfaces(ChunkPrimer primer) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int i = 1;
                int j = -1;
                Biome biome = this.biomesForGeneration[z + x * 16];
                IBlockState top = biome.field_76752_A;
                IBlockState filler = biome.field_76753_B;
                for (int y = 127; y >= 0; --y) {
                    IBlockState state = primer.func_177856_a(x, y, z);
                    if (state.func_185904_a() == Material.field_151579_a) {
                        j = -1;
                        continue;
                    }
                    if (state.func_177230_c() != Blocks.field_150348_b) continue;
                    if (j == -1) {
                        if (i <= 0) {
                            top = AIR;
                            filler = biome.field_76753_B;
                        }
                        j = i;
                        if (y >= 0) {
                            primer.func_177855_a(x, y, z, top);
                            continue;
                        }
                        primer.func_177855_a(x, y, z, filler);
                        continue;
                    }
                    if (j <= 0) continue;
                    primer.func_177855_a(x, y, z, filler);
                    if (--j != 0 || filler.func_177230_c() != Blocks.field_150354_m) continue;
                    j = this.rand.nextInt(4) + Math.max(0, y - 63);
                    filler = SANDSTONE;
                }
            }
        }
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        ChunkPrimer primer = new ChunkPrimer();
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 16, chunkZ * 16, 16, 16);
        this.setBlocksInChunk(chunkX, chunkZ, primer);
        this.buildSurfaces(primer);
        this.skyWatchTowerGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.caveGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        Chunk chunk = new Chunk(this.world, primer, chunkX, chunkZ);
        byte[] biomes = chunk.func_76605_m();
        for (int index = 0; index < biomes.length; ++index) {
            biomes[index] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[index]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        int i;
        int genY;
        int genZ;
        int genX;
        BlockFalling.field_149832_M = true;
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false);
        BlockPos pos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
        Biome biome = this.world.func_180494_b(pos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long xSeed = this.rand.nextLong() / 2L * 2L + 1L;
        long zSeed = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * xSeed + (long)chunkZ * zSeed ^ this.world.func_72905_C());
        if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) && this.rand.nextInt(4) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            genX = this.rand.nextInt(16) + 8;
            genZ = this.rand.nextInt(16) + 8;
            genY = this.rand.nextInt(Math.max(this.world.func_175645_m(pos.func_177982_a(genX, 0, genZ)).func_177956_o() - 10, 1)) + 10;
            this.lakeWaterGen.func_180709_b(this.world, this.rand, pos.func_177982_a(genX, genY, genZ));
        }
        if (this.rand.nextInt(8) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA) && ((genY = this.rand.nextInt(Math.max((i = this.world.func_175645_m(pos.func_177982_a(genX = this.rand.nextInt(16) + 8, 0, genZ = this.rand.nextInt(16) + 8)).func_177956_o()) - 10, 1)) + 10) < i || this.rand.nextInt(10) == 0)) {
            this.lakeLavaGen.func_180709_b(this.world, this.rand, pos.func_177982_a(genX, genY, genZ));
        }
        boolean doGen = TerrainGen.generateOre((World)this.world, (Random)this.rand, (WorldGenerator)this.worldGenIron, (BlockPos)pos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.IRON);
        for (i = 0; doGen && i < 20; ++i) {
            genX = this.rand.nextInt(16);
            genY = this.rand.nextInt(50) + 20;
            genZ = this.rand.nextInt(16);
            this.worldGenIron.func_180709_b(this.world, this.rand, pos.func_177982_a(genX, genY, genZ));
        }
        doGen = TerrainGen.generateOre((World)this.world, (Random)this.rand, (WorldGenerator)this.worldGenEmerald, (BlockPos)pos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.EMERALD);
        for (i = 0; doGen && i < 6; ++i) {
            genX = this.rand.nextInt(16);
            genY = this.rand.nextInt(50) + 10;
            genZ = this.rand.nextInt(16);
            this.worldGenEmerald.func_180709_b(this.world, this.rand, pos.func_177982_a(genX, genY, genZ));
        }
        doGen = TerrainGen.generateOre((World)this.world, (Random)this.rand, (WorldGenerator)this.worldGenDiamond, (BlockPos)pos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIAMOND);
        for (i = 0; doGen && i < 8; ++i) {
            genX = this.rand.nextInt(16);
            genY = this.rand.nextInt(50) + 10;
            genZ = this.rand.nextInt(16);
            this.worldGenDiamond.func_180709_b(this.world, this.rand, pos.func_177982_a(genX, genY, genZ));
        }
        biome.func_180624_a(this.world, this.rand, pos);
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(pos.func_177958_n() + 8), (int)(pos.func_177952_p() + 8), (int)16, (int)16, (Random)this.rand);
        }
        pos = pos.func_177982_a(8, 0, 8);
        doGen = TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE);
        for (genX = 0; doGen && genX < 16; ++genX) {
            for (genZ = 0; genZ < 16; ++genZ) {
                BlockPos top = this.world.func_175725_q(pos.func_177982_a(genX, 0, genZ)).func_177977_b();
                if (!this.world.func_175675_v(top)) continue;
                this.world.func_180501_a(top, Blocks.field_150432_aD.func_176223_P(), 2);
            }
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false);
        ChunkPos coord = new ChunkPos(chunkX, chunkZ);
        this.skyWatchTowerGenerator.func_175794_a(this.world, this.rand, coord);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunk, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType type, BlockPos pos) {
        return this.world.func_180494_b(pos).func_76747_a(type);
    }

    public boolean func_193414_a(World world, String structureName, BlockPos pos) {
        if ("SkyWatchTower".equals(structureName) && this.skyWatchTowerGenerator != null) {
            return this.skyWatchTowerGenerator.func_175795_b(pos);
        }
        return false;
    }

    public BlockPos func_180513_a(World world, String structureName, BlockPos pos, boolean findUnexplored) {
        if ("SkyWatchTower".equals(structureName) && this.skyWatchTowerGenerator != null) {
            return this.skyWatchTowerGenerator.func_180706_b(world, pos, findUnexplored);
        }
        return null;
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
        this.skyWatchTowerGenerator.func_186125_a(this.world, x, z, null);
    }
}

