/*
 * Decompiled with CFR 0.152.
 */
package cavern.world.mirage;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class ChunkGeneratorCrownCliffs
implements IChunkGenerator {
    protected static final IBlockState STONE = Blocks.field_150348_b.func_176223_P();
    protected static final IBlockState WATER = Blocks.field_150355_j.func_176223_P();
    private final World world;
    private final Random rand;
    private NoiseGeneratorOctaves minLimitPerlinNoise;
    private NoiseGeneratorOctaves maxLimitPerlinNoise;
    private NoiseGeneratorOctaves mainPerlinNoise;
    private NoiseGeneratorPerlin surfaceNoise;
    private NoiseGeneratorOctaves depthNoise;
    private final double[] heightMap;
    private final float[] biomeWeights;
    private double[] depthBuffer = new double[256];
    private double[] mainNoiseRegion;
    private double[] minLimitRegion;
    private double[] maxLimitRegion;
    private double[] depthRegion;
    private Biome[] biomesForGeneration;
    private final MapGenBase caveGenerator = new MapGenCaves();
    private final MapGenBase ravineGenerator = new MapGenRavine();
    private final MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    private final WorldGenerator lakeWaterGen = new WorldGenLakes((Block)Blocks.field_150355_j);
    private final WorldGenerator lakeLavaGen = new WorldGenLakes((Block)Blocks.field_150353_l);
    private final WorldGenerator dungeonGen = new WorldGenDungeons();

    public ChunkGeneratorCrownCliffs(World world) {
        this.world = world;
        this.rand = new Random(world.func_72905_C());
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.surfaceNoise = new NoiseGeneratorPerlin(this.rand, 4);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.heightMap = new double[825];
        this.biomeWeights = new float[25];
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                this.biomeWeights[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
    }

    public void setBlocksInChunk(int x, int z, ChunkPrimer primer) {
        this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, x * 4 - 2, z * 4 - 2, 10, 10);
        this.generateHeightmap(x * 4, 0, z * 4);
        for (int i = 0; i < 4; ++i) {
            int j = i * 5;
            int k = (i + 1) * 5;
            for (int l = 0; l < 4; ++l) {
                int i1 = (j + l) * 33;
                int j1 = (j + l + 1) * 33;
                int k1 = (k + l) * 33;
                int l1 = (k + l + 1) * 33;
                for (int i2 = 0; i2 < 32; ++i2) {
                    double d1 = this.heightMap[i1 + i2];
                    double d2 = this.heightMap[j1 + i2];
                    double d3 = this.heightMap[k1 + i2];
                    double d4 = this.heightMap[l1 + i2];
                    double d5 = (this.heightMap[i1 + i2 + 1] - d1) * 0.125;
                    double d6 = (this.heightMap[j1 + i2 + 1] - d2) * 0.125;
                    double d7 = (this.heightMap[k1 + i2 + 1] - d3) * 0.125;
                    double d8 = (this.heightMap[l1 + i2 + 1] - d4) * 0.125;
                    for (int j2 = 0; j2 < 8; ++j2) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        for (int k2 = 0; k2 < 4; ++k2) {
                            double d16 = (d11 - d10) * 0.25;
                            double lvt_45_1_ = d10 - d16;
                            for (int l2 = 0; l2 < 4; ++l2) {
                                double d;
                                lvt_45_1_ += d16;
                                if (d > 0.0) {
                                    primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, STONE);
                                    continue;
                                }
                                if (i2 * 8 + j2 >= 63) continue;
                                primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, WATER);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void replaceBiomeBlocks(int x, int z, ChunkPrimer primer, Biome[] biomesIn) {
        this.depthBuffer = this.surfaceNoise.func_151599_a(this.depthBuffer, (double)(x * 16), (double)(z * 16), 16, 16, 0.0625, 0.0625, 1.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biome = biomesIn[j + i * 16];
                biome.func_180622_a(this.world, this.rand, primer, x * 16 + i, z * 16 + j, this.depthBuffer[j + i * 16]);
            }
        }
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        ChunkPrimer primer = new ChunkPrimer();
        this.setBlocksInChunk(chunkX, chunkZ, primer);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 16, chunkZ * 16, 16, 16);
        this.replaceBiomeBlocks(chunkX, chunkZ, primer, this.biomesForGeneration);
        this.caveGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.ravineGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        this.mineshaftGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        Chunk chunk = new Chunk(this.world, primer, chunkX, chunkZ);
        byte[] biomes = chunk.func_76605_m();
        for (int i = 0; i < biomes.length; ++i) {
            biomes[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void generateHeightmap(int posX, int posY, int posZ) {
        this.depthRegion = this.depthNoise.func_76305_a(this.depthRegion, posX, posZ, 5, 5, 200.0, 200.0, 0.5);
        float f = 684.412f;
        float f1 = 684.412f;
        this.mainNoiseRegion = this.mainPerlinNoise.func_76304_a(this.mainNoiseRegion, posX, posY, posZ, 5, 33, 5, (double)(f / 80.0f), (double)(f1 / 160.0f), (double)(f / 80.0f));
        this.minLimitRegion = this.minLimitPerlinNoise.func_76304_a(this.minLimitRegion, posX, posY, posZ, 5, 33, 5, (double)f, (double)f1, (double)f);
        this.maxLimitRegion = this.maxLimitPerlinNoise.func_76304_a(this.maxLimitRegion, posX, posY, posZ, 5, 33, 5, (double)f, (double)f1, (double)f);
        int i = 0;
        int j = 0;
        for (int k = 0; k < 5; ++k) {
            for (int l = 0; l < 5; ++l) {
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                Biome biome = this.biomesForGeneration[k + 2 + (l + 2) * 10];
                for (int j1 = -2; j1 <= 2; ++j1) {
                    for (int k1 = -2; k1 <= 2; ++k1) {
                        Biome biome1 = this.biomesForGeneration[k + j1 + 2 + (l + k1 + 2) * 10];
                        float f5 = biome1.func_185355_j();
                        float f6 = biome1.func_185360_m();
                        if (f5 > 0.0f) {
                            f5 = 1.0f + f5 * 2.0f;
                            f6 = 1.0f + f6 * 6.5f;
                        }
                        float f7 = this.biomeWeights[j1 + 2 + (k1 + 2) * 5] / (f5 + 2.0f);
                        if (biome1.func_185355_j() > biome.func_185355_j()) {
                            f7 /= 1.5f;
                        }
                        f2 += f6 * f7;
                        f3 += f5 * f7;
                        f4 += f7;
                    }
                }
                f2 /= f4;
                f3 /= f4;
                f2 = f2 * 0.9f + 0.1f;
                f3 = (f3 * 4.0f - 1.0f) / 8.0f;
                double d7 = this.depthRegion[j] / 8000.0;
                if (d7 < 0.0) {
                    d7 = -d7 * 0.3;
                }
                if ((d7 = d7 * 3.0 - 2.0) < 0.0) {
                    if ((d7 /= 2.0) < -1.0) {
                        d7 = -1.0;
                    }
                    d7 /= 1.4;
                    d7 /= 2.0;
                } else {
                    if (d7 > 1.0) {
                        d7 = 1.0;
                    }
                    d7 /= 8.0;
                }
                ++j;
                double d8 = f3;
                double d9 = f2;
                d8 += d7 * 0.2;
                d8 = d8 * 8.5 / 8.0;
                double d0 = 8.5 + d8 * 4.0;
                for (int l1 = 0; l1 < 33; ++l1) {
                    double d1 = ((double)l1 - d0) * 12.0 * 128.0 / 256.0 / d9;
                    if (d1 < 0.0) {
                        d1 *= 4.0;
                    }
                    double d2 = this.minLimitRegion[i] / 512.0;
                    double d3 = this.maxLimitRegion[i] / 512.0;
                    double d4 = (this.mainNoiseRegion[i] / 10.0 + 1.0) / 2.0;
                    double d5 = MathHelper.func_151238_b((double)d2, (double)d3, (double)d4) - d1;
                    if (l1 > 29) {
                        double d6 = (float)(l1 - 29) / 3.0f;
                        d5 = d5 * (1.0 - d6) + -10.0 * d6;
                    }
                    this.heightMap[i] = d5;
                    ++i;
                }
            }
        }
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        int i;
        int genZ;
        int genY;
        int genX;
        BlockFalling.field_149832_M = true;
        int x = chunkX << 4;
        int z = chunkZ << 4;
        BlockPos blockpos = new BlockPos(x, 0, z);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long seedX = this.rand.nextLong() / 2L * 2L + 1L;
        long seedZ = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * seedX + (long)chunkZ * seedZ ^ this.world.func_72905_C());
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false);
        ChunkPos coord = new ChunkPos(chunkX, chunkZ);
        this.mineshaftGenerator.func_175794_a(this.world, this.rand, coord);
        if (biome != Biomes.field_76769_d && biome != Biomes.field_76786_s && this.rand.nextInt(10) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            genX = this.rand.nextInt(16) + 8;
            genY = this.rand.nextInt(256);
            genZ = this.rand.nextInt(16) + 8;
            this.lakeWaterGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(genX, genY, genZ));
        }
        if (this.rand.nextInt(30) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA)) {
            genX = this.rand.nextInt(16) + 8;
            genY = this.rand.nextInt(this.rand.nextInt(248) + 8);
            genZ = this.rand.nextInt(16) + 8;
            if (genY < this.world.func_181545_F() || this.rand.nextInt(20) == 0) {
                this.lakeLavaGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(genX, genY, genZ));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON)) {
            for (i = 0; i < 6; ++i) {
                int genX2 = this.rand.nextInt(16) + 8;
                int genY2 = this.rand.nextInt(256);
                int genZ2 = this.rand.nextInt(16) + 8;
                this.dungeonGen.func_180709_b(this.world, this.rand, blockpos.func_177982_a(genX2, genY2, genZ2));
            }
        }
        biome.func_180624_a(this.world, this.rand, new BlockPos(x, 0, z));
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(x + 8), (int)(z + 8), (int)16, (int)16, (Random)this.rand);
        }
        blockpos = blockpos.func_177982_a(8, 0, 8);
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            for (i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    BlockPos top = this.world.func_175725_q(blockpos.func_177982_a(i, 0, j));
                    BlockPos under = top.func_177977_b();
                    if (this.world.func_175675_v(under)) {
                        this.world.func_180501_a(under, Blocks.field_150432_aD.func_176223_P(), 2);
                    }
                    if (!this.world.func_175708_f(top, true)) continue;
                    this.world.func_180501_a(top, Blocks.field_150431_aC.func_176223_P(), 2);
                }
            }
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunk, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_180494_b(pos);
        return biome.func_76747_a(creatureType);
    }

    public boolean func_193414_a(World world, String structureName, BlockPos pos) {
        if ("Mineshaft".equals(structureName) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_175795_b(pos);
        }
        return false;
    }

    public BlockPos func_180513_a(World world, String structureName, BlockPos pos, boolean findUnexplored) {
        if ("Mineshaft".equals(structureName) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_180706_b(world, pos, findUnexplored);
        }
        return null;
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
        this.mineshaftGenerator.func_186125_a(this.world, x, z, null);
    }
}

