/*
 * Decompiled with CFR 0.152.
 */
package cavern.world.mirage;

import cavern.config.CavelandConfig;
import cavern.world.CaveVeinProvider;
import cavern.world.gen.MapGenCavelandCaves;
import cavern.world.gen.MapGenCavelandRavine;
import cavern.world.gen.VeinGenerator;
import cavern.world.gen.WorldGenAcresia;
import cavern.world.gen.WorldGenBirchTreePerverted;
import cavern.world.gen.WorldGenCaveBush;
import cavern.world.gen.WorldGenRuinedHouse;
import cavern.world.gen.WorldGenSpruceTreePerverted;
import cavern.world.gen.WorldGenTreesPerverted;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.feature.WorldGenDeadBush;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkGeneratorCaveland
implements IChunkGenerator {
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState DIRT = Blocks.field_150346_d.func_176223_P();
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    protected static final IBlockState SANDSTONE = Blocks.field_150322_A.func_176223_P();
    private final World world;
    private final Random rand;
    private Biome[] biomesForGeneration;
    private final MapGenBase caveGenerator = new MapGenCavelandCaves();
    private final MapGenBase ravineGenerator = new MapGenCavelandRavine();
    private final VeinGenerator veinGenerator;
    private final WorldGenerator lakeWaterGen = new WorldGenLakes((Block)Blocks.field_150355_j);
    private final WorldGenerator lakeLavaGen = new WorldGenLakes((Block)Blocks.field_150353_l);
    private final WorldGenerator mushroomBrownGen = new WorldGenCaveBush(Blocks.field_150338_P);
    private final WorldGenerator mushroomRedGen = new WorldGenCaveBush(Blocks.field_150337_Q);
    private final WorldGenerator liquidWaterGen = new WorldGenLiquids((Block)Blocks.field_150358_i);
    private final WorldGenerator liquidLavaGen = new WorldGenLiquids((Block)Blocks.field_150356_k);
    private final WorldGenerator deadBushGen = new WorldGenDeadBush();
    private final WorldGenerator acresiaGen = new WorldGenAcresia();
    private final WorldGenerator ruinedHouseGen = new WorldGenRuinedHouse();

    public ChunkGeneratorCaveland(World world) {
        this.world = world;
        this.rand = new Random(world.func_72905_C());
        this.veinGenerator = new VeinGenerator(new CaveVeinProvider(world, () -> CavelandConfig.autoVeins ? null : CavelandConfig.VEINS));
    }

    public void setBlocksInChunk(ChunkPrimer primer) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 255; y >= 0; --y) {
                    primer.func_177855_a(x, y, z, DIRT);
                }
            }
        }
    }

    public void replaceBiomeBlocks(int chunkX, int chunkZ, ChunkPrimer primer) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)chunkX, (int)chunkZ, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        int worldHeight = this.world.field_73011_w.getActualHeight();
        int blockHeight = worldHeight - 1;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                Biome biome = this.biomesForGeneration[x * 16 + z];
                IBlockState top = biome.field_76752_A;
                IBlockState filter = biome.field_76753_B;
                if (biome.func_150559_j()) {
                    top = Blocks.field_150403_cj.func_176223_P();
                    filter = Blocks.field_150403_cj.func_176223_P();
                }
                if (filter.func_177230_c() == Blocks.field_150354_m) {
                    filter = SANDSTONE;
                }
                primer.func_177855_a(x, 0, z, BEDROCK);
                primer.func_177855_a(x, blockHeight, z, BEDROCK);
                primer.func_177855_a(x, 1, z, primer.func_177856_a(x, 2, z));
                for (y = 1; y <= blockHeight - 1; ++y) {
                    if (primer.func_177856_a(x, y, z).func_177230_c() == Blocks.field_150349_c || primer.func_177856_a(x, y, z).func_185904_a().func_76220_a() && primer.func_177856_a(x, y + 1, z).func_177230_c() == Blocks.field_150350_a) {
                        primer.func_177855_a(x, y, z, top);
                        continue;
                    }
                    if (primer.func_177856_a(x, y, z).func_177230_c() != Blocks.field_150346_d) continue;
                    primer.func_177855_a(x, y, z, filter);
                }
                if (blockHeight >= 255) continue;
                for (y = blockHeight + 1; y < 256; ++y) {
                    primer.func_177855_a(x, y, z, AIR);
                }
            }
        }
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 16, chunkZ * 16, 16, 16);
        ChunkPrimer primer = new ChunkPrimer();
        this.setBlocksInChunk(primer);
        this.caveGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        if (CavelandConfig.generateRiver) {
            this.ravineGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        }
        this.replaceBiomeBlocks(chunkX, chunkZ, primer);
        this.veinGenerator.generate(this.world, this.rand, this.biomesForGeneration, primer);
        Chunk chunk = new Chunk(this.world, primer, chunkX, chunkZ);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        int i;
        int z;
        int y;
        int x;
        BlockFalling.field_149832_M = true;
        int worldX = chunkX << 4;
        int worldZ = chunkZ << 4;
        BlockPos blockPos = new BlockPos(worldX, 0, worldZ);
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        Biome biome = this.world.func_180494_b(blockPos.func_177982_a(16, 0, 16));
        BiomeDecorator decorator = biome.field_76760_I;
        int worldHeight = this.world.field_73011_w.getActualHeight();
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false);
        if (CavelandConfig.generateLakes) {
            if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
                x = this.rand.nextInt(16) + 8;
                y = this.rand.nextInt(worldHeight - 16);
                z = this.rand.nextInt(16) + 8;
                this.lakeWaterGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(x, y, z));
            }
            if (this.rand.nextInt(30) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA)) {
                x = this.rand.nextInt(16) + 8;
                y = this.rand.nextInt(worldHeight / 2);
                z = this.rand.nextInt(16) + 8;
                this.lakeLavaGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(x, y, z));
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.world, this.rand, chunkPos));
        if (this.rand.nextInt(30) == 0 && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            x = this.rand.nextInt(16) + 8;
            y = this.rand.nextInt(worldHeight / 2);
            z = this.rand.nextInt(16) + 8;
            this.ruinedHouseGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(x, y, z));
        }
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(this.world, this.rand, blockPos));
        for (i = 0; i < 10; ++i) {
            x = this.rand.nextInt(16) + 8;
            y = this.rand.nextInt(worldHeight - 10);
            z = this.rand.nextInt(16) + 8;
            this.acresiaGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(x, y, z));
        }
        for (i = 0; i < 15; ++i) {
            x = this.rand.nextInt(16) + 8;
            y = this.rand.nextInt(worldHeight / 2 - 10) + worldHeight / 2;
            z = this.rand.nextInt(16) + 8;
            this.acresiaGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(x, y, z));
        }
        if (TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM)) {
            this.mushroomBrownGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(16, 0, 16));
            this.mushroomRedGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(16, 0, 16));
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
            if (TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CACTUS)) {
                for (i = 0; i < 80; ++i) {
                    x = this.rand.nextInt(16) + 8;
                    y = this.rand.nextInt(worldHeight - 5);
                    z = this.rand.nextInt(16) + 8;
                    decorator.field_76824_w.func_180709_b(this.world, this.rand, blockPos.func_177982_a(x, y, z));
                }
            }
            if (TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.DEAD_BUSH)) {
                for (i = 0; i < 10; ++i) {
                    x = this.rand.nextInt(16) + 8;
                    y = this.rand.nextInt(worldHeight - 5);
                    z = this.rand.nextInt(16) + 8;
                    this.deadBushGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(x, y, z));
                }
            }
        } else {
            if (TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
                for (i = 0; i < 8; ++i) {
                    x = this.rand.nextInt(16) + 8;
                    y = this.rand.nextInt(worldHeight - 5);
                    z = this.rand.nextInt(16) + 8;
                    decorator.field_150514_p.func_180709_b(this.world, this.rand, blockPos.func_177982_a(x, y, z));
                }
            }
            for (i = 0; i < 18; ++i) {
                x = this.rand.nextInt(16) + 8;
                y = this.rand.nextInt(worldHeight - 5);
                z = this.rand.nextInt(16) + 8;
                biome.func_76730_b(this.rand).func_180709_b(this.world, this.rand, blockPos.func_177982_a(x, y, z));
            }
            if (TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) {
                Object treeGen = null;
                if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                    treeGen = new WorldGenTreesPerverted(false, 4 + this.rand.nextInt(7), BlockPlanks.EnumType.JUNGLE, true);
                } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || this.rand.nextInt(10) == 0) {
                    treeGen = BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) ? new WorldGenSpruceTreePerverted(false) : (this.rand.nextInt(3) == 0 ? new WorldGenBirchTreePerverted(false, false) : new WorldGenTreesPerverted(false, 3, BlockPlanks.EnumType.OAK, true));
                }
                if (treeGen != null) {
                    BlockPos pos;
                    int i2;
                    for (i2 = 0; i2 < 80; ++i2) {
                        x = this.rand.nextInt(16) + 8;
                        pos = blockPos.func_177982_a(x, y = this.rand.nextInt(worldHeight), z = this.rand.nextInt(16) + 8);
                        if (!treeGen.func_180709_b(this.world, this.rand, pos)) continue;
                        treeGen.func_180711_a(this.world, this.rand, pos);
                    }
                    for (i2 = 0; i2 < 60; ++i2) {
                        x = this.rand.nextInt(16) + 8;
                        pos = blockPos.func_177982_a(x, y = 8 + this.rand.nextInt(5), z = this.rand.nextInt(16) + 8);
                        if (!treeGen.func_180709_b(this.world, this.rand, pos)) continue;
                        treeGen.func_180711_a(this.world, this.rand, pos);
                    }
                }
            }
            if (decorator.field_76808_K) {
                if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
                    if (TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER)) {
                        for (int i3 = 0; i3 < 150; ++i3) {
                            x = this.rand.nextInt(16) + 8;
                            y = this.rand.nextInt(this.rand.nextInt(worldHeight - 16) + 10);
                            z = this.rand.nextInt(16) + 8;
                            this.liquidWaterGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(x, y, z));
                        }
                    }
                } else {
                    if (TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER)) {
                        for (int i4 = 0; i4 < 100; ++i4) {
                            x = this.rand.nextInt(16) + 8;
                            y = this.rand.nextInt(this.rand.nextInt(worldHeight - 16) + 10);
                            z = this.rand.nextInt(16) + 8;
                            this.liquidWaterGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(x, y, z));
                        }
                    }
                    if (TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA)) {
                        for (int i5 = 0; i5 < 20; ++i5) {
                            x = this.rand.nextInt(16) + 8;
                            y = this.rand.nextInt(worldHeight / 2);
                            z = this.rand.nextInt(16) + 8;
                            this.liquidLavaGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(x, y, z));
                        }
                    }
                }
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.world, this.rand, chunkPos));
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunk, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return Collections.emptyList();
    }

    public boolean func_193414_a(World world, String structureName, BlockPos pos) {
        return false;
    }

    public BlockPos func_180513_a(World world, String structureName, BlockPos pos, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
    }
}

