/*
 * Decompiled with CFR 0.152.
 */
package cavern.world.gen;

import cavern.block.CaveBlocks;
import java.util.Random;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraftforge.common.IPlantable;

public class WorldGenTreesPerverted
extends WorldGenTrees {
    private final int minTreeHeight;
    private final boolean vinesGrow;
    private final IBlockState stateWood;
    private final IBlockState stateLeaves;

    public WorldGenTreesPerverted(boolean flag, int min, IBlockState wood, IBlockState leaves, boolean grow) {
        super(flag);
        this.minTreeHeight = min;
        this.stateWood = wood;
        this.stateLeaves = leaves;
        this.vinesGrow = grow;
    }

    public WorldGenTreesPerverted(boolean flag, int min, BlockPlanks.EnumType type, boolean grow) {
        this(flag, min, CaveBlocks.PERVERTED_LOG.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)type), CaveBlocks.PERVERTED_LEAVES.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)type).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), grow);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int treeHeight = rand.nextInt(3) + this.minTreeHeight;
        boolean flag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + treeHeight + 1 <= world.func_72800_K()) {
            for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + 1 + treeHeight; ++y) {
                int range = 1;
                if (y == pos.func_177956_o()) {
                    range = 0;
                }
                if (y >= pos.func_177956_o() + 1 + treeHeight - 2) {
                    range = 2;
                }
                BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos();
                for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range && flag; ++x) {
                    for (int z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range && flag; ++z) {
                        if (y >= 0 && y < world.func_72800_K()) {
                            if (this.isReplaceable(world, (BlockPos)blockpos.func_181079_c(x, y, z))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            IBlockState state = world.func_180495_p(pos.func_177977_b());
            if (state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)CaveBlocks.PERVERTED_SAPLING) && pos.func_177956_o() < world.func_72800_K() - treeHeight - 1) {
                int z;
                int range;
                int y;
                this.func_175921_a(world, pos.func_177977_b());
                int i = 3;
                int j = 0;
                for (y = pos.func_177956_o() - i + treeHeight; y <= pos.func_177956_o() + treeHeight; ++y) {
                    int k = y - (pos.func_177956_o() + treeHeight);
                    range = j + 1 - k / 2;
                    for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range; ++x) {
                        int px = x - pos.func_177958_n();
                        for (z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range; ++z) {
                            BlockPos blockpos;
                            int pz = z - pos.func_177952_p();
                            if (Math.abs(px) == range && Math.abs(pz) == range && (rand.nextInt(2) == 0 || k == 0) || !(state = world.func_180495_p(blockpos = new BlockPos(x, y, z))).func_177230_c().isAir(state, (IBlockAccess)world, blockpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, blockpos) && state.func_185904_a() != Material.field_151582_l) continue;
                            this.func_175903_a(world, blockpos, this.stateLeaves);
                        }
                    }
                }
                for (y = 0; y < treeHeight; ++y) {
                    BlockPos up = pos.func_177981_b(y);
                    state = world.func_180495_p(up);
                    if (!state.func_177230_c().isAir(state, (IBlockAccess)world, up) && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, up) && state.func_185904_a() != Material.field_151582_l) continue;
                    this.func_175903_a(world, pos.func_177981_b(y), this.stateWood);
                    if (!this.vinesGrow || y <= 0) continue;
                    if (rand.nextInt(3) > 0 && world.func_175623_d(pos.func_177982_a(-1, y, 0))) {
                        this.setVine(world, pos.func_177982_a(-1, y, 0), BlockVine.field_176278_M);
                    }
                    if (rand.nextInt(3) > 0 && world.func_175623_d(pos.func_177982_a(1, y, 0))) {
                        this.setVine(world, pos.func_177982_a(1, y, 0), BlockVine.field_176280_O);
                    }
                    if (rand.nextInt(3) > 0 && world.func_175623_d(pos.func_177982_a(0, y, -1))) {
                        this.setVine(world, pos.func_177982_a(0, y, -1), BlockVine.field_176279_N);
                    }
                    if (rand.nextInt(3) <= 0 || !world.func_175623_d(pos.func_177982_a(0, y, 1))) continue;
                    this.setVine(world, pos.func_177982_a(0, y, 1), BlockVine.field_176273_b);
                }
                if (this.vinesGrow) {
                    for (y = pos.func_177956_o() - 3 + treeHeight; y <= pos.func_177956_o() + treeHeight; ++y) {
                        int k = y - (pos.func_177956_o() + treeHeight);
                        range = 2 - k / 2;
                        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos();
                        for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range; ++x) {
                            for (z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range; ++z) {
                                blockpos.func_181079_c(x, y, z);
                                state = world.func_180495_p((BlockPos)blockpos);
                                if (!state.func_177230_c().isLeaves(state, (IBlockAccess)world, (BlockPos)blockpos)) continue;
                                BlockPos west = blockpos.func_177976_e();
                                BlockPos east = blockpos.func_177974_f();
                                BlockPos north = blockpos.func_177978_c();
                                BlockPos south = blockpos.func_177968_d();
                                if (rand.nextInt(4) == 0 && world.func_175623_d(west)) {
                                    this.setVines(world, west, BlockVine.field_176278_M);
                                }
                                if (rand.nextInt(4) == 0 && world.func_175623_d(east)) {
                                    this.setVines(world, east, BlockVine.field_176280_O);
                                }
                                if (rand.nextInt(4) == 0 && world.func_175623_d(north)) {
                                    this.setVines(world, north, BlockVine.field_176279_N);
                                }
                                if (rand.nextInt(4) != 0 || !world.func_175623_d(south)) continue;
                                this.setVines(world, south, BlockVine.field_176273_b);
                            }
                        }
                    }
                    if (rand.nextInt(5) == 0 && treeHeight > 5) {
                        for (int k = 0; k < 2; ++k) {
                            for (EnumFacing face : EnumFacing.Plane.HORIZONTAL) {
                                if (rand.nextInt(4 - k) != 0) continue;
                                EnumFacing side = face.func_176734_d();
                                this.setCocoa(world, rand.nextInt(3), pos.func_177982_a(side.func_82601_c(), treeHeight - 5 + k, side.func_82599_e()), face);
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void setCocoa(World world, int age, BlockPos pos, EnumFacing side) {
        this.func_175903_a(world, pos, Blocks.field_150375_by.func_176223_P().func_177226_a((IProperty)BlockCocoa.field_176501_a, (Comparable)Integer.valueOf(age)).func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)side));
    }

    private void setVine(World world, BlockPos pos, PropertyBool prop) {
        this.func_175903_a(world, pos, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)prop, (Comparable)Boolean.valueOf(true)));
    }

    private void setVines(World world, BlockPos pos, PropertyBool prop) {
        this.setVine(world, pos, prop);
        pos = pos.func_177977_b();
        for (int i = 4; world.func_175623_d(pos) && i > 0; --i) {
            this.setVine(world, pos, prop);
            pos = pos.func_177977_b();
        }
    }
}

