/*
 * Decompiled with CFR 0.152.
 */
package cavern.world.gen;

import cavern.util.CaveLog;
import cavern.util.CaveUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.loot.LootTableList;

public class WorldGenTowerDungeons
extends WorldGenerator {
    private static final ResourceLocation CHESTS_TOWER_DUNGEON = LootTableList.func_186375_a((ResourceLocation)CaveUtils.getKey("chests/tower_dungeon"));
    private int maxFloor;
    private int roomSize;
    private int roomHeight;
    private final Collection<ResourceLocation> spawnerMobs;

    public WorldGenTowerDungeons(Collection<ResourceLocation> mobs) {
        this.spawnerMobs = mobs;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        this.setRandomStructures(world, rand, pos);
        while (pos.func_177956_o() > 1 && world.func_175623_d(pos)) {
            pos = pos.func_177977_b();
        }
        this.generateAirs(world, rand, pos);
        this.generateWalls(world, rand, pos);
        this.generateFloors(world, rand, pos);
        this.generatePillars(world, rand, pos);
        this.generateCeiling(world, rand, pos);
        this.generateLadders(world, rand, pos);
        this.generateChests(world, rand, pos);
        this.generateSpawners(world, rand, pos);
        return true;
    }

    protected void setRandomStructures(World world, Random rand, BlockPos pos) {
        this.maxFloor = rand.nextInt(4) + 5;
        this.roomSize = rand.nextInt(4) + 4;
        this.roomHeight = rand.nextInt(4) + 5;
    }

    protected void generateAirs(World world, Random rand, BlockPos pos) {
        int y = this.roomHeight * this.maxFloor;
        int ceilSize = this.roomSize - 1;
        BlockPos from = pos.func_177982_a(ceilSize, 0, ceilSize);
        BlockPos to = pos.func_177982_a(-ceilSize, y, -ceilSize);
        BlockPos.func_177975_b((BlockPos)from, (BlockPos)to).forEach(blockPos -> world.func_180501_a((BlockPos)blockPos, Blocks.field_150350_a.func_176223_P(), 2));
    }

    protected void generateWalls(World world, Random rand, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos center = pos.func_177967_a(facing, this.roomSize);
            BlockPos from = center.func_177967_a(facing.func_176746_e(), this.roomSize);
            BlockPos to = center.func_177967_a(facing.func_176735_f(), this.roomSize).func_177981_b(this.roomHeight * this.maxFloor);
            BlockPos.func_177975_b((BlockPos)from, (BlockPos)to).forEach(blockPos -> world.func_180501_a((BlockPos)blockPos, this.getWallBlock(world, rand, (BlockPos)blockPos), 2));
        }
    }

    protected IBlockState getWallBlock(World world, Random rand, BlockPos pos) {
        IBlockState state = Blocks.field_150417_aV.func_176223_P();
        if (rand.nextDouble() < 0.7) {
            return state.func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.MOSSY);
        }
        return state;
    }

    protected void generateFloors(World world, Random rand, BlockPos pos) {
        int floorSize = this.roomSize - 2;
        for (int i = 0; i < this.maxFloor; ++i) {
            int y = this.roomHeight * i;
            BlockPos from = pos.func_177982_a(floorSize, y, floorSize);
            BlockPos to = pos.func_177982_a(-floorSize, y, -floorSize);
            for (BlockPos blockPos2 : BlockPos.func_177975_b((BlockPos)from, (BlockPos)to)) {
                world.func_180501_a(blockPos2, this.getFloorBlock(world, rand, i + 1, blockPos2), 2);
            }
        }
        int ceilSize = this.roomSize - 1;
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos center = pos.func_177967_a(facing, ceilSize);
            BlockPos from = center.func_177967_a(facing.func_176746_e(), ceilSize);
            BlockPos to = center.func_177967_a(facing.func_176735_f(), ceilSize);
            BlockPos.func_177975_b((BlockPos)from, (BlockPos)to).forEach(blockPos -> world.func_180501_a((BlockPos)blockPos, this.getFirstFloorLiquid(world, rand, (BlockPos)blockPos), 2));
            world.func_180501_a(center, this.getFootholdBlock(world, rand, center), 2);
        }
    }

    protected IBlockState getFloorBlock(World world, Random rand, int floor, BlockPos pos) {
        if (floor <= 1) {
            return this.getWallBlock(world, rand, pos);
        }
        IBlockState state = Blocks.field_150417_aV.func_176223_P();
        if (rand.nextDouble() < 0.7) {
            return state.func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED);
        }
        return state;
    }

    protected IBlockState getFirstFloorLiquid(World world, Random rand, BlockPos pos) {
        return Blocks.field_150353_l.func_176223_P();
    }

    protected IBlockState getFootholdBlock(World world, Random rand, BlockPos pos) {
        return Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED);
    }

    protected void generatePillars(World world, Random rand, BlockPos pos) {
        int floorSize = this.roomSize - 2;
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos center = pos.func_177967_a(facing, floorSize);
            BlockPos from = center.func_177967_a(facing.func_176746_e(), floorSize);
            BlockPos to = from.func_177981_b(this.roomHeight * this.maxFloor - 1);
            BlockPos.func_177975_b((BlockPos)from, (BlockPos)to).forEach(blockPos -> world.func_180501_a((BlockPos)blockPos, this.getPillarBlock(world, rand, (BlockPos)blockPos), 2));
        }
    }

    protected IBlockState getPillarBlock(World world, Random rand, BlockPos pos) {
        return Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED);
    }

    protected void generateCeiling(World world, Random rand, BlockPos pos) {
        int y = this.roomHeight * this.maxFloor;
        int ceilSize = this.roomSize - 1;
        BlockPos from = pos.func_177982_a(ceilSize, y, ceilSize);
        BlockPos to = pos.func_177982_a(-ceilSize, y, -ceilSize);
        BlockPos.func_177975_b((BlockPos)from, (BlockPos)to).forEach(blockPos -> world.func_180501_a((BlockPos)blockPos, this.getCeilingBlock(world, rand, (BlockPos)blockPos), 2));
    }

    protected IBlockState getCeilingBlock(World world, Random rand, BlockPos pos) {
        return Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED);
    }

    protected void generateLadders(World world, Random rand, BlockPos pos) {
        int ceilSize = this.roomSize - 1;
        int ladderHeight = this.roomHeight * (this.maxFloor - 1);
        int wallHeight = this.roomHeight * this.maxFloor - 1;
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos center = pos.func_177967_a(facing, ceilSize);
            BlockPos from = center.func_177984_a();
            BlockPos to = center.func_177981_b(ladderHeight);
            BlockPos.func_177975_b((BlockPos)from, (BlockPos)to).forEach(blockPos -> world.func_180501_a((BlockPos)blockPos, Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)facing.func_176734_d()), 2));
            from = center.func_177972_a(facing.func_176746_e());
            to = from.func_177981_b(wallHeight);
            BlockPos.func_177975_b((BlockPos)from, (BlockPos)to).forEach(blockPos -> world.func_180501_a((BlockPos)blockPos, this.getLadderCoverBlock(world, rand, (BlockPos)blockPos), 2));
            from = center.func_177972_a(facing.func_176735_f());
            to = from.func_177981_b(wallHeight);
            BlockPos.func_177975_b((BlockPos)from, (BlockPos)to).forEach(blockPos -> world.func_180501_a((BlockPos)blockPos, this.getLadderCoverBlock(world, rand, (BlockPos)blockPos), 2));
        }
    }

    protected IBlockState getLadderCoverBlock(World world, Random rand, BlockPos pos) {
        return Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED);
    }

    protected void generateChests(World world, Random rand, BlockPos pos) {
        int floorSize = this.roomSize - 2;
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos center = pos.func_177967_a(facing, floorSize);
            BlockPos chestPos = center.func_177967_a(facing.func_176735_f(), floorSize - 2);
            for (int i = 1; i < this.maxFloor; ++i) {
                if (rand.nextDouble() > 0.7) continue;
                int y = this.roomHeight * i + 1;
                BlockPos blockPos = chestPos.func_177981_b(y);
                world.func_180501_a(blockPos, Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)facing.func_176734_d()), 2);
                TileEntity tile = world.func_175625_s(blockPos);
                if (tile == null || !(tile instanceof TileEntityChest)) continue;
                ((TileEntityChest)tile).func_189404_a(CHESTS_TOWER_DUNGEON, rand.nextLong());
            }
        }
    }

    protected void generateSpawners(World world, Random rand, BlockPos pos) {
        for (int i = 0; i < this.maxFloor; ++i) {
            int y = this.roomHeight * i + 1;
            BlockPos blockPos = pos.func_177981_b(y);
            world.func_180501_a(blockPos, Blocks.field_150474_ac.func_176223_P(), 2);
            TileEntity tile = world.func_175625_s(blockPos);
            if (tile != null && tile instanceof TileEntityMobSpawner) {
                ((TileEntityMobSpawner)tile).func_145881_a().func_190894_a(this.pickMobSpawner(rand, i + 1));
                continue;
            }
            CaveLog.warning("Failed to fetch mob spawner entity at (" + blockPos.func_177958_n() + ", " + blockPos.func_177956_o() + ", " + blockPos.func_177952_p() + ")", new Object[0]);
        }
    }

    @Nullable
    public ResourceLocation pickMobSpawner(Random rand, int floor) {
        if (!this.spawnerMobs.isEmpty()) {
            return (ResourceLocation)CaveUtils.getRandomObject(Lists.newArrayList(this.spawnerMobs));
        }
        return null;
    }
}

