/*
 * Decompiled with CFR 0.152.
 */
package cavern.world.gen;

import cavern.util.CaveLog;
import cavern.util.CaveUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.storage.loot.LootTableList;

public class WorldGenCaveDungeons
extends WorldGenDungeons {
    private final Collection<ResourceLocation> spawnerMobs;

    public WorldGenCaveDungeons(Collection<ResourceLocation> mobs) {
        this.spawnerMobs = mobs;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int i1 = rand.nextInt(2) + 2;
        int j1 = -i1 - 1;
        int k1 = i1 + 1;
        int i2 = rand.nextInt(2) + 2;
        int j2 = -i2 - 1;
        int k2 = i2 + 1;
        int count = 0;
        for (int x = j1; x <= k1; ++x) {
            for (int y = -1; y <= 4; ++y) {
                for (int z = j2; z <= k2; ++z) {
                    BlockPos blockpos = pos.func_177982_a(x, y, z);
                    Material material = world.func_180495_p(blockpos).func_185904_a();
                    boolean flag = material.func_76220_a();
                    if (y == -1 && !flag) {
                        return false;
                    }
                    if (y == 4 && !flag) {
                        return false;
                    }
                    if (x != j1 && x != k1 && z != j2 && z != k2 || y != 0 || !world.func_175623_d(blockpos) || !world.func_175623_d(blockpos.func_177984_a())) continue;
                    ++count;
                }
            }
        }
        if (count >= 1 && count <= 5) {
            int type = rand.nextInt(2);
            switch (type) {
                case 1: {
                    IBlockState state1 = Blocks.field_150417_aV.func_176223_P();
                    IBlockState z = Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.MOSSY);
                }
            }
            IBlockState state1 = Blocks.field_150347_e.func_176223_P();
            IBlockState state2 = Blocks.field_150341_Y.func_176223_P();
            for (int x = j1; x <= k1; ++x) {
                for (int y = 3; y >= -1; --y) {
                    for (int z = j2; z <= k2; ++z) {
                        BlockPos blockpos = pos.func_177982_a(x, y, z);
                        if (x != j1 && y != -1 && z != j2 && x != k1 && y != 4 && z != k2) {
                            if (world.func_180495_p(blockpos).func_177230_c() == Blocks.field_150486_ae) continue;
                            world.func_175698_g(blockpos);
                            continue;
                        }
                        if (blockpos.func_177956_o() >= 0 && !world.func_180495_p(blockpos.func_177977_b()).func_185904_a().func_76220_a()) {
                            world.func_175698_g(blockpos);
                            continue;
                        }
                        if (!world.func_180495_p(blockpos).func_185904_a().func_76220_a() || world.func_180495_p(blockpos).func_177230_c() == Blocks.field_150486_ae) continue;
                        if (y == -1 && rand.nextInt(4) != 0) {
                            world.func_180501_a(blockpos, state2, 2);
                            continue;
                        }
                        world.func_180501_a(blockpos, state1, 2);
                    }
                }
            }
            block9: for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int z;
                    int y;
                    int x = pos.func_177958_n() + rand.nextInt(i1 * 2 + 1) - i1;
                    BlockPos blockpos = new BlockPos(x, y = pos.func_177956_o(), z = pos.func_177952_p() + rand.nextInt(i2 * 2 + 1) - i2);
                    if (!world.func_175623_d(blockpos)) continue;
                    count = 0;
                    for (EnumFacing face : EnumFacing.Plane.HORIZONTAL) {
                        if (!world.func_180495_p(blockpos.func_177972_a(face)).func_185904_a().func_76220_a()) continue;
                        ++count;
                    }
                    if (count != 1) continue;
                    world.func_180501_a(blockpos, Blocks.field_150486_ae.func_176458_f(world, blockpos, Blocks.field_150486_ae.func_176223_P()), 2);
                    TileEntity tile = world.func_175625_s(blockpos);
                    if (tile == null || !(tile instanceof TileEntityChest)) continue block9;
                    ((TileEntityChest)tile).func_189404_a(LootTableList.field_186422_d, rand.nextLong());
                    continue block9;
                }
            }
            world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null && tile instanceof TileEntityMobSpawner) {
                ((TileEntityMobSpawner)tile).func_145881_a().func_190894_a(this.func_76543_b(rand));
            } else {
                CaveLog.warning("Failed to fetch mob spawner entity at (" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + ")", new Object[0]);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public ResourceLocation func_76543_b(Random random) {
        if (!this.spawnerMobs.isEmpty()) {
            return (ResourceLocation)CaveUtils.getRandomObject(Lists.newArrayList(this.spawnerMobs));
        }
        return null;
    }
}

