/*
 * Decompiled with CFR 0.152.
 */
package cavern.world.gen;

import cavern.block.CaveBlocks;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraftforge.common.IPlantable;

public class WorldGenBirchTreePerverted
extends WorldGenBirchTree {
    private boolean useExtraRandomHeight;

    public WorldGenBirchTreePerverted(boolean notify, boolean useExtraRandomHeightIn) {
        super(notify, useExtraRandomHeightIn);
        this.useExtraRandomHeight = useExtraRandomHeightIn;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int treeHeight = rand.nextInt(3) + 4;
        if (this.useExtraRandomHeight) {
            treeHeight += rand.nextInt(6);
        }
        boolean flag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + treeHeight + 1 <= 256) {
            for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + 1 + treeHeight; ++y) {
                int range = 1;
                if (y == pos.func_177956_o()) {
                    range = 0;
                }
                if (y >= pos.func_177956_o() + 1 + treeHeight - 2) {
                    range = 2;
                }
                BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos();
                for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range && flag; ++x) {
                    for (int z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range && flag; ++z) {
                        if (y >= 0 && y < world.func_72800_K()) {
                            if (this.isReplaceable(world, (BlockPos)blockpos.func_181079_c(x, y, z))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            IBlockState wood = CaveBlocks.PERVERTED_LOG.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.BIRCH);
            IBlockState leaves = CaveBlocks.PERVERTED_LEAVES.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.BIRCH).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
            BlockPos down = pos.func_177977_b();
            IBlockState state = world.func_180495_p(down);
            boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, down, EnumFacing.UP, (IPlantable)CaveBlocks.PERVERTED_SAPLING);
            if (isSoil && pos.func_177956_o() < world.func_72800_K() - treeHeight - 1) {
                state.func_177230_c().onPlantGrow(state, world, down, pos);
                for (int y = pos.func_177956_o() - 3 + treeHeight; y <= pos.func_177956_o() + treeHeight; ++y) {
                    int i = y - (pos.func_177956_o() + treeHeight);
                    int range = 1 - i / 2;
                    for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range; ++x) {
                        int j = x - pos.func_177958_n();
                        for (int z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range; ++z) {
                            BlockPos blockpos;
                            IBlockState state2;
                            int k = z - pos.func_177952_p();
                            if (Math.abs(j) == range && Math.abs(k) == range && (rand.nextInt(2) == 0 || i == 0) || !(state2 = world.func_180495_p(blockpos = new BlockPos(x, y, z))).func_177230_c().isAir(state2, (IBlockAccess)world, blockpos) && !state2.func_177230_c().isAir(state2, (IBlockAccess)world, blockpos)) continue;
                            this.func_175903_a(world, blockpos, leaves);
                        }
                    }
                }
                for (int height = 0; height < treeHeight; ++height) {
                    BlockPos up = pos.func_177981_b(height);
                    IBlockState state2 = world.func_180495_p(up);
                    if (!state2.func_177230_c().isAir(state2, (IBlockAccess)world, up) && !state2.func_177230_c().isLeaves(state2, (IBlockAccess)world, up)) continue;
                    this.func_175903_a(world, pos.func_177981_b(height), wood);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

