/*
 * Decompiled with CFR 0.152.
 */
package cavern.world.gen;

import cavern.entity.boss.EntitySkySeeker;
import cavern.entity.monster.EntityCrystalTurret;
import cavern.util.CaveUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponentTemplate;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class SkyWatchTowerPiece {
    private static final ResourceLocation LOOT_CHEST = LootTableList.func_186375_a((ResourceLocation)CaveUtils.getKey("chests/sky_watchtower"));

    public static void registerSkyCastlePiece() {
        MapGenStructureIO.func_143031_a(SkyCastleTemplate.class, (String)"SCT");
    }

    public static void generateCore(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<SkyCastleTemplate> list, Random random) {
        SkyWatchTowerPiece.generateMain(templateManager, pos, rotation, list, random);
        SkyWatchTowerPiece.generateWatchTower(templateManager, pos, rotation, list, random);
    }

    private static void generateWatchTower(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<SkyCastleTemplate> list, Random random) {
        BlockPos blockpos2 = pos.func_177967_a(rotation.func_185831_a(EnumFacing.WEST), 32);
        SkyWatchTowerPiece.addSubCastle(templateManager, list, blockpos2, rotation, EnumFacing.WEST, random);
        blockpos2 = pos.func_177967_a(rotation.func_185831_a(EnumFacing.EAST), 32);
        SkyWatchTowerPiece.addSubCastle(templateManager, list, blockpos2, rotation, EnumFacing.EAST, random);
        blockpos2 = pos.func_177967_a(rotation.func_185831_a(EnumFacing.NORTH), 32);
        SkyWatchTowerPiece.addSubCastle(templateManager, list, blockpos2, rotation, EnumFacing.NORTH, random);
        blockpos2 = pos.func_177967_a(rotation.func_185831_a(EnumFacing.SOUTH), 32);
        SkyWatchTowerPiece.addSubCastle(templateManager, list, blockpos2, rotation, EnumFacing.SOUTH, random);
    }

    private static void generateMain(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<SkyCastleTemplate> list, Random random) {
        BlockPos pos1 = new BlockPos((Vec3i)pos.func_177981_b(15));
        list.add(new SkyCastleTemplate(templateManager, pos, rotation, "sky_watchtower_main"));
        list.add(new SkyCastleTemplate(templateManager, pos1, rotation, "sky_watchtower_main2"));
    }

    private static void addSubCastle(TemplateManager templateManager, List<SkyCastleTemplate> list, BlockPos pos, Rotation rotationIn, EnumFacing facing, Random random) {
        Rotation rotation = Rotation.NONE;
        String s = SkyWatchTowerPiece.get1x1(random);
        if (facing != EnumFacing.EAST) {
            if (facing == EnumFacing.NORTH) {
                rotation = rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90);
            } else if (facing == EnumFacing.WEST) {
                rotation = rotation.func_185830_a(Rotation.CLOCKWISE_180);
            } else if (facing == EnumFacing.SOUTH) {
                rotation = rotation.func_185830_a(Rotation.CLOCKWISE_90);
            }
        }
        BlockPos blockpos = Template.func_191157_a((BlockPos)new BlockPos(1, 0, 0), (Mirror)Mirror.NONE, (Rotation)rotation, (int)19, (int)19);
        rotation = rotation.func_185830_a(rotationIn);
        blockpos = blockpos.func_190942_a(rotationIn);
        BlockPos blockpos1 = pos.func_177982_a(blockpos.func_177958_n(), 0, blockpos.func_177952_p());
        list.add(new SkyCastleTemplate(templateManager, blockpos1, rotation, s));
    }

    private static String get1x1(Random random) {
        return "sky_watchtower_sub_1x1_" + (random.nextInt(1) + 1);
    }

    public static class SkyCastleTemplate
    extends StructureComponentTemplate {
        private Rotation rotation;
        private Mirror mirror;
        private String templateName;
        private boolean isAleadyBossRoomGen;

        public SkyCastleTemplate() {
        }

        public SkyCastleTemplate(TemplateManager manager, BlockPos pos, Rotation rotation, String templateName) {
            this(manager, pos, rotation, Mirror.NONE, templateName);
        }

        private SkyCastleTemplate(TemplateManager manager, BlockPos pos, Rotation rotation, Mirror mirror, String templateName) {
            super(0);
            this.field_186178_c = pos;
            this.rotation = rotation;
            this.mirror = mirror;
            this.templateName = templateName;
            this.loadTemplate(manager);
        }

        private void loadTemplate(TemplateManager manager) {
            Template template = manager.func_186237_a(null, CaveUtils.getKey("sky_watchtower/" + this.templateName));
            PlacementSettings placementsettings = new PlacementSettings().func_186222_a(true).func_186220_a(this.rotation).func_186214_a(this.mirror);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox box) {
            super.func_74875_a(world, random, box);
            return true;
        }

        protected void func_186175_a(String function, BlockPos pos, World world, Random rand, StructureBoundingBox box) {
            if (function.equals("CastleChest")) {
                TileEntity tileEntity;
                if (box.func_175898_b((Vec3i)pos) && (tileEntity = world.func_175625_s(pos.func_177977_b())) instanceof TileEntityChest) {
                    ((TileEntityChest)tileEntity).func_189404_a(LOOT_CHEST, rand.nextLong());
                }
            } else if (function.equals("Guard")) {
                EntityCrystalTurret entity = new EntityCrystalTurret(world);
                entity.func_110163_bv();
                entity.func_174828_a(pos, 0.0f, 0.0f);
                world.func_72838_d((Entity)entity);
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            } else if (function.equals("Rift")) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            } else if (function.equals("Boss")) {
                EntitySkySeeker entity = new EntitySkySeeker(world);
                entity.func_110163_bv();
                entity.func_174828_a(pos, 0.0f, 0.0f);
                entity.setSleep(true);
                world.func_72838_d((Entity)entity);
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
        }

        protected void func_143012_a(NBTTagCompound compound) {
            super.func_143012_a(compound);
            compound.func_74757_a("BossRoom", this.isAleadyBossRoomGen);
            compound.func_74778_a("Template", this.templateName);
            compound.func_74778_a("Rot", this.field_186177_b.func_186215_c().name());
            compound.func_74778_a("Mi", this.field_186177_b.func_186212_b().name());
        }

        protected void func_143011_b(NBTTagCompound compound, TemplateManager manager) {
            super.func_143011_b(compound, manager);
            this.isAleadyBossRoomGen = compound.func_74767_n("BossRoom");
            this.templateName = compound.func_74779_i("Template");
            this.rotation = Rotation.valueOf((String)compound.func_74779_i("Rot"));
            this.mirror = Mirror.valueOf((String)compound.func_74779_i("Mi"));
            this.loadTemplate(manager);
        }
    }
}

