/*
 * Decompiled with CFR 0.152.
 */
package cavern.world.gen;

import cavern.world.gen.SkyWatchTowerPiece;
import cavern.world.mirage.ChunkGeneratorSkyland;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenSkyWatchTower
extends MapGenStructure {
    private final ChunkGeneratorSkyland provider;
    private final int distance;

    public MapGenSkyWatchTower(ChunkGeneratorSkyland provider) {
        this.provider = provider;
        this.distance = 34;
    }

    public String func_143025_a() {
        return "SkyWatchTower";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.distance - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.distance - 1;
        }
        int k = chunkX / this.distance;
        int l = chunkZ / this.distance;
        Random random = this.field_75039_c.func_72843_D(k, l, 14267312);
        k *= this.distance;
        l *= this.distance;
        return i == (k += random.nextInt(this.distance - 8)) && j == (l += random.nextInt(this.distance - 8));
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        return MapGenSkyWatchTower.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)this.distance, (int)8, (int)14267312, (boolean)false, (int)100, (boolean)findUnexplored);
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.provider, this.field_75038_b, chunkX, chunkZ);
    }

    public static class Start
    extends StructureStart {
        private boolean isValid;

        public Start() {
        }

        public Start(World world, ChunkGeneratorSkyland provider, Random random, int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
            this.create(world, provider, random, chunkX, chunkZ);
        }

        private void create(World world, ChunkGeneratorSkyland provider, Random random, int chunkX, int chunkZ) {
            Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
            ChunkPrimer primer = new ChunkPrimer();
            provider.setBlocksInChunk(chunkX, chunkZ, primer);
            BlockPos blockpos = new BlockPos(chunkX * 16 + 8, 90, chunkZ * 16 + 8);
            LinkedList list = Lists.newLinkedList();
            SkyWatchTowerPiece.generateCore(world.func_72860_G().func_186340_h(), blockpos, rotation, list, random);
            this.field_75075_a.addAll(list);
            this.func_75072_c();
            this.isValid = true;
        }

        public boolean func_75069_d() {
            return this.isValid;
        }
    }
}

