/*
 * Decompiled with CFR 0.152.
 */
package cavern.world.gen;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenRavine;

public class MapGenCavernRavine
extends MapGenRavine {
    protected static final IBlockState FLOWING_WATER = Blocks.field_150358_i.func_176223_P();
    protected static final IBlockState BLK_AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState BLK_WATER = Blocks.field_150355_j.func_176223_P();
    protected static final IBlockState BLK_STONE = Blocks.field_150348_b.func_176223_P();
    protected static final IBlockState BLK_GRAVEL = Blocks.field_150351_n.func_176223_P();
    protected static final IBlockState BLK_ICE = Blocks.field_150432_aD.func_176223_P();
    private final float[] parabolicField = new float[1024];

    protected void func_180707_a(long ravineSeed, int chunkX, int chunkZ, ChunkPrimer primer, double blockX, double blockY, double blockZ, float scale, float leftRightRadian, float upDownRadian, int currentY, int targetY, double scaleHeight) {
        Random random = new Random(ravineSeed);
        int worldHeight = this.field_75039_c.func_72940_L();
        double centerX = chunkX * 16 + 8;
        double centerZ = chunkZ * 16 + 8;
        float leftRightChange = 0.0f;
        float upDownChange = 0.0f;
        if (targetY <= 0) {
            int blockRangeY = this.field_75040_a * 16 - 16;
            targetY = blockRangeY - random.nextInt(blockRangeY / 4);
        }
        boolean createFinalRoom = false;
        if (currentY == -1) {
            currentY = targetY / 2;
            createFinalRoom = true;
        }
        float nextInterHeight = 1.0f;
        for (int y = 0; y < worldHeight; ++y) {
            if (y == 0 || random.nextInt(3) == 0) {
                nextInterHeight = 1.0f + random.nextFloat() * random.nextFloat() * 1.0f;
            }
            this.parabolicField[y] = nextInterHeight * nextInterHeight;
        }
        while (currentY < targetY) {
            double roomWidth = 1.5 + (double)(MathHelper.func_76126_a((float)((float)currentY * (float)Math.PI / (float)targetY)) * scale * 1.0f);
            double roomHeight = roomWidth * scaleHeight;
            roomWidth *= (double)random.nextFloat() * 0.25 + 0.75;
            roomHeight *= (double)random.nextFloat() * 0.25 + 0.75;
            float moveHorizontal = MathHelper.func_76134_b((float)upDownRadian);
            float moveVertical = MathHelper.func_76126_a((float)upDownRadian);
            blockX += (double)(MathHelper.func_76134_b((float)leftRightRadian) * moveHorizontal);
            blockY += (double)moveVertical;
            blockZ += (double)(MathHelper.func_76126_a((float)leftRightRadian) * moveHorizontal);
            upDownRadian *= 0.7f;
            upDownRadian += upDownChange * 0.05f;
            leftRightRadian += leftRightChange * 0.05f;
            upDownChange *= 0.8f;
            leftRightChange *= 0.5f;
            upDownChange += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            leftRightChange += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (createFinalRoom || random.nextInt(4) != 0) {
                double distanceX = blockX - centerX;
                double distanceZ = blockZ - centerZ;
                double distanceY = targetY - currentY;
                double maxDistance = scale + 2.0f + 16.0f;
                if (distanceX * distanceX + distanceZ * distanceZ - distanceY * distanceY > maxDistance * maxDistance) {
                    return;
                }
                if (blockX >= centerX - 16.0 - roomWidth * 2.0 && blockZ >= centerZ - 16.0 - roomWidth * 2.0 && blockX <= centerX + 16.0 + roomWidth * 2.0 && blockZ <= centerZ + 16.0 + roomWidth * 2.0) {
                    int xLow = Math.max(MathHelper.func_76128_c((double)(blockX - roomWidth)) - chunkX * 16 - 1, 0);
                    int xHigh = Math.min(MathHelper.func_76128_c((double)(blockX + roomWidth)) - chunkX * 16 + 1, 16);
                    int yLow = Math.max(MathHelper.func_76128_c((double)(blockY - roomHeight)) - 1, 1);
                    int yHigh = Math.min(MathHelper.func_76128_c((double)(blockY + roomHeight)) + 1, worldHeight - 8);
                    int zLow = Math.max(MathHelper.func_76128_c((double)(blockZ - roomWidth)) - chunkZ * 16 - 1, 0);
                    int zHigh = Math.min(MathHelper.func_76128_c((double)(blockZ + roomWidth)) - chunkZ * 16 + 1, 16);
                    for (int x = xLow; x < xHigh; ++x) {
                        double xScale = ((double)(chunkX * 16 + x) + 0.5 - blockX) / roomWidth;
                        for (int z = zLow; z < zHigh; ++z) {
                            double zScale = ((double)(chunkZ * 16 + z) + 0.5 - blockZ) / roomWidth;
                            if (!(xScale * xScale + zScale * zScale < 1.0)) continue;
                            for (int y = yHigh - 1; y >= yLow; --y) {
                                double yScale = ((double)y + 0.5 - blockY) / roomHeight;
                                if (!((xScale * xScale + zScale * zScale) * (double)this.parabolicField[y] + yScale * yScale / 6.0 < 1.0)) continue;
                                this.digBlock(primer, x, y, z, chunkX, chunkZ, false);
                            }
                        }
                    }
                    if (createFinalRoom) break;
                }
            }
            ++currentY;
        }
    }

    protected void func_180701_a(World world, int chunkX, int chunkZ, int x, int z, ChunkPrimer primer) {
        if (this.field_75038_b.nextInt(45) == 0) {
            int worldHeight = world.func_72940_L();
            double blockX = chunkX * 16 + this.field_75038_b.nextInt(16);
            double blockY = this.field_75038_b.nextInt(this.field_75038_b.nextInt(worldHeight / 2) + world.field_73011_w.func_76557_i() + 10);
            double blockZ = chunkZ * 16 + this.field_75038_b.nextInt(16);
            float leftRightRadian = this.field_75038_b.nextFloat() * (float)Math.PI * 2.0f;
            float upDownRadian = (this.field_75038_b.nextFloat() - 0.5f) * 2.0f / 8.0f;
            float scale = (this.field_75038_b.nextFloat() * 2.0f + this.field_75038_b.nextFloat()) * 2.0f;
            if (blockY > (double)(worldHeight - 40)) {
                blockY = world.field_73011_w.func_76557_i() + this.field_75038_b.nextInt(10);
            }
            this.func_180707_a(this.field_75038_b.nextLong(), x, z, primer, blockX, blockY, blockZ, scale, leftRightRadian, upDownRadian, 0, 0, 3.0);
        }
    }

    protected void digBlock(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ, boolean foundTop) {
        if (y - 1 < 10) {
            data.func_177855_a(x, y, z, field_186135_a);
        } else {
            data.func_177855_a(x, y, z, field_186136_b);
        }
    }
}

