/*
 * Decompiled with CFR 0.152.
 */
package cavern.world;

import cavern.block.BlockPortalCavern;
import cavern.block.CaveBlocks;
import cavern.capability.CaveCapabilities;
import cavern.client.CaveMusics;
import cavern.client.renderer.EmptyRenderer;
import cavern.config.CavernConfig;
import cavern.entity.CaveEntityRegistry;
import cavern.world.CaveBiomeProvider;
import cavern.world.CaveDimensions;
import cavern.world.CaveEntitySpawner;
import cavern.world.CavePortalList;
import cavern.world.ChunkGeneratorCavern;
import cavern.world.CustomHeightData;
import cavern.world.CustomSeedData;
import cavern.world.CustomSeedProvider;
import java.util.Random;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderCavern
extends WorldProviderSurface
implements CustomSeedProvider,
CaveEntitySpawner.IWorldEntitySpawner {
    private CustomSeedData seedData;
    private CustomHeightData heightData;
    protected CaveEntitySpawner entitySpawner = new CaveEntitySpawner(this);
    protected boolean spawnHostileMobs = true;
    protected boolean spawnPeacefulMobs = true;

    protected void func_76572_b() {
        this.field_191067_f = false;
        this.seedData = this.field_76579_a instanceof WorldServer ? new CustomSeedData(this.field_76579_a.func_72912_H().getDimensionData(this.getDimension())) : new CustomSeedData();
        this.heightData = this.field_76579_a instanceof WorldServer ? new CustomHeightData(this.field_76579_a.func_72912_H().getDimensionData(this.getDimension())) : null;
        this.field_76578_c = this.createBiomeProvider();
    }

    protected BiomeProvider createBiomeProvider() {
        return new CaveBiomeProvider(this.field_76579_a, CavernConfig.BIOMES);
    }

    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorCavern(this.field_76579_a);
    }

    public DimensionType func_186058_p() {
        return CaveDimensions.CAVERN;
    }

    @Override
    public CustomSeedData getSeedData() {
        return this.seedData;
    }

    public long getSeed() {
        if (this.seedData != null) {
            if (this.field_76579_a instanceof WorldServer) {
                return this.seedData.getSeed();
            }
            return this.seedData.getSeedValue(this.field_76579_a.func_72912_H().func_76063_b());
        }
        return super.getSeed();
    }

    public int getWorldHeight() {
        return CavernConfig.worldHeight;
    }

    public int getActualHeight() {
        if (this.heightData != null) {
            return this.heightData.getHeight(this.getWorldHeight());
        }
        return super.getActualHeight();
    }

    public int getMonsterSpawn() {
        return CavernConfig.monsterSpawn;
    }

    public double getBrightness() {
        return CavernConfig.caveBrightness;
    }

    protected void func_76556_a() {
        float f = (float)this.getBrightness();
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            this.field_76573_f[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
    }

    public boolean func_76569_d() {
        return false;
    }

    public boolean func_76566_a(int x, int z) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public MusicTicker.MusicType getMusicType() {
        return CaveMusics.CAVES;
    }

    @SideOnly(value=Side.CLIENT)
    public float[] func_76560_a(float angle, float ticks) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float angle, float ticks) {
        return new Vec3d(0.01, 0.01, 0.01);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76561_g() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getSkyColor(Entity cameraEntity, float partialTicks) {
        return new Vec3d(0.01, 0.01, 0.01);
    }

    public int func_76557_i() {
        return 10;
    }

    public boolean shouldClientCheckLighting() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (super.getSkyRenderer() == null) {
            this.setSkyRenderer(EmptyRenderer.INSTANCE);
        }
        return super.getSkyRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getCloudRenderer() {
        if (super.getCloudRenderer() == null) {
            this.setCloudRenderer(EmptyRenderer.INSTANCE);
        }
        return super.getCloudRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getWeatherRenderer() {
        if (super.getWeatherRenderer() == null) {
            this.setWeatherRenderer(EmptyRenderer.INSTANCE);
        }
        return super.getWeatherRenderer();
    }

    public boolean shouldMapSpin(String entity, double posX, double posY, double posZ) {
        return posY < 0.0 || posY >= (double)this.getActualHeight();
    }

    public BlockPos getSpawnPoint() {
        BlockPos origin = BlockPos.field_177992_a.func_177981_b(50);
        CavePortalList portalList = (CavePortalList)this.field_76579_a.getCapability(CaveCapabilities.CAVE_PORTAL_LIST, null);
        if (portalList == null || portalList.isPortalEmpty()) {
            return origin;
        }
        for (BlockPortalCavern portal : CaveBlocks.PORTALS) {
            BlockPos pos;
            if (portal.getDimension() != this.func_186058_p() || (pos = (BlockPos)portalList.getPortalPositions(portal).stream().findAny().orElse(null)) == null) continue;
            return pos;
        }
        return portalList.getPortalPositions().stream().findAny().orElse(origin);
    }

    public BlockPos getRandomizedSpawnPoint() {
        return this.getSpawnPoint();
    }

    public boolean func_76567_e() {
        return false;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        CavePortalList portalList = (CavePortalList)this.field_76579_a.getCapability(CaveCapabilities.CAVE_PORTAL_LIST, null);
        if ((portalList == null || portalList.isPortalEmpty()) && player.getBedLocation(this.getDimension()) == null) {
            return 0;
        }
        return this.getDimension();
    }

    public boolean isDaytime() {
        return false;
    }

    public void setAllowedSpawnTypes(boolean allowHostile, boolean allowPeaceful) {
        super.setAllowedSpawnTypes(allowHostile, allowPeaceful);
        this.spawnHostileMobs = allowHostile;
        this.spawnPeacefulMobs = allowPeaceful;
    }

    public double getHorizon() {
        return this.getActualHeight();
    }

    public WorldProvider.WorldSleepResult canSleepAt(EntityPlayer player, BlockPos pos) {
        return WorldProvider.WorldSleepResult.ALLOW;
    }

    public boolean canDoLightning(Chunk chunk) {
        return false;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return false;
    }

    public boolean func_186056_c(int x, int z) {
        return true;
    }

    public void func_186057_q() {
        NBTTagCompound nbt;
        if (this.seedData != null) {
            nbt = this.field_76579_a.func_72912_H().getDimensionData(this.getDimension());
            this.field_76579_a.func_72912_H().setDimensionData(this.getDimension(), this.seedData.getCompound(nbt));
        }
        if (this.heightData != null) {
            nbt = this.field_76579_a.func_72912_H().getDimensionData(this.getDimension());
            this.field_76579_a.func_72912_H().setDimensionData(this.getDimension(), this.heightData.getCompound(nbt));
        }
    }

    public void func_186059_r() {
        WorldServer worldServer;
        if (this.field_76579_a instanceof WorldServer && (worldServer = (WorldServer)this.field_76579_a).func_82736_K().func_82766_b("doMobSpawning") && worldServer.func_72912_H().func_76067_t() != WorldType.field_180272_g) {
            this.entitySpawner.findChunksForSpawning(worldServer, this.spawnHostileMobs, this.spawnPeacefulMobs, worldServer.func_72912_H().func_82573_f() % 400L == 0L);
        }
    }

    @Override
    public Integer getMaxNumberOfCreature(WorldServer world, boolean spawnHostileMobs, boolean spawnPeacefulMobs, boolean spawnOnSetTickRate, EnumCreatureType type) {
        if (!type.func_75599_d()) {
            return this.getMonsterSpawn();
        }
        return null;
    }

    @Override
    public EntityLiving createSpawnCreature(WorldServer world, EnumCreatureType type, BlockPos pos, Biome.SpawnListEntry entry) {
        if (type != EnumCreatureType.MONSTER) {
            return null;
        }
        if (world.field_73012_v.nextInt(30) == 0) {
            Biome.SpawnListEntry spawnEntry = (Biome.SpawnListEntry)WeightedRandom.func_76271_a((Random)world.field_73012_v, CaveEntityRegistry.SPAWNS);
            try {
                return spawnEntry.newInstance((World)world);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

