/*
 * Decompiled with CFR 0.152.
 */
package cavern.world;

import cavern.client.CaveMusics;
import cavern.config.AquaCavernConfig;
import cavern.entity.passive.EntityAquaSquid;
import cavern.world.CaveBiomeProvider;
import cavern.world.CaveDimensions;
import cavern.world.ChunkGeneratorAquaCavern;
import cavern.world.WorldProviderCavern;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderAquaCavern
extends WorldProviderCavern {
    @Override
    protected BiomeProvider createBiomeProvider() {
        return new CaveBiomeProvider(this.field_76579_a, AquaCavernConfig.BIOMES);
    }

    @Override
    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorAquaCavern(this.field_76579_a);
    }

    @Override
    public DimensionType func_186058_p() {
        return CaveDimensions.AQUA_CAVERN;
    }

    @Override
    public int getWorldHeight() {
        return AquaCavernConfig.worldHeight;
    }

    @Override
    public int getMonsterSpawn() {
        return 0;
    }

    @Override
    public double getBrightness() {
        return AquaCavernConfig.caveBrightness;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public MusicTicker.MusicType getMusicType() {
        return CaveMusics.AQUA_CAVES;
    }

    @Override
    public Integer getMaxNumberOfCreature(WorldServer world, boolean spawnHostileMobs, boolean spawnPeacefulMobs, boolean spawnOnSetTickRate, EnumCreatureType type) {
        if (type == EnumCreatureType.WATER_CREATURE) {
            return 100;
        }
        return null;
    }

    @Override
    public EntityLiving createSpawnCreature(WorldServer world, EnumCreatureType type, BlockPos pos, Biome.SpawnListEntry entry) {
        if (type != EnumCreatureType.WATER_CREATURE) {
            return null;
        }
        return new EntityAquaSquid((World)world);
    }
}

