/*
 * Decompiled with CFR 0.152.
 */
package cavern.world;

import cavern.block.BlockPortalCavern;
import cavern.capability.CaveCapabilities;
import cavern.config.GeneralConfig;
import cavern.core.Cavern;
import cavern.data.PortalCache;
import cavern.world.CavePortalList;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;

public class TeleporterCavern
implements ITeleporter {
    private static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final IBlockState MOSSY_STONE = Blocks.field_150341_Y.func_176223_P();
    protected final BlockPortalCavern portalBlock;
    private Vec3d portalVec;
    private EnumFacing teleportDirection;

    public TeleporterCavern(BlockPortalCavern portal) {
        this.portalBlock = portal;
    }

    public TeleporterCavern setPortalInfo(Vec3d vec, EnumFacing direction) {
        this.portalVec = vec;
        this.teleportDirection = direction;
        return this;
    }

    public void placeEntity(World world, Entity entity, float yaw) {
        CavePortalList portalList;
        PortalCache cache;
        int radius = GeneralConfig.findPortalRange;
        boolean placed = false;
        if (GeneralConfig.portalCache && (cache = (PortalCache)entity.getCapability(CaveCapabilities.PORTAL_CACHE, null)) != null) {
            placed = this.placeInCachedPortal(world, entity, yaw, radius, cache);
        }
        BlockPos pos = entity.func_180425_c();
        if (!placed && (portalList = (CavePortalList)world.getCapability(CaveCapabilities.CAVE_PORTAL_LIST, null)) != null) {
            placed = this.placeInStoredPortal(world, entity, yaw, radius, pos, portalList);
        }
        if (!placed && !(placed = this.placeInPortal(world, entity, yaw, radius, pos))) {
            placed = this.placeInPortal(world, entity, yaw, radius, this.makePortal(world, entity, radius));
        }
    }

    public boolean placeInCachedPortal(World world, Entity entity, float yaw, int radius, PortalCache cache) {
        DimensionType dim;
        ResourceLocation key = this.portalBlock.getRegistryName();
        BlockPos pos = cache.getLastPos(key, dim = world.field_73011_w.func_186058_p(), null);
        if (pos == null) {
            return false;
        }
        return this.placeInPortal(world, entity, yaw, radius, pos);
    }

    public boolean placeInStoredPortal(World world, Entity entity, float yaw, int radius, BlockPos checkPos, CavePortalList list) {
        List positions = list.getPortalPositions(this.portalBlock).stream().filter(o -> new BlockPos(o.func_177958_n(), 0, o.func_177952_p()).func_185332_f(checkPos.func_177958_n(), 0, checkPos.func_177952_p()) <= (double)radius).sorted((o1, o2) -> Double.compare(o1.func_177951_i((Vec3i)checkPos), o2.func_177951_i((Vec3i)checkPos))).collect(Collectors.toList());
        for (BlockPos portalPos : positions) {
            if (this.placeInPortal(world, entity, yaw, 8, portalPos)) {
                return true;
            }
            list.removePortal(this.portalBlock, portalPos);
        }
        return false;
    }

    public boolean placeInPortal(World world, Entity entity, float yaw, int radius, BlockPos checkPos) {
        boolean flag;
        BlockPos pos = null;
        if (world.func_180495_p(checkPos).func_177230_c() == this.portalBlock) {
            pos = checkPos;
        } else {
            int min = 1;
            int max = world.func_72940_L() - 1;
            BlockPos.MutableBlockPos findPos = new BlockPos.MutableBlockPos(checkPos);
            LongArraySet findChunks = new LongArraySet();
            findChunks.add(ChunkPos.func_77272_a((int)(checkPos.func_177958_n() >> 4), (int)(checkPos.func_177952_p() >> 4)));
            block0: for (int r = 1; r <= radius; ++r) {
                for (int i = -r; i <= r; ++i) {
                    for (int j = -r; j <= r; ++j) {
                        int y;
                        if (Math.abs(i) < r && Math.abs(j) < r) continue;
                        int x = checkPos.func_177958_n() + i;
                        int z = checkPos.func_177952_p() + j;
                        ChunkPos chunkPos = new ChunkPos((BlockPos)findPos.func_181079_c(x, 0, z));
                        if (findChunks.add(ChunkPos.func_77272_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b))) {
                            Cavern.proxy.loadChunks(world, chunkPos.field_77276_a, chunkPos.field_77275_b, 1);
                        }
                        for (y = checkPos.func_177956_o(); y < max; ++y) {
                            if (world.func_180495_p((BlockPos)findPos.func_181079_c(x, y, z)).func_177230_c() != this.portalBlock) continue;
                            pos = findPos.func_185334_h();
                            break block0;
                        }
                        for (y = checkPos.func_177956_o(); y > min; --y) {
                            if (world.func_180495_p((BlockPos)findPos.func_181079_c(x, y, z)).func_177230_c() != this.portalBlock) continue;
                            pos = findPos.func_185334_h();
                            break block0;
                        }
                    }
                }
            }
            if (pos == null) {
                pos = world.func_175694_M();
            }
            if (world.func_180495_p(pos).func_177230_c() != this.portalBlock) {
                return false;
            }
        }
        CavePortalList portalList = (CavePortalList)world.getCapability(CaveCapabilities.CAVE_PORTAL_LIST, null);
        if (portalList != null) {
            portalList.addPortal(this.portalBlock, pos);
        }
        if (this.portalVec == null) {
            this.portalVec = Vec3d.field_186680_a;
        }
        if (this.teleportDirection == null) {
            this.teleportDirection = EnumFacing.NORTH;
        }
        BlockPattern.PatternHelper pattern = this.portalBlock.func_181089_f(world, pos);
        double posX = (double)pos.func_177958_n() + 0.5;
        double posY = (double)(pattern.func_181117_a().func_177956_o() + 1) - this.portalVec.field_72448_b * (double)pattern.func_181119_e();
        double posZ = (double)pos.func_177952_p() + 0.5;
        double d1 = pattern.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? (double)pattern.func_181117_a().func_177952_p() : (double)pattern.func_181117_a().func_177958_n();
        boolean bl = flag = pattern.func_177669_b().func_176746_e().func_176743_c() == EnumFacing.AxisDirection.NEGATIVE;
        if (flag) {
            d1 += 1.0;
        }
        if (pattern.func_177669_b().func_176740_k() == EnumFacing.Axis.X) {
            posZ = d1 + (1.0 - this.portalVec.field_72450_a) * (double)pattern.func_181118_d() * (double)pattern.func_177669_b().func_176746_e().func_176743_c().func_179524_a();
        } else {
            posX = d1 + (1.0 - this.portalVec.field_72450_a) * (double)pattern.func_181118_d() * (double)pattern.func_177669_b().func_176746_e().func_176743_c().func_179524_a();
        }
        float f1 = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (pattern.func_177669_b().func_176734_d() == this.teleportDirection) {
            f1 = 1.0f;
            f2 = 1.0f;
        } else if (pattern.func_177669_b().func_176734_d() == this.teleportDirection.func_176734_d()) {
            f1 = -1.0f;
            f2 = -1.0f;
        } else if (pattern.func_177669_b().func_176734_d() == this.teleportDirection.func_176746_e()) {
            f3 = 1.0f;
            f4 = -1.0f;
        } else {
            f3 = -1.0f;
            f4 = 1.0f;
        }
        double mx = entity.field_70159_w;
        double mz = entity.field_70179_y;
        entity.field_70159_w = mx * (double)f1 + mz * (double)f4;
        entity.field_70179_y = mx * (double)f3 + mz * (double)f2;
        entity.field_70177_z = yaw - (float)(this.teleportDirection.func_176734_d().func_176736_b() * 90) + (float)(pattern.func_177669_b().func_176736_b() * 90);
        entity.func_70634_a(posX, posY, posZ);
        return true;
    }

    @Nullable
    public BlockPos makePortal(World world, Entity entity, int radius) {
        int j1;
        int i1;
        int k;
        int py;
        double zSize;
        double xSize;
        int pz;
        int px;
        int rz;
        int rx;
        int r;
        int originX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int originY = MathHelper.func_76128_c((double)entity.field_70163_u);
        int originZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        int min = 10;
        int max = world.func_72940_L() - 10;
        int x = originX;
        int y = originY;
        int z = originZ;
        int i = 0;
        int j = world.field_73012_v.nextInt(4);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        double portalDist = -1.0;
        for (r = 1; r <= radius; ++r) {
            for (rx = -r; rx <= r; ++rx) {
                for (rz = -r; rz <= r; ++rz) {
                    if (Math.abs(rx) < r && Math.abs(rz) < r) continue;
                    px = originX + rx;
                    pz = originZ + rz;
                    xSize = (double)px + 0.5 - entity.field_70165_t;
                    zSize = (double)pz + 0.5 - entity.field_70161_v;
                    for (py = min; py < max && !world.func_175623_d((BlockPos)pos.func_181079_c(px, py, pz)); ++py) {
                    }
                    if (py >= max) continue;
                    block4: for (k = j; k < j + 4; ++k) {
                        i1 = k % 2;
                        j1 = 1 - i1;
                        if (k % 4 >= 2) {
                            i1 = -i1;
                            j1 = -j1;
                        }
                        for (int size1 = 0; size1 < 3; ++size1) {
                            for (int size2 = 0; size2 < 4; ++size2) {
                                for (int height = -1; height < 4; ++height) {
                                    int checkX = px + (size2 - 1) * i1 + size1 * j1;
                                    int checkY = py + height;
                                    int checkZ = pz + (size2 - 1) * j1 - size1 * i1;
                                    pos.func_181079_c(checkX, checkY, checkZ);
                                    if (height < 0 && !world.func_180495_p((BlockPos)pos).func_185904_a().func_76220_a() || height >= 0 && !world.func_175623_d((BlockPos)pos)) continue block4;
                                }
                            }
                        }
                        double ySize = (double)py + 0.5 - entity.field_70163_u;
                        double size = xSize * xSize + ySize * ySize + zSize * zSize;
                        if (!(portalDist < 0.0) && !(size < portalDist)) continue;
                        portalDist = size;
                        x = px;
                        y = py;
                        z = pz;
                        i = k % 4;
                    }
                }
            }
            if (portalDist >= 0.0) break;
        }
        if (portalDist < 0.0) {
            for (r = 1; r <= radius; ++r) {
                for (rx = -r; rx <= r; ++rx) {
                    for (rz = -r; rz <= r; ++rz) {
                        if (Math.abs(rx) < r && Math.abs(rz) < r) continue;
                        px = originX + rx;
                        pz = originZ + rz;
                        xSize = (double)px + 0.5 - entity.field_70165_t;
                        zSize = (double)pz + 0.5 - entity.field_70161_v;
                        for (py = min; py < max && !world.func_175623_d((BlockPos)pos.func_181079_c(px, py, pz)); ++py) {
                        }
                        if (py >= max) continue;
                        block12: for (k = j; k < j + 2; ++k) {
                            i1 = k % 2;
                            j1 = 1 - i1;
                            for (int width = 0; width < 4; ++width) {
                                for (int height = -1; height < 4; ++height) {
                                    int px1 = px + (width - 1) * i1;
                                    int py1 = py + height;
                                    int pz1 = pz + (width - 1) * j1;
                                    pos.func_181079_c(px1, py1, pz1);
                                    if (height < 0 && !world.func_180495_p((BlockPos)pos).func_185904_a().func_76220_a() || height >= 0 && !world.func_175623_d((BlockPos)pos)) continue block12;
                                }
                            }
                            double ySize = (double)py + 0.5 - entity.field_70163_u;
                            double size = xSize * xSize + ySize * ySize + zSize * zSize;
                            if (!(portalDist < 0.0) && !(size < portalDist)) continue;
                            portalDist = size;
                            x = px;
                            y = py;
                            z = pz;
                            i = k % 2;
                        }
                    }
                }
                if (portalDist >= 0.0) break;
            }
        }
        int x2 = x;
        int y1 = y;
        int z2 = z;
        int i12 = i % 2;
        int j12 = 1 - i12;
        if (i % 4 >= 2) {
            i12 = -i12;
            j12 = -j12;
        }
        if (portalDist < 0.0) {
            y1 = y = MathHelper.func_76125_a((int)y, (int)min, (int)max);
            for (int size1 = -1; size1 <= 1; ++size1) {
                for (int size2 = 1; size2 < 3; ++size2) {
                    for (int height = -1; height < 3; ++height) {
                        int blockX = x2 + (size2 - 1) * i12 + size1 * j12;
                        int blockY = y1 + height;
                        int blockZ = z2 + (size2 - 1) * j12 - size1 * i12;
                        boolean isFloor = height < 0;
                        world.func_175656_a((BlockPos)pos.func_181079_c(blockX, blockY, blockZ), isFloor ? MOSSY_STONE : AIR);
                    }
                }
            }
        }
        IBlockState portalState = this.portalBlock.func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)(i12 != 0 ? EnumFacing.Axis.X : EnumFacing.Axis.Z));
        BlockPos portalPos = null;
        for (int width = 0; width < 4; ++width) {
            for (int height = -1; height < 4; ++height) {
                int blockX = x2 + (width - 1) * i12;
                int blockY = y1 + height;
                int blockZ = z2 + (width - 1) * j12;
                boolean isFrame = width == 0 || width == 3 || height == -1 || height == 3;
                world.func_180501_a((BlockPos)pos.func_181079_c(blockX, blockY, blockZ), isFrame ? MOSSY_STONE : portalState, 2);
                if (width != 1 || height != 0) continue;
                portalPos = new BlockPos((double)blockX + 0.5, (double)blockY + 0.5, (double)blockZ + 0.5);
            }
        }
        return portalPos;
    }
}

