/*
 * Decompiled with CFR 0.152.
 */
package cavern.world;

import cavern.handler.CaveEventHooks;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class CustomExplosion
extends Explosion {
    private final Random random = CaveEventHooks.RANDOM;
    private final boolean causesFire;
    private final boolean damagesTerrain;
    private final World world;
    private final double x;
    private final double y;
    private final double z;
    private final Entity exploder;
    private final float size;
    private final List<BlockPos> affectedBlockPositions = Lists.newArrayList();
    private final Map<EntityPlayer, Vec3d> playerKnockbackMap = Maps.newHashMap();
    private final Vec3d position;

    public CustomExplosion(World world, Entity entity, double x, double y, double z, float size, boolean flaming, boolean damagesTerrain) {
        super(world, entity, x, y, z, size, flaming, damagesTerrain);
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.exploder = entity;
        this.size = size;
        this.causesFire = flaming;
        this.damagesTerrain = damagesTerrain;
        this.position = new Vec3d(x, y, z);
    }

    public boolean canExplodeEntity(Entity entity) {
        return !entity.func_180427_aV();
    }

    public void func_77278_a() {
        HashSet set = Sets.newHashSet();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    if (i != 0 && i != 15 && j != 0 && j != 15 && k != 0 && k != 15) continue;
                    double d0 = (float)i / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double posX = this.x;
                    double posY = this.y;
                    double posZ = this.z;
                    for (float f = this.size * (0.7f + this.random.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos pos = new BlockPos(posX, posY, posZ);
                        IBlockState state = this.world.func_180495_p(pos);
                        if (state.func_185904_a() != Material.field_151579_a) {
                            float resistance = this.exploder != null ? this.exploder.func_180428_a((Explosion)this, this.world, pos, state) : state.func_177230_c().getExplosionResistance(this.world, pos, null, (Explosion)this);
                            f -= (resistance + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.exploder == null || this.exploder.func_174816_a((Explosion)this, this.world, pos, state, f))) {
                            set.add(pos);
                        }
                        posX += d0 * (double)0.3f;
                        posY += d1 * (double)0.3f;
                        posZ += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(set);
    }

    public void func_77279_a(boolean spawnParticles) {
        this.world.func_184148_a(null, this.x, this.y, this.z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f) * 0.7f);
        if (spawnParticles) {
            if (this.size >= 2.0f && this.damagesTerrain) {
                this.world.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.x, this.y, this.z, 1.0, 0.0, 0.0, new int[0]);
            } else {
                this.world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.x, this.y, this.z, 1.0, 0.0, 0.0, new int[0]);
            }
        }
        if (this.damagesTerrain) {
            for (BlockPos pos : this.affectedBlockPositions) {
                IBlockState state = this.world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (spawnParticles) {
                    double ex = (float)pos.func_177958_n() + this.random.nextFloat();
                    double ey = (float)pos.func_177956_o() + this.random.nextFloat();
                    double ez = (float)pos.func_177952_p() + this.random.nextFloat();
                    double rx = ex - this.x;
                    double ry = ey - this.y;
                    double rz = ez - this.z;
                    double rd = MathHelper.func_76133_a((double)(rx * rx + ry * ry + rz * rz));
                    rx /= rd;
                    ry /= rd;
                    rz /= rd;
                    double d7 = 0.5 / (rd / (double)this.size + 0.1);
                    this.world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (ex + this.x) / 2.0, (ey + this.y) / 2.0, (ez + this.z) / 2.0, rx *= (d7 *= (double)(this.random.nextFloat() * this.random.nextFloat() + 0.3f)), ry *= d7, rz *= d7, new int[0]);
                    this.world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, ex, ey, ez, rx, ry, rz, new int[0]);
                }
                if (state.func_185904_a() == Material.field_151579_a) continue;
                if (block.func_149659_a((Explosion)this)) {
                    block.func_180653_a(this.world, pos, this.world.func_180495_p(pos), 1.0f / this.size, 0);
                }
                block.onBlockExploded(this.world, pos, (Explosion)this);
            }
        }
        if (this.causesFire) {
            for (BlockPos pos : this.affectedBlockPositions) {
                if (this.world.func_180495_p(pos).func_185904_a() != Material.field_151579_a || !this.world.func_180495_p(pos.func_177977_b()).func_185913_b() || this.random.nextInt(3) != 0) continue;
                this.world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    public void doExplosionEntities() {
        float f = this.size * 2.0f;
        int minX = MathHelper.func_76128_c((double)(this.x - (double)f - 1.0));
        int maxX = MathHelper.func_76128_c((double)(this.x + (double)f + 1.0));
        int minY = MathHelper.func_76128_c((double)(this.y - (double)f - 1.0));
        int maxY = MathHelper.func_76128_c((double)(this.y + (double)f + 1.0));
        int minZ = MathHelper.func_76128_c((double)(this.z - (double)f - 1.0));
        int maxZ = MathHelper.func_76128_c((double)(this.z + (double)f + 1.0));
        List entities = this.world.func_72839_b(this.exploder, new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this, (List)entities, (double)f);
        if (entities.isEmpty()) {
            return;
        }
        entities.stream().filter(this::canExplodeEntity).forEach(entity -> {
            double ez;
            double ey;
            double ex;
            double ed;
            double dist = entity.func_70011_f(this.x, this.y, this.z) / (double)f;
            if (dist <= 1.0 && (ed = (double)MathHelper.func_76133_a((double)((ex = entity.field_70165_t - this.x) * ex + (ey = entity.field_70163_u + (double)entity.func_70047_e() - this.y) * ey + (ez = entity.field_70161_v - this.z) * ez))) != 0.0) {
                ex /= ed;
                ey /= ed;
                ez /= ed;
                double density = this.world.func_72842_a(this.position, entity.func_174813_aQ());
                double damage = (1.0 - dist) * density;
                entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), (float)this.getExplosionAttackDamage((Entity)entity, (int)((damage * damage + damage) / 2.0 * 7.0 * (double)f + 1.0)));
                double blast = damage;
                if (entity instanceof EntityLivingBase) {
                    blast = EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)damage);
                }
                entity.field_70159_w += ex * blast;
                entity.field_70181_x += ey * blast;
                entity.field_70179_y += ez * blast;
            }
        });
    }

    protected int getExplosionAttackDamage(Entity entity, int damage) {
        return damage;
    }

    public Map<EntityPlayer, Vec3d> func_77277_b() {
        return this.playerKnockbackMap;
    }

    public EntityLivingBase func_94613_c() {
        return this.exploder == null ? null : (this.exploder instanceof EntityTNTPrimed ? ((EntityTNTPrimed)this.exploder).func_94083_c() : (this.exploder instanceof EntityLivingBase ? (EntityLivingBase)this.exploder : null));
    }

    public void func_180342_d() {
        this.affectedBlockPositions.clear();
    }

    public List<BlockPos> func_180343_e() {
        return this.affectedBlockPositions;
    }

    public Vec3d getPosition() {
        return this.position;
    }
}

