/*
 * Decompiled with CFR 0.152.
 */
package cavern.world;

import cavern.block.CaveBlocks;
import cavern.config.CavernConfig;
import cavern.config.manager.CaveBiome;
import cavern.world.CaveVeinProvider;
import cavern.world.gen.MapGenCavernCaves;
import cavern.world.gen.MapGenCavernRavine;
import cavern.world.gen.MapGenExtremeCaves;
import cavern.world.gen.MapGenExtremeRavine;
import cavern.world.gen.VeinGenerator;
import cavern.world.gen.WorldGenCaveBush;
import cavern.world.gen.WorldGenCaveDungeons;
import cavern.world.gen.WorldGenMirageRemnant;
import cavern.world.gen.WorldGenTowerDungeons;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkGeneratorCavern
implements IChunkGenerator {
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState STONE = Blocks.field_150348_b.func_176223_P();
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    private final World world;
    private final Random rand;
    private Biome[] biomesForGeneration;
    private final MapGenBase caveGenerator = new MapGenCavernCaves();
    private final MapGenBase ravineGenerator = new MapGenCavernRavine();
    private final MapGenBase extremeCaveGenerator = new MapGenExtremeCaves();
    private final MapGenBase extremeRavineGenerator = new MapGenExtremeRavine();
    private final MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    private final VeinGenerator veinGenerator;
    private final WorldGenerator lakeWaterGen = new WorldGenLakes((Block)Blocks.field_150355_j);
    private final WorldGenerator lakeLavaGen = new WorldGenLakes((Block)Blocks.field_150353_l);
    private final WorldGenerator mushroomBrownGen = new WorldGenCaveBush(Blocks.field_150338_P);
    private final WorldGenerator mushroomRedGen = new WorldGenCaveBush(Blocks.field_150337_Q);
    private final WorldGenerator cavenicShroomGen = new WorldGenCaveBush(CaveBlocks.CAVENIC_SHROOM);
    private final WorldGenerator dungeonGen = new WorldGenCaveDungeons(CavernConfig.dungeonMobs.getKeys());
    private final WorldGenerator towerDungeonGen = new WorldGenTowerDungeons(CavernConfig.towerDungeonMobs.getKeys());
    private final WorldGenerator mirageRemnantGen = new WorldGenMirageRemnant();
    private final WorldGenerator liquidWaterGen = new WorldGenLiquids((Block)Blocks.field_150358_i);
    private final WorldGenerator liquidLavaGen = new WorldGenLiquids((Block)Blocks.field_150356_k);

    public ChunkGeneratorCavern(World world) {
        this.world = world;
        this.rand = new Random(world.func_72905_C());
        this.veinGenerator = new VeinGenerator(new CaveVeinProvider(world, () -> CavernConfig.autoVeins ? null : CavernConfig.VEINS));
    }

    public void setBlocksInChunk(ChunkPrimer primer) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 255; y >= 0; --y) {
                    primer.func_177855_a(x, y, z, STONE);
                }
            }
        }
    }

    public void replaceBiomeBlocks(int chunkX, int chunkZ, ChunkPrimer primer) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)chunkX, (int)chunkZ, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        int worldHeight = this.world.field_73011_w.getActualHeight();
        int blockHeight = worldHeight - 1;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                Biome biome = this.biomesForGeneration[x * 16 + z];
                CaveBiome caveBiome = CavernConfig.BIOMES.getCaveBiome(biome);
                IBlockState top = caveBiome == null ? STONE : caveBiome.getTopBlock().getBlockState();
                IBlockState filter = caveBiome == null ? top : caveBiome.getTerrainBlock().getBlockState();
                primer.func_177855_a(x, 0, z, BEDROCK);
                primer.func_177855_a(x, blockHeight, z, BEDROCK);
                for (y = 1; y <= blockHeight - 1; ++y) {
                    if (primer.func_177856_a(x, y, z).func_185904_a().func_76220_a() && primer.func_177856_a(x, y + 1, z).func_177230_c() == Blocks.field_150350_a) {
                        primer.func_177855_a(x, y, z, top);
                        continue;
                    }
                    if (primer.func_177856_a(x, y, z).func_177230_c() != Blocks.field_150348_b) continue;
                    primer.func_177855_a(x, y, z, filter);
                }
                if (blockHeight >= 255) continue;
                for (y = blockHeight + 1; y < 256; ++y) {
                    primer.func_177855_a(x, y, z, AIR);
                }
            }
        }
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 16, chunkZ * 16, 16, 16);
        ChunkPrimer primer = new ChunkPrimer();
        this.setBlocksInChunk(primer);
        if (CavernConfig.generateCaves) {
            this.caveGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        }
        if (CavernConfig.generateRavine) {
            this.ravineGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        }
        if (CavernConfig.generateExtremeCaves) {
            this.extremeCaveGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        }
        if (CavernConfig.generateExtremeRavine) {
            this.extremeRavineGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        }
        if (CavernConfig.generateMineshaft) {
            this.mineshaftGenerator.func_186125_a(this.world, chunkX, chunkZ, primer);
        }
        this.replaceBiomeBlocks(chunkX, chunkZ, primer);
        this.veinGenerator.generate(this.world, this.rand, this.biomesForGeneration, primer);
        Chunk chunk = new Chunk(this.world, primer, chunkX, chunkZ);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        int i;
        int z;
        int y;
        int x;
        BlockFalling.field_149832_M = true;
        int worldX = chunkX << 4;
        int worldZ = chunkZ << 4;
        BlockPos blockPos = new BlockPos(worldX, 0, worldZ);
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        Biome biome = this.world.func_180494_b(blockPos.func_177982_a(16, 0, 16));
        BiomeDecorator decorator = biome.field_76760_I;
        int worldHeight = this.world.field_73011_w.getActualHeight();
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false);
        ChunkPos coord = new ChunkPos(chunkX, chunkZ);
        if (CavernConfig.generateMineshaft) {
            this.mineshaftGenerator.func_175794_a(this.world, this.rand, coord);
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            if (CavernConfig.generateLakes && this.rand.nextInt(4) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA)) {
                x = this.rand.nextInt(16) + 8;
                y = this.rand.nextInt(worldHeight - 16);
                z = this.rand.nextInt(16) + 8;
                this.lakeLavaGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(x, y, z));
            }
        } else if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) && CavernConfig.generateLakes) {
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) && this.rand.nextInt(4) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
                x = this.rand.nextInt(16) + 8;
                y = this.rand.nextInt(worldHeight - 16);
                z = this.rand.nextInt(16) + 8;
                this.lakeWaterGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(x, y, z));
            }
            if (this.rand.nextInt(20) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA)) {
                x = this.rand.nextInt(16) + 8;
                y = this.rand.nextInt(worldHeight / 2);
                z = this.rand.nextInt(16) + 8;
                this.lakeLavaGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(x, y, z));
            }
        }
        if (CavernConfig.generateDungeons && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON)) {
            for (i = 0; i < 20; ++i) {
                x = this.rand.nextInt(16) + 8;
                y = this.rand.nextInt(worldHeight - 30) + 5;
                z = this.rand.nextInt(16) + 8;
                this.dungeonGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(x, y, z));
            }
        }
        if (CavernConfig.generateTowerDungeons && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON) && this.rand.nextInt(100) == 0) {
            y = this.rand.nextInt(16) + 8;
            this.towerDungeonGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(16, y, 16));
        }
        if (CavernConfig.generateMirageLibrary && this.rand.nextInt(50) == 0) {
            x = this.rand.nextInt(16) + 8;
            y = this.rand.nextInt(50) + 12;
            z = this.rand.nextInt(16) + 8;
            this.mirageRemnantGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(x, y, z));
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.world, this.rand, chunkPos));
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(this.world, this.rand, blockPos));
        if (TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM)) {
            i = 0;
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
                i += 2;
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
                ++i;
            }
            if (this.rand.nextInt(5) <= i) {
                this.mushroomBrownGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(16, 0, 16));
            }
            if (this.rand.nextInt(10) <= i) {
                this.mushroomRedGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(16, 0, 16));
            }
            if (this.rand.nextInt(7) <= i) {
                this.cavenicShroomGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(16, 0, 16));
            }
        }
        if (decorator.field_76808_K) {
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
                if (TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA)) {
                    for (i = 0; i < 40; ++i) {
                        x = this.rand.nextInt(16) + 8;
                        y = this.rand.nextInt(worldHeight - 12) + 10;
                        z = this.rand.nextInt(16) + 8;
                        this.liquidLavaGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(x, y, z));
                    }
                }
            } else if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
                if (TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER)) {
                    for (i = 0; i < 65; ++i) {
                        x = this.rand.nextInt(16) + 8;
                        y = this.rand.nextInt(this.rand.nextInt(worldHeight - 16) + 10);
                        z = this.rand.nextInt(16) + 8;
                        this.liquidWaterGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(x, y, z));
                    }
                }
            } else if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
                if (TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER)) {
                    for (i = 0; i < 50; ++i) {
                        x = this.rand.nextInt(16) + 8;
                        y = this.rand.nextInt(this.rand.nextInt(worldHeight - 16) + 10);
                        z = this.rand.nextInt(16) + 8;
                        this.liquidWaterGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(x, y, z));
                    }
                }
                if (TerrainGen.decorate((World)this.world, (Random)this.rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA)) {
                    for (i = 0; i < 20; ++i) {
                        x = this.rand.nextInt(16) + 8;
                        y = this.rand.nextInt(worldHeight / 2);
                        z = this.rand.nextInt(16) + 8;
                        this.liquidLavaGen.func_180709_b(this.world, this.rand, blockPos.func_177982_a(x, y, z));
                    }
                }
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.world, this.rand, chunkPos));
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunk, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return Collections.emptyList();
    }

    public boolean func_193414_a(World world, String structureName, BlockPos pos) {
        if ("Mineshaft".equals(structureName) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_175795_b(pos);
        }
        return false;
    }

    public BlockPos func_180513_a(World world, String structureName, BlockPos pos, boolean findUnexplored) {
        if ("Mineshaft".equals(structureName) && this.mineshaftGenerator != null) {
            return this.mineshaftGenerator.func_180706_b(world, pos, findUnexplored);
        }
        return null;
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
        if (CavernConfig.generateMineshaft) {
            this.mineshaftGenerator.func_186125_a(this.world, x, z, null);
        }
    }
}

