/*
 * Decompiled with CFR 0.152.
 */
package cavern.world;

import cavern.block.BlockCave;
import cavern.block.CaveBlocks;
import cavern.config.manager.CaveVein;
import cavern.config.manager.CaveVeinManager;
import cavern.util.BlockMeta;
import cavern.util.CaveLog;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;

public class CaveVeinProvider {
    private static final Map<BlockMeta, EnumRarity> RARITY_MAP = Maps.newHashMap();
    private final World world;
    private final Random rand;
    private final Supplier<CaveVeinManager> veinManager;
    private Pair<Long, List<CaveVein>> cachedVeins;

    public static void setRarity(IBlockState state, EnumRarity rarity) {
        RARITY_MAP.put(new BlockMeta(state), rarity);
    }

    public CaveVeinProvider(World world, Supplier<CaveVeinManager> manager) {
        this.world = world;
        this.rand = new Random();
        this.veinManager = manager;
    }

    public List<CaveVein> getVeins() {
        IBlockState state;
        Block block;
        CaveVeinManager manager = this.veinManager.get();
        if (manager != null) {
            return manager.getCaveVeins();
        }
        long time = this.world.func_72912_H().func_82573_f();
        if (this.cachedVeins != null && (Long)this.cachedVeins.getLeft() + 1200L >= time) {
            return (List)this.cachedVeins.getRight();
        }
        ArrayList list = Lists.newArrayList();
        int worldHeight = this.world.func_72940_L() - 1;
        Set oreNames = Arrays.stream(OreDictionary.getOreNames()).filter(name -> name.startsWith("ore") && name.length() > 3 && Character.isUpperCase(name.charAt(3))).sorted().collect(Collectors.toSet());
        for (String name2 : oreNames) {
            for (ItemStack stack : OreDictionary.getOres((String)name2, (boolean)false)) {
                try {
                    MapColor color;
                    if (stack.func_190926_b() || stack.func_77973_b() == Items.field_190931_a || !(stack.func_77973_b() instanceof ItemBlock) || (block = ((ItemBlock)stack.func_77973_b()).func_179223_d()) == null || block instanceof BlockAir || (color = (state = block.func_176203_a(stack.func_77952_i())).func_185909_g((IBlockAccess)this.world, BlockPos.field_177992_a)) == MapColor.field_151655_K) continue;
                    BlockMeta blockMeta = new BlockMeta(state);
                    EnumRarity rarity = RARITY_MAP.get(blockMeta);
                    if (rarity == null) {
                        int harvestLevel;
                        String variant = name2.substring(3).toLowerCase();
                        int level = harvestLevel = block.getHarvestLevel(state);
                        Item pickaxe = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(block.getRegistryName().func_110624_b(), variant + "_pickaxe"));
                        double toolRarity = 1.0;
                        if (pickaxe != null) {
                            ItemStack dummy = new ItemStack(pickaxe);
                            int max = pickaxe.getMaxDamage(dummy);
                            float destroy = pickaxe.func_150893_a(dummy, Blocks.field_150366_p.func_176223_P());
                            int enchant = pickaxe.getItemEnchantability(dummy);
                            int harvest = pickaxe.getHarvestLevel(dummy, "pickaxe", null, null);
                            toolRarity = (double)max * 0.01 + (double)destroy * 0.001 + (double)enchant * 0.01 + (double)harvest * 1.0;
                        } else if (harvestLevel > 0) {
                            ++level;
                        }
                        if (toolRarity >= 5.0) {
                            level += MathHelper.func_76143_f((double)(toolRarity * 0.25)) - 3;
                        }
                        if (level > 3) {
                            rarity = EnumRarity.EPIC;
                        } else if (level > 2) {
                            rarity = EnumRarity.RARE;
                        } else if (level > 1) {
                            rarity = EnumRarity.UNCOMMON;
                        }
                        rarity = EnumRarity.COMMON;
                        RARITY_MAP.put(blockMeta, rarity);
                    }
                    int weight = 30;
                    int size = 10;
                    int min = 1;
                    int max = worldHeight;
                    switch (rarity) {
                        case COMMON: {
                            weight = MathHelper.func_76136_a((Random)this.rand, (int)25, (int)35);
                            size = MathHelper.func_76136_a((Random)this.rand, (int)10, (int)20);
                            break;
                        }
                        case UNCOMMON: {
                            weight = MathHelper.func_76136_a((Random)this.rand, (int)15, (int)25);
                            size = MathHelper.func_76136_a((Random)this.rand, (int)7, (int)12);
                            break;
                        }
                        case RARE: {
                            weight = MathHelper.func_76136_a((Random)this.rand, (int)10, (int)20);
                            size = MathHelper.func_76136_a((Random)this.rand, (int)5, (int)10);
                            break;
                        }
                        case EPIC: {
                            weight = MathHelper.func_76136_a((Random)this.rand, (int)1, (int)5);
                            size = MathHelper.func_76136_a((Random)this.rand, (int)2, (int)7);
                            max = 30;
                        }
                    }
                    list.add(new CaveVein(blockMeta, weight, size, min, max, new Object[0]));
                }
                catch (Exception e) {
                    CaveLog.log(Level.ERROR, "An error occurred while setup. Skip: {%s} %s", name2, stack.toString());
                }
            }
        }
        oreNames = Arrays.stream(OreDictionary.getOreNames()).filter(name -> name.startsWith("stone") && name.length() > 5 && Character.isUpperCase(name.charAt(5)) && !name.endsWith("Polished")).sorted().collect(Collectors.toSet());
        oreNames.add("dirt");
        oreNames.add("gravel");
        for (String name2 : oreNames) {
            for (ItemStack stack : OreDictionary.getOres((String)name2, (boolean)false)) {
                try {
                    if (stack.func_190926_b() || stack.func_77973_b() == Items.field_190931_a || !(stack.func_77973_b() instanceof ItemBlock) || (block = ((ItemBlock)stack.func_77973_b()).func_179223_d()) == null || block instanceof BlockAir) continue;
                    state = block.func_176203_a(stack.func_77952_i());
                    int weight = MathHelper.func_76136_a((Random)this.rand, (int)25, (int)40);
                    int size = MathHelper.func_76136_a((Random)this.rand, (int)10, (int)30);
                    list.add(new CaveVein(new BlockMeta(state), weight, size, 1, worldHeight, new Object[0]));
                }
                catch (Exception e) {
                    CaveLog.log(Level.ERROR, "An error occurred while setup. Skip: {%s} %s", name2, stack.toString());
                }
            }
        }
        this.cachedVeins = Pair.of((Object)time, (Object)list);
        return list;
    }

    static {
        CaveVeinProvider.setRarity(Blocks.field_150365_q.func_176223_P(), EnumRarity.COMMON);
        CaveVeinProvider.setRarity(Blocks.field_150366_p.func_176223_P(), EnumRarity.COMMON);
        CaveVeinProvider.setRarity(Blocks.field_150352_o.func_176223_P(), EnumRarity.RARE);
        CaveVeinProvider.setRarity(Blocks.field_150450_ax.func_176223_P(), EnumRarity.UNCOMMON);
        CaveVeinProvider.setRarity(Blocks.field_150369_x.func_176223_P(), EnumRarity.RARE);
        CaveVeinProvider.setRarity(Blocks.field_150412_bA.func_176223_P(), EnumRarity.RARE);
        CaveVeinProvider.setRarity(Blocks.field_150482_ag.func_176223_P(), EnumRarity.EPIC);
        CaveVeinProvider.setRarity(CaveBlocks.CAVE_BLOCK.func_176203_a(BlockCave.EnumType.AQUAMARINE_ORE.getMetadata()), EnumRarity.UNCOMMON);
        CaveVeinProvider.setRarity(CaveBlocks.CAVE_BLOCK.func_176203_a(BlockCave.EnumType.MAGNITE_ORE.getMetadata()), EnumRarity.COMMON);
        CaveVeinProvider.setRarity(CaveBlocks.CAVE_BLOCK.func_176203_a(BlockCave.EnumType.RANDOMITE_ORE.getMetadata()), EnumRarity.UNCOMMON);
        CaveVeinProvider.setRarity(CaveBlocks.CAVE_BLOCK.func_176203_a(BlockCave.EnumType.HEXCITE_ORE.getMetadata()), EnumRarity.RARE);
        CaveVeinProvider.setRarity(CaveBlocks.CAVE_BLOCK.func_176203_a(BlockCave.EnumType.FISSURED_STONE.getMetadata()), EnumRarity.UNCOMMON);
    }
}

