/*
 * Decompiled with CFR 0.152.
 */
package cavern.world;

import cavern.block.BlockPortalCavern;
import cavern.block.CaveBlocks;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.common.util.INBTSerializable;

public class CavePortalList
implements INBTSerializable<NBTTagCompound> {
    private final SetMultimap<BlockPortalCavern, BlockPos> cavePortals = HashMultimap.create();

    public boolean addPortal(BlockPortalCavern portal, BlockPos pos) {
        return !this.hasPortal(portal, pos.func_177958_n() << 4, pos.func_177952_p() << 4) && this.cavePortals.put((Object)portal, (Object)pos);
    }

    public boolean removePortal(BlockPortalCavern portal, BlockPos pos) {
        return this.cavePortals.remove((Object)portal, (Object)pos);
    }

    public ImmutableSet<BlockPos> getPortalPositions() {
        return ImmutableSet.copyOf((Collection)this.cavePortals.values());
    }

    public ImmutableSet<BlockPos> getPortalPositions(BlockPortalCavern portal) {
        return ImmutableSet.copyOf((Collection)this.cavePortals.get((Object)portal));
    }

    public boolean hasPortal(int chunkX, int chunkZ) {
        return this.cavePortals.values().stream().anyMatch(pos -> pos.func_177958_n() >> 4 == chunkX && pos.func_177952_p() >> 4 == chunkZ);
    }

    public boolean hasPortal(ChunkPos pos) {
        return this.hasPortal(pos.field_77276_a, pos.field_77275_b);
    }

    public boolean hasPortal(BlockPortalCavern portal, int chunkX, int chunkZ) {
        return this.cavePortals.get((Object)portal).stream().anyMatch(pos -> pos.func_177958_n() >> 4 == chunkX && pos.func_177952_p() >> 4 == chunkZ);
    }

    public boolean isPortalEmpty() {
        return this.cavePortals.values().isEmpty();
    }

    public boolean isPortalEmpty(BlockPortalCavern portal) {
        return this.cavePortals.get((Object)portal).isEmpty();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (BlockPortalCavern portal : CaveBlocks.PORTALS) {
            NBTTagList list = new NBTTagList();
            for (BlockPos pos : this.cavePortals.get((Object)portal)) {
                list.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
            }
            nbt.func_74782_a(portal.getRegistryName().toString(), (NBTBase)list);
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        for (BlockPortalCavern portal : CaveBlocks.PORTALS) {
            NBTTagList list = nbt.func_150295_c(portal.getRegistryName().toString(), 10);
            for (NBTBase entry : list) {
                this.cavePortals.put((Object)portal, (Object)NBTUtil.func_186861_c((NBTTagCompound)((NBTTagCompound)entry)));
            }
        }
    }
}

