/*
 * Decompiled with CFR 0.152.
 */
package cavern.world;

import cavern.api.CavernAPI;
import cavern.config.AquaCavernConfig;
import cavern.config.CavelandConfig;
import cavern.config.CaveniaConfig;
import cavern.config.CavernConfig;
import cavern.config.HugeCavernConfig;
import cavern.config.MirageWorldsConfig;
import cavern.core.Cavern;
import cavern.item.CaveItems;
import cavern.world.WorldProviderAquaCavern;
import cavern.world.WorldProviderCavern;
import cavern.world.WorldProviderHugeCavern;
import cavern.world.mirage.WorldProviderCaveland;
import cavern.world.mirage.WorldProviderCavenia;
import cavern.world.mirage.WorldProviderCrownCliffs;
import cavern.world.mirage.WorldProviderDarkForest;
import cavern.world.mirage.WorldProviderFrostMountains;
import cavern.world.mirage.WorldProviderSkyland;
import cavern.world.mirage.WorldProviderVoid;
import cavern.world.mirage.WorldProviderWideDesert;
import javax.annotation.Nullable;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;

public final class CaveDimensions {
    public static DimensionType CAVERN;
    public static DimensionType HUGE_CAVERN;
    public static DimensionType AQUA_CAVERN;
    public static DimensionType CAVELAND;
    public static DimensionType CAVENIA;
    public static DimensionType FROST_MOUNTAINS;
    public static DimensionType WIDE_DESERT;
    public static DimensionType THE_VOID;
    public static DimensionType DARK_FOREST;
    public static DimensionType CROWN_CLIFFS;
    public static DimensionType SKYLAND;

    @Nullable
    private static DimensionType register(String name, int id, Class<? extends WorldProvider> provider) {
        if (id == 0 || DimensionManager.isDimensionRegistered((int)id)) {
            return null;
        }
        DimensionType type = DimensionType.register((String)name, (String)("_" + name.replace(" ", "_").toLowerCase()), (int)id, provider, (boolean)false);
        DimensionManager.registerDimension((int)id, (DimensionType)type);
        return type;
    }

    public static void registerDimensions() {
        CAVERN = CaveDimensions.register("cavern", CavernConfig.dimensionId, WorldProviderCavern.class);
        HUGE_CAVERN = CaveDimensions.register("huge_cavern", HugeCavernConfig.dimensionId, WorldProviderHugeCavern.class);
        AQUA_CAVERN = CaveDimensions.register("aqua_cavern", AquaCavernConfig.dimensionId, WorldProviderAquaCavern.class);
        CAVELAND = CaveDimensions.register("caveland", CavelandConfig.dimensionId, WorldProviderCaveland.class);
        CAVENIA = CaveDimensions.register("cavenia", CaveniaConfig.dimensionId, WorldProviderCavenia.class);
        FROST_MOUNTAINS = CaveDimensions.register("frost_mountains", MirageWorldsConfig.frostMountains, WorldProviderFrostMountains.class);
        WIDE_DESERT = CaveDimensions.register("wide_desert", MirageWorldsConfig.wideDesert, WorldProviderWideDesert.class);
        THE_VOID = CaveDimensions.register("the_void", MirageWorldsConfig.theVoid, WorldProviderVoid.class);
        DARK_FOREST = CaveDimensions.register("dark_forest", MirageWorldsConfig.darkForest, WorldProviderDarkForest.class);
        CROWN_CLIFFS = CaveDimensions.register("crown_cliffs", MirageWorldsConfig.crownCliffs, WorldProviderCrownCliffs.class);
        SKYLAND = CaveDimensions.register("skyland", MirageWorldsConfig.skyland, WorldProviderSkyland.class);
    }

    public static String getLocalizedName(@Nullable DimensionType type) {
        if (type == null) {
            return null;
        }
        if (type == CAVERN) {
            return Cavern.proxy.translate("dimension.cavern.name");
        }
        if (type == HUGE_CAVERN) {
            return Cavern.proxy.translate("dimension.hugeCavern.name");
        }
        if (type == AQUA_CAVERN) {
            return Cavern.proxy.translate("dimension.aquaCavern.name");
        }
        String suffix = CaveItems.MIRAGE_BOOK.func_77658_a();
        if (type == CAVELAND) {
            return Cavern.proxy.translate(suffix + ".caveland.name");
        }
        if (type == CAVENIA) {
            return Cavern.proxy.translate(suffix + ".cavenia.name");
        }
        if (type == FROST_MOUNTAINS) {
            return Cavern.proxy.translate(suffix + ".frostMountains.name");
        }
        if (type == WIDE_DESERT) {
            return Cavern.proxy.translate(suffix + ".wideDesert.name");
        }
        if (type == THE_VOID) {
            return Cavern.proxy.translate(suffix + ".theVoid.name");
        }
        if (type == DARK_FOREST) {
            return Cavern.proxy.translate(suffix + ".darkForest.name");
        }
        if (type == CROWN_CLIFFS) {
            return Cavern.proxy.translate(suffix + ".crownCliffs.name");
        }
        if (type == SKYLAND) {
            return Cavern.proxy.translate(suffix + ".skyland.name");
        }
        if (CavernAPI.dimension.isMirageWorlds(type)) {
            return Cavern.proxy.translate("dimension.mirageWorlds.name");
        }
        return type.func_186065_b();
    }
}

