/*
 * Decompiled with CFR 0.152.
 */
package cavern.world;

import cavern.config.manager.CaveBiome;
import cavern.config.manager.CaveBiomeManager;
import cavern.util.CaveUtils;
import cavern.world.CaveBiomeCache;
import cavern.world.gen.GenLayerCaveBiomes;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.init.Biomes;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import org.apache.commons.lang3.tuple.Pair;

public class CaveBiomeProvider
extends BiomeProvider {
    private final World world;
    private final CaveBiomeCache biomeCache;
    private final CaveBiomeManager biomeManager;
    private Pair<Long, List<CaveBiome>> cachedBiomes;

    public CaveBiomeProvider(World world, CaveBiomeManager biomeManager) {
        this.world = world;
        this.biomeCache = new CaveBiomeCache(this, 512, true);
        this.biomeManager = biomeManager;
        this.makeLayers(world.func_72905_C());
    }

    private void makeLayers(long seed) {
        GenLayerCaveBiomes layer = new GenLayerCaveBiomes(() -> this.getRandomBiome(), 1L);
        layer = new GenLayerZoom(1000L, (GenLayer)layer);
        layer = new GenLayerZoom(1001L, (GenLayer)layer);
        layer = new GenLayerZoom(1002L, (GenLayer)layer);
        layer = new GenLayerZoom(1003L, (GenLayer)layer);
        layer = new GenLayerZoom(1004L, (GenLayer)layer);
        GenLayerVoronoiZoom voronoi = new GenLayerVoronoiZoom(10L, (GenLayer)layer);
        layer.func_75905_a(seed);
        voronoi.func_75905_a(seed);
        CaveUtils.setPrivateValue(BiomeProvider.class, this, layer, "genBiomes", "field_76944_d");
        CaveUtils.setPrivateValue(BiomeProvider.class, this, voronoi, "biomeIndexLayer", "field_76945_e");
    }

    public List<Biome> func_76932_a() {
        return Lists.newArrayList(this.biomeManager.getCaveBiomes().keySet());
    }

    @Nonnull
    public Biome getRandomBiome() {
        CaveBiome biome = (CaveBiome)WeightedRandom.func_76271_a((Random)this.world.field_73012_v, this.getCachedBiomes());
        if (biome == null) {
            return Biomes.field_76772_c;
        }
        return biome.getBiome();
    }

    public List<CaveBiome> getCachedBiomes() {
        long time = this.world.func_72912_H().func_82573_f();
        if (this.cachedBiomes == null || (Long)this.cachedBiomes.getLeft() + 400L < time) {
            this.cachedBiomes = Pair.of((Object)time, (Object)Lists.newArrayList(this.biomeManager.getCaveBiomes().values()));
        }
        return (List)this.cachedBiomes.getRight();
    }

    public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
        return this.getBiomesForGeneration(biomes, x, z, width, height, true);
    }

    public Biome[] getBiomesForGeneration(Biome[] biomes, int x, int z, int width, int height, boolean cache) {
        if (cache && this.biomeCache.isGridAligned(x, z, width, height)) {
            Biome[] cached = this.biomeCache.getBiomes(x, z);
            return Arrays.copyOf(cached, cached.length);
        }
        return super.func_76937_a(biomes, x, z, width, height);
    }

    public void func_76938_b() {
        this.biomeCache.cleanup();
        super.func_76938_b();
    }
}

