/*
 * Decompiled with CFR 0.152.
 */
package cavern.util;

import cavern.core.Cavern;
import cavern.util.CaveUtils;
import com.google.common.base.Strings;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class Version {
    public static ForgeVersion.CheckResult getResult() {
        return ForgeVersion.getResult((ModContainer)CaveUtils.getModContainer());
    }

    public static ForgeVersion.Status getStatus() {
        return Version.getResult().status;
    }

    @Nullable
    public static ComparableVersion getTarget() {
        return Version.getResult().target;
    }

    public static String getCurrent() {
        return Strings.nullToEmpty((String)Cavern.metadata.version);
    }

    public static ComparableVersion getLatest() {
        return (ComparableVersion)ObjectUtils.defaultIfNull((Object)Version.getTarget(), (Object)new ComparableVersion(Version.getCurrent()));
    }

    public static boolean isOutdated() {
        return Version.getStatus() == ForgeVersion.Status.OUTDATED || Version.getStatus() == ForgeVersion.Status.BETA_OUTDATED;
    }

    public static boolean isDev() {
        return FMLLaunchHandler.isDeobfuscatedEnvironment();
    }

    public static boolean isBeta() {
        return StringUtils.containsIgnoreCase((CharSequence)Version.getCurrent(), (CharSequence)"beta");
    }

    public static boolean isAlpha() {
        return StringUtils.containsIgnoreCase((CharSequence)Version.getCurrent(), (CharSequence)"alpha");
    }
}

