/*
 * Decompiled with CFR 0.152.
 */
package cavern.util;

import cavern.network.CaveNetworkRegistry;
import cavern.network.client.ToastMessage;
import cavern.util.CaveUtils;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class PlayerHelper {
    public static boolean grantAdvancement(EntityPlayer entityPlayer, String key) {
        return PlayerHelper.grantCriterion(entityPlayer, key, key);
    }

    public static boolean grantCriterion(EntityPlayer entityPlayer, String key, String criterion) {
        if (entityPlayer == null || !(entityPlayer instanceof EntityPlayerMP)) {
            return false;
        }
        EntityPlayerMP player = (EntityPlayerMP)entityPlayer;
        Advancement advancement = player.field_71133_b.func_191949_aK().func_192778_a(CaveUtils.getKey(key));
        return advancement != null && player.func_192039_O().func_192750_a(advancement, criterion);
    }

    public static boolean grantToast(EntityPlayer player, String key) {
        if (PlayerHelper.grantCriterion(player, "toasts/" + key, key)) {
            CaveNetworkRegistry.sendTo(() -> new ToastMessage(key), player);
            return true;
        }
        return false;
    }

    public static EntityPlayer.SleepResult trySleep(EntityPlayer player, BlockPos pos) {
        World world = player.field_70170_p;
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
        if (!world.field_72995_K) {
            if (player.func_70608_bn() || !player.func_70089_S()) {
                return EntityPlayer.SleepResult.OTHER_PROBLEM;
            }
            if (!PlayerHelper.bedInRange((Entity)player, pos, facing)) {
                return EntityPlayer.SleepResult.TOO_FAR_AWAY;
            }
            List list = world.func_72872_a(EntityMob.class, new AxisAlignedBB((double)pos.func_177958_n() - 8.0, (double)pos.func_177956_o() - 5.0, (double)pos.func_177952_p() - 8.0, (double)pos.func_177958_n() + 8.0, (double)pos.func_177956_o() + 5.0, (double)pos.func_177952_p() + 8.0));
            if (!list.isEmpty()) {
                return EntityPlayer.SleepResult.NOT_SAFE;
            }
        }
        if (player.func_184218_aH()) {
            player.func_184210_p();
        }
        PlayerHelper.setSize((Entity)player, 0.2f, 0.2f);
        IBlockState state = null;
        if (world.func_175667_e(pos)) {
            state = world.func_180495_p(pos);
        }
        if (state != null && state.func_177230_c().isBed(state, (IBlockAccess)world, pos, (Entity)player)) {
            float offsetX = 0.5f + (float)facing.func_82601_c() * 0.4f;
            float offsetZ = 0.5f + (float)facing.func_82599_e() * 0.4f;
            PlayerHelper.setRenderOffsetForSleep(player, facing);
            player.func_70107_b((double)((float)pos.func_177958_n() + offsetX), (double)((float)pos.func_177956_o() + 0.6875f), (double)((float)pos.func_177952_p() + offsetZ));
        } else {
            player.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.6875f), (double)((float)pos.func_177952_p() + 0.5f));
        }
        CaveUtils.setPrivateValue(EntityPlayer.class, player, true, "sleeping", "field_71083_bS");
        CaveUtils.setPrivateValue(EntityPlayer.class, player, 0, "sleepTimer", "field_71076_b");
        player.field_71081_bT = pos;
        player.field_70159_w = 0.0;
        player.field_70181_x = 0.0;
        player.field_70179_y = 0.0;
        if (!world.field_72995_K) {
            world.func_72854_c();
        }
        return EntityPlayer.SleepResult.OK;
    }

    public static boolean bedInRange(Entity entity, BlockPos pos, EnumFacing facing) {
        if (Math.abs(entity.field_70165_t - (double)pos.func_177958_n()) <= 3.0 && Math.abs(entity.field_70163_u - (double)pos.func_177956_o()) <= 2.0 && Math.abs(entity.field_70161_v - (double)pos.func_177952_p()) <= 3.0) {
            return true;
        }
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        return Math.abs(entity.field_70165_t - (double)blockpos.func_177958_n()) <= 3.0 && Math.abs(entity.field_70163_u - (double)blockpos.func_177956_o()) <= 2.0 && Math.abs(entity.field_70161_v - (double)blockpos.func_177952_p()) <= 3.0;
    }

    public static void setSize(Entity entity, float width, float height) {
        if (width != entity.field_70130_N || height != entity.field_70131_O) {
            boolean firstUpdate;
            float f = entity.field_70130_N;
            entity.field_70130_N = width;
            entity.field_70131_O = height;
            if (entity.field_70130_N < f) {
                double half = (double)width / 2.0;
                entity.func_174826_a(new AxisAlignedBB(entity.field_70165_t - half, entity.field_70163_u, entity.field_70161_v - half, entity.field_70165_t + half, entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v + half));
                return;
            }
            AxisAlignedBB box = entity.func_174813_aQ();
            entity.func_174826_a(new AxisAlignedBB(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72340_a + (double)entity.field_70130_N, box.field_72338_b + (double)entity.field_70131_O, box.field_72339_c + (double)entity.field_70130_N));
            if (entity.field_70130_N > f && !entity.field_70170_p.field_72995_K && !(firstUpdate = ((Boolean)CaveUtils.getPrivateValue(Entity.class, entity, "firstUpdate", "field_70148_d")).booleanValue())) {
                entity.func_70091_d(MoverType.SELF, (double)(f - entity.field_70130_N), 0.0, (double)(f - entity.field_70130_N));
            }
        }
    }

    public static void setRenderOffsetForSleep(EntityPlayer player, EnumFacing facing) {
        player.field_71079_bU = -1.8f * (float)facing.func_82601_c();
        player.field_71089_bV = -1.8f * (float)facing.func_82599_e();
    }
}

