/*
 * Decompiled with CFR 0.152.
 */
package cavern.util;

import cavern.util.CaveUtils;
import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.ObjectUtils;

public class ItemMeta
implements Comparable<ItemMeta> {
    private final Item item;
    private final int meta;

    public ItemMeta(Item item, int meta) {
        this.item = item;
        this.meta = meta;
    }

    public ItemMeta(ItemStack stack) {
        this(stack.func_77973_b(), stack.func_77960_j());
    }

    public ItemMeta(String name, int meta) {
        this((Item)ObjectUtils.defaultIfNull((Object)Item.func_111206_d((String)name), (Object)Items.field_190931_a), meta);
    }

    @Nonnull
    public Item getItem() {
        return this.item;
    }

    public int getMeta() {
        return this.meta;
    }

    public boolean getHasSubtypes() {
        return this.item.func_77614_k();
    }

    public ItemStack getItemStack() {
        return this.getItemStack(1);
    }

    public ItemStack getItemStack(int amount) {
        return this.isEmpty() ? ItemStack.field_190927_a : new ItemStack(this.item, amount, this.meta);
    }

    public boolean isEmpty() {
        return this.item == null || this.item == Items.field_190931_a;
    }

    public String getItemName() {
        return this.item.getRegistryName().toString();
    }

    public String getName() {
        String name = this.getItemName();
        if (this.meta < 0 || this.meta == Short.MAX_VALUE || !this.item.func_77614_k()) {
            return name;
        }
        return name + ":" + this.meta;
    }

    public String toString() {
        String name = this.getItemName();
        if (!this.item.func_77614_k()) {
            return name;
        }
        if (this.meta < 0 || this.meta == Short.MAX_VALUE) {
            return name + ",meta=all";
        }
        return name + ",meta=" + this.meta;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ItemMeta)) {
            return false;
        }
        ItemMeta itemMeta = (ItemMeta)obj;
        if (this.item != itemMeta.item) {
            return false;
        }
        if (!this.item.func_77614_k() && !itemMeta.item.func_77614_k()) {
            return true;
        }
        if (this.meta < 0 || this.meta == Short.MAX_VALUE || itemMeta.meta < 0 || itemMeta.meta == Short.MAX_VALUE) {
            return true;
        }
        return this.meta == itemMeta.meta;
    }

    public int hashCode() {
        if (!this.item.func_77614_k() || this.meta < 0 || this.meta == Short.MAX_VALUE) {
            return this.item.hashCode();
        }
        return Objects.hashCode((Object[])new Object[]{this.item, this.meta});
    }

    @Override
    public int compareTo(ItemMeta itemMeta) {
        int i = CaveUtils.compareWithNull(this, itemMeta);
        if (i == 0 && itemMeta != null) {
            i = this.getName().compareTo(itemMeta.getName());
        }
        return i;
    }
}

