/*
 * Decompiled with CFR 0.152.
 */
package cavern.util;

import cavern.util.CaveUtils;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.IStringSerializable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BlockMeta
implements Comparable<BlockMeta> {
    private final Block block;
    private int meta;
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[0-9]+$");
    private static final LoadingCache<Pair<Block, String>, Integer> STRING_META_CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Pair<Block, String>, Integer>(){

        public Integer load(Pair<Block, String> key) throws Exception {
            Block block = (Block)key.getLeft();
            String str = (String)key.getRight();
            if (block == null || Strings.isNullOrEmpty((String)str) || str.equalsIgnoreCase("all") || str.equalsIgnoreCase("null")) {
                return -1;
            }
            str = str.trim();
            if (NUMBER_PATTERN.matcher(str).matches()) {
                try {
                    return Integer.parseInt(str, 10);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Class clazz = null;
            for (Field field : block.getClass().getDeclaredFields()) {
                if ((field.getModifiers() & 1) == 0 || (field.getModifiers() & 8) == 0 || field.getType() != PropertyEnum.class) continue;
                try {
                    clazz = ((PropertyEnum)field.get(null)).func_177699_b();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                return -1;
            }
            for (Field obj : clazz.getEnumConstants()) {
                String name;
                if (!(obj instanceof IStringSerializable) || !str.equalsIgnoreCase(name = ((IStringSerializable)obj).func_176610_l())) continue;
                for (Method method : obj.getClass().getDeclaredMethods()) {
                    if (method.getReturnType() != Integer.TYPE || method.getParameterTypes().length != 0) continue;
                    try {
                        return (Integer)method.invoke((Object)obj, new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return -1;
        }
    });
    private static final LoadingCache<Pair<Block, Integer>, String> META_STRING_CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Pair<Block, Integer>, String>(){

        public String load(Pair<Block, Integer> key) throws Exception {
            Block block = (Block)key.getLeft();
            int meta = (Integer)key.getRight();
            if (block == null) {
                return null;
            }
            if (meta < 0) {
                return "all";
            }
            Class clazz = null;
            for (Field field : block.getClass().getDeclaredFields()) {
                if ((field.getModifiers() & 1) == 0 || (field.getModifiers() & 8) == 0 || field.getType() != PropertyEnum.class) continue;
                try {
                    clazz = ((PropertyEnum)field.get(null)).func_177699_b();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                return "null";
            }
            for (Field obj : clazz.getEnumConstants()) {
                if (!(obj instanceof IStringSerializable)) continue;
                String name = ((IStringSerializable)obj).func_176610_l();
                for (Method method : obj.getClass().getDeclaredMethods()) {
                    if (method.getReturnType() != Integer.TYPE || method.getParameterTypes().length != 0) continue;
                    try {
                        if ((Integer)method.invoke((Object)obj, new Object[0]) != meta) continue;
                        return name;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return "null";
        }
    });

    public BlockMeta(Block block, int meta) {
        this.block = block;
        this.meta = meta;
    }

    public BlockMeta(IBlockState state) {
        this(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
    }

    public BlockMeta(String name, int meta) {
        this((Block)ObjectUtils.defaultIfNull((Object)Block.func_149684_b((String)name), (Object)Blocks.field_150350_a), meta);
    }

    public BlockMeta(String name, String meta) {
        this(name, -1);
        this.meta = BlockMeta.getMetaFromString(this.block, meta);
    }

    @Nonnull
    public Block getBlock() {
        return this.block;
    }

    public boolean isNotAir() {
        return !(this.block instanceof BlockAir);
    }

    public int getMeta() {
        return this.meta;
    }

    public IBlockState getBlockState() {
        return this.block.func_176203_a(this.meta);
    }

    public String getBlockName() {
        return this.block.getRegistryName().toString();
    }

    public String getMetaName() {
        return BlockMeta.getMetaName(this.block, this.meta);
    }

    public String getMetaString() {
        return BlockMeta.getMetaString(this.block, this.meta);
    }

    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean metaName) {
        String name = this.getBlockName();
        if (this.meta < 0 || this.meta == Short.MAX_VALUE || !Item.func_150898_a((Block)this.block).func_77614_k()) {
            return name;
        }
        return name + ":" + (metaName ? this.getMetaString() : Integer.valueOf(this.meta));
    }

    public String toString() {
        String name = this.getBlockName();
        if (!Item.func_150898_a((Block)this.block).func_77614_k()) {
            return name;
        }
        if (this.meta < 0 || this.meta == Short.MAX_VALUE) {
            return name + ",meta=all";
        }
        return name + ",meta=" + this.meta;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof BlockMeta)) {
            return false;
        }
        BlockMeta blockMeta = (BlockMeta)obj;
        if (this.block != blockMeta.block) {
            return false;
        }
        if (this.meta < 0 || this.meta == Short.MAX_VALUE || blockMeta.meta < 0 || blockMeta.meta == Short.MAX_VALUE) {
            return true;
        }
        if (!Item.func_150898_a((Block)this.block).func_77614_k() && !Item.func_150898_a((Block)blockMeta.block).func_77614_k()) {
            return true;
        }
        return this.meta == blockMeta.meta;
    }

    public int hashCode() {
        if (this.meta < 0 || this.meta == Short.MAX_VALUE || !Item.func_150898_a((Block)this.block).func_77614_k()) {
            return this.block.hashCode();
        }
        return Objects.hashCode((Object[])new Object[]{this.block, this.meta});
    }

    @Override
    public int compareTo(BlockMeta blockMeta) {
        int i = CaveUtils.compareWithNull(this, blockMeta);
        if (i == 0 && blockMeta != null) {
            i = this.getName().compareTo(blockMeta.getName());
        }
        return i;
    }

    public static int getMetaFromString(Block block, String str) {
        return (Integer)STRING_META_CACHE.getUnchecked((Object)Pair.of((Object)block, (Object)str));
    }

    public static String getMetaName(Block block, int meta) {
        if (block.getRegistryName().func_110624_b().equals("minecraft")) {
            return (String)META_STRING_CACHE.getUnchecked((Object)Pair.of((Object)block, (Object)meta));
        }
        return Integer.toString(meta);
    }

    public static String getMetaString(Block block, int meta) {
        String name = BlockMeta.getMetaName(block, meta);
        if (Strings.isNullOrEmpty((String)name) || name.equals("null")) {
            return Integer.toString(0);
        }
        return name;
    }
}

