/*
 * Decompiled with CFR 0.152.
 */
package cavern.network.server;

import cavern.api.data.IMiner;
import cavern.config.MiningAssistConfig;
import cavern.data.Miner;
import cavern.data.MinerRank;
import cavern.miningassist.MiningAssist;
import cavern.network.server.IPlayerMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MiningAssistMessage
implements IPlayerMessage<MiningAssistMessage, IMessage> {
    private MiningAssist assist;

    public MiningAssistMessage() {
    }

    public MiningAssistMessage(MiningAssist assist) {
        this.assist = assist;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        try {
            this.assist = MiningAssist.get(buf.readInt());
        }
        catch (IllegalArgumentException e) {
            this.assist = null;
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        if (this.assist != null) {
            buf.writeInt(this.assist.getType());
        }
    }

    @Override
    public IMessage process(EntityPlayerMP player) {
        IMiner miner = Miner.get((EntityPlayer)player);
        if (miner.getRank() < MiningAssistConfig.minerRank.getValue()) {
            TextComponentTranslation component = new TextComponentTranslation(MinerRank.get(MiningAssistConfig.minerRank.getValue()).getUnlocalizedName(), new Object[0]);
            component.func_150256_b().func_150217_b(Boolean.valueOf(true));
            component = new TextComponentTranslation("cavern.miningassist.toggle.failed.message", new Object[]{component});
            component.func_150256_b().func_150238_a(TextFormatting.RED);
            player.func_145747_a((ITextComponent)component);
        } else {
            if (this.assist == null) {
                miner.toggleMiningAssist();
            } else {
                miner.setMiningAssist(this.assist.getType());
            }
            miner.adjustData();
            TextComponentTranslation component = new TextComponentTranslation(MiningAssist.get(miner.getMiningAssist()).getUnlocalizedName(), new Object[0]);
            component.func_150256_b().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.valueOf(true));
            component = new TextComponentTranslation("cavern.miningassist.toggle.message", new Object[]{component});
            player.func_145747_a((ITextComponent)component);
        }
        return null;
    }
}

