/*
 * Decompiled with CFR 0.152.
 */
package cavern.network.client;

import cavern.api.data.IMiner;
import cavern.data.Miner;
import cavern.network.client.IPlayerMessage;
import cavern.util.BlockMeta;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.GameData;

public class MiningRecordsMessage
implements IPlayerMessage<MiningRecordsMessage, IMessage> {
    private Map<BlockMeta, Integer> records;

    public MiningRecordsMessage() {
    }

    public MiningRecordsMessage(IMiner stats) {
        this.records = stats.getMiningRecords();
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.records = Maps.newHashMap();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            IBlockState state = (IBlockState)GameData.getBlockStateIDMap().func_148745_a(buf.readInt());
            int count = buf.readInt();
            this.records.put(new BlockMeta(state), count);
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.records.size());
        for (Map.Entry<BlockMeta, Integer> record : this.records.entrySet()) {
            buf.writeInt(GameData.getBlockStateIDMap().func_148747_b((Object)record.getKey().getBlockState()));
            buf.writeInt(record.getValue().intValue());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IMessage process(EntityPlayerSP player) {
        IMiner miner = Miner.get((EntityPlayer)player, true);
        if (miner != null) {
            for (Map.Entry<BlockMeta, Integer> record : this.records.entrySet()) {
                miner.setMiningRecord(record.getKey(), record.getValue());
            }
        }
        return null;
    }
}

