/*
 * Decompiled with CFR 0.152.
 */
package cavern.network;

import cavern.network.client.CustomSeedMessage;
import cavern.network.client.ExplosionMessage;
import cavern.network.client.FallTeleportMessage;
import cavern.network.client.MagicCancelMessage;
import cavern.network.client.MinerDataMessage;
import cavern.network.client.MiningMessage;
import cavern.network.client.MiningRecordsGuiMessage;
import cavern.network.client.MiningRecordsMessage;
import cavern.network.client.MirageSelectMessage;
import cavern.network.client.RegenerationGuiMessage;
import cavern.network.client.ToastMessage;
import cavern.network.server.MagicBookMessage;
import cavern.network.server.MagicInvisibleMessage;
import cavern.network.server.MagicResultMessage;
import cavern.network.server.MiningAssistMessage;
import cavern.network.server.MirageTeleportMessage;
import cavern.network.server.RegenerationMessage;
import cavern.network.server.SpecialMagicMessage;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public final class CaveNetworkRegistry {
    public static final SimpleNetworkWrapper NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("cavern");

    private static <REQ extends IMessage, REPLY extends IMessage> void registerMessage(Class<? extends IMessageHandler<REQ, REPLY>> messageHandler, Class<REQ> requestMessageType, int id, Side side) {
        NETWORK.registerMessage(messageHandler, requestMessageType, id, side);
    }

    public static void sendTo(Supplier<IMessage> message, @Nullable EntityPlayer player) {
        if (player != null && player instanceof EntityPlayerMP && !(player instanceof FakePlayer)) {
            NETWORK.sendTo(message.get(), (EntityPlayerMP)player);
        }
    }

    public static void registerMessages() {
        int id = 0;
        CaveNetworkRegistry.registerMessage(CustomSeedMessage.class, CustomSeedMessage.class, id++, Side.CLIENT);
        CaveNetworkRegistry.registerMessage(MiningMessage.class, MiningMessage.class, id++, Side.CLIENT);
        CaveNetworkRegistry.registerMessage(MinerDataMessage.class, MinerDataMessage.class, id++, Side.CLIENT);
        CaveNetworkRegistry.registerMessage(MiningRecordsMessage.class, MiningRecordsMessage.class, id++, Side.CLIENT);
        CaveNetworkRegistry.registerMessage(RegenerationGuiMessage.class, RegenerationGuiMessage.class, id++, Side.CLIENT);
        CaveNetworkRegistry.registerMessage(MiningRecordsGuiMessage.class, MiningRecordsGuiMessage.class, id++, Side.CLIENT);
        CaveNetworkRegistry.registerMessage(ToastMessage.class, ToastMessage.class, id++, Side.CLIENT);
        CaveNetworkRegistry.registerMessage(MirageSelectMessage.class, MirageSelectMessage.class, id++, Side.CLIENT);
        CaveNetworkRegistry.registerMessage(MagicCancelMessage.class, MagicCancelMessage.class, id++, Side.CLIENT);
        CaveNetworkRegistry.registerMessage(ExplosionMessage.class, ExplosionMessage.class, id++, Side.CLIENT);
        CaveNetworkRegistry.registerMessage(FallTeleportMessage.class, FallTeleportMessage.class, id++, Side.CLIENT);
        CaveNetworkRegistry.registerMessage(RegenerationMessage.class, RegenerationMessage.class, id++, Side.SERVER);
        CaveNetworkRegistry.registerMessage(MiningAssistMessage.class, MiningAssistMessage.class, id++, Side.SERVER);
        CaveNetworkRegistry.registerMessage(MirageTeleportMessage.class, MirageTeleportMessage.class, id++, Side.SERVER);
        CaveNetworkRegistry.registerMessage(MagicBookMessage.class, MagicBookMessage.class, id++, Side.SERVER);
        CaveNetworkRegistry.registerMessage(MagicResultMessage.class, MagicResultMessage.class, id++, Side.SERVER);
        CaveNetworkRegistry.registerMessage(MagicInvisibleMessage.class, MagicInvisibleMessage.class, id++, Side.SERVER);
        CaveNetworkRegistry.registerMessage(SpecialMagicMessage.class, SpecialMagicMessage.class, id++, Side.SERVER);
    }
}

