/*
 * Decompiled with CFR 0.152.
 */
package cavern.miningassist;

import cavern.config.property.ConfigBlocks;
import cavern.util.CaveUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.ObjectUtils;

public abstract class MiningSnapshot
implements Comparator<BlockPos> {
    protected final World world;
    protected final BlockPos originPos;
    protected final IBlockState originState;
    protected EntityLivingBase miner;
    protected Set<BlockPos> miningTargets;
    protected float breakSpeed;

    public MiningSnapshot(World world, BlockPos pos, IBlockState state) {
        this.world = world;
        this.originPos = pos;
        this.originState = state;
    }

    public MiningSnapshot(World world, BlockPos pos, IBlockState state, EntityLivingBase entity) {
        this(world, pos, state);
        this.miner = entity;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getOriginPos() {
        return this.originPos;
    }

    public IBlockState getOriginState() {
        return this.originState;
    }

    @Nullable
    public EntityLivingBase getMiner() {
        return this.miner;
    }

    public boolean isChecked() {
        return this.miningTargets != null;
    }

    public boolean isEmpty() {
        return this.miningTargets == null || this.miningTargets.isEmpty();
    }

    public boolean equals(World worldIn, BlockPos pos) {
        if (worldIn == null || pos == null) {
            return false;
        }
        return this.world.field_73011_w.func_186058_p() == worldIn.field_73011_w.func_186058_p() && this.originPos.equals((Object)pos);
    }

    public int getTargetCount() {
        return this.isEmpty() ? 0 : this.miningTargets.size();
    }

    public Set<BlockPos> getTargets() {
        return (Set)ObjectUtils.defaultIfNull(this.miningTargets, Collections.emptySet());
    }

    @Nullable
    public ConfigBlocks getValidTargetBlocks() {
        return null;
    }

    public boolean hasValidTargetBlocks() {
        return this.getValidTargetBlocks() != null && !this.getValidTargetBlocks().isEmpty();
    }

    public void checkForMining() {
        this.breakSpeed = 0.0f;
        if (this.miningTargets != null && this.miner != null && this.miner instanceof EntityPlayer) {
            float origin;
            EntityPlayer player = (EntityPlayer)this.miner;
            int count = this.miningTargets.size();
            this.breakSpeed = player.getDigSpeed(this.originState, this.originPos);
            if (count <= 1) {
                return;
            }
            float max = origin = this.world.func_180495_p(this.originPos).func_185887_b(this.world, this.originPos);
            float total = 0.0f;
            for (BlockPos pos : this.miningTargets) {
                float hardness = this.world.func_180495_p(pos).func_185887_b(this.world, pos);
                if (hardness > max) {
                    max = hardness;
                }
                total += hardness;
            }
            this.breakSpeed /= total * 0.25f;
            float dist = max - origin;
            if (dist >= 5.0f) {
                this.breakSpeed /= dist * 0.05f;
            }
        }
    }

    public float getBreakSpeed() {
        return this.breakSpeed;
    }

    public boolean offer(BlockPos pos) {
        if (this.miningTargets == null) {
            return false;
        }
        if (this.validTarget(pos) && !this.miningTargets.contains(pos)) {
            return this.miningTargets.add(pos);
        }
        return false;
    }

    public boolean validTarget(BlockPos pos) {
        IBlockState state = this.world.func_180495_p(pos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)this.world, pos) || state.func_185887_b(this.world, pos) < 0.0f) {
            return false;
        }
        if (this.hasValidTargetBlocks()) {
            return this.getValidTargetBlocks().hasBlockState(state);
        }
        if (this.miner != null) {
            return this.miner.func_184614_ca().func_150998_b(state);
        }
        return CaveUtils.isBlockEqual(state, this.originState);
    }

    @Override
    public int compare(BlockPos o1, BlockPos o2) {
        int i = CaveUtils.compareWithNull(o1, o2);
        if (i == 0 && o1 != null && o2 != null && (i = Integer.compare(this.originPos.compareTo((Vec3i)o1), this.originPos.compareTo((Vec3i)o2))) == 0) {
            i = o1.compareTo((Vec3i)o2);
        }
        return i;
    }
}

