/*
 * Decompiled with CFR 0.152.
 */
package cavern.miningassist;

import cavern.capability.CaveCapabilities;
import cavern.config.MiningAssistConfig;
import cavern.miningassist.AditMiningSnapshot;
import cavern.miningassist.MiningAssist;
import cavern.miningassist.MiningSnapshot;
import cavern.miningassist.QuickMiningSnapshot;
import cavern.miningassist.RangedMiningSnapshot;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.commons.lang3.ObjectUtils;

public class MiningAssistUnit {
    private final EntityPlayer player;
    private MiningSnapshot snapshot;
    private boolean checking;
    private boolean breaking;
    private boolean captureDrops;
    private boolean captureExperiences;
    private Map<BlockPos, NonNullList<ItemStack>> capturedDrops;
    private Map<BlockPos, Integer> capturedExperiences;

    public MiningAssistUnit(EntityPlayer player) {
        this.player = player;
    }

    public MiningSnapshot getSnapshot(MiningAssist type, BlockPos pos, IBlockState state) {
        return this.getSnapshot(type, pos, state, true);
    }

    public MiningSnapshot getSnapshot(MiningAssist type, BlockPos pos, IBlockState state, boolean refresh) {
        if (this.snapshot == null || refresh && !this.snapshot.equals(this.player.field_70170_p, pos)) {
            if (MiningAssistConfig.priorityQuickMining && MiningAssist.QUICK.isEffectiveTarget(this.player.func_184614_ca(), state)) {
                this.snapshot = new QuickMiningSnapshot(this.player.field_70170_p, pos, state, (EntityLivingBase)this.player);
            } else {
                switch (type) {
                    case QUICK: 
                    case AUTO_QUICK: {
                        this.snapshot = new QuickMiningSnapshot(this.player.field_70170_p, pos, state, (EntityLivingBase)this.player);
                        break;
                    }
                    case RANGED: {
                        this.snapshot = new RangedMiningSnapshot(this.player.field_70170_p, pos, state, (EntityLivingBase)this.player);
                        break;
                    }
                    case ADIT: 
                    case AUTO_ADIT: {
                        this.snapshot = new AditMiningSnapshot(this.player.field_70170_p, pos, state, (EntityLivingBase)this.player);
                        break;
                    }
                }
            }
        }
        if (this.snapshot != null && !this.snapshot.isChecked()) {
            this.snapshot.checkForMining();
        }
        return this.snapshot;
    }

    @Nullable
    public MiningSnapshot getCachedSnapshot() {
        return this.snapshot;
    }

    public void clearCache() {
        this.snapshot = null;
    }

    public float getBreakSpeed(MiningSnapshot snapshot) {
        return snapshot.getBreakSpeed();
    }

    public boolean isChecking() {
        return this.checking;
    }

    public void setChecking(boolean state) {
        this.checking = state;
    }

    public boolean isBreaking() {
        return this.breaking;
    }

    public void setBreaking(boolean state) {
        this.breaking = state;
    }

    public boolean getCaptureDrops() {
        return this.captureDrops;
    }

    @Nullable
    public Map<BlockPos, NonNullList<ItemStack>> captureDrops(boolean value) {
        this.captureDrops = value;
        if (value) {
            this.capturedDrops = Maps.newHashMap();
            return null;
        }
        return this.capturedDrops;
    }

    public boolean addDrops(BlockPos pos, NonNullList<ItemStack> drops) {
        if (!this.captureDrops || this.capturedDrops == null || pos == null || drops == null || drops.isEmpty()) {
            return false;
        }
        this.capturedDrops.put(pos, drops);
        return true;
    }

    public boolean getCaptureExperiences() {
        return this.captureExperiences;
    }

    @Nullable
    public Map<BlockPos, Integer> captureExperiences(boolean value) {
        this.captureExperiences = value;
        if (value) {
            this.capturedExperiences = Maps.newHashMap();
            return null;
        }
        return this.capturedExperiences;
    }

    public boolean addExperience(BlockPos pos, int experience) {
        if (!this.captureExperiences || this.capturedExperiences == null || pos == null || experience <= 0) {
            return false;
        }
        this.capturedExperiences.put(pos, experience);
        return true;
    }

    public static MiningAssistUnit get(EntityPlayer player) {
        return (MiningAssistUnit)ObjectUtils.defaultIfNull((Object)CaveCapabilities.getCapability((ICapabilityProvider)player, CaveCapabilities.MINING_ASSIST), (Object)new MiningAssistUnit(player));
    }
}

