/*
 * Decompiled with CFR 0.152.
 */
package cavern.magic;

import cavern.entity.monster.EntitySummonCavenicSkeleton;
import cavern.entity.monster.EntitySummonCavenicZombie;
import cavern.entity.monster.EntitySummonSkeleton;
import cavern.entity.monster.EntitySummonZombie;
import cavern.handler.CaveEventHooks;
import cavern.magic.Magic;
import cavern.util.PlayerHelper;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class MagicSummon
extends Magic {
    private int count;

    public MagicSummon(World world, EntityPlayer player, EnumHand hand) {
        super(world, player, hand);
    }

    @Override
    public long getSpellTime() {
        return 8000L;
    }

    @Override
    public ActionResult<ITextComponent> fireMagic() {
        if (!this.world.field_72995_K) {
            int chance = MathHelper.func_76125_a((int)(this.isOverload() ? 3 : CaveEventHooks.RANDOM.nextInt(3) + 1), (int)1, (int)this.getMana());
            for (int i = 0; i < chance; ++i) {
                if (!this.fireSummonMagic()) continue;
                ++this.count;
            }
            if (this.count <= 0) {
                return new ActionResult(EnumActionResult.FAIL, null);
            }
            PlayerHelper.grantAdvancement(this.player, "magic_summon");
            return new ActionResult(EnumActionResult.SUCCESS, null);
        }
        return new ActionResult(EnumActionResult.PASS, null);
    }

    @Override
    public int getCost() {
        return this.count;
    }

    @Override
    public boolean canOverload() {
        return true;
    }

    public boolean fireSummonMagic() {
        BlockPos summonPos;
        Vec3d hitVec = ForgeHooks.rayTraceEyeHitVec((EntityLivingBase)this.player, (double)5.0);
        if (hitVec != null && (summonPos = this.getSummonPos(new BlockPos(hitVec.field_72450_a, hitVec.field_72448_b + 1.0, hitVec.field_72449_c))) != null) {
            this.summon(summonPos);
            return true;
        }
        BlockPos origin = this.player.func_180425_c();
        EnumFacing frontFace = this.player.func_174811_aO();
        for (int i = 0; i < 3; ++i) {
            summonPos = this.getSummonPos(origin.func_177967_a(frontFace, i));
            if (summonPos == null) continue;
            this.summon(summonPos);
            return true;
        }
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)origin.func_177982_a(2, 0, 2), (BlockPos)origin.func_177982_a(-2, 0, -2))) {
            summonPos = this.getSummonPos(pos);
            if (summonPos == null) continue;
            this.summon(summonPos);
            return true;
        }
        return false;
    }

    @Nullable
    public BlockPos getSummonPos(BlockPos checkPos) {
        int diff;
        BlockPos pos = checkPos;
        if (this.world.func_175623_d(pos)) {
            for (diff = 0; diff < 5 && this.world.func_175623_d(pos); ++diff) {
                pos = pos.func_177977_b();
            }
            pos = pos.func_177984_a();
        } else {
            while (diff < 5 && !this.world.func_175623_d(pos)) {
                pos = pos.func_177984_a();
                ++diff;
            }
        }
        if (!this.world.func_175623_d(pos) || !this.world.func_175623_d(pos.func_177984_a()) || this.world.func_175623_d(pos.func_177977_b())) {
            return null;
        }
        if (!this.world.func_72855_b(new AxisAlignedBB(pos))) {
            return null;
        }
        if (this.world.func_147447_a(new Vec3d(this.player.field_70165_t, this.player.field_70163_u + (double)this.player.func_70047_e(), this.player.field_70161_v), new Vec3d((Vec3i)pos), false, true, false) != null) {
            return null;
        }
        BlockPos blockpos = this.player.func_180425_c();
        double prev = pos.func_177951_i((Vec3i)blockpos);
        if (prev - pos.func_177951_i((Vec3i)blockpos.func_177972_a(this.player.func_174811_aO())) < 0.0) {
            return null;
        }
        return pos;
    }

    public EntityLivingBase createSummonMob() {
        if (this.isOverload()) {
            return CaveEventHooks.RANDOM.nextInt(2) == 0 ? new EntitySummonCavenicSkeleton(this.world, this.player) : new EntitySummonCavenicZombie(this.world, this.player);
        }
        if (CaveEventHooks.RANDOM.nextDouble() < 0.3) {
            return new EntitySummonCavenicSkeleton(this.world, this.player);
        }
        if (CaveEventHooks.RANDOM.nextDouble() < 0.3) {
            return new EntitySummonCavenicZombie(this.world, this.player);
        }
        if (CaveEventHooks.RANDOM.nextDouble() < 0.5) {
            return new EntitySummonSkeleton(this.world, this.player);
        }
        return new EntitySummonZombie(this.world, this.player);
    }

    public void summon(BlockPos pos) {
        EntityLivingBase entity = this.createSummonMob();
        entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p() + 0.5, this.world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_180482_a(this.world.func_175649_E(pos), null);
        }
        this.world.func_72838_d((Entity)entity);
    }
}

