/*
 * Decompiled with CFR 0.152.
 */
package cavern.item;

import cavern.core.Cavern;
import cavern.entity.projectile.EntityRapidArrow;
import cavern.entity.projectile.EntityTorchArrow;
import cavern.util.CaveUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBowCavenic
extends ItemBow {
    public ItemBowCavenic() {
        this.func_77655_b("bowCavenic");
        this.func_77637_a(Cavern.TAB_CAVERN);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                if (entity == null || entity.func_184607_cu().func_77973_b() != ItemBowCavenic.this) {
                    return 0.0f;
                }
                return (float)(stack.func_77988_m() - entity.func_184605_cv()) / BowMode.byItemStack(stack).getPullingSpeed();
            }
        });
    }

    public BowMode toggleBowMode(ItemStack stack) {
        BowMode current = BowMode.byItemStack(stack);
        BowMode next = BowMode.byType(current.getType() + 1);
        stack.func_77983_a("Mode", (NBTBase)new NBTTagInt(next.getType()));
        return next;
    }

    public boolean onEntitySwing(EntityLivingBase entity, ItemStack stack) {
        this.toggleBowMode(stack);
        entity.func_184185_a(SoundEvents.field_187909_gi, 0.5f, 1.75f);
        if (entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_146105_b(this.getBowModeMessage(stack), true);
        }
        return false;
    }

    private ITextComponent getBowModeMessage(ItemStack stack) {
        BowMode mode = BowMode.byItemStack(stack);
        TextComponentTranslation name = new TextComponentTranslation(mode.getUnlocalizedName(stack), new Object[0]);
        TextComponentTranslation title = new TextComponentTranslation(stack.func_77977_a() + ".mode", new Object[0]);
        return title.func_150258_a(": ").func_150257_a((ITextComponent)name);
    }

    protected ItemStack findTorch(EntityPlayer player) {
        if (this.isTorch(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isTorch(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        return player.field_71071_by.field_70462_a.stream().filter(this::isTorch).findFirst().orElse(ItemStack.field_190927_a);
    }

    protected boolean isTorch(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        return block != null && block instanceof BlockTorch;
    }

    @Nullable
    protected EntityArrow createCustomArrow(BowMode mode, World world, EntityLivingBase shooter, ItemStack subAmmo) {
        switch (mode) {
            case RAPID: {
                return new EntityRapidArrow(world, shooter);
            }
            case TORCH: {
                return new EntityTorchArrow(world, shooter).setTorchItem(subAmmo);
            }
        }
        return null;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        boolean flag;
        float f;
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        BowMode mode = BowMode.byItemStack(stack);
        boolean infinity = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
        ItemStack ammo = this.func_185060_a(player);
        ItemStack torch = mode == BowMode.TORCH ? this.findTorch(player) : ItemStack.field_190927_a;
        int i = this.func_77626_a(stack) - timeLeft;
        if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)player, (int)i, (!ammo.func_190926_b() || infinity ? 1 : 0) != 0)) < 0 || ammo.func_190926_b() && !infinity || mode == BowMode.TORCH && torch.func_190926_b() && !infinity) {
            return;
        }
        if (ammo.func_190926_b()) {
            ammo = new ItemStack(Items.field_151032_g);
        }
        if (mode == BowMode.TORCH && torch.func_190926_b()) {
            torch = new ItemStack(Blocks.field_150478_aa);
        }
        if ((double)(f = ItemBowCavenic.func_185059_b((int)i)) < 0.1) {
            return;
        }
        boolean bl = flag = player.field_71075_bZ.field_75098_d || ammo.func_77973_b() instanceof ItemArrow && ((ItemArrow)ammo.func_77973_b()).isInfinite(ammo, stack, player);
        if (!world.field_72995_K) {
            int punch;
            int power;
            EntityArrow entityArrow = this.createCustomArrow(mode, world, (EntityLivingBase)player, torch);
            if (entityArrow == null) {
                ItemArrow arrow = (ItemArrow)(ammo.func_77973_b() instanceof ItemArrow ? ammo.func_77973_b() : Items.field_151032_g);
                entityArrow = arrow.func_185052_a(world, ammo, (EntityLivingBase)player);
            }
            entityArrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 3.0f, 1.0f);
            if ((double)f >= 1.0 || mode == BowMode.SNIPE && (double)f >= 0.65) {
                entityArrow.func_70243_d(true);
            }
            if ((power = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                entityArrow.func_70239_b(entityArrow.func_70242_d() + (double)power * 0.5 + 0.5);
            }
            if ((punch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                entityArrow.func_70240_a(punch);
            }
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                entityArrow.func_70015_d(100);
            }
            stack.func_77972_a(1, (EntityLivingBase)player);
            if (flag || player.field_71075_bZ.field_75098_d && (ammo.func_77973_b() == Items.field_185166_h || ammo.func_77973_b() == Items.field_185167_i)) {
                entityArrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
            }
            entityArrow.func_70239_b(entityArrow.func_70242_d() * mode.getAttackPower());
            world.func_72838_d((Entity)entityArrow);
        }
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
        if (!flag && !player.field_71075_bZ.field_75098_d) {
            ammo.func_190918_g(1);
            if (ammo.func_190926_b()) {
                player.field_71071_by.func_184437_d(ammo);
            }
        }
        player.func_71029_a(StatList.func_188057_b((Item)this));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ActionResult result = super.func_77659_a(world, player, hand);
        if (result.func_188397_a() == EnumActionResult.SUCCESS) {
            ItemStack heldItem = player.func_184586_b(hand);
            BowMode mode = BowMode.byItemStack(heldItem);
            switch (mode) {
                case RAPID: {
                    CaveUtils.setPrivateValue(EntityLivingBase.class, player, 20, "activeItemStackUseCount", "field_184628_bn");
                    player.func_184597_cx();
                    break;
                }
                case TORCH: {
                    boolean flag;
                    boolean bl = flag = !this.findTorch(player).func_190926_b();
                    if (player.field_71075_bZ.field_75098_d || flag) break;
                    return flag ? new ActionResult(EnumActionResult.PASS, (Object)heldItem) : new ActionResult(EnumActionResult.FAIL, (Object)heldItem);
                }
            }
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(this.getBowModeMessage(stack).func_150260_c());
    }

    public static enum BowMode {
        NORMAL(0, "normal", 1.0, 20.0f, 0.15f),
        RAPID(1, "rapid", 0.65, 0.0f, 0.0f),
        SNIPE(2, "snipe", 3.0, 80.0f, 0.75f),
        TORCH(3, "torch", 1.0, 40.0f, 0.225f);

        private static final BowMode[] TYPE_LOOKUP;
        private int modeType;
        private String modeName;
        private double attackPower;
        private float pullingSpeed;
        private float zoomScale;

        private BowMode(int type, String name, double power, float pulling, float zoom) {
            this.modeType = type;
            this.modeName = name;
            this.attackPower = power;
            this.pullingSpeed = pulling;
            this.zoomScale = zoom;
        }

        public int getType() {
            return this.modeType;
        }

        public String getModeName() {
            return this.modeName;
        }

        public String getUnlocalizedName(ItemStack stack) {
            return stack.func_77977_a() + "." + this.modeName;
        }

        public double getAttackPower() {
            return this.attackPower;
        }

        public float getPullingSpeed() {
            return this.pullingSpeed;
        }

        public float getZoomScale() {
            return this.zoomScale;
        }

        public static BowMode byItemStack(ItemStack stack) {
            if (stack.func_190926_b()) {
                return NORMAL;
            }
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null || !nbt.func_150297_b("Mode", 3)) {
                return NORMAL;
            }
            return BowMode.byType(nbt.func_74762_e("Mode"));
        }

        public static BowMode byType(int type) {
            if (type < 0 || type >= TYPE_LOOKUP.length) {
                type = 0;
            }
            return TYPE_LOOKUP[type];
        }

        static {
            TYPE_LOOKUP = new BowMode[BowMode.values().length];
            BowMode[] bowModeArray = BowMode.values();
            int n = bowModeArray.length;
            for (int i = 0; i < n; ++i) {
                BowMode mode;
                BowMode.TYPE_LOOKUP[mode.getType()] = mode = bowModeArray[i];
            }
        }
    }
}

