/*
 * Decompiled with CFR 0.152.
 */
package cavern.item;

import cavern.block.CaveBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class ItemAcresia
extends ItemBlock
implements IPlantable {
    public ItemAcresia(Block block) {
        super(block);
        this.setRegistryName(block.getRegistryName());
        this.func_77655_b("acresia");
        this.func_77627_a(true);
    }

    public String func_77667_c(ItemStack stack) {
        return "item." + EnumType.byItemStack(stack).getTranslationKey();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (EnumType type : EnumType.VALUES) {
            subItems.add((Object)type.getItemStack());
        }
    }

    public boolean isSeeds(ItemStack stack) {
        return !stack.func_190926_b() && EnumType.byItemStack(stack) == EnumType.SEEDS;
    }

    public boolean isFruits(ItemStack stack) {
        return !stack.func_190926_b() && EnumType.byItemStack(stack) == EnumType.FRUITS;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).isSideSolid(world, pos.func_177977_b(), EnumFacing.UP) ? EnumPlantType.Cave : EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return Block.func_149634_a((Item)this).func_176223_P();
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state;
        Block soil;
        ItemStack held = player.func_184586_b(hand);
        if (this.isSeeds(held) && facing == EnumFacing.UP && player.func_175151_a(pos, facing, held) && player.func_175151_a(pos.func_177984_a(), facing, held) && (soil = (state = world.func_180495_p(pos)).func_177230_c()) != Blocks.field_150357_h && soil.canSustainPlant(state, (IBlockAccess)world, pos, facing, (IPlantable)this) && world.func_175623_d(pos.func_177984_a())) {
            world.func_175656_a(pos.func_177984_a(), this.getPlant((IBlockAccess)world, pos));
            held.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (this.isFruits(stack)) {
            stack.func_190918_g(1);
            if (entityLiving instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entityLiving;
                player.func_71024_bL().func_75122_a(this.getHealAmount(stack), this.getSaturationModifier(stack));
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                player.func_71029_a(StatList.func_188057_b((Item)this));
            }
            return stack;
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (this.isFruits(held) && player.func_71043_e(false)) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)held);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)held);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.isFruits(stack) ? EnumAction.EAT : EnumAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return this.isFruits(stack) ? 20 : super.func_77626_a(stack);
    }

    public int getHealAmount(ItemStack stack) {
        return 1;
    }

    public float getSaturationModifier(ItemStack stack) {
        return 0.001f;
    }

    public static enum EnumType {
        SEEDS(0, "seedsAcresia"),
        FRUITS(1, "fruitsAcresia");

        public static final EnumType[] VALUES;
        private final int meta;
        private final String translationKey;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.translationKey = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public ItemStack getItemStack() {
            return this.getItemStack(1);
        }

        public ItemStack getItemStack(int amount) {
            return new ItemStack((Block)CaveBlocks.ACRESIA, amount, this.getMetadata());
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= VALUES.length) {
                meta = 0;
            }
            return VALUES[meta];
        }

        public static EnumType byItemStack(ItemStack stack) {
            return EnumType.byMetadata(stack.func_190926_b() ? 0 : stack.func_77960_j());
        }

        static {
            VALUES = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.VALUES[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

