/*
 * Decompiled with CFR 0.152.
 */
package cavern.item;

import cavern.item.ItemArmorCave;
import cavern.item.ItemAxeAquamarine;
import cavern.item.ItemAxeCave;
import cavern.item.ItemAxeCavenic;
import cavern.item.ItemAxeIce;
import cavern.item.ItemBowCavenic;
import cavern.item.ItemBowIce;
import cavern.item.ItemCave;
import cavern.item.ItemHoeCave;
import cavern.item.ItemHoeIce;
import cavern.item.ItemMagicBook;
import cavern.item.ItemMirageBook;
import cavern.item.ItemOreCompass;
import cavern.item.ItemPickaxeAquamarine;
import cavern.item.ItemPickaxeCave;
import cavern.item.ItemPickaxeIce;
import cavern.item.ItemShovelAquamarine;
import cavern.item.ItemShovelCave;
import cavern.item.ItemShovelIce;
import cavern.item.ItemSwordCave;
import cavern.item.ItemSwordCavenic;
import cavern.item.ItemSwordIce;
import cavern.recipe.RecipeChargeIceEquipment;
import cavern.util.CaveUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.ObjectUtils;

public final class CaveItems {
    public static final Item.ToolMaterial AQUAMARINE = EnumHelper.addToolMaterial((String)"AQUAMARINE", (int)2, (int)200, (float)8.0f, (float)1.5f, (int)15);
    public static final Item.ToolMaterial MAGNITE = EnumHelper.addToolMaterial((String)"MAGNITE", (int)3, (int)10, (float)100.0f, (float)11.0f, (int)50);
    public static final Item.ToolMaterial HEXCITE = EnumHelper.addToolMaterial((String)"HEXCITE", (int)3, (int)1041, (float)10.0f, (float)5.0f, (int)15);
    public static final Item.ToolMaterial ICE = EnumHelper.addToolMaterial((String)"ICE", (int)1, (int)120, (float)5.0f, (float)1.0f, (int)0);
    public static final Item.ToolMaterial CAVENIC = EnumHelper.addToolMaterial((String)"CAVENIC", (int)2, (int)278, (float)7.0f, (float)2.5f, (int)30);
    public static final ItemArmor.ArmorMaterial HEXCITE_ARMOR = EnumHelper.addArmorMaterial((String)"HEXCITE", (String)"hexcite", (int)22, (int[])new int[]{4, 7, 9, 4}, (int)15, (SoundEvent)SoundEvents.field_187716_o, (float)1.0f);
    public static final Item CAVE_ITEM = new ItemCave();
    public static final ItemPickaxeAquamarine AQUAMARINE_PICKAXE = new ItemPickaxeAquamarine();
    public static final ItemAxeAquamarine AQUAMARINE_AXE = new ItemAxeAquamarine();
    public static final ItemShovelAquamarine AQUAMARINE_SHOVEL = new ItemShovelAquamarine();
    public static final ItemSwordCave MAGNITE_SWORD = new ItemSwordCave(MAGNITE, "swordMagnite");
    public static final ItemPickaxeCave MAGNITE_PICKAXE = new ItemPickaxeCave(MAGNITE, "pickaxeMagnite");
    public static final ItemAxeCave MAGNITE_AXE = new ItemAxeCave(MAGNITE, 18.0f, -3.0f, "axeMagnite");
    public static final ItemShovelCave MAGNITE_SHOVEL = new ItemShovelCave(MAGNITE, "shovelMagnite");
    public static final ItemSwordCave HEXCITE_SWORD = new ItemSwordCave(HEXCITE, "swordHexcite");
    public static final ItemPickaxeCave HEXCITE_PICKAXE = new ItemPickaxeCave(HEXCITE, "pickaxeHexcite");
    public static final ItemAxeCave HEXCITE_AXE = new ItemAxeCave(HEXCITE, 10.0f, -2.8f, "axeHexcite");
    public static final ItemShovelCave HEXCITE_SHOVEL = new ItemShovelCave(HEXCITE, "shovelHexcite");
    public static final ItemHoeCave HEXCITE_HOE = new ItemHoeCave(HEXCITE, "hoeHexcite");
    public static final ItemArmorCave HEXCITE_HELMET = new ItemArmorCave(HEXCITE_ARMOR, "helmetHexcite", "hexcite", EntityEquipmentSlot.HEAD);
    public static final ItemArmorCave HEXCITE_CHESTPLATE = new ItemArmorCave(HEXCITE_ARMOR, "chestplateHexcite", "hexcite", EntityEquipmentSlot.CHEST);
    public static final ItemArmorCave HEXCITE_LEGGINGS = new ItemArmorCave(HEXCITE_ARMOR, "leggingsHexcite", "hexcite", EntityEquipmentSlot.LEGS);
    public static final ItemArmorCave HEXCITE_BOOTS = new ItemArmorCave(HEXCITE_ARMOR, "bootsHexcite", "hexcite", EntityEquipmentSlot.FEET);
    public static final ItemSwordIce ICE_SWORD = new ItemSwordIce();
    public static final ItemPickaxeIce ICE_PICKAXE = new ItemPickaxeIce();
    public static final ItemAxeIce ICE_AXE = new ItemAxeIce();
    public static final ItemShovelIce ICE_SHOVEL = new ItemShovelIce();
    public static final ItemHoeIce ICE_HOE = new ItemHoeIce();
    public static final ItemBowIce ICE_BOW = new ItemBowIce();
    public static final ItemSwordCavenic CAVENIC_SWORD = new ItemSwordCavenic();
    public static final ItemAxeCavenic CAVENIC_AXE = new ItemAxeCavenic();
    public static final ItemBowCavenic CAVENIC_BOW = new ItemBowCavenic();
    public static final ItemOreCompass ORE_COMPASS = new ItemOreCompass();
    public static final ItemMirageBook MIRAGE_BOOK = new ItemMirageBook();
    public static final ItemMagicBook MAGIC_BOOK = new ItemMagicBook();

    public static void registerItems(IForgeRegistry<Item> registry) {
        registry.register(CAVE_ITEM.setRegistryName("cave_item"));
        registry.register(AQUAMARINE_PICKAXE.setRegistryName("aquamarine_pickaxe"));
        registry.register(AQUAMARINE_AXE.setRegistryName("aquamarine_axe"));
        registry.register(AQUAMARINE_SHOVEL.setRegistryName("aquamarine_shovel"));
        registry.register(MAGNITE_SWORD.setRegistryName("magnite_sword"));
        registry.register(MAGNITE_PICKAXE.setRegistryName("magnite_pickaxe"));
        registry.register(MAGNITE_AXE.setRegistryName("magnite_axe"));
        registry.register(MAGNITE_SHOVEL.setRegistryName("magnite_shovel"));
        registry.register(HEXCITE_SWORD.setRegistryName("hexcite_sword"));
        registry.register(HEXCITE_PICKAXE.setRegistryName("hexcite_pickaxe"));
        registry.register(HEXCITE_AXE.setRegistryName("hexcite_axe"));
        registry.register(HEXCITE_SHOVEL.setRegistryName("hexcite_shovel"));
        registry.register(HEXCITE_HOE.setRegistryName("hexcite_hoe"));
        registry.register(HEXCITE_HELMET.setRegistryName("hexcite_helmet"));
        registry.register(HEXCITE_CHESTPLATE.setRegistryName("hexcite_chestplate"));
        registry.register(HEXCITE_LEGGINGS.setRegistryName("hexcite_leggings"));
        registry.register(HEXCITE_BOOTS.setRegistryName("hexcite_boots"));
        registry.register(ICE_SWORD.setRegistryName("ice_sword"));
        registry.register(ICE_PICKAXE.setRegistryName("ice_pickaxe"));
        registry.register(ICE_AXE.setRegistryName("ice_axe"));
        registry.register(ICE_SHOVEL.setRegistryName("ice_shovel"));
        registry.register(ICE_HOE.setRegistryName("ice_hoe"));
        registry.register(ICE_BOW.setRegistryName("ice_bow"));
        registry.register(CAVENIC_SWORD.setRegistryName("cavenic_sword"));
        registry.register(CAVENIC_AXE.setRegistryName("cavenic_axe"));
        registry.register(CAVENIC_BOW.setRegistryName("cavenic_bow"));
        registry.register(ORE_COMPASS.setRegistryName("ore_compass"));
        registry.register(MIRAGE_BOOK.setRegistryName("mirage_book"));
        registry.register(MAGIC_BOOK.setRegistryName("magic_book"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModels() {
        CaveItems.registerModels(CAVE_ITEM, "aquamarine", "magnite_ingot", "hexcite", "ice_stick", "miner_orb", "cavenic_orb");
        CaveItems.registerModel((Item)AQUAMARINE_PICKAXE);
        CaveItems.registerModel((Item)AQUAMARINE_AXE);
        CaveItems.registerModel((Item)AQUAMARINE_SHOVEL);
        CaveItems.registerModel((Item)MAGNITE_SWORD);
        CaveItems.registerModel((Item)MAGNITE_PICKAXE);
        CaveItems.registerModel((Item)MAGNITE_AXE);
        CaveItems.registerModel((Item)MAGNITE_SHOVEL);
        CaveItems.registerModel((Item)HEXCITE_SWORD);
        CaveItems.registerModel((Item)HEXCITE_PICKAXE);
        CaveItems.registerModel((Item)HEXCITE_AXE);
        CaveItems.registerModel((Item)HEXCITE_SHOVEL);
        CaveItems.registerModel((Item)HEXCITE_HOE);
        CaveItems.registerModel((Item)HEXCITE_HELMET);
        CaveItems.registerModel((Item)HEXCITE_CHESTPLATE);
        CaveItems.registerModel((Item)HEXCITE_LEGGINGS);
        CaveItems.registerModel((Item)HEXCITE_BOOTS);
        CaveItems.registerModel((Item)ICE_SWORD);
        CaveItems.registerModel((Item)ICE_PICKAXE);
        CaveItems.registerModel((Item)ICE_AXE);
        CaveItems.registerModel((Item)ICE_SHOVEL);
        CaveItems.registerModel((Item)ICE_HOE);
        CaveItems.registerModel((Item)ICE_BOW);
        CaveItems.registerModel((Item)CAVENIC_SWORD);
        CaveItems.registerModel((Item)CAVENIC_AXE);
        CaveItems.registerModel((Item)CAVENIC_BOW);
        CaveItems.registerModel(ORE_COMPASS);
        CaveItems.registerModels("mirage_book_", MIRAGE_BOOK, "caveland", "cavenia", "frost_mountains", "wide_desert", "the_void", "dark_forest", "crown_cliffs", "skyland");
        CaveItems.registerModels("magic_book_", MAGIC_BOOK, "storage", "heal", "warp", "teleport", "torch", "invisible", "summon", "explosion", "thunderbolt", "infinity", "overload", "physical_boost");
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModel(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModel(Item item, String modelName) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(CaveUtils.getKey(modelName), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModels(Item item, String ... modelNames) {
        CaveItems.registerModels(null, item, modelNames);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModels(@Nullable String prefix, Item item, String ... modelNames) {
        ArrayList models = Lists.newArrayList();
        for (String model : modelNames) {
            models.add(new ModelResourceLocation(CaveUtils.getKey((String)ObjectUtils.defaultIfNull((Object)prefix, (Object)"") + model), "inventory"));
        }
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])models.toArray(new ResourceLocation[models.size()]));
        int size = models.size();
        for (int i = 0; i < size; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)((ModelResourceLocation)models.get(i)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerVanillaModel(Item item, String modelName) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("minecraft:" + modelName, "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerVanillaModels(Item item, String ... modelNames) {
        ArrayList models = Lists.newArrayList();
        for (String model : modelNames) {
            models.add(new ModelResourceLocation("minecraft:" + model, "inventory"));
        }
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])models.toArray(new ResourceLocation[models.size()]));
        int size = models.size();
        for (int i = 0; i < size; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)((ModelResourceLocation)models.get(i)));
        }
    }

    public static void registerOreDicts() {
        OreDictionary.registerOre((String)"gemAquamarine", (ItemStack)ItemCave.EnumType.AQUAMARINE.getItemStack());
        OreDictionary.registerOre((String)"ingotMagnite", (ItemStack)ItemCave.EnumType.MAGNITE_INGOT.getItemStack());
        OreDictionary.registerOre((String)"gemHexcite", (ItemStack)ItemCave.EnumType.HEXCITE.getItemStack());
        OreDictionary.registerOre((String)"stickIce", (ItemStack)ItemCave.EnumType.ICE_STICK.getItemStack());
        OreDictionary.registerOre((String)"orbMiner", (ItemStack)ItemCave.EnumType.MINER_ORB.getItemStack());
        OreDictionary.registerOre((String)"orbCavenic", (ItemStack)ItemCave.EnumType.CAVENIC_ORB.getItemStack());
    }

    public static void registerEquipments() {
        AQUAMARINE.setRepairItem(ItemCave.EnumType.AQUAMARINE.getItemStack());
        MAGNITE.setRepairItem(ItemCave.EnumType.MAGNITE_INGOT.getItemStack());
        HEXCITE.setRepairItem(ItemCave.EnumType.HEXCITE.getItemStack());
        ICE.setRepairItem(new ItemStack(Blocks.field_150403_cj));
    }

    public static void registerRecipes(IForgeRegistry<IRecipe> registry) {
        registry.register(new RecipeChargeIceEquipment().setRegistryName("charge_ice_equip"));
    }
}

