/*
 * Decompiled with CFR 0.152.
 */
package cavern.handler;

import cavern.api.CavernAPI;
import cavern.api.item.IIceEquipment;
import cavern.block.RandomiteHelper;
import cavern.handler.CaveEventHooks;
import cavern.item.CaveItems;
import cavern.network.CaveNetworkRegistry;
import cavern.network.client.FallTeleportMessage;
import cavern.world.CaveDimensions;
import cavern.world.gen.WorldGenDarkLibrary;
import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class MirageEventHooks {
    public static boolean fallDamageCancel;
    private final Random rand = CaveEventHooks.RANDOM;
    private final Set<String> fallCancelPlayers = Sets.newHashSet();

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (CavernAPI.dimension.isInMirageWorlds((Entity)entity) && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            player.func_70606_j(0.1f);
            CaveItems.MIRAGE_BOOK.transferTo(null, player);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        EntityPlayer entityPlayer = event.getPlayer();
        if (entityPlayer == null || entityPlayer instanceof FakePlayer || !(entityPlayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)entityPlayer;
        if (!CavernAPI.dimension.isInCaveDimensions((Entity)player)) {
            return;
        }
        World world = event.getWorld();
        IBlockState state = event.getState();
        ItemStack stack = player.func_184614_ca();
        if (CavernAPI.dimension.isInFrostMountains((Entity)player)) {
            if (player.field_71075_bZ.field_75098_d) {
                return;
            }
            if (state.func_177230_c() != Blocks.field_150403_cj || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
                return;
            }
            BlockPos pos = event.getPos();
            Biome biome = world.func_180494_b(pos);
            if (!biome.func_150559_j()) {
                return;
            }
            if (this.rand.nextDouble() < 0.05) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Blocks.field_150432_aD));
            } else if (this.rand.nextDouble() < 0.005) {
                RandomiteHelper.Category category = RandomiteHelper.Category.COMMON;
                if (this.rand.nextInt(5) == 0) {
                    category = RandomiteHelper.Category.FOOD;
                }
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)RandomiteHelper.getDropItem(category));
            } else if (stack.func_77973_b() instanceof IIceEquipment && this.rand.nextDouble() < 0.03 || this.rand.nextDouble() < 0.01) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Blocks.field_150403_cj));
            }
        }
    }

    @SubscribeEvent
    public void onDecorateBiome(DecorateBiomeEvent.Pre event) {
        World world = event.getWorld();
        Random rand = event.getRand();
        ChunkPos chunkPos = event.getChunkPos();
        if (world.field_73011_w.func_186058_p() == CaveDimensions.DARK_FOREST && rand.nextInt(50) == 0) {
            int seaLevel;
            int x = rand.nextInt(8) + 4;
            int z = rand.nextInt(8) + 4;
            int top = world.func_189649_b(chunkPos.func_180334_c() + x, chunkPos.func_180333_d() + z);
            if (top >= (seaLevel = world.func_181545_F()) && top - seaLevel < 6) {
                new WorldGenDarkLibrary().func_180709_b(world, rand, new BlockPos(chunkPos.func_180334_c() + x, seaLevel, chunkPos.func_180333_d() + z));
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!CavernAPI.dimension.isInSkyland((Entity)entity)) {
            return;
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            if (!player.field_70122_E && player.func_174813_aQ().field_72338_b <= -20.0) {
                CaveItems.MIRAGE_BOOK.transferTo(null, (EntityPlayer)player);
                if (player.field_71093_bK == 0) {
                    player.field_71135_a.func_147364_a(player.field_70165_t, 305.0, player.field_70161_v, player.field_70177_z, 60.0f);
                    this.fallCancelPlayers.add(player.func_189512_bd());
                }
                CaveNetworkRegistry.sendTo(FallTeleportMessage::new, (EntityPlayer)player);
            }
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityPlayer && (fallDamageCancel || this.fallCancelPlayers.remove(entity.func_189512_bd()))) {
            event.setCanceled(true);
        }
    }
}

