/*
 * Decompiled with CFR 0.152.
 */
package cavern.handler;

import cavern.api.data.IMiner;
import cavern.config.MiningAssistConfig;
import cavern.core.Cavern;
import cavern.data.Miner;
import cavern.handler.CaveEventHooks;
import cavern.miningassist.MiningAssist;
import cavern.miningassist.MiningAssistUnit;
import cavern.miningassist.MiningSnapshot;
import cavern.util.CaveUtils;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class MiningAssistEventHooks {
    private boolean isActive(EntityPlayer player, IBlockState state) {
        ItemStack held = player.func_184614_ca();
        if (!MiningAssistConfig.isEffectiveItem(held)) {
            return false;
        }
        IMiner miner = Miner.get(player);
        if (miner.getRank() < MiningAssistConfig.minerRank.getValue()) {
            return false;
        }
        MiningAssist type = MiningAssist.get(miner.getMiningAssist());
        if (type == MiningAssist.DISABLED) {
            return false;
        }
        return type.isEffectiveTarget(held, state);
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (!MiningAssistConfig.modifiedHardness || !Cavern.proxy.isSinglePlayer()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        MiningAssistUnit assist = MiningAssistUnit.get(player);
        if (assist.isChecking()) {
            return;
        }
        IBlockState state = event.getState();
        if (!this.isActive(player, state)) {
            return;
        }
        MiningAssist type = MiningAssist.byPlayer(player);
        BlockPos pos = event.getPos();
        assist.setChecking(true);
        MiningSnapshot snapshot = assist.getSnapshot(type, pos, state);
        if (snapshot != null && !snapshot.isEmpty()) {
            event.setNewSpeed(assist.getBreakSpeed(snapshot));
        }
        assist.setChecking(false);
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Map<BlockPos, Integer> map;
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        if (player == null || player instanceof FakePlayer) {
            return;
        }
        BlockPos pos = event.getPos();
        MiningAssistUnit assist = MiningAssistUnit.get(player);
        if (assist.addExperience(pos, event.getExpToDrop())) {
            event.setExpToDrop(0);
        }
        if (assist.isBreaking()) {
            return;
        }
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        IBlockState state = event.getState();
        if (!this.isActive(player, state)) {
            return;
        }
        MiningAssist type = MiningAssist.byPlayer(player);
        MiningSnapshot snapshot = assist.getSnapshot(type, pos, state);
        if (snapshot == null || snapshot.isEmpty()) {
            return;
        }
        PlayerInteractionManager im = ((EntityPlayerMP)player).field_71134_c;
        assist.captureDrops(MiningAssistConfig.collectDrops);
        assist.captureExperiences(MiningAssistConfig.collectExps);
        assist.setBreaking(true);
        for (BlockPos blockPos : snapshot.getTargets()) {
            if (snapshot.validTarget(blockPos) && !this.harvestBlock(im, blockPos)) break;
        }
        assist.setBreaking(false);
        Map<BlockPos, NonNullList<ItemStack>> drops = assist.captureDrops(false);
        if (drops != null && !drops.isEmpty()) {
            for (NonNullList<ItemStack> nonNullList : drops.values()) {
                for (ItemStack stack : nonNullList) {
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
                }
            }
        }
        if ((map = assist.captureExperiences(false)) != null && !map.isEmpty() && !im.func_73083_d() && world.func_82736_K().func_82766_b("doTileDrops")) {
            void var12_17;
            int n = map.values().stream().mapToInt(Integer::intValue).sum();
            while (var12_17 > 0) {
                int i = EntityXPOrb.func_70527_a((int)var12_17);
                var12_17 -= i;
                world.func_72838_d((Entity)new EntityXPOrb(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, i));
            }
        }
    }

    private boolean harvestBlock(PlayerInteractionManager im, @Nullable BlockPos pos) {
        if (pos == null) {
            return false;
        }
        if (Cavern.proxy.isSinglePlayer()) {
            World world = im.field_73092_a;
            IBlockState state = world.func_180495_p(pos);
            if (im.func_180237_b(pos)) {
                if (!im.func_73083_d()) {
                    world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                }
                return true;
            }
        } else if (im.func_180237_b(pos)) {
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = event.getHarvester();
        if (player == null || player instanceof FakePlayer) {
            return;
        }
        BlockPos pos = event.getPos();
        MiningAssistUnit assist = MiningAssistUnit.get(player);
        if (!assist.getCaptureDrops()) {
            return;
        }
        NonNullList items = NonNullList.func_191196_a();
        List drops = event.getDrops();
        float chance = event.getDropChance();
        for (ItemStack stack : drops) {
            if (!(CaveEventHooks.RANDOM.nextFloat() < chance)) continue;
            items.add((Object)stack);
        }
        drops.clear();
        assist.addDrops(pos, (NonNullList<ItemStack>)items);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos;
        EntityPlayer player = event.getEntityPlayer();
        MiningAssist assist = MiningAssist.byPlayer(player);
        if (assist != MiningAssist.AUTO && assist != MiningAssist.AUTO_QUICK && assist != MiningAssist.AUTO_ADIT) {
            return;
        }
        World world = event.getWorld();
        IBlockState state = world.func_180495_p(pos = event.getPos());
        Block block = state.func_177230_c();
        int level = block.getHarvestLevel(state);
        if (level < 0) {
            return;
        }
        ItemStack heldMain = player.func_184614_ca();
        ItemStack heldOff = player.func_184592_cb();
        if (block.isToolEffective("pickaxe", state)) {
            if (CaveUtils.isPickaxe(heldMain)) {
                return;
            }
            if (CaveUtils.isPickaxe(heldOff)) {
                player.func_184611_a(EnumHand.OFF_HAND, heldMain);
                player.func_184611_a(EnumHand.MAIN_HAND, heldOff);
                return;
            }
            NonNullList mainInventory = player.field_71071_by.field_70462_a;
            int slot = -1;
            int size = mainInventory.size();
            for (int i = 0; i < size; ++i) {
                ItemStack stack = (ItemStack)mainInventory.get(i);
                if (!CaveUtils.isPickaxe(stack)) continue;
                if (level > 0 && stack.func_77973_b().getHarvestLevel(stack, "pickaxe", player, state) < level) {
                    if (slot >= 0) continue;
                    slot = i;
                    continue;
                }
                slot = i;
            }
            if (slot >= 0) {
                ItemStack prev = player.field_71071_by.func_70448_g();
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, player.field_71071_by.func_70301_a(slot));
                player.field_71071_by.func_70299_a(slot, prev);
            }
        } else if (block.isToolEffective("axe", state)) {
            if (CaveUtils.isAxe(heldMain)) {
                return;
            }
            if (CaveUtils.isAxe(heldOff)) {
                player.func_184611_a(EnumHand.OFF_HAND, heldMain);
                player.func_184611_a(EnumHand.MAIN_HAND, heldOff);
                return;
            }
            NonNullList mainInventory = player.field_71071_by.field_70462_a;
            int slot = -1;
            int size = mainInventory.size();
            for (int i = 0; i < size; ++i) {
                ItemStack stack = (ItemStack)mainInventory.get(i);
                if (!CaveUtils.isAxe(stack)) continue;
                if (level > 0 && stack.func_77973_b().getHarvestLevel(stack, "axe", player, state) < level) {
                    if (slot >= 0) continue;
                    slot = i;
                    continue;
                }
                slot = i;
            }
            if (slot >= 0) {
                ItemStack prev = player.field_71071_by.func_70448_g();
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, player.field_71071_by.func_70301_a(slot));
                player.field_71071_by.func_70299_a(slot, prev);
            }
        } else if (block.isToolEffective("shovel", state)) {
            if (CaveUtils.isShovel(heldMain)) {
                return;
            }
            if (CaveUtils.isShovel(heldOff)) {
                player.func_184611_a(EnumHand.OFF_HAND, heldMain);
                player.func_184611_a(EnumHand.MAIN_HAND, heldOff);
                return;
            }
            NonNullList mainInventory = player.field_71071_by.field_70462_a;
            int slot = -1;
            int size = mainInventory.size();
            for (int i = 0; i < size; ++i) {
                ItemStack stack = (ItemStack)mainInventory.get(i);
                if (!CaveUtils.isShovel(stack)) continue;
                if (level > 0 && stack.func_77973_b().getHarvestLevel(stack, "shovel", player, state) < level) {
                    if (slot >= 0) continue;
                    slot = i;
                    continue;
                }
                slot = i;
            }
            if (slot >= 0) {
                ItemStack prev = player.field_71071_by.func_70448_g();
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, player.field_71071_by.func_70301_a(slot));
                player.field_71071_by.func_70299_a(slot, prev);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAttackEntity(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        MiningAssist assist = MiningAssist.byPlayer(player);
        if (assist != MiningAssist.AUTO && assist != MiningAssist.AUTO_QUICK && assist != MiningAssist.AUTO_ADIT) {
            return;
        }
        ItemStack heldMain = player.func_184614_ca();
        ItemStack heldOff = player.func_184592_cb();
        if (heldMain.func_77973_b() instanceof ItemSword) {
            return;
        }
        if (heldOff.func_77973_b() instanceof ItemSword) {
            player.func_184611_a(EnumHand.OFF_HAND, heldMain);
            player.func_184611_a(EnumHand.MAIN_HAND, heldOff);
            return;
        }
        NonNullList mainInventory = player.field_71071_by.field_70462_a;
        int slot = -1;
        int size = mainInventory.size();
        for (int i = 0; i < size; ++i) {
            if (!(((ItemStack)mainInventory.get(i)).func_77973_b() instanceof ItemSword)) continue;
            slot = i;
            break;
        }
        if (slot >= 0) {
            ItemStack prev = player.field_71071_by.func_70448_g();
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, player.field_71071_by.func_70301_a(slot));
            player.field_71071_by.func_70299_a(slot, prev);
        }
    }
}

