/*
 * Decompiled with CFR 0.152.
 */
package cavern.handler;

import cavern.api.CavernAPI;
import cavern.api.data.IMiner;
import cavern.api.data.IMiningData;
import cavern.api.event.CriticalMiningEvent;
import cavern.config.GeneralConfig;
import cavern.config.MiningAssistConfig;
import cavern.data.Miner;
import cavern.data.MinerRank;
import cavern.data.MiningData;
import cavern.handler.CaveEventHooks;
import cavern.item.ItemCave;
import cavern.miningassist.MiningAssistUnit;
import cavern.network.CaveNetworkRegistry;
import cavern.network.client.MiningMessage;
import cavern.util.BlockMeta;
import cavern.util.PlayerHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public final class MinerEventHooks {
    private final Random rand = CaveEventHooks.RANDOM;

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            Miner.adjustData(player);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        EntityPlayer entityPlayer = event.getPlayer();
        if (entityPlayer == null || entityPlayer instanceof FakePlayer || !(entityPlayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)entityPlayer;
        if (!CavernAPI.dimension.isInCaveDimensions((Entity)player)) {
            return;
        }
        if (MiningAssistConfig.actualMining && MiningAssistUnit.get((EntityPlayer)player).isBreaking()) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (!GeneralConfig.isMiningPointItem(stack)) {
            return;
        }
        World world = event.getWorld();
        IBlockState state = event.getState();
        int point = Miner.getPointAmount(state);
        if (point <= 0) {
            return;
        }
        IMiner miner = Miner.get((EntityPlayer)player);
        IMiningData data = MiningData.get((EntityPlayer)player);
        if (player.field_71071_by.func_70431_c(ItemCave.EnumType.MINER_ORB.getItemStack()) && this.rand.nextDouble() < 0.1) {
            point += Math.max(point / 2, 1);
        }
        miner.addPoint(point);
        miner.addMiningRecord(new BlockMeta(state));
        data.notifyMining(state, point);
        int combo = data.getMiningCombo();
        if (combo > 0 && combo % 10 == 0) {
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.25, player.field_70161_v, SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.8f));
            player.func_71023_q(combo / 10);
        }
        if (combo >= 50) {
            PlayerHelper.grantAdvancement((EntityPlayer)player, "good_mine");
        }
        MiningMessage message = new MiningMessage(state, point);
        CaveNetworkRegistry.sendTo(() -> message, (EntityPlayer)player);
    }

    @SubscribeEvent
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        if (!GeneralConfig.criticalMining || event.isSilkTouching()) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = event.getHarvester();
        if (player == null || player instanceof FakePlayer || !CavernAPI.dimension.isInCaveDimensions((Entity)player)) {
            return;
        }
        IBlockState state = event.getState();
        if (Miner.getPointAmount(state) <= 0) {
            return;
        }
        if (state.func_185904_a() != Material.field_151576_e) {
            return;
        }
        MinerRank rank = MinerRank.get(Miner.get(player).getRank());
        float f = rank.getBoost();
        if (f <= 1.0f) {
            return;
        }
        f = (f - 1.0f) * 0.3f;
        ItemStack held = player.func_184614_ca();
        String tool = state.func_177230_c().getHarvestTool(state);
        if (held.func_190926_b() || tool == null) {
            return;
        }
        int toolLevel = held.func_77973_b().getHarvestLevel(held, tool, player, state);
        if (toolLevel <= 0) {
            return;
        }
        f *= 1.0f + (float)toolLevel * 0.1f;
        List originalDrops = event.getDrops();
        ArrayList drops = Lists.newArrayList();
        for (ItemStack stack : originalDrops) {
            if (stack.func_190926_b() || stack.func_77973_b() instanceof ItemBlock || !(this.rand.nextFloat() <= f)) continue;
            drops.add(stack.func_77946_l());
        }
        if (!drops.isEmpty()) {
            CriticalMiningEvent criticalEvent = new CriticalMiningEvent(world, event.getPos(), state, player, event.getFortuneLevel(), originalDrops, drops);
            if (MinecraftForge.EVENT_BUS.post((Event)criticalEvent)) {
                return;
            }
            player.func_146105_b((ITextComponent)new TextComponentTranslation("cavern.message.mining.critical", new Object[0]), true);
            originalDrops.addAll(criticalEvent.getBonusDrops());
        }
    }
}

