/*
 * Decompiled with CFR 0.152.
 */
package cavern.handler;

import cavern.api.CavernAPI;
import cavern.api.item.IIceEquipment;
import cavern.block.BlockLeavesPerverted;
import cavern.block.BlockLogPerverted;
import cavern.block.BlockPortalCavern;
import cavern.block.BlockSaplingPerverted;
import cavern.block.CaveBlocks;
import cavern.config.GeneralConfig;
import cavern.data.Miner;
import cavern.data.PlayerData;
import cavern.item.CaveItems;
import cavern.magic.Magic;
import cavern.magic.MagicBook;
import cavern.magic.MagicInvisible;
import cavern.network.CaveNetworkRegistry;
import cavern.network.client.CustomSeedMessage;
import cavern.util.PlayerHelper;
import cavern.world.CaveDimensions;
import cavern.world.CustomSeedData;
import cavern.world.CustomSeedProvider;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.apache.commons.lang3.ObjectUtils;

public final class CaveEventHooks {
    public static final Random RANDOM = new Random();

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        World world = event.getWorld();
        if (!world.field_72995_K && world.field_73011_w instanceof CustomSeedProvider) {
            CustomSeedData data = ((CustomSeedProvider)world.field_73011_w).getSeedData();
            if (data == null) {
                return;
            }
            if (event.getEntity() instanceof EntityPlayerMP) {
                CaveNetworkRegistry.sendTo(() -> new CustomSeedMessage(data.getSeedValue(world.func_72912_H().func_76063_b())), (EntityPlayer)((EntityPlayerMP)event.getEntity()));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        if (CavernAPI.dimension.isInCaveDimensions((Entity)player)) {
            WorldServer world = player.func_71121_q();
            DimensionType type = world.field_73011_w.func_186058_p();
            if (CavernAPI.dimension.isCaves(type)) {
                PlayerHelper.grantCriterion((EntityPlayer)player, "root", "entered_cavern");
            }
            if (type != CaveDimensions.CAVERN) {
                String name = type.func_186065_b();
                if (name.startsWith("the_")) {
                    name = name.substring(4);
                }
                PlayerHelper.grantCriterion((EntityPlayer)player, "enter_the_" + name, "entered_" + name);
            }
        }
        Miner.adjustData(player);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        if (CavernAPI.dimension.isInCaverns((Entity)player)) {
            BlockPos pos;
            WorldServer world = player.func_71121_q();
            if (world.func_180495_p(pos = player.func_180425_c().func_177977_b()).func_185887_b((World)world, pos) < 0.0f) {
                CaveItems.MIRAGE_BOOK.placeEntity((World)world, (Entity)player, player.field_70177_z);
            }
            player.field_71088_bW = 100;
        }
    }

    @SubscribeEvent
    public void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        ItemStack stack = event.getItemStack();
        if (stack.func_190926_b()) {
            return;
        }
        World world = event.getWorld();
        IBlockState state = world.func_180495_p(pos = event.getPos());
        if (state.func_177230_c() != Blocks.field_150341_Y && (state.func_177230_c() != Blocks.field_150417_aV || state.func_177230_c().func_176201_c(state) != BlockStoneBrick.field_176250_M)) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        HashSet portals = Sets.newHashSet();
        portals.add(CaveBlocks.CAVERN_PORTAL);
        portals.add(CaveBlocks.HUGE_CAVERN_PORTAL);
        portals.add(CaveBlocks.AQUA_CAVERN_PORTAL);
        portals.add(CaveBlocks.MIRAGE_PORTAL);
        Item portalItem = Items.field_190931_a;
        for (BlockPortalCavern portal : portals) {
            if (!portal.isTriggerItem(stack)) continue;
            portalItem = Item.func_150898_a((Block)portal);
            break;
        }
        if (portalItem != Items.field_190931_a) {
            EnumFacing facing = (EnumFacing)ObjectUtils.defaultIfNull((Object)event.getFace(), (Object)EnumFacing.UP);
            Vec3d hit = event.getHitVec();
            EnumActionResult result = portalItem.func_180614_a(player, world, pos, event.getHand(), facing, (float)hit.field_72450_a, (float)hit.field_72448_b, (float)hit.field_72449_c);
            if (result == EnumActionResult.SUCCESS) {
                event.setCancellationResult(result);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPortalSpawn(BlockEvent.PortalSpawnEvent event) {
        World world = event.getWorld();
        if (CavernAPI.dimension.isCaveDimensions(world.field_73011_w.func_186058_p())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        EntityLivingBase target = event.getTarget();
        if (target == null || !(target instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)target;
        Magic magic = MagicBook.get(player).getSpellingMagic();
        if (magic == null || !(magic instanceof MagicInvisible)) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_70624_b(null);
        }
        entity.func_110142_aN().func_94549_h();
    }

    @SubscribeEvent
    public void onPlayerSleepInBed(PlayerSleepInBedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (!CavernAPI.dimension.isInCaveDimensions((Entity)player)) {
            return;
        }
        EntityPlayer.SleepResult result = null;
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            PlayerData data = PlayerData.get(player);
            long worldTime = world.func_82737_E();
            long sleepTime = data.getLastSleepTime();
            long requireTime = GeneralConfig.sleepWaitTime * 20;
            if (sleepTime <= 0L) {
                sleepTime = worldTime;
                requireTime = 0L;
                data.setLastSleepTime(sleepTime);
            }
            if (requireTime > 0L && sleepTime + requireTime > worldTime) {
                result = EntityPlayer.SleepResult.OTHER_PROBLEM;
                long remainTime = requireTime - (worldTime - sleepTime);
                int min = MathHelper.func_76123_f((float)(remainTime / 20L / 60L + 1L));
                player.func_146105_b((ITextComponent)new TextComponentTranslation("cavern.message.sleep.still", new Object[]{min}), true);
            }
        }
        if (result == null) {
            result = PlayerHelper.trySleep(player, event.getPos());
        }
        if (!world.field_72995_K && result == EntityPlayer.SleepResult.OK) {
            PlayerData.get(player).setLastSleepTime(world.func_82737_E());
        }
        event.setResult(result);
    }

    @SubscribeEvent
    public void onPlayerWakeUp(PlayerWakeUpEvent event) {
        if (!GeneralConfig.sleepRefresh) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        World world = player.field_70170_p;
        if (world.field_72995_K || !player.func_70996_bM()) {
            return;
        }
        if (CavernAPI.dimension.isInCaveDimensions((Entity)player)) {
            player.func_70691_i(player.func_110138_aP() * 0.5f);
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        int charge;
        EntityPlayer player = event.player;
        ItemStack stack = event.crafting;
        World world = player.field_70170_p;
        if (!world.field_72995_K && !stack.func_190926_b() && stack.func_77973_b() instanceof IIceEquipment && (charge = ((IIceEquipment)stack.func_77973_b()).getCharge(stack)) > 0 && stack.func_77978_p().func_74767_n("AfterIceCharge")) {
            PlayerHelper.grantAdvancement(player, "ice_charge");
            stack.func_77978_p().func_82580_o("AfterIceCharge");
        }
    }

    @SubscribeEvent
    public void onFurnaceFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        ItemStack stack = event.getItemStack();
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block == null) {
            return;
        }
        if (block instanceof BlockLogPerverted) {
            event.setBurnTime(100);
        } else if (block instanceof BlockLeavesPerverted || block instanceof BlockSaplingPerverted) {
            event.setBurnTime(35);
        }
    }
}

