/*
 * Decompiled with CFR 0.152.
 */
package cavern.handler;

import cavern.api.CavernAPI;
import cavern.api.item.IAquaTool;
import cavern.data.Miner;
import cavern.data.MinerRank;
import cavern.data.MiningData;
import cavern.util.CaveUtils;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class AquaEventHooks {
    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        float original = event.getOriginalSpeed();
        boolean flag = EnchantmentHelper.func_185287_i((EntityLivingBase)player);
        if (player.func_70090_H() && stack.func_77973_b() instanceof IAquaTool) {
            IAquaTool tool = (IAquaTool)stack.func_77973_b();
            float speed = tool.getAquaBreakSpeed(stack, player, event.getPos(), event.getState(), original);
            if (flag) {
                speed *= 0.5f;
            }
            event.setNewSpeed(speed);
            flag = true;
        }
        if (CavernAPI.dimension.isInCaveDimensions((Entity)player) && CaveUtils.isPickaxe(stack)) {
            int rank = Miner.get(player).getRank();
            if (!flag && player.func_70090_H() && rank >= MinerRank.AQUA_MINER.getRank()) {
                event.setNewSpeed(original * 5.0f);
            }
            event.setNewSpeed(event.getNewSpeed() * MinerRank.get(rank).getBoost());
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!(entity instanceof EntityPlayer) || entity instanceof FakePlayer) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        MiningData.get(player).onUpdate();
        if (!player.func_70090_H() || !CavernAPI.dimension.isInCaveDimensions((Entity)player)) {
            return;
        }
        if (Miner.get(player).getRank() < MinerRank.AQUA_MINER.getRank()) {
            return;
        }
        if (!player.func_70648_aU() && !player.func_70644_a(MobEffects.field_76427_o) && player.field_70173_aa % 20 == 0) {
            player.func_70050_g(300);
        }
        if (player.field_71075_bZ.field_75100_b || EnchantmentHelper.func_185294_d((EntityLivingBase)player) > 0) {
            return;
        }
        double prevY = player.field_70163_u;
        float vec1 = 0.6f;
        float vec2 = 0.01f;
        float vec3 = 0.4f;
        if (!player.field_70122_E) {
            vec3 *= 0.5f;
        }
        if (player.func_82243_bO() >= 0.75f) {
            vec3 *= 0.5f;
        }
        if (vec3 > 0.0f) {
            vec1 += (0.54600006f - vec1) * vec3 / 3.0f;
            vec2 += (player.func_70689_ay() - vec2) * vec3 / 3.0f;
        }
        player.func_191958_b(player.field_70702_br, player.field_70701_bs, player.field_191988_bg, vec2);
        player.func_70091_d(MoverType.SELF, player.field_70159_w, player.field_70181_x, player.field_70179_y);
        player.field_70159_w *= (double)vec1;
        player.field_70181_x *= (double)0.8f;
        player.field_70179_y *= (double)vec1;
        if (player.field_70123_F && player.func_70038_c(player.field_70159_w, player.field_70181_x + (double)0.6f - player.field_70163_u + prevY, player.field_70179_y)) {
            player.field_70181_x = 0.3f;
        }
        if (player.field_82175_bq || player.func_70093_af()) {
            player.field_70181_x *= 0.3;
        }
    }
}

