/*
 * Decompiled with CFR 0.152.
 */
package cavern.entity.monster;

import cavern.api.CavernAPI;
import cavern.api.entity.ICavenicMob;
import cavern.item.ItemCave;
import cavern.item.ItemMagicBook;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityCavenicWitch
extends EntityWitch
implements ICavenicMob {
    public EntityCavenicWitch(World world) {
        super(world);
        this.field_70728_aV = 12;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.applyMobAttributes();
    }

    protected void applyMobAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_70099_a(ItemCave.EnumType.CAVENIC_ORB.getItemStack(), 0.5f);
        } else if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_70099_a(ItemMagicBook.getRandomBook(), 0.25f);
        }
    }

    public boolean isFriends(@Nullable Entity entity) {
        return entity != null && entity instanceof EntityCavenicWitch;
    }

    public boolean func_180431_b(DamageSource source) {
        if (super.func_180431_b(source)) {
            return true;
        }
        if (source.func_76346_g() == this || source.func_76364_f() == this) {
            return true;
        }
        return this.isFriends(source.func_76346_g()) || this.isFriends(source.func_76364_f());
    }

    public void func_70624_b(EntityLivingBase entity) {
        if (this.isFriends((Entity)entity)) {
            return;
        }
        super.func_70624_b(entity);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        int count = this.getAttackPotionCount();
        for (int i = 0; i < count; ++i) {
            if (this.func_184730_o()) continue;
            double d0 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f;
            double d1 = target.field_70165_t + target.field_70159_w - this.field_70165_t;
            double d2 = d0 - this.field_70163_u;
            double d3 = target.field_70161_v + target.field_70179_y - this.field_70161_v;
            float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3));
            PotionType potion = PotionTypes.field_185252_x;
            float f2 = this.field_70146_Z.nextFloat();
            float f3 = target.func_110143_aJ() >= 8.0f ? 0.5f : 0.3f;
            if (f2 < f3) {
                potion = target.func_70662_br() ? PotionTypes.field_185250_v : PotionTypes.field_185254_z;
            } else if (this.field_70146_Z.nextFloat() < 0.25f) {
                potion = PotionTypes.field_185226_I;
            } else if (this.field_70146_Z.nextFloat() < 0.2f) {
                potion = PotionTypes.field_185246_r;
            }
            EntityPotion entity = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)potion));
            entity.field_70125_A -= -20.0f;
            entity.func_70186_c(d1, d2 + (double)(f * 0.2f), d3, 0.75f, 8.0f);
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187924_gx, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
            this.field_70170_p.func_72838_d((Entity)entity);
        }
    }

    public int getAttackPotionCount() {
        return this.field_70170_p.func_72912_H().func_176130_y().func_151525_a();
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source == DamageSource.field_76379_h) {
            damage *= 0.35f;
        }
        return !source.func_76347_k() && super.func_70097_a(source, damage);
    }

    public int func_70641_bl() {
        return CavernAPI.dimension.isInCavenia((Entity)this) ? 4 : 1;
    }
}

