/*
 * Decompiled with CFR 0.152.
 */
package cavern.entity.monster;

import cavern.api.CavernAPI;
import cavern.api.entity.ICavenicMob;
import cavern.api.entity.IEntitySummonable;
import cavern.entity.ai.EntityAIAttackCavenicBow;
import cavern.entity.projectile.EntityCavenicArrow;
import cavern.item.CaveItems;
import cavern.item.ItemCave;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityCavenicSkeleton
extends EntitySkeleton
implements ICavenicMob {
    protected EntityAIAttackRangedBow<EntityCavenicSkeleton> field_85037_d;
    protected EntityAIAttackMelee field_85038_e;

    public EntityCavenicSkeleton(World world) {
        super(world);
        this.field_70728_aV = 13;
        this.func_70105_a(0.68f, 2.0f);
    }

    protected void initCustomAI() {
        this.field_85037_d = new EntityAIAttackCavenicBow<EntityCavenicSkeleton>(this, 0.975, 5.0f, 4);
        this.field_85038_e = new EntityAIAttackMelee((EntityCreature)this, 1.25, false){

            public void func_75251_c() {
                super.func_75251_c();
                EntityCavenicSkeleton.this.func_184724_a(false);
            }

            public void func_75249_e() {
                super.func_75249_e();
                EntityCavenicSkeleton.this.func_184724_a(true);
            }
        };
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.applyMobAttributes();
    }

    protected void applyMobAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(21.0);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        if (this.field_70146_Z.nextDouble() < 0.45) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)CaveItems.CAVENIC_BOW));
        }
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_70099_a(ItemCave.EnumType.CAVENIC_ORB.getItemStack(), 0.5f);
        }
    }

    public void func_85036_m() {
        if (this.field_85037_d == null || this.field_85038_e == null) {
            this.initCustomAI();
        }
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.field_85038_e);
            this.field_70714_bg.func_85156_a(this.field_85037_d);
            ItemStack heldMain = this.func_184614_ca();
            if (!heldMain.func_190926_b() && heldMain.func_77973_b() instanceof ItemBow) {
                this.field_70714_bg.func_75776_a(4, this.field_85037_d);
            } else {
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.field_85038_e);
            }
        }
    }

    protected EntityArrow func_190726_a(float dist) {
        ItemStack heldOff = this.func_184582_a(EntityEquipmentSlot.OFFHAND);
        if (heldOff.func_77973_b() == Items.field_185166_h) {
            EntitySpectralArrow arrow = new EntitySpectralArrow(this.field_70170_p, (EntityLivingBase)this);
            arrow.func_190547_a((EntityLivingBase)this, dist);
            return arrow;
        }
        EntityCavenicArrow arrow = new EntityCavenicArrow(this.field_70170_p, (EntityLivingBase)this);
        arrow.func_190547_a((EntityLivingBase)this, dist);
        if (heldOff.func_77973_b() == Items.field_185167_i && arrow instanceof EntityTippedArrow) {
            ((EntityTippedArrow)arrow).func_184555_a(heldOff);
        }
        return arrow;
    }

    public boolean isFriends(@Nullable Entity entity) {
        return entity != null && entity instanceof EntityCavenicSkeleton && !(entity instanceof IEntitySummonable);
    }

    public boolean func_180431_b(DamageSource source) {
        if (super.func_180431_b(source)) {
            return true;
        }
        if (source.func_76346_g() == this || source.func_76364_f() == this) {
            return true;
        }
        return this.isFriends(source.func_76346_g()) || this.isFriends(source.func_76364_f());
    }

    public void func_70624_b(EntityLivingBase entity) {
        if (this.isFriends((Entity)entity)) {
            return;
        }
        super.func_70624_b(entity);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source == DamageSource.field_76379_h) {
            damage *= 0.35f;
        }
        return !source.func_76347_k() && super.func_70097_a(source, damage);
    }

    public int func_70641_bl() {
        return CavernAPI.dimension.isInCavenia((Entity)this) ? 4 : 1;
    }
}

