/*
 * Decompiled with CFR 0.152.
 */
package cavern.entity.monster;

import cavern.api.CavernAPI;
import cavern.api.entity.ICavenicMob;
import cavern.item.ItemMagicBook;
import cavern.item.ItemMirageBook;
import cavern.util.CaveUtils;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityCaveman
extends EntityMob
implements ICavenicMob {
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityCaveman.class, (DataSerializer)DataSerializers.field_187198_h);
    private final InventoryBasic backpackInventory;
    private final EntityAIAttackMelee aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, (double)1.15f, false);
    private int restTime;

    public EntityCaveman(World world) {
        super(world);
        this.field_70728_aV = 5;
        this.backpackInventory = new InventoryBasic("entity.Caveman.name", false, 27);
        this.func_70105_a(0.48f, 1.85f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2875);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SITTING.equals(key)) {
            this.setSizeForSitting(this.isSitting());
        }
        super.func_184206_a(key);
    }

    public InventoryBasic getBackpackInventory() {
        return this.backpackInventory;
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void setSitting(boolean sit) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sit);
    }

    public int getRestTime() {
        return this.restTime;
    }

    protected void setSizeForSitting(boolean sit) {
        if (sit) {
            this.func_70105_a(0.48f, 1.35f);
        } else {
            this.func_70105_a(0.48f, 1.85f);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("RestTime", this.restTime);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.backpackInventory.func_70302_i_(); ++i) {
            ItemStack stack = this.backpackInventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            list.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74782_a("Inventory", (NBTBase)list);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.restTime = compound.func_74762_e("RestTime");
        NBTTagList list = compound.func_150295_c("Inventory", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack stack = new ItemStack(list.func_150305_b(i));
            if (stack.func_190926_b()) continue;
            this.backpackInventory.func_174894_a(stack);
        }
    }

    public float func_70047_e() {
        if (this.isSitting()) {
            return 1.125f;
        }
        return 1.65f;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70122_E && !CaveUtils.isMoving((Entity)this)) {
                ++this.restTime;
                if (this.restTime > 500) {
                    this.setSitting(true);
                }
            } else {
                if (this.restTime > 0) {
                    this.setSitting(false);
                }
                this.restTime = 0;
            }
            this.pickupItem();
        }
    }

    protected void pickupItem() {
        if (this.field_70173_aa % 10 != 0) {
            return;
        }
        for (EntityItem entityItem : this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_186662_g(0.65))) {
            if (!entityItem.func_70089_S() || !entityItem.field_70122_E) continue;
            ItemStack stack = entityItem.func_92059_d();
            if (stack.func_190926_b()) break;
            if ((stack = this.onItemStackPickup(stack)).func_190926_b()) {
                entityItem.func_70106_y();
                this.playPickupSound();
                break;
            }
            entityItem.func_92058_a(stack);
            break;
        }
    }

    public ItemStack onItemStackPickup(ItemStack stack) {
        return this.backpackInventory.func_174894_a(stack);
    }

    protected void playPickupSound() {
        this.func_184185_a(SoundEvents.field_187638_cR, 0.25f, 0.85f);
    }

    public boolean canCombatItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (held.func_190926_b() || this.func_70068_e((Entity)player) > 3.0) {
            return false;
        }
        player.func_184609_a(hand);
        if (!this.field_70170_p.field_72995_K) {
            player.func_71007_a((IInventory)this.backpackInventory);
            this.playPickupSound();
        }
        return true;
    }

    public void func_184201_a(EntityEquipmentSlot slot, ItemStack stack) {
        super.func_184201_a(slot, stack);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K && slot == EntityEquipmentSlot.MAINHAND) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttackOnCollide);
            if (this.canCombatItem(stack)) {
                this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.aiAttackOnCollide);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_184611_a(EnumHand.MAIN_HAND, this.getInitialHeldItem());
        for (ItemStack stack : this.getInitialInventoryItems()) {
            this.backpackInventory.func_174894_a(stack);
        }
        return livingdata;
    }

    protected ItemStack getInitialHeldItem() {
        if (this.field_70146_Z.nextDouble() < 0.35) {
            return new ItemStack(Items.field_151040_l);
        }
        if (this.field_70146_Z.nextDouble() < 0.35) {
            return new ItemStack(Items.field_151035_b);
        }
        if (this.field_70146_Z.nextDouble() < 0.15) {
            return new ItemStack(Items.field_151036_c);
        }
        if (this.field_70146_Z.nextDouble() < 0.15) {
            return new ItemStack(Items.field_151037_a);
        }
        return ItemStack.field_190927_a;
    }

    protected NonNullList<ItemStack> getInitialInventoryItems() {
        ItemStack stack;
        NonNullList list = NonNullList.func_191196_a();
        for (int i = 0; i < 2; ++i) {
            ItemStack stack2 = this.getInitialHeldItem();
            if (stack2.func_190926_b()) continue;
            list.add((Object)stack2);
        }
        list.add((Object)new ItemStack(Blocks.field_150478_aa, MathHelper.func_76136_a((Random)this.field_70146_Z, (int)3, (int)10)));
        list.add((Object)new ItemStack(Items.field_151025_P, MathHelper.func_76136_a((Random)this.field_70146_Z, (int)1, (int)3)));
        if (this.field_70146_Z.nextDouble() < 0.05 && !(stack = ItemMirageBook.getRandomBook()).func_190926_b()) {
            list.add((Object)stack);
        }
        if (this.field_70146_Z.nextDouble() < 0.05) {
            list.add((Object)ItemMagicBook.getRandomBook());
        }
        return list;
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        if (!this.field_70170_p.field_72995_K) {
            InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this.backpackInventory);
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source == DamageSource.field_76379_h) {
            damage *= 0.35f;
        }
        return !source.func_76347_k() && super.func_70097_a(source, damage);
    }

    public int func_70641_bl() {
        return CavernAPI.dimension.isInCavenia((Entity)this) ? 4 : 1;
    }
}

